<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_search extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'xgcms_search';
		$this->primarykey = array('searchid');
		$this->maxcol = 'searchid';
	}
	public function get_one($map) {
		$rs = $this->index_fetch($map,array('searchid'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function add_index($data){
           $words=$this->safe_replace($data['title']);
           $words.=' '.$this->safe_replace($data['keywords']);
           $arr=array(
                 'modelid'=>$data['modelid'],
                 'catid'=>$data['catid'],
                 'id'=>$data['id'],
                 'adddate'=>$data['updatetime'],
                 'data'=>$words
                );
           $rs=$this->get_one(array('catid'=>$data['catid'],'id'=>$data['id']));
		   
		   // hook xgcms_search_model_add_index_create_before.php
		   
           if($rs){
           	  $arr=array_merge($rs,$arr);
           	  $this->update($arr);
           }else{
           	  $this->create($arr);
           } 
		   // hook xgcms_search_model_add_index_end.php 
	}

	public function safe_replace($string) {
        $string = str_replace('%20',' ',$string);
        $string = str_replace('%27',' ',$string);
        $string = str_replace('%2527',' ',$string);
        $string = str_replace('*',' ',$string);
        $string = str_replace('"',' ',$string);
        $string = str_replace("'",' ',$string);
        $string = str_replace(",",' ',$string);
        $string = str_replace('"',' ',$string);
        $string = str_replace(';',' ',$string);
        $string = str_replace('<',' ',$string);
        $string = str_replace('>',' ',$string);
        $string = str_replace("{",' ',$string);
        $string = str_replace('}',' ',$string);
        $string = str_replace('\\',' ',$string);
        return $string;
   }
   // hook xgcms_search_model_end.php
}

?>