<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_search_keyword extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'xgcms_search_keyword';
		$this->primarykey = array('keyword');
	}
		// 带有过期时间的 get
	public function get($k,$life=3600) {
		$arr = parent::get($k);
		if(!empty($arr)){
			$arr['searchnum']=isset($arr['searchnum'])?$arr['searchnum']+1:1;
			parent::set($k , $arr);
		}else{
			parent::set($k,array('keyword'=>$k,'data'=>'[]','expiry'=>$_SERVER['time'] +$life));
		}
		if(!empty($arr) && (empty($arr['expiry']) || $arr['expiry'] > $_SERVER['time'])){
			$r=core::json_decode($arr['data']);
			if(empty($r)) return $r=2;
			return $r;
		}
		return false;
	}
	
	// 带有过期时间的 set
	public function set($k, $s, $life = 0) {
		$s = core::json_encode($s);
		$arr = array();
		$arr['keyword'] = $k;
		$arr['data'] = $s;
		$arr['expiry'] = $life ? $_SERVER['time'] + $life : 0;
		$rs=$this->get($k);
		$rs && $arr['searchnum']=$rs['searchnum']+1;
		return parent::set($k, $arr);
	}
	// hook xgcms_search_keyword_model_end.php

}

?>