﻿<?php
/*
 * auth身份验证类（使用session）
 * 直接通过静态方法调用
 * @Mars
 */
class auth {

	//禁止实例化
	private function __construct() {}
		
	/*
	 * 检查用户是否已经登陆
	 */
	public static function isLogin( $id = '' ) {
		if ( !empty($id) ) {
			$id = '_' . $id;
		}
		$isLogin = session::get('mars_auth_isLogin' . $id);
		if( $isLogin == true) {
			return true;
		} else {
			return false;
		}
	}
	/*
	 * 登入
	 */
	public static function setLogin( $data, $id = '' ) {	
		if ( !is_array($data) ) {
			return false;
		}
		if ( !isset($_SESSION['marsphp_session']) ) {
			session::start();
		}
		if ( !empty($id) ) {
			$id = '_' . $id;
		}
		session::set('mars_auth_isLogin' . $id, 'true');
		session::set('mars_auth_loginTime' . $id, time());
		session::set('mars_auth_data' . $id, $data);
		return true;
	}
	
	/*
	 * 登出
	 */
	public static function setLogout( $id = '' ) {
		if ( !empty($id) ) {
			$id = '_' . $id;
		}
		session::clear('mars_auth_isLogin' . $id);
		session::clear('mars_auth_loginTime' . $id);
		session::clear('mars_auth_data' . $id);
	}
	/*
	 * 设置一个数据
	 */
	public static function setData( $key, $value, $id = '' ) {
		if ( !empty($id) ) {
			$id = '_' . $id;
		}
		$data = session::get('mars_auth_data' . $id);
		$data[$key] = $value;
		session::set('mars_auth_data' . $id, $data);
	}
	/*
	 * 读取一个数据
	 */
	public static function getData( $key, $id = '' ) {
		if ( !empty($id) ) {
			$id = '_' . $id;
		}
		$data = session::get('mars_auth_data' . $id);
		if ( isset($data[$key]) ) {
			return $data[$key];
		} else {
			return false;
		}
	}
	/*
	 * 检验验证码
	 */
	public static function checkCode( $str ) {
		// 验证码不能为空
		$str = strtoupper($str);
		$auth_code = session::get('mars_auth_code_code');
		$auth_time = session::get('mars_auth_code_time');
		if(empty($str) || empty($auth_code) || empty($auth_time)) {
			return false;
		}
		// session 过期
		$time = session::get('mars_auth_code_time');
		if(time() - $time > 3000) {
			unset($auth_code);
			unset($auth_time);
			return false;
		}

		if($str == session::get('mars_auth_code_code')) {
			return true;
		}

		return false;
	}
}