<?php
/*
 * 缓存类
 * 直接通过静态方法调用
 * @Mars
 */
class cache {

	//禁止实例化
	private function __construct() {}
	
	/*
	 * 保存
	 * @parame string
	 * $key 缓存名称
	 * @parame mixed $var 要缓存的数据
	 * @parame int $expire 缓存有效期，0为始终有效
	 */
	public static function set( $key, $var, $expire = 0 ) {
		$dir = APP_ROOT . 'cache';
		if ( !is_dir($dir) ) {
			@mkdir($dir, 0777);
		}
		$key = md5($key);
		$dir = $dir . '/' . substr($key, 0, 1);
		basic::checkDir($dir);
		$file = $dir . '/' . $key . '.html';
		$ft = @fopen($file, 'w');
		if (!$ft) {
			try {
				throw new Except('无法写入缓存文件');
			} catch (Except $e) {
				$e->display();
			}
		}
		if ( !empty($expire) ) {
			$expire += time();
		}
		$cache = array('var'=>$var, 'expire'=>$expire);
		$str = serialize($cache);  //序列化后写入文件
		if ($ft) {
			fwrite($ft, $str);
			fclose($ft);
			return true;
		} else {
			return false;
		}
	}
	
	/*
	 * 读取
	 */
	public static function get( $key ) {
		$dir = APP_ROOT . 'cache';
		$key = md5($key);
		$dir = $dir . '/' . substr($key, 0, 1);
		$file = $dir . '/' . $key . '.html';
		if ( file_exists($file) ) {
			$content = file_get_contents($file);
			$content = unserialize($content);
			if ($content['expire'] > 0 && $content['expire'] < time()) {
				@unlink($file);  //删除超时的缓存
				$content['var'] = false;
			}
			return $content['var'];
		} else {
			return false;
		}
	}
	
	/*
	 * 删除
	 */
	public static function delete( $key ) {
		$dir = APP_ROOT . 'cache';
		$key = md5($key);
		$dir = $dir . '/' . substr($key, 0, 1);
		$file = $dir . '/' . $key . '.html';
		if ( file_exists($file) ) {
			$rs = @unlink($file);
			return $rs;
		} else {
			return false;
		}
	}
	
	/*
	 * 清除所有缓存
	 */
	public static function flush() {
		$dir = APP_ROOT . 'cache';
		if (!$hd = @opendir($dir)) {
			return false;
		}
		while ( $obj = readdir($hd) ) {
			if ($obj == '.' || $obj == '..' || $obj == '.htaccess') {
				continue;
			}
			$file =  $dir . '/' . $obj;
			if ( is_dir($file) ) {
				self::flush($file);
			}			
			if ( is_file($file) ) {
				@unlink($file);
			}
		}
	}
}
?>