<?php
/*
 * 静态页面类
 * 直接通过静态方法调用
 * @Mars
 */
class html {
	private static $_cache = '';

	//禁止实例化
	private function __construct() {}
	
	/*
	 * 取模板文件缓存
	 * @parame string $name 模板名称
	 * @parame array $array 数据
	 * @parame string $path 模板所在路径（在tpl目录下的相对路径）
	 */
	public static function fetch( $name, $array, $path = '' ) {
		$view = new Action();
		$view->assign($array);
		self::$_cache = $view->fetch($name, $path);
	}
	/*
	 * 生成静态网页
	 * @parame string $name 静态网页名称
	 * @parame string $path 目标文件夹路径（路径前不要加APP_ROOT）
	 */
	public static function make( $name, $path = '' ) {
		if ( empty(self::$_cache) ) {
			return NULL;
		}
		$dir = rtrim(APP_ROOT . $path, '/');
        basic::checkDir($dir);
		$file = $dir . '/' . $name . '.html';
		$ft = @fopen($file, 'w');
		if (!$ft) {
			try {
				throw new Except('无法写入静态文件：' . $path . '/' . $name . '.html');
			} catch (Except $e) {
				$e->display();
			}
		}
		if ($ft) {
			fwrite($ft, self::$_cache);  //写入静态文件
			fclose($ft);
			return true;
		} else {
			return false;
		}
	}
}
?>