<?php
/**
 * 分页类
 * 需要创建对象
 * @author Mars
 */
class pagination {
	public $_data;
	public $_size;  //每页数据数
	public $_count;  //数据总数
	public $_pageCount;  //总页数
	public $_pageNum;  //当前页数

	/*
	 * 构造函数
	 * @param array $data 要分页显示的数据
	 */
	public function __construct( $data = NULL ) {
		if ( empty($data) ) {
			return false;
		}
		$this->_count = $data['count'];
		unset($data['count']);
		$this->_size = $data['size'];
		unset($data['size']);
		$this->_pageNum = $data['page'];
		unset($data['page']);
		$this->_data = $data;
		if ( !empty($this->_count) ) {
			$this->_pageCount = intval($this->_count / $this->_size);
			if (($this->_count % $this->_size) != 0) {
				$this->_pageCount++;
			}
		} else {
			$this->_pageCount = 0;
		}
	}
	
	/*
	 * 获得分页的数据
	 */
	public function getList() {
		return $this->_data;
	}
	
	/*
	 * 获得分页的HTML代码
	 */
	public function getHtml() {
		$str = '<ul id="pagination">';
		if ($this->_pageNum > $this->_pageCount) {
			return false;
		}
		$url = '?';
		if ( is_array($_GET) ) {
			foreach ($_GET as $key=>$value) {
				if ($key != 'page') {
					$url .= "{$key}={$value}&";
				}
			}
		}
		//上一页
		if ($this->_pageNum != 1) {
			$str .= '<li><a href="' . $url . 'page=' . ($this->_pageNum - 1) . '"><</a></li>';
		}
		//计算页码范围
		$array = range(1, $this->_pageCount);
		if ($this->_pageNum <= 3) {
			$array = array_slice($array, 0, 6);
		} else if (($this->_pageNum >= 6) && ($this->_pageCount - $this->_pageNum <= 6)) {
			$array = array_slice($array, $this->_pageCount - 6, 6);
		} else {
			$array = array_slice($array, $this->_pageNum - 3, 6);	
		}
		foreach ($array as $i=>$v) {
			//first...
			if (($i == 0) && ($v > 1)) {
				$str .= '<li><a href="' . $url . 'page=1">';
				$str .= '1</a><li><a>...</a></li>';
			}
			//页码
			if ($v == $this->_pageNum) {
				$str .= '<li id="current"><a>';
				$str .= $v . '</a></li>';
			} else {
				$str .= '<li><a href="' . $url . 'page=' . $v . '">';
				$str .= $v . '</a></li>';
			}
			//...last
			if (($i == count($array) - 1) && ($v < $this->_pageCount)) {
				$str .= '<li><a>...</a></li>';
				$str .= '<li><a href="' . $url . 'page=' . $this->_pageCount . '">';
				$str .= $this->_pageCount . '</a></li>';
			
			}
		}
		//下一页
		if ($this->_pageNum != $this->_pageCount) {
			$str .= '<li><a href="' . $url . 'page=' . ($this->_pageNum + 1) . '">';
			$str .= '></a><li>';
		}
		$str .= '</ul>';
		return $str;
	}
	
	public function getCount() {
		return $this->_count;
	}
	
	public function getPageCount() {
		return $this->_pageCount;
	}
	
	public function getPageNum() {
		return $this->_pageNum;
	}
	
}
?>