<?php
/**
 * session类
 * 直接通过静态方法调用
 * @Mars
 */
class session {

	//禁止实例化
	private function __construct() {}
		
	/*
	 * 启动session
	 */
	public static function start() {		
		if ( !isset($_SESSION) ) {
			if ( !defined('SESSION_NAME') ) {
				define('SESSION_NAME', 'SECURITY_SESSION');
			}
			session_name(SESSION_NAME);
			session_start();
		}		
		if ( !isset($_SESSION['marsphp_session']) ) {
			$_SESSION['marsphp_session'] = 'started';
		} else {
			$_SESSION['marsphp_session'] = 'continued';
		}
	}
	
	/*
	 * 检查是否已被设置
	 */
	public static function is_set( $name ){
		return isset($_SESSION[$name]);
	}
	
	/*
	 * 设置session内容
	 */
	public static function set( $name, $value ) {
		if ( empty($value) ) {
			unset($_SESSION[$name]);
		} else {
			$_SESSION[$name] = $value;
		}
	}
	
	/*
	 * 取得session内容
	 */
	public static function get( $name ) {
		if( isset($_SESSION[$name]) ) {
			return $_SESSION[$name];
		} else {
			return false;
		}
	}
	
	/*
	 * 清空session内容
	 */
	public static function clear( $name ) {
		unset($_SESSION[$name]);
	}
	
	/*
	 * 销毁全部session
	 */
	public static function destroy() {
		unset($_SESSION);
		session_destroy();
	}
}
?>