<?php
class Action {
	private static $_object;  //模板引擎对象

	/*
	 * _初始化用函数，载入模板引擎
	 */
	private function _init() {
		if ( is_object(self::$_object) ) {
			return true;  //避免重复载入
		}
		$path = MARS_ROOT . 'core/tpl.php';
		if ( is_file($path) ) {
			//载入驱动文件
			require_once($path);
		} else {
			try {
				throw new Except('无法载入模板引擎文件');
			} catch (Except $e) {
				$e->display();
			}
			exit();
		}
		//生成驱动对象
		$tpl = 'TPL_default';
		self::$_object = new $tpl();
	}
	/*
	 * 载入变量并显示模板
	 * @param string $name 模板的名称
	 * @param array $data 要载入的数据，关联数组形式
	 * @param string $path 模板在tpl目录下的路径，默认为default
	 */
	public function show($name,$data = array(), $path = '' ) {
		//$name问题待解决
		self::_init();
		$obj = self::$_object;
		$obj->assign($data);
		$obj->display($name, $path);
		exit();
	}
	/*
	 * 载入变量
	 */
	public function assign( $data ) {
		self::_init();
		$obj = self::$_object;
		$obj->assign($data);
	}
	/*
	 * 显示模板
	 */
	public function display( $name, $path = '' ) {
		$obj = self::$_object;
		$obj->display($name, $path);
		exit();
	}
	/*
	 * 获取模板内容
	 */
	public function fetch( $name, $path = '' ) {
		$obj = self::$_object;
		$rs = $obj->fetch($name, $path);
		return $rs;
	}
	/*
	 * 包含文件
	 */
	public function includeTpl( $file ) {
		$obj = self::$_object;
		$rs = $obj->includeTpl($file);
	}
	/*
	 * 页面跳转
	 */
	 public function redirect($url, $msg = ''){
	 	basic::redirect($url, $msg = '');
	 }
}