<?php
/*
 * 程序核心，解析URL后载入动作
 * @author Mars 
 */
//加载核心库文件，有顺序
require_once(MARS_ROOT . 'core/basic.php');
require_once(MARS_ROOT . 'core/exception.php');
require_once(MARS_ROOT . 'core/action.php');
require_once(MARS_ROOT . 'core/model.php');
//common部分采用autoload方式加载
function __autoload( $class ) {
	$common = array( 'session','pagination','auth','image','cache','buildImageVerify','html');
	if ( in_array($class, $common) ) {
		require_once(MARS_ROOT . 'common/' . $class . '.class.php');
	}
}
class core{
	//禁止实例化
	private function __construct(){}
	
	//启动程序
	public static function run(){
		if(!defined('APP_ROOT') && !defined('MARS_ROOT')){
			die('Access Denied');
		}
		if(SESSION_AUTO_START == 1){
			session::start();
		}
		//解析URL
		$uri = $_SERVER['PHP_SELF'];
		if(empty($uri)){
			basic::throw404();
		}	
		//按index.php拆分（程序入口文件必须是根目录下的index.php）
		$uri = explode('/index.php', $uri);
		if(isset($_SERVER['HTTP_HOST'])) {
			$url = 'http://' . $_SERVER['HTTP_HOST'];
		}else{
			$url = 'http://' . $_SERVER['SERVER_NAME'];
			if ($_SERVER['SERVER_PORT'] != 80) {
				$url .= ':' . $_SERVER['SERVER_PORT'];
			}
		}
		$url .= rtrim($uri['0'], '/') . '/';
		define('URL', $url);
		//解析动作
		if(!empty($uri[1])){
			$uri[1] = trim($uri['1'], '/');
			$action = explode('/',$uri['1']);
			$count = count($action);
			if ($count == 1) {
				$function = 'index';
			}else{
				$function = $action[$count - 1];
				array_pop($action);
			}
			$class = implode('/', $action);
		}
		$class = empty($class) ? 'Index' : $class;
		$function = empty($function) ? 'index' : $function;
		//加载对应的Action类，执行相应的动作（必须把类文件置于程序根目录下的action目录下）
		$path = APP_ROOT . 'action/' . $class . 'Action.php';
		if(is_file($path)){
			require_once($path);  //载入类文件
		}else{
			try {
				throw new Except('您所请求的方法不存在');
			} catch (Except $e) {
				$e->display();
			}
			exit();
		}
		$pos = strrpos($class, '/');
		if($pos > 0){
			$clsName = substr($class, $pos + 1);
		} else {
			$clsName = $class;
		}
		$clsName = $clsName . 'Action'; //控制器的类名请加上'Action'
		if(class_exists($clsName)){
			$object = new $clsName();   //生成对象
		}else{
			try {
				throw new Except('缺少控制器类：' . $clsName);
			} catch (Except $e) {
				$e->display();
			}
			exit();
		}
		if(method_exists($object, $function)){
			$object->$function();  //执行动作
		}else{
			try {
				throw new Except('您所请求的方法不存在');
			} catch (Except $e) {
				$e->display();
			}
			exit();
		}
		
	}

}