<?php
/*
 * 模型类（继承DB类，以调用DB方法）
 * 模型操作是真面向对象的，需要创建对象实例
 * @Mars
 */
//引入DB类
require_once(MARS_ROOT . 'core/db.php');
class model {
	private $_model = '';  //模型的对象实例
	private $_class =  '';  //模型中的类名称
    private $_table = '';  //数据表的名称
	private $_manager = array();  //SQL语句管理
	private static $_sql = '';  //每次执行的SQL语句，静态变量
	/*
	 * 构造函数
	 * @param string $model 模型类的名称
	 */
	public function __construct( $model ) {
        $modelClass = $model . 'Model';
		if ( !class_exists($modelClass) ) {
			$path = APP_ROOT . 'model/' . $model . '.php';
			if ( is_file($path) ) {
				//载入模型文件
				require_once($path);
			} else {
				$model = escapeshellcmd($model);
				if ( !empty($model) ) {
					try {
						throw new Except('错误的模型类');
					} catch (Except $e) {
						$e->display();
					}
				}
				$code = "class $modelClass {}";
				eval($code);
			}
		}        
		if ( class_exists($modelClass) ) {
			$this->_model = new $modelClass();
		} else {
			try {
				throw new Except('缺少模型类：' . $modelClass);
			} catch (Except $e) {
				$e->display();
			}
			exit();
		}
		$this->_class = get_class($this->_model);
        $this->_table = $model;
		$this->_sqlInit();
	}
	/*
	 * 处理未定义的方法（用来调用不同数据库模型的自定义方法）
	 */
	public function __call( $name, $arguments ) {
		if ( method_exists($this->_model, $name) ) {
			$rs = call_user_func_array(array($this->_model, $name), $arguments);
			return $rs;
		} else {
			die("Fatal error: Call to undefined method $name()");
		}
	}
	/*
	 * 连接数据库（默认会自动连接，用此方法切换不同的数据库服务器）
	 * $dbn默认值basic_default_db，即调用model::connect()默认切换到默认数据库
	 */
	public static function connect( $dbn = 'mars_default_db' ) {
		db::conn($dbn);
	}
	/*
	 * _初始化SQL-Manager
	 */
	private function _sqlInit() {
		$this->_manager['column'] = '';
		$this->_manager['alias'] = '';
		$this->_manager['join'] = '';
		$this->_manager['where'] = '';
		$this->_manager['group'] = '';
		$this->_manager['having'] = '';
		$this->_manager['order'] = '';
		$this->_manager['limit'] = '';
		$this->_manager['cache'] = '';
	}
	/*
	 * 添加到数据库 插入
	 */
	public function add() {
		return $this->save(0);
	}
	/*
	 * 保存到数据库 插入/更新/替换
	 * @param mixed $condition 更新的条件：0-insert/1-replace/string-update&where
	 */
	public function save( $condition = 0 ) {
		$where = '';
		if ( empty($condition) || $condition === 1 ) {
			if ( !empty($this->_manager['where']) ) {
				$where = $this->_manager['where'];
				if ( $condition !== 1 ) {
					$condition = 2;
				}
			}
		} else if ( $condition !== 1 ) {
			$where = $condition;
		}
		$vars = array_keys( get_object_vars($this) );  //获得该对象中的属性名称
		$table = $this->_table;
		if ( $condition === 0 ) {
			$sql = "INSERT INTO";
		} else if ( $condition === 1 ) {
			$sql = "REPLACE INTO";
		} else {
			$sql = "UPDATE";
		}
		$sql .= " `$table` SET";
		foreach ($vars as $key) {
			if ( strpos($key, '_') === 0 ) {
				continue;  //跳过自身的私有属性（下划线开头的变量均视为私有属性）
			}
			$value = $this->$key;
			$sql .= " `$key` = '$value',";
		}
		$sql = rtrim($sql, ',');
		if ( !empty($where) ) {
			$sql .= " WHERE $where";
		}
		$rs = self::exec($sql);
		$this->_sqlInit();
		return $rs;
	}
	/*
	 * 执行SQL语句
	 * @return TRUE/FALSE
	 */
	public static function exec( $sql ) {
		self::$_sql = $sql;
		db::conn();
		db::prepare($sql);
		$rs = db::execute();
		return $rs;
	}
	/*
	 * 分页用
	 * @param string $where 条件
	 * @param string $order 排序
	 * @param int $pageSize 每页的条数
	 */
	public function page( $where = '', $order = '', $pageSize = 10 ) {
		$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
		$page = ($page > 0) ? $page : 1;
		$offset = ($page - 1) * $pageSize;
		$length = $pageSize;
		$rs = $this->select($where, $order, "$offset, $length");  //调用select()
		$rs['count'] = $this->count($where);
		$rs['size'] = $pageSize;
		$rs['page'] = $page;
		return $rs;
	}
	/*
	 * 查询 取当前model的多行数据
	 * @param string $where 条件
	 * @param string $order 排序
	 * @param string $limit 数量
	 */
	public function select( $where = '', $order = '', $limit = '') {
		$sql = "SELECT ";
		if ( !empty($this->_manager['column']) ) {
			$sql .= $this->_manager['column'];
		} else {
			$sql .= "*";
		}
		$sql .= " FROM `$this->_table`";
		if ( !empty($this->_manager['alias']) ) {
			$sql .= " " . $this->_manager['alias'];
		}
		if ( !empty($where) ) {
			$sql .= " WHERE $where";
		} else if ( !empty($this->_manager['where']) ) {
			$sql .= " WHERE " . $this->_manager['where'];
		}
		if ( !empty($this->_manager['group']) ) {
			$sql .= " GROUP BY " . $this->_manager['group'];
		}
		if ( !empty($this->_manager['having']) ) {
			$sql .= " HAVING " . $this->_manager['having'];
		}
		if ( !empty($order) ) {
			$sql .= " ORDER BY $order";
		} else if ( !empty($this->_manager['order']) ) {
			$sql .= " ORDER BY " . $this->_manager['order'];
		}
		if ( !empty($limit) ) {
			$sql .= " LIMIT $limit";
		} else if ( !empty($this->_manager['limit']) ) {
			$sql .= " LIMIT " . $this->_manager['limit'];
		}
		$rs = self::_fetch($sql);
		$this->_sqlInit();
		return $rs;
	}
	/*
	 * _查询并取结果（转换为对象数组）
	 * @param string $sql 查询用的SQL语句
	 */
	private function _fetch( $sql ) {
		$rs = self::query($sql);
		return $rs;
	}
	/*
	 * 执行SQL查询并返回结果集对象数组（重载）
	 * @return 数组/NULL/FALSE
	 */
	public static function query( $sql) {
		self::$_sql = $sql;
		db::conn();
		$rs = db::query($sql);
		if ($rs) {
			$rs = db::fetchAll();
			return $rs;
		} else {
			return false;
		}
	}
	/*
	 * 查询 数据总数
	 * @param string $where 条件
	 */
	public function count( $where = '' ) {
		$sql = "SELECT COUNT(*) FROM $this->_table";
		if ( !empty($where) ) {
			$sql .= " WHERE $where";
		} else if ( !empty($this->_manager['where']) ) {
			$sql .= " WHERE " . $this->_manager['where'];
		}
		if ( !empty($this->_manager['group']) ) {
			$sql .= " GROUP BY " . $this->_manager['group'];
		}
		if ( !empty($this->_manager['having']) ) {
			$sql .= " HAVING " . $this->_manager['having'];
		}
		$rs = self::_fetch($sql);
		if ($rs) {
			$tmp = 'COUNT(*)';
			$rs = intval($rs['0']['COUNT(*)']);
		}
		$this->_sqlInit();
		return $rs;
	}

	/*
	 * 从数据库中删除
	 * @param string $where 删除的条件
	 */
	public function delete( $where ) {
		if ( empty($where) ) {
			if ( !empty($this->_manager['where']) ) {
				$where = $this->_manager['where'];
			} else {
				return false;
			}
		}
		$table = $this->_table;
		$sql = "DELETE FROM `$table`";
		$sql .= " WHERE $where";
		$rs = self::exec($sql);
		$this->_sqlInit();
		return $rs;
	}
	/*
	 * 查询 取当前model的一行数据
	 * @param string $where 条件
	 * @param string $order 顺序
	 */
	public function get( $where = '', $order = '') {
		$rs = $this->select($where, $order, '0,1');  //调用select()
		if ($rs) {
			$rs = $rs[0];  //直接返回对象
		}
		return $rs;
	}
	/*
	 * 清空结果集（重载）
	 */
	public function free() {
		db::free();
	}
	/*
	 * 返回上一个SQL操作的语句
	 */
	public function getSql() {
		return self::$_sql;
	}
	/*
	 * 返回上一个SQL操作产生的错误信息
	 */
	public function getError() {
		db::conn();
		return db::getError();
	}
	/*
	 * 调试，返回最近一次执行的SQL语句及错误信息
	 */
	public function debug() {
		$error = self::getError();
		if ( $error['errno'] == 0 ) {
			$error = 'OK';
		} else {
			$error = $error['error'];
		}
		$sql = self::$_sql;
		return "SQL \"{$sql}\": {$error}";
	}
	/*
	 * 字段过滤（SQL Manager）
	 */
	public function column( $column ) {
		$this->_manager['column'] = $column;
		return $this;
	}

	/*
	 * 表别名（SQL Manager）
	 */
	public function alias( $alias ) {
		$this->_manager['alias'] = $alias;
		return $this;
	}
	
	/*
	 * 连接查询（SQL Manager）
	 */
	public function join( $table, $on ) {
		$this->_manager['join'] .= " LEFT JOIN $table ON $on";
		return $this;
	}
	
	/*
	 * 条件查询（SQL Manager）
	 */
	public function where( $where ) {
		$this->_manager['where'] = $where;
		return $this;
	}
	
	/*
	 * 分组查询（SQL Manager）
	 */
	public function group( $group ) {
		$this->_manager['group'] = $group;
		return $this;
	}
	
	/*
	 * 分组条件（SQL Manager）
	 */
	public function having( $having ) {
		$this->_manager['having'] = $having;
		return $this;
	}
	
	/*
	 * 结果排序（SQL Manager）
	 */
	public function order( $order ) {
		$this->_manager['order'] = $order;
		return $this;
	}
	
	/*
	 * 限制查询（SQL Manager）
	 */
	public function limit( $limit ) {
		$this->_manager['limit'] = $limit;
		return $this;
	}
	/*
	 * 缓存控制（SQL Manager）
	 */
	public function cache( $bool ) {
		if ($bool) {
			$bool = 1;
		} else {
			$bool = 0;
		}
		$this->_manager['cache'] = $bool;
		return $this;
	}
	/*
	 * 取上次插入的ID
	 */
	public function getId() {
		$rs = self::query("SELECT last_insert_id()", 1);
		if ($rs) {
			$rs = $rs[0]['last_insert_id()'];
		}
		return $rs;
	}
	/*
	 * 查询 取当前model的全部数据
	 * @param string $order 排序
	 */
	public function all( $order = '' ) {
		$sql = "SELECT * FROM `$this->_table`";
		if ( !empty($order) ) {
			$sql .= " ORDER BY $order";
		} else if ( !empty($this->_manager['order']) ) {
			$sql .= " ORDER BY " . $this->_manager['order'];
		}
		$rs = self::_fetch($sql);
		$this->_sqlInit();
		return $rs;
	}
}