<?php
/*
 * 默认的模板引擎，BasicPHP的伪模板
 * 供view类调用
 * Author Mars
 */
class TPL_default {
	private static $_data = array();
    private static $_file;
    private static $_tplData;
    

	/*
	 * 载入变量
	 */
	public static function assign( $data = array() ) {
		self::$_data = $data;
	}
	/*
	 * 显示模板
	 */
	public static function display( $name, $path = '' ) {
		echo self::fetch($name, $path);
	}
	/*
	 * 获取模板内容
	 */
	public static function fetch( $name, $path = '' ) {
		self::$_file = self::getPath($name, $path);
		extract(self::$_data);  //导入变量
		self::$_tplData = file_get_contents(self::$_file);
		self::$_tplData = str_replace("<? include('","<?php self::includeTpl('",self::$_tplData);  //解析标签
		self::$_tplData = str_replace("<php>","<?php echo ",self::$_tplData);
		self::$_tplData = str_replace("</php>","; ?>",self::$_tplData);
        set_error_handler(array('self', 'errorHandler'), ini_get('error_reporting'));  //错误报告处理
        ob_start();
		eval('?>' . self::$_tplData);
		$rs = ob_get_contents();
		ob_clean();
        restore_error_handler(); 
		return $rs;
	}
	/*
	 * _获取模板文件的路径
	 */
	private static function getPath($name, $path) {
		if ( empty($path) ) {
			$path = TPL_DIR;
		}
		$name = rtrim($path, '/') . '/' . $name . '.' . TPL_EXTENSION;
		$file = APP_ROOT . 'tpl/' . $name;
		if ( !file_exists($file) ) {
			try {
				throw new Except('模板文件不存在：' . $name );
			} catch (Except $e) {
				$e->display();
			}
			exit();
		}
		return $file;
	}
	/*
	 * 包含文件
	 */
	public static function includeTpl( $file ) {
		$path = APP_ROOT . 'tpl/' . trim($file, '/');
		if ( !file_exists($path) ) {
			try {
				throw new Except('包含的模板文件不存在：' . $file );
			} catch (Except $e) {
				$e->display();
			}
			exit();
		}
		self::$_tplData = file_get_contents($path);
		self::$_tplData = str_replace("<? include('","<?php self::fetch('", self::$_tplData);  //解析标签
		self::$_tplData = str_replace("<php>","<?php echo ",self::$_tplData);
		self::$_tplData = str_replace("</php>","; ?>",self::$_tplData);
        eval('?>' . self::$_tplData);
	}
	/*
     * 处理模板错误报告
     */
    private static function errorHandler( $code, $msg ) {
        echo '<br/><b>TPL</b>: ' . $msg . '<br/>';
    }
}