<?php
class IndexAction extends Action{
	public function index(){
		$movie = new model('movie');
		$movie->column('id,title,area,sort,times,show_time');
		$url = substr(URL,0,-1).$_SERVER['REQUEST_URI'];
		$cache = cache::get($url);  //取filecache
		if ( empty($cache) ) {
			$data = $movie->page(NULL, 'times DESC',25);  //分页
			$page = new pagination($data);  //分页
			cache::set($url, $page,'3600');  //写filecache
		} else {
			$page = $cache;
		}

		$this->show('Index', array('page'=>$page));
	}

	public function lists(){
		switch(intval($_GET['id'])){
			case 1: $sort = "动作片"; break;
			case 2: $sort = "喜剧片"; break;
			case 3: $sort = "爱情片"; break;
			case 4: $sort = "动漫片"; break;
			case 5: $sort = "恐怖片"; break;
			case 6: $sort = "科幻片"; break;
			case 7: $sort = "战争片"; break;
			case 8: $sort = "纪录片"; break;
			case 9: $sort = "剧情片"; break;
			case 10: $sort = "大陆剧"; break;
			case 11: $sort = "欧美剧"; break;
			case 12: $sort = "港台剧"; break;
			case 13: $sort = "日韩剧"; break;
			case 14: $sort = "综艺其它"; break;
			case 15: $sort = "音乐"; break;
			case 16: $sort = "720P高清"; break;
			default : die("发生错误！");
		}
		$movie = new model('movie');
		$movie->column('id,title,area,sort,times,show_time');
		$url = substr(URL,0,-1).$_SERVER['REQUEST_URI'];
		$cache = cache::get($url);  //取filecache
		if ( empty($cache) ) {
			$data = $movie->page('sort = '."'".$sort."'", 'times DESC',25);  //分页
			$page = new pagination($data);  //分页
			cache::set($url, $page,'3600');  //写filecache
		} else {
			$page = $cache;
		}
		$this->show('List', array('page'=>$page,'sort'=>$sort));
	}
	public function data(){
		$_GET = basic::escape($_GET);  //转义特殊字符
		if(!empty($_GET['id'])){
			$movie = new model('movie');
			$url = substr(URL,0,-1).$_SERVER['REQUEST_URI'];
			$cache = cache::get($url);  //取filecache
			if ( empty($cache) ) {
				$r = $movie->get("id = $_GET[id]");
				cache::set($url, $r,'3600');  //写filecache
			} else {
				$r = $cache;
			}
			$r['state'] = $r['state'] ? '连载到'.$r['state'] : '已完结';
			$arr = explode('<**>',$r['address']);
			unset($r['address']);
			$r['address'] = array_filter($arr);
			$this->show('data', array('data'=>$r,'shu'=>$shu));
		}
	}
	public function play(){
		$_GET = basic::escape($_GET);  //转义特殊字符
		if($_GET['id']){
			$p = explode(',',$_GET['id']);
		}
		$play = new model('movie');
		$play->column('title,address');
		$data = $play->get("id = $p[0]");
		$arr = explode('<**>',$data['address']);
		$i = $p['1'];
		unset($data['address']);
		$data['address'] = $arr[$i-1];
		if(empty($data['address'])){
			die('不存在该影片！');
		}
		$this->show('play', array('data'=>$data));
	}
	public function search(){
		$_GET = basic::escape($_GET);  //转义特殊字符
		if(!empty($_GET['key'])){
			$search = new model('movie');
			$search->column('id,title,area,sort,times,show_time');
			$r = $search->page('title LIKE '."'%".$_GET['key']."%'", 'times DESC',25);  //分页
			$r = new pagination($r);  //分页
			$this->show('search', array('page'=>$r));
		}else{
			die("搜索内容空！");
		}
	}
}