<?php

/**
 * ADOdb Lite is a PHP class to encapsulate multiple database APIs and is compatible with 
 * a subset of the ADODB Command Syntax. 
 * Currently supports Frontbase, MaxDB, miniSQL, MSSQL, MSSQL Pro, MySQLi, MySQLt, MySQL, PostgresSQL,
 * PostgresSQL64, PostgresSQL7, PostgresSQL8, SqLite, SqLite Pro, Sybase and Sybase ASE.
 * 
 */

if (!defined('_ADODB_LAYER'))
	define('_ADODB_LAYER',1);

if (!defined('ADODB_DIR'))
	define('ADODB_DIR',dirname(__FILE__));

$ADODB_vers = 'V0.12 ADOdb Lite 9 August 2005  (c) 2005 Mark Dickenson. All rights reserved. Released LGPL.';

define('ADODB_FETCH_DEFAULT',0);
define('ADODB_FETCH_NUM',1);
define('ADODB_FETCH_ASSOC',2);
define('ADODB_FETCH_BOTH',3);

GLOBAL $ADODB_FETCH_MODE;
$ADODB_FETCH_MODE = ADODB_FETCH_DEFAULT;	// DEFAULT, NUM, ASSOC or BOTH. Default follows native driver default...

/**
 * Database connection
 * Usage: $db = new ADONewConnection('dbtype');
 * 
 * @access public 
 * @param string $dbtype 
 */

function &ADONewConnection( $dbtype = 'mysql' )
{
	$dbtype = strtolower($dbtype);
	include_once 'adodbSQL_drivers/' . $dbtype . '/' . $dbtype . '_driver.inc';
	$extention = $dbtype . '_ADOConnection';
	$object = new $extention( $dbtype );
	return $object;
}

/**
 * Alternative Database connection
 * Usage: $db = new NewADOConnection('dbtype');
 * 
 * @access public 
 * @param string $dbtype 
 */

function &NewADOConnection($dbtype='')
{
	$tmp =& ADONewConnection($dbtype);
	return $tmp;
}

class ADOConnection
{
	var $connectionId = false;
	var $database;
	var $dbtype;
	var $host;
	var $open;
	var $password;
	var $username;
	var $persistent;
	var $record_set;
	var $debug = false;
	var $forcenewconnection = false;
	var $createdatabase = false;

	function ADOConnection()
	{
	}

	/**
	 * Returns floating point version number of ADOdb Lite
	 * Usage: $db->Version();
	 * 
	 * @access public 
	 */

	function Version()
	{
		global $ADODB_vers;
		return (float) substr($ADODB_vers,1);
	}

	/**
	 * Returns true if connected to database
	 * Usage: $db->IsConnected();
	 * 
	 * @access public 
	 */

	function IsConnected()
	{
    	return !empty($this->connectionId);
	}

	/**
	* Set how select queries will retrieve data.
	* Usage: $oldmode = $db->SetFetchMode($mode)
	*
	* @param mode	The fetchmode ADODB_FETCH_ASSOC or ADODB_FETCH_NUM
	* @returns		The previous fetch mode
	*/
	function SetFetchMode($mode)
	{	
		GLOBAL $ADODB_FETCH_MODE;
		$old = $ADODB_FETCH_MODE;
		$ADODB_FETCH_MODE = $mode;
		return $old;
	}

	/**
	 * Normal Database connection
	 * Usage: $result = $db->Connect('host', 'username', 'password', 'database');
	 * 
	 * @access public 
	 * @param string $database 
	 * @param string $host 
	 * @param string $password 
	 * @param string $username 
	 * @param string $forcenew // private 
	 */

	function Connect( $host = "", $username = "", $password = "", $database = "", $forcenew = false)
	{
		return $this->_connect($host, $username, $password, $database, true, $forcenew);
	} 

	/**
	 * Persistent Database connection
	 * Usage: $result = $db->PConnect('host', 'username', 'password', 'database');
	 * 
	 * @access public 
	 * @param string $database 
	 * @param string $host 
	 * @param string $password 
	 * @param string $username 
	 */

	function PConnect( $host = "", $username = "", $password = "", $database = "")
	{
		return $this->_connect($host, $username, $password, $database, false, false);
	} 

	/**
	 * Force New Database connection
	 * Usage: $result = $db->NConnect('host', 'username', 'password', 'database');
	 * 
	 * @access public 
	 * @param string $database 
	 * @param string $host 
	 * @param string $password 
	 * @param string $username 
	 */

	function NConnect( $host = "", $username = "", $password = "", $database = "")
	{
		return $this->_connect($host, $username, $password, $database, false, true);
	} 

	/**
	 * Returns SQL query and instantiates sql statement & resultset driver
	 * Driver set by $this->dbtype
	 * Usage: $linkId =& $db->execute( 'SELECT * FROM foo ORDER BY id' );
	 * 
	 * @access public 
	 * @param string $sql 
	 * @return mixed Resource ID, Array
	 */

	function &Execute( $sql, $inputarr = false )
	{
		$rs =& $this->SelectLimit($sql, -1, -1, $inputarr);
		return $rs;
	} 

	/**
	* PEAR DB Compat - do not use internally
	*/
	function &Query($sql, $inputarr = false)
	{
		$false = false;
		$rs = &$this->Execute($sql, $inputarr);
		if (!$rs) return $false;
		return $rs;
	}

	/**
	 * Returns SQL query and instantiates sql statement & resultset driver
	 * Driver set by $this->dbtype
	 * Usage: $linkId =& $db->SelectLimit( 'SELECT * FROM foo ORDER BY id', $nrows, $offset );
	 *        $nrows and $offset are optional
	 * 
	 * @access public 
	 * @param string $sql 
	 * @param string $nrows 
	 * @param string $offset 
	 * @return mixed Resource ID, Array
	 */

	function &SelectLimit( $sql, $nrows=-1, $offset=-1, $inputarr=false, $secs2cache=0 )
	{
		$stmt = $this->dbtype . 'Statement';
		$stmt = new $stmt( $sql, $this->connectionId, $offset, $nrows, $inputarr);
		$stmt->extention = $this;
		$rs = $stmt->do_query();
		$this->record_set = $rs;
		return $rs;
	} 

	/**
	* PEAR DB Compat - do not use internally
	*/
	function &LimitQuery($sql, $offset, $nrows, $inputarr = false)
	{
		$false = false;
		$rs = &$this->SelectLimit($sql, $nrows, $offset, $inputarr); 
		if (!$rs) return $false;
		return $rs;
	}

	/**
	* PEAR DB Compat - do not use internally
	*/
	function Disconnect()
	{
		return $this->Close();
	}

	 /**
	 * Returns All Records in an array
	 *
	 * Usage: $db->GetAll($sql);
	 * @access public 
	 */

	function &GetAll($sql, $inputarr = false)
	{
		$data =& $this->GetArray($sql, $inputarr);
		return $data;
	}

	 /**
	 * Returns All Records in an array
	 *
	 * Usage: $db->GetArray($sql);
	 * @access public 
	 */

	function &GetArray($sql, $inputarr = false)
	{
		$data = false;
		$result =& $this->Execute($sql, $inputarr);
		if ($result)
		{
			$data =& $result->GetArray();
			$result->Close();
		}
		return $data;
	}

	/**
	 * Returns the last record id of an inserted item
	 * Usage: $db->GetCol($sql);
	 * 
	 * @access public 
	 */

	function GetCol($sql, $inputarr = false, $trim = false)
	{
		$data = false;
		$result = &$this->Execute($sql, $inputarr);
		if ($result) {
			$data = array();
			while (!$result->EOF) {
				$data[] = ($trim) ? trim(reset($result->fields)) : reset($result->fields);
				$result->MoveNext();
			}
			$result->Close();
		}
		return $data;
	}

	 /**
	 * Return first element of first row of sql statement. Recordset is disposed
	 * for you.
	 *
	 * Usage: $db->GetOne($sql);
	 * @access public 
	 */

	function &GetOne($sql, $inputarr = false)
	{
		$data =& $this->GetRow($sql, $inputarr, true);
		return $data;
	}

	 /**
	 * Return one row of sql statement. Recordset is disposed for you.
	 *
	 * Usage: $db->GetRow($sql);
	 * @access public 
	 */

	function &GetRow($sql, $inputarr = false, $getone = false)
	{
		$data = false;
		$result =& $this->Execute($sql, $inputarr);
		if ($result) {
			if ($getone)
			{
				if (!$result->EOF) $data = reset($result->fields);
			}
			else
			{
				if (!$result->EOF) $data = $result->fields;
				else $data = array();
			}
			$result->Close();
		}
		return $data;
	}

	 /**
	 * Display debug output and database error.
	 *
	 * @access private 
	 */

	function debugoutput($text)
	{
		echo "<br>\n(" . $this->dbtype . "): ".htmlspecialchars($text)."<br>\n Error (" . $this->ErrorNo() .'): '. $this->ErrorMsg() . "<br>\n";
	}

}
?>