<?php

class CDWHttpFile
{
    /* $strLocation - URL of the last web page retreived (could be different
        from what was requiested in case of HTTP redirect.) */
    var $strLocation;
    var $aHeaderLines; // headers of last web page
    var $strFile; // last web page retreived
    /* $bResult - contains true if last web page was
        retrieved successfully, false otherwise. */
    var $bResult;

    /* ReadHttpFile - the function that does all the work.
        $strUrl - URL of the page we want to get.
        $iHttpRedirectMaxRecursiveCalls - maximum number of
        times following HTTP redirection. */        
    function ReadHttpFile($strUrl, $iHttpRedirectMaxRecursiveCalls = 20)
    {
        // parsing the url getting web server name/IP, path and port.
        $url = parse_url($strUrl);
        // setting path to "/" if not present in $strUrl
        if (isset($url["path"]) == false) $url["path"] = "/";
        // setting port to default HTTP server port 80
        if (isset($url["port"]) == false) $url["port"] = 80;
        // connecting to the server
        $fp = fsockopen ($url["host"], $url["port"], $errno, $errstr, 30);


        // reseting class data        
        $this->bResult = false;
        unset($this->strFile);
        unset($this->aHeaderLines);
        $this->strFile ="";
        $this->strLocation = $strUrl;

        /* Return if the socket was not open $this->bResult is set to false. */
        if (!$fp)
            return;
        else
        {
            // composing HTTP request
            $strQuery = "GET ".$url["path"];
            if (isset($url["query"]) == true) $strQuery .= "?".$url["query"];
            $strQuery .= " HTTP/1.0\r\n";
			$strQuery .= "Host: ".$url["port"]."\r\n";
			$strQuery .= "Connection: Close\r\n\r\n";
            // sending the request to the server
            fputs($fp, $strQuery);
            /* $bHeader is set to true while we receive the HTTP header
            and after the empty line (end of HTTP header) it's set to false. */
            $bHeader = true;
            // continuing untill there's no more text to read from the socket
            while (!feof($fp))
            {
                /* reading a line of text from the socket
                    not more than 8192 symbols. */
                $strLine = fgets($fp, 8192);
                // removing trailing \n and \r characters.
                $strLine = ereg_replace("[\r\n]", "", $strLine);
                if ($bHeader == false) 
                    $this->strFile .= $strLine."\n";
                else
                    $this->aHeaderLines[] = trim($strLine);
                if (strlen($strLine) == 0) $bHeader = false;
            }
            fclose ($fp);
        }

        /* Processing all HTTP header lines and checking for
            HTTP redirect directive 'Location:'. */
        for ($i = 0; $i < count($this->aHeaderLines); $i++)
            if (strcasecmp(substr($this->aHeaderLines[$i], 0, 9), "Location:") == 0)
            {
                $url = trim(substr($this->aHeaderLines[$i], 9));
                // $url now is the URL of the web page we are relocated to
                // If $url is the same page we are requesting, just continue
                if ($url != $strUrl)
                {
                    /* If the maximum number of redirects is reached,
                        just return. $this->bResult is set to false. */
                    if ($iHttpRedirectMaxRecursiveCalls == 0) return;
                    /* Calling the function recursively with the new URL
                    and the maximum number of redirections reduced by one. */
                    return $this->ReadHttpFile(
                                $url,
                                $iHttpRedirectMaxRecursiveCalls-1);
                }
            }

        /* We should get here if there was no HTTP redirect directive found.
            Setting $this->bResult to true. Web page was retreived successfully. */
        $this->bResult = true;
        
        /* If magic_quotes_runtime is enabled in php.ini, then all the quotes
            in the received text will be prefixed with slashes. */
        if (ini_get("magic_quotes_runtime"))
        {
            $this->strFile = stripslashes($this->strFile);
            for ($i = 0; $i < count($this->aHeaderLines); $i++)
                $this->aHeaderLines[$i] = stripslashes($this->aHeaderLines[$i]);
        }
    }

    /* Just to make it easier to use this class, adding contructor
        which accepts URL as a parameter and calls ReadHttpFile functions. */
    function CDWHttpFile($strUrl = "")
    {
        if (strlen($strUrl) > 0)
            $this->ReadHttpFile($strUrl);
    }
}
?>