<?php switch(Yii::app()->controller->action->id): case 'index':?>
    <!-- PAGE RELATED PLUGIN(S) -->
    <!-- Flot Chart Plugin: Flot Engine, Flot Resizer, Flot Tooltip -->
    <script src="/public/pandora/js/plugin/flot/jquery.flot.cust.min.js"></script>
    <script src="/public/pandora/js/plugin/flot/jquery.flot.resize.min.js"></script>
    <script src="/public/pandora/js/plugin/flot/jquery.flot.time.min.js"></script>
    <script src="/public/pandora/js/plugin/flot/jquery.flot.tooltip.min.js"></script>
    <!-- Vector Maps Plugin: Vectormap engine, Vectormap language -->
    <script src="/public/pandora/js/plugin/vectormap/jquery-jvectormap-1.2.2.min.js"></script>
    <script src="/public/pandora/js/plugin/vectormap/jquery-jvectormap-world-mill-en.js"></script>
    <!-- Full Calendar -->
    <script src="/public/pandora/js/plugin/moment/moment.min.js"></script>
    <script src="/public/pandora/js/plugin/fullcalendar/jquery.fullcalendar.min.js"></script>
    <script>
        $(document).ready(function() {

            // DO NOT REMOVE : GLOBAL FUNCTIONS!
            pageSetUp();

            /*
             * PAGE RELATED SCRIPTS
             */

            $(".js-status-update a").click(function() {
                var selText = $(this).text();
                var $this = $(this);
                $this.parents('.btn-group').find('.dropdown-toggle').html(selText + ' <span class="caret"></span>');
                $this.parents('.dropdown-menu').find('li').removeClass('active');
                $this.parent().addClass('active');
            });

            /*
             * TODO: add a way to add more todo's to list
             */

            // initialize sortable
            $(function() {
                $("#sortable1, #sortable2").sortable({
                    handle: '.handle',
                    connectWith: ".todo",
                    update: countTasks
                }).disableSelection();
            });

            // check and uncheck
            $('.todo .checkbox > input[type="checkbox"]').click(function() {
                var $this = $(this).parent().parent().parent();

                if ($(this).prop('checked')) {
                    $this.addClass("complete");

                    // remove this if you want to undo a check list once checked
                    //$(this).attr("disabled", true);
                    $(this).parent().hide();

                    // once clicked - add class, copy to memory then remove and add to sortable3
                    $this.slideUp(500, function() {
                        $this.clone().prependTo("#sortable3").effect("highlight", {}, 800);
                        $this.remove();
                        countTasks();
                    });
                } else {
                    // insert undo code here...
                }

            })
            // count tasks
            function countTasks() {

                $('.todo-group-title').each(function() {
                    var $this = $(this);
                    $this.find(".num-of-tasks").text($this.next().find("li").size());
                });

            }

            /*
             * RUN PAGE GRAPHS
             */

            /* TAB 1: UPDATING CHART */
            // For the demo we use generated data, but normally it would be coming from the server

            var data = [],
                totalPoints = 200,
                $UpdatingChartColors = $("#updating-chart").css('color');

            function getRandomData() {
                if (data.length > 0)
                    data = data.slice(1);

                // do a random walk
                while (data.length < totalPoints) {
                    var prev = data.length > 0 ? data[data.length - 1] : 50;
                    var y = prev + Math.random() * 10 - 5;
                    if (y < 0)
                        y = 0;
                    if (y > 100)
                        y = 100;
                    data.push(y);
                }

                // zip the generated y values with the x values
                var res = [];
                for (var i = 0; i < data.length; ++i)
                    res.push([i, data[i]])
                return res;
            }

            // setup control widget
            var updateInterval = 1500;
            $("#updating-chart").val(updateInterval).change(function() {

                var v = $(this).val();
                if (v && !isNaN(+v)) {
                    updateInterval = +v;
                    $(this).val("" + updateInterval);
                }

            });

            // setup plot
            var options = {
                yaxis: {
                    min: 0,
                    max: 100
                },
                xaxis: {
                    min: 0,
                    max: 100
                },
                colors: [$UpdatingChartColors],
                series: {
                    lines: {
                        lineWidth: 1,
                        fill: true,
                        fillColor: {
                            colors: [{
                                opacity: 0.4
                            }, {
                                opacity: 0
                            }]
                        },
                        steps: false

                    }
                }
            };

            var plot = $.plot($("#updating-chart"), [getRandomData()], options);

            /* live switch */
            $('input[type="checkbox"]#start_interval').click(function() {
                if ($(this).prop('checked')) {
                    $on = true;
                    updateInterval = 1500;
                    update();
                } else {
                    clearInterval(updateInterval);
                    $on = false;
                }
            });

            function update() {
                if ($on == true) {
                    plot.setData([getRandomData()]);
                    plot.draw();
                    setTimeout(update, updateInterval);

                } else {
                    clearInterval(updateInterval)
                }

            }

            var $on = false;

            /*end updating chart*/

            /* TAB 2: Social Network  */

            $(function() {
                // jQuery Flot Chart
                var twitter = [
                        [1, 27],
                        [2, 34],
                        [3, 51],
                        [4, 48],
                        [5, 55],
                        [6, 65],
                        [7, 61],
                        [8, 70],
                        [9, 65],
                        [10, 75],
                        [11, 57],
                        [12, 59],
                        [13, 62]
                    ],
                    facebook = [
                        [1, 25],
                        [2, 31],
                        [3, 45],
                        [4, 37],
                        [5, 38],
                        [6, 40],
                        [7, 47],
                        [8, 55],
                        [9, 43],
                        [10, 50],
                        [11, 47],
                        [12, 39],
                        [13, 47]
                    ],
                    data = [{
                        label: "Twitter",
                        data: twitter,
                        lines: {
                            show: true,
                            lineWidth: 1,
                            fill: true,
                            fillColor: {
                                colors: [{
                                    opacity: 0.1
                                }, {
                                    opacity: 0.13
                                }]
                            }
                        },
                        points: {
                            show: true
                        }
                    }, {
                        label: "Facebook",
                        data: facebook,
                        lines: {
                            show: true,
                            lineWidth: 1,
                            fill: true,
                            fillColor: {
                                colors: [{
                                    opacity: 0.1
                                }, {
                                    opacity: 0.13
                                }]
                            }
                        },
                        points: {
                            show: true
                        }
                    }];

                var options = {
                    grid: {
                        hoverable: true
                    },
                    colors: ["#568A89", "#3276B1"],
                    tooltip: true,
                    tooltipOpts: {
                        //content : "Value <b>$x</b> Value <span>$y</span>",
                        defaultTheme: false
                    },
                    xaxis: {
                        ticks: [
                            [1, "JAN"],
                            [2, "FEB"],
                            [3, "MAR"],
                            [4, "APR"],
                            [5, "MAY"],
                            [6, "JUN"],
                            [7, "JUL"],
                            [8, "AUG"],
                            [9, "SEP"],
                            [10, "OCT"],
                            [11, "NOV"],
                            [12, "DEC"],
                            [13, "JAN+1"]
                        ]
                    },
                    yaxes: {

                    }
                };

                var plot3 = $.plot($("#statsChart"), data, options);
            });

            // END TAB 2

            // TAB THREE GRAPH //
            /* TAB 3: Revenew  */

            $(function() {

                var trgt = [
                        [1354586000000, 153],
                        [1364587000000, 658],
                        [1374588000000, 198],
                        [1384589000000, 663],
                        [1394590000000, 801],
                        [1404591000000, 1080],
                        [1414592000000, 353],
                        [1424593000000, 749],
                        [1434594000000, 523],
                        [1444595000000, 258],
                        [1454596000000, 688],
                        [1464597000000, 364]
                    ],
                    prft = [
                        [1354586000000, 53],
                        [1364587000000, 65],
                        [1374588000000, 98],
                        [1384589000000, 83],
                        [1394590000000, 980],
                        [1404591000000, 808],
                        [1414592000000, 720],
                        [1424593000000, 674],
                        [1434594000000, 23],
                        [1444595000000, 79],
                        [1454596000000, 88],
                        [1464597000000, 36]
                    ],
                    sgnups = [
                        [1354586000000, 647],
                        [1364587000000, 435],
                        [1374588000000, 784],
                        [1384589000000, 346],
                        [1394590000000, 487],
                        [1404591000000, 463],
                        [1414592000000, 479],
                        [1424593000000, 236],
                        [1434594000000, 843],
                        [1444595000000, 657],
                        [1454596000000, 241],
                        [1464597000000, 341]
                    ],
                    toggles = $("#rev-toggles"),
                    target = $("#flotcontainer");

                var data = [{
                    label: "Target Profit",
                    data: trgt,
                    bars: {
                        show: true,
                        align: "center",
                        barWidth: 30 * 30 * 60 * 1000 * 80
                    }
                }, {
                    label: "Actual Profit",
                    data: prft,
                    color: '#3276B1',
                    lines: {
                        show: true,
                        lineWidth: 3
                    },
                    points: {
                        show: true
                    }
                }, {
                    label: "Actual Signups",
                    data: sgnups,
                    color: '#71843F',
                    lines: {
                        show: true,
                        lineWidth: 1
                    },
                    points: {
                        show: true
                    }
                }]

                var options = {
                    grid: {
                        hoverable: true
                    },
                    tooltip: true,
                    tooltipOpts: {
                        //content: '%x - %y',
                        //dateFormat: '%b %y',
                        defaultTheme: false
                    },
                    xaxis: {
                        mode: "time"
                    },
                    yaxes: {
                        tickFormatter: function(val, axis) {
                            return "$" + val;
                        },
                        max: 1200
                    }

                };

                plot2 = null;

                function plotNow() {
                    var d = [];
                    toggles.find(':checkbox').each(function() {
                        if ($(this).is(':checked')) {
                            d.push(data[$(this).attr("name").substr(4, 1)]);
                        }
                    });
                    if (d.length > 0) {
                        if (plot2) {
                            plot2.setData(d);
                            plot2.draw();
                        } else {
                            plot2 = $.plot(target, d, options);
                        }
                    }

                };

                toggles.find(':checkbox').on('change', function() {
                    plotNow();
                });
                plotNow()

            });

            /*
             * VECTOR MAP
             */

            data_array = {
                "US": 4977,
                "AU": 4873,
                "IN": 3671,
                "BR": 2476,
                "TR": 1476,
                "CN": 146,
                "CA": 134,
                "BD": 100
            };

            $('#vector-map').vectorMap({
                map: 'world_mill_en',
                backgroundColor: '#fff',
                regionStyle: {
                    initial: {
                        fill: '#c4c4c4'
                    },
                    hover: {
                        "fill-opacity": 1
                    }
                },
                series: {
                    regions: [{
                        values: data_array,
                        scale: ['#85a8b6', '#4d7686'],
                        normalizeFunction: 'polynomial'
                    }]
                },
                onRegionLabelShow: function(e, el, code) {
                    if (typeof data_array[code] == 'undefined') {
                        e.preventDefault();
                    } else {
                        var countrylbl = data_array[code];
                        el.html(el.html() + ': ' + countrylbl + ' visits');
                    }
                }
            });

            /*
             * FULL CALENDAR JS
             */

            if ($("#calendar").length) {
                var date = new Date();
                var d = date.getDate();
                var m = date.getMonth();
                var y = date.getFullYear();

                var calendar = $('#calendar').fullCalendar({

                    editable: true,
                    draggable: true,
                    selectable: false,
                    selectHelper: true,
                    unselectAuto: false,
                    disableResizing: false,

                    header: {
                        left: 'title', //,today
                        center: 'prev, next, today',
                        right: 'month, agendaWeek, agenDay' //month, agendaDay,
                    },

                    select: function(start, end, allDay) {
                        var title = prompt('Event Title:');
                        if (title) {
                            calendar.fullCalendar('renderEvent', {
                                    title: title,
                                    start: start,
                                    end: end,
                                    allDay: allDay
                                }, true // make the event "stick"
                            );
                        }
                        calendar.fullCalendar('unselect');
                    },

                    events: [{
                        title: 'All Day Event',
                        start: new Date(y, m, 1),
                        description: 'long description',
                        className: ["event", "bg-color-greenLight"],
                        icon: 'fa-check'
                    }, {
                        title: 'Long Event',
                        start: new Date(y, m, d - 5),
                        end: new Date(y, m, d - 2),
                        className: ["event", "bg-color-red"],
                        icon: 'fa-lock'
                    }, {
                        id: 999,
                        title: 'Repeating Event',
                        start: new Date(y, m, d - 3, 16, 0),
                        allDay: false,
                        className: ["event", "bg-color-blue"],
                        icon: 'fa-clock-o'
                    }, {
                        id: 999,
                        title: 'Repeating Event',
                        start: new Date(y, m, d + 4, 16, 0),
                        allDay: false,
                        className: ["event", "bg-color-blue"],
                        icon: 'fa-clock-o'
                    }, {
                        title: 'Meeting',
                        start: new Date(y, m, d, 10, 30),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Lunch',
                        start: new Date(y, m, d, 12, 0),
                        end: new Date(y, m, d, 14, 0),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Birthday Party',
                        start: new Date(y, m, d + 1, 19, 0),
                        end: new Date(y, m, d + 1, 22, 30),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Smartadmin Open Day',
                        start: new Date(y, m, 28),
                        end: new Date(y, m, 29),
                        className: ["event", "bg-color-darken"]
                    }],

                    eventRender: function(event, element, icon) {
                        if (!event.description == "") {
                            element.find('.fc-event-title').append("<br/><span class='ultra-light'>" + event.description + "</span>");
                        }
                        if (!event.icon == "") {
                            element.find('.fc-event-title').append("<i class='air air-top-right fa " + event.icon + " '></i>");
                        }
                    }
                });

            };

            /* hide default buttons */
            $('.fc-header-right, .fc-header-center').hide();

            // calendar prev
            $('#calendar-buttons #btn-prev').click(function() {
                $('.fc-button-prev').click();
                return false;
            });

            // calendar next
            $('#calendar-buttons #btn-next').click(function() {
                $('.fc-button-next').click();
                return false;
            });

            // calendar today
            $('#calendar-buttons #btn-today').click(function() {
                $('.fc-button-today').click();
                return false;
            });

            // calendar month
            $('#mt').click(function() {
                $('#calendar').fullCalendar('changeView', 'month');
            });

            // calendar agenda week
            $('#ag').click(function() {
                $('#calendar').fullCalendar('changeView', 'agendaWeek');
            });

            // calendar agenda day
            $('#td').click(function() {
                $('#calendar').fullCalendar('changeView', 'agendaDay');
            });

            /*
             * CHAT
             */

            $.filter_input = $('#filter-chat-list');
            $.chat_users_container = $('#chat-container > .chat-list-body')
            $.chat_users = $('#chat-users')
            $.chat_list_btn = $('#chat-container > .chat-list-open-close');
            $.chat_body = $('#chat-body');

            /*
             * LIST FILTER (CHAT)
             */

            // custom css expression for a case-insensitive contains()
            jQuery.expr[':'].Contains = function(a, i, m) {
                return (a.textContent || a.innerText || "").toUpperCase().indexOf(m[3].toUpperCase()) >= 0;
            };

            function listFilter(list) { // header is any element, list is an unordered list
                // create and add the filter form to the header

                $.filter_input.change(function() {
                    var filter = $(this).val();
                    if (filter) {
                        // this finds all links in a list that contain the input,
                        // and hide the ones not containing the input while showing the ones that do
                        $.chat_users.find("a:not(:Contains(" + filter + "))").parent().slideUp();
                        $.chat_users.find("a:Contains(" + filter + ")").parent().slideDown();
                    } else {
                        $.chat_users.find("li").slideDown();
                    }
                    return false;
                }).keyup(function() {
                    // fire the above change event after every letter
                    $(this).change();

                });

            }

            // on dom ready
            listFilter($.chat_users);

            // open chat list
            $.chat_list_btn.click(function() {
                $(this).parent('#chat-container').toggleClass('open');
            })

            $.chat_body.animate({
                scrollTop: $.chat_body[0].scrollHeight
            }, 500);

        });
    </script>
    <?php break;?>

<?php case 'inbox': ?>
    <!-- PAGE RELATED PLUGIN(S) -->
    <script src="/public/pandora/js/plugin/delete-table-row/delete-table-row.min.js"></script>
    <script src="/public/pandora/js/plugin/summernote/summernote.min.js"></script>
    <script src="/public/pandora/js/plugin/select2/select2.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {

            // DO NOT REMOVE : GLOBAL FUNCTIONS!
            pageSetUp();

            // PAGE RELATED SCRIPTS

            /*
             * Fixed table height
             */

            tableHeightSize()

            $(window).resize(function() {
                tableHeightSize()
            })

            function tableHeightSize() {

                if ($('body').hasClass('menu-on-top')) {
                    var menuHeight = 68;
                    // nav height

                    var tableHeight = ($(window).height() - 224) - menuHeight;
                    if (tableHeight < (320 - menuHeight)) {
                        $('.table-wrap').css('height', (320 - menuHeight) + 'px');
                    } else {
                        $('.table-wrap').css('height', tableHeight + 'px');
                    }

                } else {
                    var tableHeight = $(window).height() - 224;
                    if (tableHeight < 320) {
                        $('.table-wrap').css('height', 320 + 'px');
                    } else {
                        $('.table-wrap').css('height', tableHeight + 'px');
                    }

                }

            }

            /*
             * LOAD INBOX MESSAGES
             */
            loadInbox();
            function loadInbox() {
                loadURL("/public/pandora/ajax/email/email-list.html", $('#inbox-content > .table-wrap'))
            }

            /*
             * Buttons (compose mail and inbox load)
             */
            $(".inbox-load").click(function() {
                loadInbox();
            });

            // compose email
            $("#compose-mail").click(function() {
                loadURL("/public/pandora/ajax/email-compose.html", $('#inbox-content > .table-wrap'));
            })

        });
    </script>
    <?php break;?>

<?php case 'flot': ?>
		<!-- PAGE RELATED PLUGIN(S) -->
		<!-- Flot Chart Plugin: Flot Engine, Flot Resizer, Flot Tooltip -->
		<script src="/public/pandora/js/plugin/flot/jquery.flot.cust.min.js"></script>
		<script src="/public/pandora/js/plugin/flot/jquery.flot.resize.min.js"></script>
		<script src="/public/pandora/js/plugin/flot/jquery.flot.fillbetween.min.js"></script>
		<script src="/public/pandora/js/plugin/flot/jquery.flot.orderBar.min.js"></script>
		<script src="/public/pandora/js/plugin/flot/jquery.flot.pie.min.js"></script>
		<script src="/public/pandora/js/plugin/flot/jquery.flot.time.min.js"></script>
		<script src="/public/pandora/js/plugin/flot/jquery.flot.tooltip.min.js"></script>

		<script type="text/javascript">
            // PAGE RELATED SCRIPTS

            /* chart colors default */
            var $chrt_border_color = "#efefef";
            var $chrt_grid_color = "#DDD"
            var $chrt_main = "#E24913";
            /* red       */
            var $chrt_second = "#6595b4";
            /* blue      */
            var $chrt_third = "#FF9F01";
            /* orange    */
            var $chrt_fourth = "#7e9d3a";
            /* green     */
            var $chrt_fifth = "#BD362F";
            /* dark red  */
            var $chrt_mono = "#000";

            $(document).ready(function() {

                // DO NOT REMOVE : GLOBAL FUNCTIONS!
                pageSetUp();

                /* sales chart */

                if ($("#saleschart").length) {
                    var d = [[1196463600000, 0], [1196550000000, 0], [1196636400000, 0], [1196722800000, 77], [1196809200000, 3636], [1196895600000, 3575], [1196982000000, 2736], [1197068400000, 1086], [1197154800000, 676], [1197241200000, 1205], [1197327600000, 906], [1197414000000, 710], [1197500400000, 639], [1197586800000, 540], [1197673200000, 435], [1197759600000, 301], [1197846000000, 575], [1197932400000, 481], [1198018800000, 591], [1198105200000, 608], [1198191600000, 459], [1198278000000, 234], [1198364400000, 1352], [1198450800000, 686], [1198537200000, 279], [1198623600000, 449], [1198710000000, 468], [1198796400000, 392], [1198882800000, 282], [1198969200000, 208], [1199055600000, 229], [1199142000000, 177], [1199228400000, 374], [1199314800000, 436], [1199401200000, 404], [1199487600000, 253], [1199574000000, 218], [1199660400000, 476], [1199746800000, 462], [1199833200000, 500], [1199919600000, 700], [1200006000000, 750], [1200092400000, 600], [1200178800000, 500], [1200265200000, 900], [1200351600000, 930], [1200438000000, 1200], [1200524400000, 980], [1200610800000, 950], [1200697200000, 900], [1200783600000, 1000], [1200870000000, 1050], [1200956400000, 1150], [1201042800000, 1100], [1201129200000, 1200], [1201215600000, 1300], [1201302000000, 1700], [1201388400000, 1450], [1201474800000, 1500], [1201561200000, 546], [1201647600000, 614], [1201734000000, 954], [1201820400000, 1700], [1201906800000, 1800], [1201993200000, 1900], [1202079600000, 2000], [1202166000000, 2100], [1202252400000, 2200], [1202338800000, 2300], [1202425200000, 2400], [1202511600000, 2550], [1202598000000, 2600], [1202684400000, 2500], [1202770800000, 2700], [1202857200000, 2750], [1202943600000, 2800], [1203030000000, 3245], [1203116400000, 3345], [1203202800000, 3000], [1203289200000, 3200], [1203375600000, 3300], [1203462000000, 3400], [1203548400000, 3600], [1203634800000, 3700], [1203721200000, 3800], [1203807600000, 4000], [1203894000000, 4500]];

                    for (var i = 0; i < d.length; ++i)
                        d[i][0] += 60 * 60 * 1000;

                    function weekendAreas(axes) {
                        var markings = [];
                        var d = new Date(axes.xaxis.min);
                        // go to the first Saturday
                        d.setUTCDate(d.getUTCDate() - ((d.getUTCDay() + 1) % 7))
                        d.setUTCSeconds(0);
                        d.setUTCMinutes(0);
                        d.setUTCHours(0);
                        var i = d.getTime();
                        do {
                            // when we don't set yaxis, the rectangle automatically
                            // extends to infinity upwards and downwards
                            markings.push({
                                xaxis : {
                                    from : i,
                                    to : i + 2 * 24 * 60 * 60 * 1000
                                }
                            });
                            i += 7 * 24 * 60 * 60 * 1000;
                        } while (i < axes.xaxis.max);

                        return markings;
                    }

                    var options = {
                        xaxis : {
                            mode : "time",
                            tickLength : 5
                        },
                        series : {
                            lines : {
                                show : true,
                                lineWidth : 1,
                                fill : true,
                                fillColor : {
                                    colors : [{
                                        opacity : 0.1
                                    }, {
                                        opacity : 0.15
                                    }]
                                }
                            },
                            //points: { show: true },
                            shadowSize : 0
                        },
                        selection : {
                            mode : "x"
                        },
                        grid : {
                            hoverable : true,
                            clickable : true,
                            tickColor : $chrt_border_color,
                            borderWidth : 0,
                            borderColor : $chrt_border_color,
                        },
                        tooltip : true,
                        tooltipOpts : {
                            content : "Your sales for <b>%x</b> was <span>$%y</span>",
                            dateFormat : "%y-%0m-%0d",
                            defaultTheme : false
                        },
                        colors : [$chrt_second]

                    };

                    var plot = $.plot($("#saleschart"), [d], options);
                };

                /* end sales chart */

                /* Sin chart */

                if ($("#sin-chart").length) {
                    var sin = [], cos = [];
                    for (var i = 0; i < 16; i += 0.5) {
                        sin.push([i, Math.sin(i)]);
                        cos.push([i, Math.cos(i)]);
                    }

                    var plot = $.plot($("#sin-chart"), [{
                        data : sin,
                        label : "sin(x)"
                    }, {
                        data : cos,
                        label : "cos(x)"
                    }], {
                        series : {
                            lines : {
                                show : true
                            },
                            points : {
                                show : true
                            }
                        },
                        grid : {
                            hoverable : true,
                            clickable : true,
                            tickColor : $chrt_border_color,
                            borderWidth : 0,
                            borderColor : $chrt_border_color,
                        },
                        tooltip : true,
                        tooltipOpts : {
                            //content : "Value <b>$x</b> Value <span>$y</span>",
                            defaultTheme : false
                        },
                        colors : [$chrt_second, $chrt_fourth],
                        yaxis : {
                            min : -1.1,
                            max : 1.1
                        },
                        xaxis : {
                            min : 0,
                            max : 15
                        }
                    });

                    $("#sin-chart").bind("plotclick", function(event, pos, item) {
                        if (item) {
                            $("#clickdata").text("You clicked point " + item.dataIndex + " in " + item.series.label + ".");
                            plot.highlight(item.series, item.datapoint);
                        }
                    });
                }

                /* end sin chart */

                /* bar chart */

                if ($("#bar-chart").length) {

                    var data1 = [];
                    for (var i = 0; i <= 12; i += 1)
                        data1.push([i, parseInt(Math.random() * 30)]);

                    var data2 = [];
                    for (var i = 0; i <= 12; i += 1)
                        data2.push([i, parseInt(Math.random() * 30)]);

                    var data3 = [];
                    for (var i = 0; i <= 12; i += 1)
                        data3.push([i, parseInt(Math.random() * 30)]);

                    var ds = new Array();

                    ds.push({
                        data : data1,
                        bars : {
                            show : true,
                            barWidth : 0.2,
                            order : 1,
                        }
                    });
                    ds.push({
                        data : data2,
                        bars : {
                            show : true,
                            barWidth : 0.2,
                            order : 2
                        }
                    });
                    ds.push({
                        data : data3,
                        bars : {
                            show : true,
                            barWidth : 0.2,
                            order : 3
                        }
                    });

                    //Display graph
                    $.plot($("#bar-chart"), ds, {
                        colors : [$chrt_second, $chrt_fourth, "#666", "#BBB"],
                        grid : {
                            show : true,
                            hoverable : true,
                            clickable : true,
                            tickColor : $chrt_border_color,
                            borderWidth : 0,
                            borderColor : $chrt_border_color,
                        },
                        legend : true,
                        tooltip : true,
                        tooltipOpts : {
                            content : "<b>%x</b> = <span>%y</span>",
                            defaultTheme : false
                        }

                    });

                }

                /* end bar chart */

                /* bar-chart-h */
                if ($("#bar-chart-h").length) {
                    //Display horizontal graph
                    var d1_h = [];
                    for (var i = 0; i <= 3; i += 1)
                        d1_h.push([parseInt(Math.random() * 30), i]);

                    var d2_h = [];
                    for (var i = 0; i <= 3; i += 1)
                        d2_h.push([parseInt(Math.random() * 30), i]);

                    var d3_h = [];
                    for (var i = 0; i <= 3; i += 1)
                        d3_h.push([parseInt(Math.random() * 30), i]);

                    var ds_h = new Array();
                    ds_h.push({
                        data : d1_h,
                        bars : {
                            horizontal : true,
                            show : true,
                            barWidth : 0.2,
                            order : 1
                        }
                    });
                    ds_h.push({
                        data : d2_h,
                        bars : {
                            horizontal : true,
                            show : true,
                            barWidth : 0.2,
                            order : 2
                        }
                    });
                    ds_h.push({
                        data : d3_h,
                        bars : {
                            horizontal : true,
                            show : true,
                            barWidth : 0.2,
                            order : 3
                        }
                    });

                    // display graph
                    $.plot($("#bar-chart-h"), ds_h, {
                        colors : [$chrt_second, $chrt_fourth, "#666", "#BBB"],
                        grid : {
                            show : true,
                            hoverable : true,
                            clickable : true,
                            tickColor : $chrt_border_color,
                            borderWidth : 0,
                            borderColor : $chrt_border_color,
                        },
                        legend : true,
                        tooltip : true,
                        tooltipOpts : {
                            content : "<b>%x</b> = <span>%y</span>",
                            defaultTheme : false
                        }
                    });

                }

                /* end bar-chart-h

                 /* fill chart */

                if ($("#fill-chart").length) {
                    var males = {
                        '15%' : [[2, 88.0], [3, 93.3], [4, 102.0], [5, 108.5], [6, 115.7], [7, 115.6], [8, 124.6], [9, 130.3], [10, 134.3], [11, 141.4], [12, 146.5], [13, 151.7], [14, 159.9], [15, 165.4], [16, 167.8], [17, 168.7], [18, 169.5], [19, 168.0]],
                        '90%' : [[2, 96.8], [3, 105.2], [4, 113.9], [5, 120.8], [6, 127.0], [7, 133.1], [8, 139.1], [9, 143.9], [10, 151.3], [11, 161.1], [12, 164.8], [13, 173.5], [14, 179.0], [15, 182.0], [16, 186.9], [17, 185.2], [18, 186.3], [19, 186.6]],
                        '25%' : [[2, 89.2], [3, 94.9], [4, 104.4], [5, 111.4], [6, 117.5], [7, 120.2], [8, 127.1], [9, 132.9], [10, 136.8], [11, 144.4], [12, 149.5], [13, 154.1], [14, 163.1], [15, 169.2], [16, 170.4], [17, 171.2], [18, 172.4], [19, 170.8]],
                        '10%' : [[2, 86.9], [3, 92.6], [4, 99.9], [5, 107.0], [6, 114.0], [7, 113.5], [8, 123.6], [9, 129.2], [10, 133.0], [11, 140.6], [12, 145.2], [13, 149.7], [14, 158.4], [15, 163.5], [16, 166.9], [17, 167.5], [18, 167.1], [19, 165.3]],
                        'mean' : [[2, 91.9], [3, 98.5], [4, 107.1], [5, 114.4], [6, 120.6], [7, 124.7], [8, 131.1], [9, 136.8], [10, 142.3], [11, 150.0], [12, 154.7], [13, 161.9], [14, 168.7], [15, 173.6], [16, 175.9], [17, 176.6], [18, 176.8], [19, 176.7]],
                        '75%' : [[2, 94.5], [3, 102.1], [4, 110.8], [5, 117.9], [6, 124.0], [7, 129.3], [8, 134.6], [9, 141.4], [10, 147.0], [11, 156.1], [12, 160.3], [13, 168.3], [14, 174.7], [15, 178.0], [16, 180.2], [17, 181.7], [18, 181.3], [19, 182.5]],
                        '85%' : [[2, 96.2], [3, 103.8], [4, 111.8], [5, 119.6], [6, 125.6], [7, 131.5], [8, 138.0], [9, 143.3], [10, 149.3], [11, 159.8], [12, 162.5], [13, 171.3], [14, 177.5], [15, 180.2], [16, 183.8], [17, 183.4], [18, 183.5], [19, 185.5]],
                        '50%' : [[2, 91.9], [3, 98.2], [4, 106.8], [5, 114.6], [6, 120.8], [7, 125.2], [8, 130.3], [9, 137.1], [10, 141.5], [11, 149.4], [12, 153.9], [13, 162.2], [14, 169.0], [15, 174.8], [16, 176.0], [17, 176.8], [18, 176.4], [19, 177.4]]
                    };

                    var females = {
                        '15%' : [[2, 84.8], [3, 93.7], [4, 100.6], [5, 105.8], [6, 113.3], [7, 119.3], [8, 124.3], [9, 131.4], [10, 136.9], [11, 143.8], [12, 149.4], [13, 151.2], [14, 152.3], [15, 155.9], [16, 154.7], [17, 157.0], [18, 156.1], [19, 155.4]],
                        '90%' : [[2, 95.6], [3, 104.1], [4, 111.9], [5, 119.6], [6, 127.6], [7, 133.1], [8, 138.7], [9, 147.1], [10, 152.8], [11, 161.3], [12, 166.6], [13, 167.9], [14, 169.3], [15, 170.1], [16, 172.4], [17, 169.2], [18, 171.1], [19, 172.4]],
                        '25%' : [[2, 87.2], [3, 95.9], [4, 101.9], [5, 107.4], [6, 114.8], [7, 121.4], [8, 126.8], [9, 133.4], [10, 138.6], [11, 146.2], [12, 152.0], [13, 153.8], [14, 155.7], [15, 158.4], [16, 157.0], [17, 158.5], [18, 158.4], [19, 158.1]],
                        '10%' : [[2, 84.0], [3, 91.9], [4, 99.2], [5, 105.2], [6, 112.7], [7, 118.0], [8, 123.3], [9, 130.2], [10, 135.0], [11, 141.1], [12, 148.3], [13, 150.0], [14, 150.7], [15, 154.3], [16, 153.6], [17, 155.6], [18, 154.7], [19, 153.1]],
                        'mean' : [[2, 90.2], [3, 98.3], [4, 105.2], [5, 112.2], [6, 119.0], [7, 125.8], [8, 131.3], [9, 138.6], [10, 144.2], [11, 151.3], [12, 156.7], [13, 158.6], [14, 160.5], [15, 162.1], [16, 162.9], [17, 162.2], [18, 163.0], [19, 163.1]],
                        '75%' : [[2, 93.2], [3, 101.5], [4, 107.9], [5, 116.6], [6, 122.8], [7, 129.3], [8, 135.2], [9, 143.7], [10, 148.7], [11, 156.9], [12, 160.8], [13, 163.0], [14, 165.0], [15, 165.8], [16, 168.7], [17, 166.2], [18, 167.6], [19, 168.0]],
                        '85%' : [[2, 94.5], [3, 102.8], [4, 110.4], [5, 119.0], [6, 125.7], [7, 131.5], [8, 137.9], [9, 146.0], [10, 151.3], [11, 159.9], [12, 164.0], [13, 166.5], [14, 167.5], [15, 168.5], [16, 171.5], [17, 168.0], [18, 169.8], [19, 170.3]],
                        '50%' : [[2, 90.2], [3, 98.1], [4, 105.2], [5, 111.7], [6, 118.2], [7, 125.6], [8, 130.5], [9, 138.3], [10, 143.7], [11, 151.4], [12, 156.7], [13, 157.7], [14, 161.0], [15, 162.0], [16, 162.8], [17, 162.2], [18, 162.8], [19, 163.3]]
                    };

                    var dataset = [{
                        label : 'female mean',
                        data : females['mean'],
                        lines : {
                            show : true
                        },
                        color : "rgb(255,50,50)"
                    }, {
                        id : 'f15%',
                        data : females['15%'],
                        lines : {
                            show : true,
                            lineWidth : 0,
                            fill : false
                        },
                        color : "rgb(255,50,50)"
                    }, {
                        id : 'f25%',
                        data : females['25%'],
                        lines : {
                            show : true,
                            lineWidth : 0,
                            fill : 0.2
                        },
                        color : "rgb(255,50,50)",
                        fillBetween : 'f15%'
                    }, {
                        id : 'f50%',
                        data : females['50%'],
                        lines : {
                            show : true,
                            lineWidth : 0.5,
                            fill : 0.4,
                            shadowSize : 0
                        },
                        color : "rgb(255,50,50)",
                        fillBetween : 'f25%'
                    }, {
                        id : 'f75%',
                        data : females['75%'],
                        lines : {
                            show : true,
                            lineWidth : 0,
                            fill : 0.4
                        },
                        color : "rgb(255,50,50)",
                        fillBetween : 'f50%'
                    }, {
                        id : 'f85%',
                        data : females['85%'],
                        lines : {
                            show : true,
                            lineWidth : 0,
                            fill : 0.2
                        },
                        color : "rgb(255,50,50)",
                        fillBetween : 'f75%'
                    }, {
                        label : 'male mean',
                        data : males['mean'],
                        lines : {
                            show : true
                        },
                        color : "rgb(50,50,255)"
                    }, {
                        id : 'm15%',
                        data : males['15%'],
                        lines : {
                            show : true,
                            lineWidth : 0,
                            fill : false
                        },
                        color : "rgb(50,50,255)"
                    }, {
                        id : 'm25%',
                        data : males['25%'],
                        lines : {
                            show : true,
                            lineWidth : 0,
                            fill : 0.2
                        },
                        color : "rgb(50,50,255)",
                        fillBetween : 'm15%'
                    }, {
                        id : 'm50%',
                        data : males['50%'],
                        lines : {
                            show : true,
                            lineWidth : 0.5,
                            fill : 0.4,
                            shadowSize : 0
                        },
                        color : "rgb(50,50,255)",
                        fillBetween : 'm25%'
                    }, {
                        id : 'm75%',
                        data : males['75%'],
                        lines : {
                            show : true,
                            lineWidth : 0,
                            fill : 0.4
                        },
                        color : "rgb(50,50,255)",
                        fillBetween : 'm50%'
                    }, {
                        id : 'm85%',
                        data : males['85%'],
                        lines : {
                            show : true,
                            lineWidth : 0,
                            fill : 0.2
                        },
                        color : "rgb(50,50,255)",
                        fillBetween : 'm75%'
                    }]

                    $.plot($("#fill-chart"), dataset, {

                        xaxis : {
                            tickDecimals : 0
                        },

                        yaxis : {
                            tickFormatter : function(v) {
                                return v + " cm";
                            }
                        },

                    });
                }

                /* end fill chart */

                /* pie chart */

                if ($('#pie-chart').length) {

                    var data_pie = [];
                    var series = Math.floor(Math.random() * 10) + 1;
                    for (var i = 0; i < series; i++) {
                        data_pie[i] = {
                            label : "Series" + (i + 1),
                            data : Math.floor(Math.random() * 100) + 1
                        }
                    }

                    $.plot($("#pie-chart"), data_pie, {
                        series : {
                            pie : {
                                show : true,
                                innerRadius : 0.5,
                                radius : 1,
                                label : {
                                    show : false,
                                    radius : 2 / 3,
                                    formatter : function(label, series) {
                                        return '<div style="font-size:11px;text-align:center;padding:4px;color:white;">' + label + '<br/>' + Math.round(series.percent) + '%</div>';
                                    },
                                    threshold : 0.1
                                }
                            }
                        },
                        legend : {
                            show : true,
                            noColumns : 1, // number of colums in legend table
                            labelFormatter : null, // fn: string -> string
                            labelBoxBorderColor : "#000", // border color for the little label boxes
                            container : null, // container (as jQuery object) to put legend in, null means default on top of graph
                            position : "ne", // position of default legend container within plot
                            margin : [5, 10], // distance from grid edge to default legend container within plot
                            backgroundColor : "#efefef", // null means auto-detect
                            backgroundOpacity : 1 // set to 0 to avoid background
                        },
                        grid : {
                            hoverable : true,
                            clickable : true
                        },
                    });

                }

                /* end pie chart */

                /* site stats chart */

                if ($("#site-stats").length) {

                    var pageviews = [[1, 75], [3, 87], [4, 93], [5, 127], [6, 116], [7, 137], [8, 135], [9, 130], [10, 167], [11, 169], [12, 179], [13, 185], [14, 176], [15, 180], [16, 174], [17, 193], [18, 186], [19, 177], [20, 153], [21, 149], [22, 130], [23, 100], [24, 50]];
                    var visitors = [[1, 65], [3, 50], [4, 73], [5, 100], [6, 95], [7, 103], [8, 111], [9, 97], [10, 125], [11, 100], [12, 95], [13, 141], [14, 126], [15, 131], [16, 146], [17, 158], [18, 160], [19, 151], [20, 125], [21, 110], [22, 100], [23, 85], [24, 37]];
                    //console.log(pageviews)
                    var plot = $.plot($("#site-stats"), [{
                        data : pageviews,
                        label : "Your pageviews"
                    }, {
                        data : visitors,
                        label : "Site visitors"
                    }], {
                        series : {
                            lines : {
                                show : true,
                                lineWidth : 1,
                                fill : true,
                                fillColor : {
                                    colors : [{
                                        opacity : 0.1
                                    }, {
                                        opacity : 0.15
                                    }]
                                }
                            },
                            points : {
                                show : true
                            },
                            shadowSize : 0
                        },
                        xaxis : {
                            mode : "time",
                            tickLength : 10
                        },

                        yaxes : [{
                            min : 20,
                            tickLength : 5
                        }],
                        grid : {
                            hoverable : true,
                            clickable : true,
                            tickColor : $chrt_border_color,
                            borderWidth : 0,
                            borderColor : $chrt_border_color,
                        },
                        tooltip : true,
                        tooltipOpts : {
                            content : "%s for <b>%x:00 hrs</b> was %y",
                            dateFormat : "%y-%0m-%0d",
                            defaultTheme : false
                        },
                        colors : [$chrt_main, $chrt_second],
                        xaxis : {
                            ticks : 15,
                            tickDecimals : 2
                        },
                        yaxis : {
                            ticks : 15,
                            tickDecimals : 0
                        },
                    });

                }

                /* end site stats */

                /* updating chart */

                if ($('#updating-chart').length) {

                    // For the demo we use generated data, but normally it would be coming from the server
                    var data = [], totalPoints = 200;
                    function getRandomData() {
                        if (data.length > 0)
                            data = data.slice(1);

                        // do a random walk
                        while (data.length < totalPoints) {
                            var prev = data.length > 0 ? data[data.length - 1] : 50;
                            var y = prev + Math.random() * 10 - 5;
                            if (y < 0)
                                y = 0;
                            if (y > 100)
                                y = 100;
                            data.push(y);
                        }

                        // zip the generated y values with the x values
                        var res = [];
                        for (var i = 0; i < data.length; ++i)
                            res.push([i, data[i]])
                        return res;
                    }

                    // setup control widget
                    var updateInterval = 1000;
                    $("#updating-chart").val(updateInterval).change(function() {
                        var v = $(this).val();
                        if (v && !isNaN(+v)) {
                            updateInterval = +v;
                            if (updateInterval < 1)
                                updateInterval = 1;
                            if (updateInterval > 2000)
                                updateInterval = 2000;
                            $(this).val("" + updateInterval);
                        }
                    });

                    // setup plot
                    var options = {
                        yaxis : {
                            min : 0,
                            max : 100
                        },
                        xaxis : {
                            min : 0,
                            max : 100
                        },
                        colors : [$chrt_fourth],
                        series : {
                            lines : {
                                lineWidth : 1,
                                fill : true,
                                fillColor : {
                                    colors : [{
                                        opacity : 0.4
                                    }, {
                                        opacity : 0
                                    }]
                                },
                                steps : false

                            }
                        }
                    };
                    var plot = $.plot($("#updating-chart"), [getRandomData()], options);

                    function update() {
                        plot.setData([getRandomData()]);
                        // since the axes don't change, we don't need to call plot.setupGrid()
                        plot.draw();

                        setTimeout(update, updateInterval);
                    }

                    update();

                }

                /*end updating chart*/

            });

            /* end flot charts */

        </script>
    <?php break;?>

<?php case 'morris': ?>
		<!-- PAGE RELATED PLUGIN(S) -->

		<!-- Morris Chart Dependencies -->
		<script src="/public/pandora/js/plugin/morris/raphael.min.js"></script>
		<script src="/public/pandora/js/plugin/morris/morris.min.js"></script>

		<script type="text/javascript">
            // PAGE RELATED SCRIPTS

            /*
             * Run all morris chart on this page
             */
            $(document).ready(function() {

                // DO NOT REMOVE : GLOBAL FUNCTIONS!
                pageSetUp();

                if ($('#sales-graph').length) {

                    Morris.Area({
                        element : 'sales-graph',
                        data : [{
                            period : '2010 Q1',
                            iphone : 2666,
                            ipad : null,
                            itouch : 2647
                        }, {
                            period : '2010 Q2',
                            iphone : 2778,
                            ipad : 2294,
                            itouch : 2441
                        }, {
                            period : '2010 Q3',
                            iphone : 4912,
                            ipad : 1969,
                            itouch : 2501
                        }, {
                            period : '2010 Q4',
                            iphone : 3767,
                            ipad : 3597,
                            itouch : 5689
                        }, {
                            period : '2011 Q1',
                            iphone : 6810,
                            ipad : 1914,
                            itouch : 2293
                        }, {
                            period : '2011 Q2',
                            iphone : 5670,
                            ipad : 4293,
                            itouch : 1881
                        }, {
                            period : '2011 Q3',
                            iphone : 4820,
                            ipad : 3795,
                            itouch : 1588
                        }, {
                            period : '2011 Q4',
                            iphone : 15073,
                            ipad : 5967,
                            itouch : 5175
                        }, {
                            period : '2012 Q1',
                            iphone : 10687,
                            ipad : 4460,
                            itouch : 2028
                        }, {
                            period : '2012 Q2',
                            iphone : 8432,
                            ipad : 5713,
                            itouch : 1791
                        }],
                        xkey : 'period',
                        ykeys : ['iphone', 'ipad', 'itouch'],
                        labels : ['iPhone', 'iPad', 'iPod Touch'],
                        pointSize : 2,
                        hideHover : 'auto'
                    });

                }

                // area graph
                if ($('#area-graph').length) {
                    Morris.Area({
                        element : 'area-graph',
                        data : [{
                            x : '2011 Q1',
                            y : 3,
                            z : 3
                        }, {
                            x : '2011 Q2',
                            y : 2,
                            z : 0
                        }, {
                            x : '2011 Q3',
                            y : 0,
                            z : 2
                        }, {
                            x : '2011 Q4',
                            y : 4,
                            z : 4
                        }],
                        xkey : 'x',
                        ykeys : ['y', 'z'],
                        labels : ['Y', 'Z']
                    });
                }

                // bar graph color
                if ($('#bar-graph').length) {

                    Morris.Bar({
                        element : 'bar-graph',
                        data : [{
                            x : '2011 Q1',
                            y : 0
                        }, {
                            x : '2011 Q2',
                            y : 1
                        }, {
                            x : '2011 Q3',
                            y : 2
                        }, {
                            x : '2011 Q4',
                            y : 3
                        }, {
                            x : '2012 Q1',
                            y : 4
                        }, {
                            x : '2012 Q2',
                            y : 5
                        }, {
                            x : '2012 Q3',
                            y : 6
                        }, {
                            x : '2012 Q4',
                            y : 7
                        }, {
                            x : '2013 Q1',
                            y : 8
                        }],
                        xkey : 'x',
                        ykeys : ['y'],
                        labels : ['Y'],
                        barColors : function(row, series, type) {
                            if (type === 'bar') {
                                var red = Math.ceil(150 * row.y / this.ymax);
                                return 'rgb(' + red + ',0,0)';
                            } else {
                                return '#000';
                            }
                        }
                    });

                }

                // Use Morris.Bar
                if ($('#normal-bar-graph').length) {

                    Morris.Bar({
                        element : 'normal-bar-graph',
                        data : [{
                            x : '2011 Q1',
                            y : 3,
                            z : 2,
                            a : 3
                        }, {
                            x : '2011 Q2',
                            y : 2,
                            z : null,
                            a : 1
                        }, {
                            x : '2011 Q3',
                            y : 0,
                            z : 2,
                            a : 4
                        }, {
                            x : '2011 Q4',
                            y : 2,
                            z : 4,
                            a : 3
                        }],
                        xkey : 'x',
                        ykeys : ['y', 'z', 'a'],
                        labels : ['Y', 'Z', 'A']
                    });

                }

                // Use Morris.Bar 2
                if ($('#noline-bar-graph').length) {
                    Morris.Bar({
                        element : 'noline-bar-graph',
                        axes : false,
                        data : [{
                            x : '2011 Q1',
                            y : 3,
                            z : 2,
                            a : 3
                        }, {
                            x : '2011 Q2',
                            y : 2,
                            z : null,
                            a : 1
                        }, {
                            x : '2011 Q3',
                            y : 0,
                            z : 2,
                            a : 4
                        }, {
                            x : '2011 Q4',
                            y : 2,
                            z : 4,
                            a : 3
                        }],
                        xkey : 'x',
                        ykeys : ['y', 'z', 'a'],
                        labels : ['Y', 'Z', 'A']
                    });
                }

                /* data stolen from http://howmanyleft.co.uk/vehicle/jaguar_'e'_type */
                if ($('#year-graph').length) {
                    var day_data = [{
                        "period" : "2012-10-01",
                        "licensed" : 3407,
                        "sorned" : 660
                    }, {
                        "period" : "2012-09-30",
                        "licensed" : 3351,
                        "sorned" : 629
                    }, {
                        "period" : "2012-09-29",
                        "licensed" : 3269,
                        "sorned" : 618
                    }, {
                        "period" : "2012-09-20",
                        "licensed" : 3246,
                        "sorned" : 661
                    }, {
                        "period" : "2012-09-19",
                        "licensed" : 3257,
                        "sorned" : 667
                    }, {
                        "period" : "2012-09-18",
                        "licensed" : 3248,
                        "sorned" : 627
                    }, {
                        "period" : "2012-09-17",
                        "licensed" : 3171,
                        "sorned" : 660
                    }, {
                        "period" : "2012-09-16",
                        "licensed" : 3171,
                        "sorned" : 676
                    }, {
                        "period" : "2012-09-15",
                        "licensed" : 3201,
                        "sorned" : 656
                    }, {
                        "period" : "2012-09-10",
                        "licensed" : 3215,
                        "sorned" : 622
                    }];
                    Morris.Line({
                        element : 'year-graph',
                        data : day_data,
                        xkey : 'period',
                        ykeys : ['licensed', 'sorned'],
                        labels : ['Licensed', 'SORN']
                    })
                }

                // decimal data
                if ($('#decimal-graph').length) {
                    var decimal_data = [];
                    for (var x = 0; x <= 360; x += 10) {
                        decimal_data.push({
                            x : x,
                            y : Math.sin(Math.PI * x / 180).toFixed(4)
                        });
                    }
                    window.m = Morris.Line({
                        element : 'decimal-graph',
                        data : decimal_data,
                        xkey : 'x',
                        ykeys : ['y'],
                        labels : ['sin(x)'],
                        parseTime : false,
                        hoverCallback : function(index, options) {
                            var row = options.data[index];
                            return "sin(" + row.x + ") = " + row.y;
                        },
                        xLabelMargin : 10
                    });
                }

                // donut
                if ($('#donut-graph').length) {
                    Morris.Donut({
                        element : 'donut-graph',
                        data : [{
                            value : 70,
                            label : 'foo'
                        }, {
                            value : 15,
                            label : 'bar'
                        }, {
                            value : 10,
                            label : 'baz'
                        }, {
                            value : 5,
                            label : 'A really really long label'
                        }],
                        formatter : function(x) {
                            return x + "%"
                        }
                    });
                }

                // time formatter
                if ($('#time-graph').length) {
                    var week_data = [{
                        "period" : "2011 W27",
                        "licensed" : 3407,
                        "sorned" : 660
                    }, {
                        "period" : "2011 W26",
                        "licensed" : 3351,
                        "sorned" : 629
                    }, {
                        "period" : "2011 W25",
                        "licensed" : 3269,
                        "sorned" : 618
                    }, {
                        "period" : "2011 W24",
                        "licensed" : 3246,
                        "sorned" : 661
                    }, {
                        "period" : "2011 W23",
                        "licensed" : 3257,
                        "sorned" : 667
                    }, {
                        "period" : "2011 W22",
                        "licensed" : 3248,
                        "sorned" : 627
                    }, {
                        "period" : "2011 W21",
                        "licensed" : 3171,
                        "sorned" : 660
                    }, {
                        "period" : "2011 W20",
                        "licensed" : 3171,
                        "sorned" : 676
                    }, {
                        "period" : "2011 W19",
                        "licensed" : 3201,
                        "sorned" : 656
                    }, {
                        "period" : "2011 W18",
                        "licensed" : 3215,
                        "sorned" : 622
                    }, {
                        "period" : "2011 W17",
                        "licensed" : 3148,
                        "sorned" : 632
                    }, {
                        "period" : "2011 W16",
                        "licensed" : 3155,
                        "sorned" : 681
                    }, {
                        "period" : "2011 W15",
                        "licensed" : 3190,
                        "sorned" : 667
                    }, {
                        "period" : "2011 W14",
                        "licensed" : 3226,
                        "sorned" : 620
                    }, {
                        "period" : "2011 W13",
                        "licensed" : 3245,
                        "sorned" : null
                    }, {
                        "period" : "2011 W12",
                        "licensed" : 3289,
                        "sorned" : null
                    }, {
                        "period" : "2011 W11",
                        "licensed" : 3263,
                        "sorned" : null
                    }, {
                        "period" : "2011 W10",
                        "licensed" : 3189,
                        "sorned" : null
                    }, {
                        "period" : "2011 W09",
                        "licensed" : 3079,
                        "sorned" : null
                    }, {
                        "period" : "2011 W08",
                        "licensed" : 3085,
                        "sorned" : null
                    }, {
                        "period" : "2011 W07",
                        "licensed" : 3055,
                        "sorned" : null
                    }, {
                        "period" : "2011 W06",
                        "licensed" : 3063,
                        "sorned" : null
                    }, {
                        "period" : "2011 W05",
                        "licensed" : 2943,
                        "sorned" : null
                    }, {
                        "period" : "2011 W04",
                        "licensed" : 2806,
                        "sorned" : null
                    }, {
                        "period" : "2011 W03",
                        "licensed" : 2674,
                        "sorned" : null
                    }, {
                        "period" : "2011 W02",
                        "licensed" : 1702,
                        "sorned" : null
                    }, {
                        "period" : "2011 W01",
                        "licensed" : 1732,
                        "sorned" : null
                    }];
                    Morris.Line({
                        element : 'time-graph',
                        data : week_data,
                        xkey : 'period',
                        ykeys : ['licensed', 'sorned'],
                        labels : ['Licensed', 'SORN'],
                        events : ['2011-04', '2011-08']
                    });
                }

                // negative value
                if ($('#graph-B').length) {
                    var neg_data = [{
                        "period" : "2011-08-12",
                        "a" : 100
                    }, {
                        "period" : "2011-03-03",
                        "a" : 75
                    }, {
                        "period" : "2010-08-08",
                        "a" : 50
                    }, {
                        "period" : "2010-05-10",
                        "a" : 25
                    }, {
                        "period" : "2010-03-14",
                        "a" : 0
                    }, {
                        "period" : "2010-01-10",
                        "a" : -25
                    }, {
                        "period" : "2009-12-10",
                        "a" : -50
                    }, {
                        "period" : "2009-10-07",
                        "a" : -75
                    }, {
                        "period" : "2009-09-25",
                        "a" : -100
                    }];
                    Morris.Line({
                        element : 'graph-B',
                        data : neg_data,
                        xkey : 'period',
                        ykeys : ['a'],
                        labels : ['Series A'],
                        units : '%'
                    });
                }

                // no grid
                /* data stolen from http://howmanyleft.co.uk/vehicle/jaguar_'e'_type */
                if ($('#nogrid-graph').length) {
                    var day_data = [{
                        "period" : "2012-10-01",
                        "licensed" : 3407,
                        "sorned" : 660
                    }, {
                        "period" : "2012-09-30",
                        "licensed" : 3351,
                        "sorned" : 629
                    }, {
                        "period" : "2012-09-29",
                        "licensed" : 3269,
                        "sorned" : 618
                    }, {
                        "period" : "2012-09-20",
                        "licensed" : 3246,
                        "sorned" : 661
                    }, {
                        "period" : "2012-09-19",
                        "licensed" : 3257,
                        "sorned" : 667
                    }, {
                        "period" : "2012-09-18",
                        "licensed" : 3248,
                        "sorned" : 627
                    }, {
                        "period" : "2012-09-17",
                        "licensed" : 3171,
                        "sorned" : 660
                    }, {
                        "period" : "2012-09-16",
                        "licensed" : 3171,
                        "sorned" : 676
                    }, {
                        "period" : "2012-09-15",
                        "licensed" : 3201,
                        "sorned" : 656
                    }, {
                        "period" : "2012-09-10",
                        "licensed" : 3215,
                        "sorned" : 622
                    }];
                    Morris.Line({
                        element : 'nogrid-graph',
                        grid : false,
                        data : day_data,
                        xkey : 'period',
                        ykeys : ['licensed', 'sorned'],
                        labels : ['Licensed', 'SORN']
                    });
                }

                // non-continus data
                /* data stolen from http://howmanyleft.co.uk/vehicle/jaguar_'e'_type */
                if ($('#non-continu-graph').length) {
                    var day_data = [{
                        "period" : "2012-10-01",
                        "licensed" : 3407
                    }, {
                        "period" : "2012-09-30",
                        "sorned" : 0
                    }, {
                        "period" : "2012-09-29",
                        "sorned" : 618
                    }, {
                        "period" : "2012-09-20",
                        "licensed" : 3246,
                        "sorned" : 661
                    }, {
                        "period" : "2012-09-19",
                        "licensed" : 3257,
                        "sorned" : null
                    }, {
                        "period" : "2012-09-18",
                        "licensed" : 3248,
                        "other" : 1000
                    }, {
                        "period" : "2012-09-17",
                        "sorned" : 0
                    }, {
                        "period" : "2012-09-16",
                        "sorned" : 0
                    }, {
                        "period" : "2012-09-15",
                        "licensed" : 3201,
                        "sorned" : 656
                    }, {
                        "period" : "2012-09-10",
                        "licensed" : 3215
                    }];
                    Morris.Line({
                        element : 'non-continu-graph',
                        data : day_data,
                        xkey : 'period',
                        ykeys : ['licensed', 'sorned', 'other'],
                        labels : ['Licensed', 'SORN', 'Other'],
                        /* custom label formatting with `xLabelFormat` */
                        xLabelFormat : function(d) {
                            return (d.getMonth() + 1) + '/' + d.getDate() + '/' + d.getFullYear();
                        },
                        /* setting `xLabels` is recommended when using xLabelFormat */
                        xLabels : 'day'
                    });
                }

                // non date data
                if ($('#non-date-graph').length) {
                    var day_data = [{
                        "elapsed" : "I",
                        "value" : 34
                    }, {
                        "elapsed" : "II",
                        "value" : 24
                    }, {
                        "elapsed" : "III",
                        "value" : 3
                    }, {
                        "elapsed" : "IV",
                        "value" : 12
                    }, {
                        "elapsed" : "V",
                        "value" : 13
                    }, {
                        "elapsed" : "VI",
                        "value" : 22
                    }, {
                        "elapsed" : "VII",
                        "value" : 5
                    }, {
                        "elapsed" : "VIII",
                        "value" : 26
                    }, {
                        "elapsed" : "IX",
                        "value" : 12
                    }, {
                        "elapsed" : "X",
                        "value" : 19
                    }];
                    Morris.Line({
                        element : 'non-date-graph',
                        data : day_data,
                        xkey : 'elapsed',
                        ykeys : ['value'],
                        labels : ['value'],
                        parseTime : false
                    });
                }

                //stacked bar
                if ($('#stacked-bar-graph').length) {
                    Morris.Bar({
                        element : 'stacked-bar-graph',
                        axes : false,
                        grid : false,
                        data : [{
                            x : '2011 Q1',
                            y : 3,
                            z : 2,
                            a : 3
                        }, {
                            x : '2011 Q2',
                            y : 2,
                            z : null,
                            a : 1
                        }, {
                            x : '2011 Q3',
                            y : 0,
                            z : 2,
                            a : 4
                        }, {
                            x : '2011 Q4',
                            y : 2,
                            z : 4,
                            a : 3
                        }],
                        xkey : 'x',
                        ykeys : ['y', 'z', 'a'],
                        labels : ['Y', 'Z', 'A'],
                        stacked : true
                    });
                }

                // interval
                if ($('#interval-graph').length) {

                    var nReloads = 0;
                    function data(offset) {
                        var ret = [];
                        for (var x = 0; x <= 360; x += 10) {
                            var v = (offset + x) % 360;
                            ret.push({
                                x : x,
                                y : Math.sin(Math.PI * v / 180).toFixed(4),
                                z : Math.cos(Math.PI * v / 180).toFixed(4)
                            });
                        }
                        return ret;
                    }

                    var graph = Morris.Line({
                        element : 'interval-graph',
                        data : data(0),
                        xkey : 'x',
                        ykeys : ['y', 'z'],
                        labels : ['sin()', 'cos()'],
                        parseTime : false,
                        ymin : -1.0,
                        ymax : 1.0,
                        hideHover : true
                    });
                    function update() {
                        nReloads++;
                        graph.setData(data(5 * nReloads));
                        $('#reloadStatus').text(nReloads + ' reloads');
                    }

                    setInterval(update, 100);
                }

            });

            //setup_flots();
            /* end flot charts */

        </script>
    <?php break; ?>

<?php case 'inlinecharts': ?>
    <script type="text/javascript">
        // DO NOT REMOVE : GLOBAL FUNCTIONS!
        $(document).ready(function() {
            pageSetUp();
        })
    </script>
    <?php break; ?>

<?php case 'dygraphs': ?>
    		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/dygraphs/demo-data.min.js"></script>
		<!-- DYGRAPH -->
		<script src="/public/pandora/js/plugin/dygraphs/dygraph-combined.min.js"></script>

		<script type="text/javascript">

            $(document).ready(function() {
                // DO NOT REMOVE : GLOBAL FUNCTIONS!
                pageSetUp();

                /*
                 * PAGE RELATED SCRIPTS
                 */

                g1 = new Dygraph(document.getElementById("noroll"), data_temp, {
                    customBars : true,
                    title : 'Daily Temperatures in New York vs. San Francisco',
                    ylabel : 'Temperature (F)',
                    legend : 'always',
                    labelsDivStyles : {
                        'textAlign' : 'right'
                    },
                    showRangeSelector : true
                });

                g2 = new Dygraph(document.getElementById("roll14"), data_temp, {
                    rollPeriod : 14,
                    showRoller : true,
                    customBars : true,
                    ylabel : 'Temperature (F)',
                    legend : 'always',
                    labelsDivStyles : {
                        'textAlign' : 'right'
                    },
                    showRangeSelector : true,
                    rangeSelectorHeight : 30,
                    rangeSelectorPlotStrokeColor : 'yellow',
                    rangeSelectorPlotFillColor : 'lightyellow'
                });

            })
        </script>
    <?php break; ?>

<?php case 'chartjs': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->
		<script src="/public/pandora/js/plugin/chartjs/chart.min.js"></script>

		<script type="text/javascript">

            $(document).ready(function() {

                /* DO NOT REMOVE : GLOBAL FUNCTIONS!
                 *
                 * pageSetUp(); WILL CALL THE FOLLOWING FUNCTIONS
                 *
                 * // activate tooltips
                 * $("[rel=tooltip]").tooltip();
                 *
                 * // activate popovers
                 * $("[rel=popover]").popover();
                 *
                 * // activate popovers with hover states
                 * $("[rel=popover-hover]").popover({ trigger: "hover" });
                 *
                 * // activate inline charts
                 * runAllCharts();
                 *
                 * // setup widgets
                 * setup_widgets_desktop();
                 *
                 * // run form elements
                 * runAllForms();
                 *
                 ********************************
                 *
                 * pageSetUp() is needed whenever you load a page.
                 * It initializes and checks for all basic elements of the page
                 * and makes rendering easier.
                 *
                 */

                pageSetUp();

                /*
                 * ALL PAGE RELATED SCRIPTS CAN GO BELOW HERE
                 * eg alert("my home function");
                 *
                 * var pagefunction = function() {
                 *   ...
                 * }
                 * loadScript("js/plugin/_PLUGIN_NAME_.js", pagefunction);
                 *
                 * TO LOAD A SCRIPT:
                 * var pagefunction = function (){
                 *  loadScript(".../plugin.js", run_after_loaded);
                 * }
                 *
                 * OR
                 *
                 * loadScript(".../plugin.js", run_after_loaded);
                 */

                // reference: http://www.chartjs.org/docs/

                // LINE CHART
                // ref: http://www.chartjs.org/docs/#line-chart-introduction
                var lineOptions = {
                    ///Boolean - Whether grid lines are shown across the chart
                    scaleShowGridLines : true,
                    //String - Colour of the grid lines
                    scaleGridLineColor : "rgba(0,0,0,.05)",
                    //Number - Width of the grid lines
                    scaleGridLineWidth : 1,
                    //Boolean - Whether the line is curved between points
                    bezierCurve : true,
                    //Number - Tension of the bezier curve between points
                    bezierCurveTension : 0.4,
                    //Boolean - Whether to show a dot for each point
                    pointDot : true,
                    //Number - Radius of each point dot in pixels
                    pointDotRadius : 4,
                    //Number - Pixel width of point dot stroke
                    pointDotStrokeWidth : 1,
                    //Number - amount extra to add to the radius to cater for hit detection outside the drawn point
                    pointHitDetectionRadius : 20,
                    //Boolean - Whether to show a stroke for datasets
                    datasetStroke : true,
                    //Number - Pixel width of dataset stroke
                    datasetStrokeWidth : 2,
                    //Boolean - Whether to fill the dataset with a colour
                    datasetFill : true,
                    //Boolean - Re-draw chart on page resize
                    responsive: true,
                    //String - A legend template
                    legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].lineColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>"
                };

                var lineData = { labels: ["January", "February", "March", "April", "May", "June", "July"],
                    datasets: [
                        {
                            label: "My First dataset",
                            fillColor: "rgba(220,220,220,0.2)",
                            strokeColor: "rgba(220,220,220,1)",
                            pointColor: "rgba(220,220,220,1)",
                            pointStrokeColor: "#fff",
                            pointHighlightFill: "#fff",
                            pointHighlightStroke: "rgba(220,220,220,1)",
                            data: [65, 59, 80, 81, 56, 55, 40]
                        },
                        {
                            label: "My Second dataset",
                            fillColor: "rgba(151,187,205,0.2)",
                            strokeColor: "rgba(151,187,205,1)",
                            pointColor: "rgba(151,187,205,1)",
                            pointStrokeColor: "#fff",
                            pointHighlightFill: "#fff",
                            pointHighlightStroke: "rgba(151,187,205,1)",
                            data: [28, 48, 40, 19, 86, 27, 90]
                        }
                    ]
                };

                // render chart
                var ctx = document.getElementById("lineChart").getContext("2d");
                var myNewChart = new Chart(ctx).Line(lineData, lineOptions);

                // END LINE CHART

                // BAR CHART

                var barOptions = {
                    //Boolean - Whether the scale should start at zero, or an order of magnitude down from the lowest value
                    scaleBeginAtZero : true,
                    //Boolean - Whether grid lines are shown across the chart
                    scaleShowGridLines : true,
                    //String - Colour of the grid lines
                    scaleGridLineColor : "rgba(0,0,0,.05)",
                    //Number - Width of the grid lines
                    scaleGridLineWidth : 1,
                    //Boolean - If there is a stroke on each bar
                    barShowStroke : true,
                    //Number - Pixel width of the bar stroke
                    barStrokeWidth : 1,
                    //Number - Spacing between each of the X value sets
                    barValueSpacing : 5,
                    //Number - Spacing between data sets within X values
                    barDatasetSpacing : 1,
                    //Boolean - Re-draw chart on page resize
                    responsive: true,
                    //String - A legend template
                    legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].lineColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>"
                }

                var barData = {
                    labels: ["January", "February", "March", "April", "May", "June", "July"],
                    datasets: [
                        {
                            label: "My First dataset",
                            fillColor: "rgba(220,220,220,0.5)",
                            strokeColor: "rgba(220,220,220,0.8)",
                            highlightFill: "rgba(220,220,220,0.75)",
                            highlightStroke: "rgba(220,220,220,1)",
                            data: [65, 59, 80, 81, 56, 55, 40]
                        },
                        {
                            label: "My Second dataset",
                            fillColor: "rgba(151,187,205,0.5)",
                            strokeColor: "rgba(151,187,205,0.8)",
                            highlightFill: "rgba(151,187,205,0.75)",
                            highlightStroke: "rgba(151,187,205,1)",
                            data: [28, 48, 40, 19, 86, 27, 90]
                        }
                    ]
                };

                // render chart
                var ctx = document.getElementById("barChart").getContext("2d");
                var myNewChart = new Chart(ctx).Bar(barData, barOptions);

                // END BAR CHART

                // POLAR CHART

                var polarOptions = {
                    //Boolean - Show a backdrop to the scale label
                    scaleShowLabelBackdrop : true,
                    //String - The colour of the label backdrop
                    scaleBackdropColor : "rgba(255,255,255,0.75)",
                    // Boolean - Whether the scale should begin at zero
                    scaleBeginAtZero : true,
                    //Number - The backdrop padding above & below the label in pixels
                    scaleBackdropPaddingY : 2,
                    //Number - The backdrop padding to the side of the label in pixels
                    scaleBackdropPaddingX : 2,
                    //Boolean - Show line for each value in the scale
                    scaleShowLine : true,
                    //Boolean - Stroke a line around each segment in the chart
                    segmentShowStroke : true,
                    //String - The colour of the stroke on each segement.
                    segmentStrokeColor : "#fff",
                    //Number - The width of the stroke value in pixels
                    segmentStrokeWidth : 2,
                    //Number - Amount of animation steps
                    animationSteps : 100,
                    //String - Animation easing effect.
                    animationEasing : "easeOutBounce",
                    //Boolean - Whether to animate the rotation of the chart
                    animateRotate : true,
                    //Boolean - Whether to animate scaling the chart from the centre
                    animateScale : false,
                    //Boolean - Re-draw chart on page resize
                    responsive: true,
                    //String - A legend template
                    legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<segments.length; i++){%><li><span style=\"background-color:<%=segments[i].fillColor%>\"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>"
                };

                var polarData = [
                    {
                        value: 300,
                        color:"rgba(220,220,220,0.8)",
                        highlight: "rgba(220,220,220,0.7)",
                        label: "Grey"
                    },
                    {
                        value: 50,
                        color: "rgba(151,187,205,1)",
                        highlight: "rgba(151,187,205,0.8)",
                        label: "Blue"
                    },
                    {
                        value: 100,
                        color: "rgba(169, 3, 41, 0.7)",
                        highlight: "rgba(169, 3, 41, 0.7)",
                        label: "Red"
                    },
                    {
                        value: 40,
                        color: "#949FB1",
                        highlight: "#A8B3C5",
                        label: "Grey"
                    },
                    {
                        value: 120,
                        color: "#4D5360",
                        highlight: "#616774",
                        label: "Dark Grey"
                    }
                ];

                // render chart
                var ctx = document.getElementById("polarChart").getContext("2d");
                var myNewChart = new Chart(ctx).PolarArea(polarData, polarOptions);

                // END POLAR CHART

                // DOUGNUT CHART

                var doughnutOptions = {
                    //Boolean - Whether we should show a stroke on each segment
                    segmentShowStroke : true,
                    //String - The colour of each segment stroke
                    segmentStrokeColor : "#fff",
                    //Number - The width of each segment stroke
                    segmentStrokeWidth : 2,
                    //Number - The percentage of the chart that we cut out of the middle
                    percentageInnerCutout : 50, // This is 0 for Pie charts
                    //Number - Amount of animation steps
                    animationSteps : 100,
                    //String - Animation easing effect
                    animationEasing : "easeOutBounce",
                    //Boolean - Whether we animate the rotation of the Doughnut
                    animateRotate : true,
                    //Boolean - Whether we animate scaling the Doughnut from the centre
                    animateScale : false,
                    //Boolean - Re-draw chart on page resize
                    responsive: true,
                    //String - A legend template
                    legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<segments.length; i++){%><li><span style=\"background-color:<%=segments[i].fillColor%>\"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>"
                };

                var doughnutData = [
                    {
                        value: 300,
                        color:"rgba(220,220,220,0.8)",
                        highlight: "rgba(220,220,220,0.7)",
                        label: "Grey"
                    },
                    {
                        value: 50,
                        color: "rgba(151,187,205,1)",
                        highlight: "rgba(151,187,205,0.8)",
                        label: "Blue"
                    },
                    {
                        value: 100,
                        color: "rgba(169, 3, 41, 0.7)",
                        highlight: "rgba(169, 3, 41, 0.7)",
                        label: "Red"
                    }
                ];

                // render chart
                var ctx = document.getElementById("doughnutChart").getContext("2d");
                var myNewChart = new Chart(ctx).Doughnut(doughnutData, doughnutOptions);

                // END DOUGHNUT CHART

                // RADAR CHART

                var radarData = {
                    labels: ["Eating", "Drinking", "Sleeping", "Designing", "Coding", "Cycling", "Running"],
                    datasets: [
                        {
                            label: "My First dataset",
                            fillColor: "rgba(220,220,220,0.2)",
                            strokeColor: "rgba(220,220,220,1)",
                            pointColor: "rgba(220,220,220,1)",
                            pointStrokeColor: "#fff",
                            pointHighlightFill: "#fff",
                            pointHighlightStroke: "rgba(220,220,220,1)",
                            data: [65, 59, 90, 81, 56, 55, 40]
                        },
                        {
                            label: "My Second dataset",
                            fillColor: "rgba(151,187,205,0.2)",
                            strokeColor: "rgba(151,187,205,1)",
                            pointColor: "rgba(151,187,205,1)",
                            pointStrokeColor: "#fff",
                            pointHighlightFill: "#fff",
                            pointHighlightStroke: "rgba(151,187,205,1)",
                            data: [28, 48, 40, 19, 96, 27, 100]
                        }
                    ]
                };

                var radarOptions = {
                    //Boolean - Whether to show lines for each scale point
                    scaleShowLine : true,
                    //Boolean - Whether we show the angle lines out of the radar
                    angleShowLineOut : true,
                    //Boolean - Whether to show labels on the scale
                    scaleShowLabels : false,
                    // Boolean - Whether the scale should begin at zero
                    scaleBeginAtZero : true,
                    //String - Colour of the angle line
                    angleLineColor : "rgba(0,0,0,.1)",
                    //Number - Pixel width of the angle line
                    angleLineWidth : 1,
                    //String - Point label font declaration
                    pointLabelFontFamily : "'Arial'",
                    //String - Point label font weight
                    pointLabelFontStyle : "normal",
                    //Number - Point label font size in pixels
                    pointLabelFontSize : 10,
                    //String - Point label font colour
                    pointLabelFontColor : "#666",
                    //Boolean - Whether to show a dot for each point
                    pointDot : true,
                    //Number - Radius of each point dot in pixels
                    pointDotRadius : 3,
                    //Number - Pixel width of point dot stroke
                    pointDotStrokeWidth : 1,
                    //Number - amount extra to add to the radius to cater for hit detection outside the drawn point
                    pointHitDetectionRadius : 20,
                    //Boolean - Whether to show a stroke for datasets
                    datasetStroke : true,
                    //Number - Pixel width of dataset stroke
                    datasetStrokeWidth : 2,
                    //Boolean - Whether to fill the dataset with a colour
                    datasetFill : true,
                    //Boolean - Re-draw chart on page resize
                    responsive: true,
                    //String - A legend template
                    legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].lineColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>"
                }

                // render chart
                var ctx = document.getElementById("radarChart").getContext("2d");
                var myNewChart = new Chart(ctx).Radar(radarData, radarOptions);

                // END RADAR CHART

                // PIE CHART

                var pieOptions = {
                    //Boolean - Whether we should show a stroke on each segment
                    segmentShowStroke: true,
                    //String - The colour of each segment stroke
                    segmentStrokeColor: "#fff",
                    //Number - The width of each segment stroke
                    segmentStrokeWidth: 2,
                    //Number - Amount of animation steps
                    animationSteps: 100,
                    //String - types of animation
                    animationEasing: "easeOutBounce",
                    //Boolean - Whether we animate the rotation of the Doughnut
                    animateRotate: true,
                    //Boolean - Whether we animate scaling the Doughnut from the centre
                    animateScale: false,
                    //Boolean - Re-draw chart on page resize
                    responsive: true,
                    //String - A legend template
                    legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<segments.length; i++){%><li><span style=\"background-color:<%=segments[i].fillColor%>\"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>"
                };

                var pieData = [
                    {
                        value: 300,
                        color:"rgba(220,220,220,0.9)",
                        highlight: "rgba(220,220,220,0.8)",
                        label: "Grey"
                    },
                    {
                        value: 50,
                        color: "rgba(151,187,205,1)",
                        highlight: "rgba(151,187,205,0.8)",
                        label: "Blue"
                    },
                    {
                        value: 100,
                        color: "rgba(169, 3, 41, 0.7)",
                        highlight: "rgba(169, 3, 41, 0.7)",
                        label: "Red"
                    }
                ];

                // render chart
                var ctx = document.getElementById("pieChart").getContext("2d");
                var myNewChart = new Chart(ctx).Pie(pieData, pieOptions);

                // END PIE CHART

            })

        </script>
    <?php break; ?>

<?php case 'table': ?>
    <!-- PAGE RELATED PLUGIN(S) -->
		<script type="text/javascript">
            // DO NOT REMOVE : GLOBAL FUNCTIONS!
            $(document).ready(function() {
                pageSetUp();
            })
        </script>
    <?php break; ?>

<?php case 'datatables': ?>
    		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/datatables/jquery.dataTables.min.js"></script>
		<script src="/public/pandora/js/plugin/datatables/dataTables.colVis.min.js"></script>
		<script src="/public/pandora/js/plugin/datatables/dataTables.tableTools.min.js"></script>
		<script src="/public/pandora/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
		<script src="/public/pandora/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                /* // DOM Position key index //

                 l - Length changing (dropdown)
                 f - Filtering input (search)
                 t - The Table! (datatable)
                 i - Information (records)
                 p - Pagination (paging)
                 r - pRocessing
                 < and > - div elements
                 <"#id" and > - div with an id
                 <"class" and > - div with a class
                 <"#id.class" and > - div with an id and class

                 Also see: http://legacy.datatables.net/usage/features
                 */

                /* BASIC ;*/
                var responsiveHelper_dt_basic = undefined;
                var responsiveHelper_datatable_fixed_column = undefined;
                var responsiveHelper_datatable_col_reorder = undefined;
                var responsiveHelper_datatable_tabletools = undefined;

                var breakpointDefinition = {
                    tablet : 1024,
                    phone : 480
                };

                $('#dt_basic').dataTable({
                    "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'col-sm-6 col-xs-12 hidden-xs'l>r>"+
                    "t"+
                    "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
                    "autoWidth" : true,
                    "preDrawCallback" : function() {
                        // Initialize the responsive datatables helper once.
                        if (!responsiveHelper_dt_basic) {
                            responsiveHelper_dt_basic = new ResponsiveDatatablesHelper($('#dt_basic'), breakpointDefinition);
                        }
                    },
                    "rowCallback" : function(nRow) {
                        responsiveHelper_dt_basic.createExpandIcon(nRow);
                    },
                    "drawCallback" : function(oSettings) {
                        responsiveHelper_dt_basic.respond();
                    }
                });

                /* END BASIC */

                /* COLUMN FILTER  */
                var otable = $('#datatable_fixed_column').DataTable({
                    //"bFilter": false,
                    //"bInfo": false,
                    //"bLengthChange": false
                    //"bAutoWidth": false,
                    //"bPaginate": false,
                    //"bStateSave": true // saves sort state using localStorage
                    "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6 hidden-xs'f><'col-sm-6 col-xs-12 hidden-xs'<'toolbar'>>r>"+
                    "t"+
                    "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
                    "autoWidth" : true,
                    "preDrawCallback" : function() {
                        // Initialize the responsive datatables helper once.
                        if (!responsiveHelper_datatable_fixed_column) {
                            responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                        }
                    },
                    "rowCallback" : function(nRow) {
                        responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
                    },
                    "drawCallback" : function(oSettings) {
                        responsiveHelper_datatable_fixed_column.respond();
                    }

                });

                // custom toolbar
                $("div.toolbar").html('<div class="text-right"><img src="/public/pandora/img/logo.png" alt="SmartAdmin" style="width: 111px; margin-top: 3px; margin-right: 10px;"></div>');

                // Apply the filter
                $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {

                    otable
                        .column( $(this).parent().index()+':visible' )
                        .search( this.value )
                        .draw();

                } );
                /* END COLUMN FILTER */

                /* COLUMN SHOW - HIDE */
                $('#datatable_col_reorder').dataTable({
                    "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs'C>r>"+
                    "t"+
                    "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
                    "autoWidth" : true,
                    "preDrawCallback" : function() {
                        // Initialize the responsive datatables helper once.
                        if (!responsiveHelper_datatable_col_reorder) {
                            responsiveHelper_datatable_col_reorder = new ResponsiveDatatablesHelper($('#datatable_col_reorder'), breakpointDefinition);
                        }
                    },
                    "rowCallback" : function(nRow) {
                        responsiveHelper_datatable_col_reorder.createExpandIcon(nRow);
                    },
                    "drawCallback" : function(oSettings) {
                        responsiveHelper_datatable_col_reorder.respond();
                    }
                });

                /* END COLUMN SHOW - HIDE */

                /* TABLETOOLS */
                $('#datatable_tabletools').dataTable({

                    // Tabletools options:
                    //   https://datatables.net/extensions/tabletools/button_options
                    "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs'T>r>"+
                    "t"+
                    "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
                    "oTableTools": {
                        "aButtons": [
                            "copy",
                            "csv",
                            "xls",
                            {
                                "sExtends": "pdf",
                                "sTitle": "SmartAdmin_PDF",
                                "sPdfMessage": "SmartAdmin PDF Export",
                                "sPdfSize": "letter"
                            },
                            {
                                "sExtends": "print",
                                "sMessage": "Generated by SmartAdmin <i>(press Esc to close)</i>"
                            }
                        ],
                        "sSwfPath": "/public/pandora/js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
                    },
                    "autoWidth" : true,
                    "preDrawCallback" : function() {
                        // Initialize the responsive datatables helper once.
                        if (!responsiveHelper_datatable_tabletools) {
                            responsiveHelper_datatable_tabletools = new ResponsiveDatatablesHelper($('#datatable_tabletools'), breakpointDefinition);
                        }
                    },
                    "rowCallback" : function(nRow) {
                        responsiveHelper_datatable_tabletools.createExpandIcon(nRow);
                    },
                    "drawCallback" : function(oSettings) {
                        responsiveHelper_datatable_tabletools.respond();
                    }
                });

                /* END TABLETOOLS */

            })

        </script>
    <?php break; ?>

<?php case 'jqgrid': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script src="/public/pandora/js/plugin/jqgrid/jquery.jqGrid.min.js"></script>
		<script src="/public/pandora/js/plugin/jqgrid/grid.locale-en.min.js"></script>

		<script type="text/javascript">
            $(document).ready(function() {
                pageSetUp();

                var jqgrid_data = [{
                    id : "1",
                    date : "2007-10-01",
                    name : "test",
                    note : "note",
                    amount : "200.00",
                    tax : "10.00",
                    total : "210.00"
                }, {
                    id : "2",
                    date : "2007-10-02",
                    name : "test2",
                    note : "note2",
                    amount : "300.00",
                    tax : "20.00",
                    total : "320.00"
                }, {
                    id : "3",
                    date : "2007-09-01",
                    name : "test3",
                    note : "note3",
                    amount : "400.00",
                    tax : "30.00",
                    total : "430.00"
                }, {
                    id : "4",
                    date : "2007-10-04",
                    name : "test",
                    note : "note",
                    amount : "200.00",
                    tax : "10.00",
                    total : "210.00"
                }, {
                    id : "5",
                    date : "2007-10-05",
                    name : "test2",
                    note : "note2",
                    amount : "300.00",
                    tax : "20.00",
                    total : "320.00"
                }, {
                    id : "6",
                    date : "2007-09-06",
                    name : "test3",
                    note : "note3",
                    amount : "400.00",
                    tax : "30.00",
                    total : "430.00"
                }, {
                    id : "7",
                    date : "2007-10-04",
                    name : "test",
                    note : "note",
                    amount : "200.00",
                    tax : "10.00",
                    total : "210.00"
                }, {
                    id : "8",
                    date : "2007-10-03",
                    name : "test2",
                    note : "note2",
                    amount : "300.00",
                    tax : "20.00",
                    total : "320.00"
                }, {
                    id : "9",
                    date : "2007-09-01",
                    name : "test3",
                    note : "note3",
                    amount : "400.00",
                    tax : "30.00",
                    total : "430.00"
                }, {
                    id : "10",
                    date : "2007-10-01",
                    name : "test",
                    note : "note",
                    amount : "200.00",
                    tax : "10.00",
                    total : "210.00"
                }, {
                    id : "11",
                    date : "2007-10-02",
                    name : "test2",
                    note : "note2",
                    amount : "300.00",
                    tax : "20.00",
                    total : "320.00"
                }, {
                    id : "12",
                    date : "2007-09-01",
                    name : "test3",
                    note : "note3",
                    amount : "400.00",
                    tax : "30.00",
                    total : "430.00"
                }, {
                    id : "13",
                    date : "2007-10-04",
                    name : "test",
                    note : "note",
                    amount : "200.00",
                    tax : "10.00",
                    total : "210.00"
                }, {
                    id : "14",
                    date : "2007-10-05",
                    name : "test2",
                    note : "note2",
                    amount : "300.00",
                    tax : "20.00",
                    total : "320.00"
                }, {
                    id : "15",
                    date : "2007-09-06",
                    name : "test3",
                    note : "note3",
                    amount : "400.00",
                    tax : "30.00",
                    total : "430.00"
                }, {
                    id : "16",
                    date : "2007-10-04",
                    name : "test",
                    note : "note",
                    amount : "200.00",
                    tax : "10.00",
                    total : "210.00"
                }, {
                    id : "17",
                    date : "2007-10-03",
                    name : "test2",
                    note : "note2",
                    amount : "300.00",
                    tax : "20.00",
                    total : "320.00"
                }, {
                    id : "18",
                    date : "2007-09-01",
                    name : "test3",
                    note : "note3",
                    amount : "400.00",
                    tax : "30.00",
                    total : "430.00"
                }];

                jQuery("#jqgrid").jqGrid({
                    data : jqgrid_data,
                    datatype : "local",
                    height : 'auto',
                    colNames : ['Actions', 'Inv No', 'Date', 'Client', 'Amount', 'Tax', 'Total', 'Notes'],
                    colModel : [{
                        name : 'act',
                        index : 'act',
                        sortable : false
                    }, {
                        name : 'id',
                        index : 'id'
                    }, {
                        name : 'date',
                        index : 'date',
                        editable : true
                    }, {
                        name : 'name',
                        index : 'name',
                        editable : true
                    }, {
                        name : 'amount',
                        index : 'amount',
                        align : "right",
                        editable : true
                    }, {
                        name : 'tax',
                        index : 'tax',
                        align : "right",
                        editable : true
                    }, {
                        name : 'total',
                        index : 'total',
                        align : "right",
                        editable : true
                    }, {
                        name : 'note',
                        index : 'note',
                        sortable : false,
                        editable : true
                    }],
                    rowNum : 10,
                    rowList : [10, 20, 30],
                    pager : '#pjqgrid',
                    sortname : 'id',
                    toolbarfilter : true,
                    viewrecords : true,
                    sortorder : "asc",
                    gridComplete : function() {
                        var ids = jQuery("#jqgrid").jqGrid('getDataIDs');
                        for (var i = 0; i < ids.length; i++) {
                            var cl = ids[i];
                            be = "<button class='btn btn-xs btn-default' data-original-title='Edit Row' onclick=\"jQuery('#jqgrid').editRow('" + cl + "');\"><i class='fa fa-pencil'></i></button>";
                            se = "<button class='btn btn-xs btn-default' data-original-title='Save Row' onclick=\"jQuery('#jqgrid').saveRow('" + cl + "');\"><i class='fa fa-save'></i></button>";
                            ca = "<button class='btn btn-xs btn-default' data-original-title='Cancel' onclick=\"jQuery('#jqgrid').restoreRow('" + cl + "');\"><i class='fa fa-times'></i></button>";
                            //ce = "<button class='btn btn-xs btn-default' onclick=\"jQuery('#jqgrid').restoreRow('"+cl+"');\"><i class='fa fa-times'></i></button>";
                            //jQuery("#jqgrid").jqGrid('setRowData',ids[i],{act:be+se+ce});
                            jQuery("#jqgrid").jqGrid('setRowData', ids[i], {
                                act : be + se + ca
                            });
                        }
                    },
                    editurl : "dummy.html",
                    caption : "SmartAdmin jQgrid Skin",
                    multiselect : true,
                    autowidth : true,

                });
                jQuery("#jqgrid").jqGrid('navGrid', "#pjqgrid", {
                    edit : false,
                    add : false,
                    del : true
                });
                jQuery("#jqgrid").jqGrid('inlineNav', "#pjqgrid");
                /* Add tooltips */
                $('.navtable .ui-pg-button').tooltip({
                    container : 'body'
                });

                jQuery("#m1").click(function() {
                    var s;
                    s = jQuery("#jqgrid").jqGrid('getGridParam', 'selarrrow');
                    alert(s);
                });
                jQuery("#m1s").click(function() {
                    jQuery("#jqgrid").jqGrid('setSelection', "13");
                });

                // remove classes
                $(".ui-jqgrid").removeClass("ui-widget ui-widget-content");
                $(".ui-jqgrid-view").children().removeClass("ui-widget-header ui-state-default");
                $(".ui-jqgrid-labels, .ui-search-toolbar").children().removeClass("ui-state-default ui-th-column ui-th-ltr");
                $(".ui-jqgrid-pager").removeClass("ui-state-default");
                $(".ui-jqgrid").removeClass("ui-widget-content");

                // add classes
                $(".ui-jqgrid-htable").addClass("table table-bordered table-hover");
                $(".ui-jqgrid-btable").addClass("table table-bordered table-striped");

                $(".ui-pg-div").removeClass().addClass("btn btn-sm btn-primary");
                $(".ui-icon.ui-icon-plus").removeClass().addClass("fa fa-plus");
                $(".ui-icon.ui-icon-pencil").removeClass().addClass("fa fa-pencil");
                $(".ui-icon.ui-icon-trash").removeClass().addClass("fa fa-trash-o");
                $(".ui-icon.ui-icon-search").removeClass().addClass("fa fa-search");
                $(".ui-icon.ui-icon-refresh").removeClass().addClass("fa fa-refresh");
                $(".ui-icon.ui-icon-disk").removeClass().addClass("fa fa-save").parent(".btn-primary").removeClass("btn-primary").addClass("btn-success");
                $(".ui-icon.ui-icon-cancel").removeClass().addClass("fa fa-times").parent(".btn-primary").removeClass("btn-primary").addClass("btn-danger");

                $(".ui-icon.ui-icon-seek-prev").wrap("<div class='btn btn-sm btn-default'></div>");
                $(".ui-icon.ui-icon-seek-prev").removeClass().addClass("fa fa-backward");

                $(".ui-icon.ui-icon-seek-first").wrap("<div class='btn btn-sm btn-default'></div>");
                $(".ui-icon.ui-icon-seek-first").removeClass().addClass("fa fa-fast-backward");

                $(".ui-icon.ui-icon-seek-next").wrap("<div class='btn btn-sm btn-default'></div>");
                $(".ui-icon.ui-icon-seek-next").removeClass().addClass("fa fa-forward");

                $(".ui-icon.ui-icon-seek-end").wrap("<div class='btn btn-sm btn-default'></div>");
                $(".ui-icon.ui-icon-seek-end").removeClass().addClass("fa fa-fast-forward");

            })

            $(window).on('resize.jqGrid', function() {
                $("#jqgrid").jqGrid('setGridWidth', $("#content").width());
            })

        </script>
    <?php break; ?>

<?php case 'formelements': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->
		<script type="text/javascript">
            // DO NOT REMOVE : GLOBAL FUNCTIONS!
            $(document).ready(function() {
                pageSetUp();
            });

        </script>
    <?php break; ?>

<?php case 'formtemplates': ?>
		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/jquery-form/jquery-form.min.js"></script>


		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                var $checkoutForm = $('#checkout-form').validate({
                    // Rules for form validation
                    rules : {
                        fname : {
                            required : true
                        },
                        lname : {
                            required : true
                        },
                        email : {
                            required : true,
                            email : true
                        },
                        phone : {
                            required : true
                        },
                        country : {
                            required : true
                        },
                        city : {
                            required : true
                        },
                        code : {
                            required : true,
                            digits : true
                        },
                        address : {
                            required : true
                        },
                        name : {
                            required : true
                        },
                        card : {
                            required : true,
                            creditcard : true
                        },
                        cvv : {
                            required : true,
                            digits : true
                        },
                        month : {
                            required : true
                        },
                        year : {
                            required : true,
                            digits : true
                        }
                    },

                    // Messages for form validation
                    messages : {
                        fname : {
                            required : 'Please enter your first name'
                        },
                        lname : {
                            required : 'Please enter your last name'
                        },
                        email : {
                            required : 'Please enter your email address',
                            email : 'Please enter a VALID email address'
                        },
                        phone : {
                            required : 'Please enter your phone number'
                        },
                        country : {
                            required : 'Please select your country'
                        },
                        city : {
                            required : 'Please enter your city'
                        },
                        code : {
                            required : 'Please enter code',
                            digits : 'Digits only please'
                        },
                        address : {
                            required : 'Please enter your full address'
                        },
                        name : {
                            required : 'Please enter name on your card'
                        },
                        card : {
                            required : 'Please enter your card number'
                        },
                        cvv : {
                            required : 'Enter CVV2',
                            digits : 'Digits only'
                        },
                        month : {
                            required : 'Select month'
                        },
                        year : {
                            required : 'Enter year',
                            digits : 'Digits only please'
                        }
                    },

                    // Do not change code below
                    errorPlacement : function(error, element) {
                        error.insertAfter(element.parent());
                    }
                });

                var $registerForm = $("#smart-form-register").validate({

                    // Rules for form validation
                    rules : {
                        username : {
                            required : true
                        },
                        email : {
                            required : true,
                            email : true
                        },
                        password : {
                            required : true,
                            minlength : 3,
                            maxlength : 20
                        },
                        passwordConfirm : {
                            required : true,
                            minlength : 3,
                            maxlength : 20,
                            equalTo : '#password'
                        },
                        firstname : {
                            required : true
                        },
                        lastname : {
                            required : true
                        },
                        gender : {
                            required : true
                        },
                        terms : {
                            required : true
                        }
                    },

                    // Messages for form validation
                    messages : {
                        login : {
                            required : 'Please enter your login'
                        },
                        email : {
                            required : 'Please enter your email address',
                            email : 'Please enter a VALID email address'
                        },
                        password : {
                            required : 'Please enter your password'
                        },
                        passwordConfirm : {
                            required : 'Please enter your password one more time',
                            equalTo : 'Please enter the same password as above'
                        },
                        firstname : {
                            required : 'Please select your first name'
                        },
                        lastname : {
                            required : 'Please select your last name'
                        },
                        gender : {
                            required : 'Please select your gender'
                        },
                        terms : {
                            required : 'You must agree with Terms and Conditions'
                        }
                    },

                    // Do not change code below
                    errorPlacement : function(error, element) {
                        error.insertAfter(element.parent());
                    }
                });

                var $reviewForm = $("#review-form").validate({
                    // Rules for form validation
                    rules : {
                        name : {
                            required : true
                        },
                        email : {
                            required : true,
                            email : true
                        },
                        review : {
                            required : true,
                            minlength : 20
                        },
                        quality : {
                            required : true
                        },
                        reliability : {
                            required : true
                        },
                        overall : {
                            required : true
                        }
                    },

                    // Messages for form validation
                    messages : {
                        name : {
                            required : 'Please enter your name'
                        },
                        email : {
                            required : 'Please enter your email address',
                            email : '<i class="fa fa-warning"></i><strong>Please enter a VALID email addres</strong>'
                        },
                        review : {
                            required : 'Please enter your review'
                        },
                        quality : {
                            required : 'Please rate quality of the product'
                        },
                        reliability : {
                            required : 'Please rate reliability of the product'
                        },
                        overall : {
                            required : 'Please rate the product'
                        }
                    },

                    // Do not change code below
                    errorPlacement : function(error, element) {
                        error.insertAfter(element.parent());
                    }
                });

                var $commentForm = $("#comment-form").validate({
                    // Rules for form validation
                    rules : {
                        name : {
                            required : true
                        },
                        email : {
                            required : true,
                            email : true
                        },
                        url : {
                            url : true
                        },
                        comment : {
                            required : true
                        }
                    },

                    // Messages for form validation
                    messages : {
                        name : {
                            required : 'Enter your name',
                        },
                        email : {
                            required : 'Enter your email address',
                            email : 'Enter a VALID email'
                        },
                        url : {
                            email : 'Enter a VALID url'
                        },
                        comment : {
                            required : 'Please enter your comment'
                        }
                    },

                    // Ajax form submition
                    submitHandler : function(form) {
                        $(form).ajaxSubmit({
                            success : function() {
                                $("#comment-form").addClass('submited');
                            }
                        });
                    },

                    // Do not change code below
                    errorPlacement : function(error, element) {
                        error.insertAfter(element.parent());
                    }
                });

                var $contactForm = $("#contact-form").validate({
                    // Rules for form validation
                    rules : {
                        name : {
                            required : true
                        },
                        email : {
                            required : true,
                            email : true
                        },
                        message : {
                            required : true,
                            minlength : 10
                        }
                    },

                    // Messages for form validation
                    messages : {
                        name : {
                            required : 'Please enter your name',
                        },
                        email : {
                            required : 'Please enter your email address',
                            email : 'Please enter a VALID email address'
                        },
                        message : {
                            required : 'Please enter your message'
                        }
                    },

                    // Ajax form submition
                    submitHandler : function(form) {
                        $(form).ajaxSubmit({
                            success : function() {
                                $("#contact-form").addClass('submited');
                            }
                        });
                    },

                    // Do not change code below
                    errorPlacement : function(error, element) {
                        error.insertAfter(element.parent());
                    }
                });

                var $loginForm = $("#login-form").validate({
                    // Rules for form validation
                    rules : {
                        email : {
                            required : true,
                            email : true
                        },
                        password : {
                            required : true,
                            minlength : 3,
                            maxlength : 20
                        }
                    },

                    // Messages for form validation
                    messages : {
                        email : {
                            required : 'Please enter your email address',
                            email : 'Please enter a VALID email address'
                        },
                        password : {
                            required : 'Please enter your password'
                        }
                    },

                    // Do not change code below
                    errorPlacement : function(error, element) {
                        error.insertAfter(element.parent());
                    }
                });

                var $orderForm = $("#order-form").validate({
                    // Rules for form validation
                    rules : {
                        name : {
                            required : true
                        },
                        email : {
                            required : true,
                            email : true
                        },
                        phone : {
                            required : true
                        },
                        interested : {
                            required : true
                        },
                        budget : {
                            required : true
                        }
                    },

                    // Messages for form validation
                    messages : {
                        name : {
                            required : 'Please enter your name'
                        },
                        email : {
                            required : 'Please enter your email address',
                            email : 'Please enter a VALID email address'
                        },
                        phone : {
                            required : 'Please enter your phone number'
                        },
                        interested : {
                            required : 'Please select interested service'
                        },
                        budget : {
                            required : 'Please select your budget'
                        }
                    },

                    // Do not change code below
                    errorPlacement : function(error, element) {
                        error.insertAfter(element.parent());
                    }
                });

                // START AND FINISH DATE
                $('#startdate').datepicker({
                    dateFormat : 'dd.mm.yy',
                    prevText : '<i class="fa fa-chevron-left"></i>',
                    nextText : '<i class="fa fa-chevron-right"></i>',
                    onSelect : function(selectedDate) {
                        $('#finishdate').datepicker('option', 'minDate', selectedDate);
                    }
                });

                $('#finishdate').datepicker({
                    dateFormat : 'dd.mm.yy',
                    prevText : '<i class="fa fa-chevron-left"></i>',
                    nextText : '<i class="fa fa-chevron-right"></i>',
                    onSelect : function(selectedDate) {
                        $('#startdate').datepicker('option', 'maxDate', selectedDate);
                    }
                });



            })

        </script>
    <?php break; ?>

<?php case 'validation'; ?>
    <!-- PAGE RELATED PLUGIN(S)
    <script src="..."></script>-->



    <script type="text/javascript">

        // DO NOT REMOVE : GLOBAL FUNCTIONS!

        $(document).ready(function() {

            pageSetUp();

        })

    </script>
    <?php break; ?>

<?php case 'bootstrapforms'; ?>
    <!-- PAGE RELATED PLUGIN(S)
<script src="..."></script> -->


    <script type="text/javascript">

        // DO NOT REMOVE : GLOBAL FUNCTIONS!

        $(document).ready(function() {

            pageSetUp();

            // PAGE RELATED SCRIPTS

            // class switcher for radio and checkbox
            $('input[name="demo-switcher-1"]').change( function() {
                //alert($(this).val())
                $this = $(this);

                myNewClass = $this.attr('id');

                $('.demo-switcher-1 input[type="checkbox"]').removeClass();
                $('.demo-switcher-1 input[type="checkbox"]').addClass("checkbox "+ myNewClass);

                $('.demo-switcher-1 input[type="radio"]').removeClass();
                $('.demo-switcher-1 input[type="radio"]').addClass("radiobox "+ myNewClass);

            })

        })

    </script>
    <?php break; ?>

<?php case 'bootstrapvalidator'; ?>
    <!-- PAGE RELATED PLUGIN(S)
    <script src="..."></script>-->

    <script src="/public/pandora/js/plugin/bootstrapvalidator/bootstrapValidator.min.js"></script>

    <script type="text/javascript">

        $(document).ready(function() {

            /* DO NOT REMOVE : GLOBAL FUNCTIONS!
             *
             * pageSetUp(); WILL CALL THE FOLLOWING FUNCTIONS
             *
             * // activate tooltips
             * $("[rel=tooltip]").tooltip();
             *
             * // activate popovers
             * $("[rel=popover]").popover();
             *
             * // activate popovers with hover states
             * $("[rel=popover-hover]").popover({ trigger: "hover" });
             *
             * // activate inline charts
             * runAllCharts();
             *
             * // setup widgets
             * setup_widgets_desktop();
             *
             * // run form elements
             * runAllForms();
             *
             ********************************
             *
             * pageSetUp() is needed whenever you load a page.
             * It initializes and checks for all basic elements of the page
             * and makes rendering easier.
             *
             */

            pageSetUp();

            /*
             * ALL PAGE RELATED SCRIPTS CAN GO BELOW HERE
             * eg alert("my home function");
             *
             * var pagefunction = function() {
             *   ...
             * }
             * loadScript("js/plugin/_PLUGIN_NAME_.js", pagefunction);
             *
             * TO LOAD A SCRIPT:
             * var pagefunction = function (){
             *  loadScript(".../plugin.js", run_after_loaded);
             * }
             *
             * OR
             *
             * loadScript(".../plugin.js", run_after_loaded);
             */

            // pagefunction

            // clears the variable if left blank

            // movie form
            $('#movieForm').bootstrapValidator({
                feedbackIcons : {
                    valid : 'glyphicon glyphicon-ok',
                    invalid : 'glyphicon glyphicon-remove',
                    validating : 'glyphicon glyphicon-refresh'
                },
                fields : {
                    title : {
                        group : '.col-md-8',
                        validators : {
                            notEmpty : {
                                message : 'The title is required'
                            },
                            stringLength : {
                                max : 200,
                                message : 'The title must be less than 200 characters long'
                            }
                        }
                    },
                    genre : {
                        group : '.col-md-4',
                        validators : {
                            notEmpty : {
                                message : 'The genre is required'
                            }
                        }
                    },
                    director : {
                        group : '.col-md-4',
                        validators : {
                            notEmpty : {
                                message : 'The director name is required'
                            },
                            stringLength : {
                                max : 80,
                                message : 'The director name must be less than 80 characters long'
                            }
                        }
                    },
                    writer : {
                        group : '.col-md-4',
                        validators : {
                            notEmpty : {
                                message : 'The writer name is required'
                            },
                            stringLength : {
                                max : 80,
                                message : 'The writer name must be less than 80 characters long'
                            }
                        }
                    },
                    producer : {
                        group : '.col-md-4',
                        validators : {
                            notEmpty : {
                                message : 'The producer name is required'
                            },
                            stringLength : {
                                max : 80,
                                message : 'The producer name must be less than 80 characters long'
                            }
                        }
                    },
                    website : {
                        group : '.col-md-6',
                        validators : {
                            notEmpty : {
                                message : 'The website address is required'
                            },
                            uri : {
                                message : 'The website address is not valid'
                            }
                        }
                    },
                    trailer : {
                        group : '.col-md-6',
                        validators : {
                            notEmpty : {
                                message : 'The trailer link is required'
                            },
                            uri : {
                                message : 'The trailer link is not valid'
                            }
                        }
                    },
                    review : {
                        // The group will be set as default (.form-group)
                        validators : {
                            stringLength : {
                                max : 500,
                                message : 'The review must be less than 500 characters long'
                            }
                        }
                    },
                    rating : {
                        // The group will be set as default (.form-group)
                        validators : {
                            notEmpty : {
                                message : 'The rating is required'
                            }
                        }
                    }
                }
            });
            // end movie form

            // toggle form

            $('#togglingForm').bootstrapValidator({
                feedbackIcons : {
                    valid : 'glyphicon glyphicon-ok',
                    invalid : 'glyphicon glyphicon-remove',
                    validating : 'glyphicon glyphicon-refresh'
                },
                fields : {
                    firstName : {
                        validators : {
                            notEmpty : {
                                message : 'The first name is required'
                            }
                        }
                    },
                    lastName : {
                        validators : {
                            notEmpty : {
                                message : 'The last name is required'
                            }
                        }
                    },
                    company : {
                        validators : {
                            notEmpty : {
                                message : 'The company name is required'
                            }
                        }
                    },
                    // These fields will be validated when being visible
                    job : {
                        validators : {
                            notEmpty : {
                                message : 'The job title is required'
                            }
                        }
                    },
                    department : {
                        validators : {
                            notEmpty : {
                                message : 'The department name is required'
                            }
                        }
                    },
                    mobilePhone : {
                        validators : {
                            notEmpty : {
                                message : 'The mobile phone number is required'
                            },
                            digits : {
                                message : 'The mobile phone number is not valid'
                            }
                        }
                    },
                    // These fields will be validated when being visible
                    homePhone : {
                        validators : {
                            digits : {
                                message : 'The home phone number is not valid'
                            }
                        }
                    },
                    officePhone : {
                        validators : {
                            digits : {
                                message : 'The office phone number is not valid'
                            }
                        }
                    }
                }
            }).find('button[data-toggle]').on('click', function() {
                var $target = $($(this).attr('data-toggle'));
                // Show or hide the additional fields
                // They will or will not be validated based on their visibilities
                $target.toggle();
                if (!$target.is(':visible')) {
                    // Enable the submit buttons in case additional fields are not valid
                    $('#togglingForm').data('bootstrapValidator').disableSubmitButtons(false);
                }
            });

            // end toggle form

            // button group form

            $('#buttonGroupForm').bootstrapValidator({
                excluded : ':disabled',
                feedbackIcons : {
                    valid : 'glyphicon glyphicon-ok',
                    invalid : 'glyphicon glyphicon-remove',
                    validating : 'glyphicon glyphicon-refresh'
                },
                fields : {
                    gender : {
                        validators : {
                            notEmpty : {
                                message : 'The gender is required'
                            }
                        }
                    },
                    'languages[]' : {
                        validators : {
                            choice : {
                                min : 1,
                                max : 2,
                                message : 'Please choose 1 - 2 languages you can speak'
                            }
                        }
                    }
                }
            });

            // end button group form

            // product form

            $('#productForm').bootstrapValidator({
                feedbackIcons : {
                    valid : 'glyphicon glyphicon-ok',
                    invalid : 'glyphicon glyphicon-remove',
                    validating : 'glyphicon glyphicon-refresh'
                },
                fields : {
                    price : {
                        validators : {
                            notEmpty : {
                                message : 'The price is required'
                            },
                            numeric : {
                                message : 'The price must be a number'
                            }
                        }
                    },
                    amount : {
                        validators : {
                            notEmpty : {
                                message : 'The amount is required'
                            },
                            numeric : {
                                message : 'The amount must be a number'
                            }
                        }
                    },
                    color : {
                        validators : {
                            notEmpty : {
                                message : 'The color is required'
                            }
                        }
                    },
                    size : {
                        validators : {
                            notEmpty : {
                                message : 'The size is required'
                            }
                        }
                    }
                }
            });

            // end product form

            // profile form

            $('#profileForm').bootstrapValidator({
                feedbackIcons : {
                    valid : 'glyphicon glyphicon-ok',
                    invalid : 'glyphicon glyphicon-remove',
                    validating : 'glyphicon glyphicon-refresh'
                },
                fields : {
                    email : {
                        validators : {
                            notEmpty : {
                                message : 'The email address is required'
                            },
                            emailAddress : {
                                message : 'The email address is not valid'
                            }
                        }
                    },
                    password : {
                        validators : {
                            notEmpty : {
                                message : 'The password is required'
                            }
                        }
                    }
                }
            });

            // end profile form

            //attributeForm
            $('#attributeForm').bootstrapValidator();
            // end attributeForm

            // contactForm
            $('#contactForm').bootstrapValidator({
                container : '#messages',
                feedbackIcons : {
                    valid : 'glyphicon glyphicon-ok',
                    invalid : 'glyphicon glyphicon-remove',
                    validating : 'glyphicon glyphicon-refresh'
                },
                fields : {
                    fullName : {
                        validators : {
                            notEmpty : {
                                message : 'The full name is required and cannot be empty'
                            }
                        }
                    },
                    email : {
                        validators : {
                            notEmpty : {
                                message : 'The email address is required and cannot be empty'
                            },
                            emailAddress : {
                                message : 'The email address is not valid'
                            }
                        }
                    },
                    title : {
                        validators : {
                            notEmpty : {
                                message : 'The title is required and cannot be empty'
                            },
                            stringLength : {
                                max : 100,
                                message : 'The title must be less than 100 characters long'
                            }
                        }
                    },
                    content : {
                        validators : {
                            notEmpty : {
                                message : 'The content is required and cannot be empty'
                            },
                            stringLength : {
                                max : 500,
                                message : 'The content must be less than 500 characters long'
                            }
                        }
                    }
                }
            });
            // end contactForm


        })

    </script>
    <?php break; ?>

<?php case 'plugins'; ?>
    <!-- PAGE RELATED PLUGIN(S) -->
    <script src="/public/pandora/js/plugin/maxlength/bootstrap-maxlength.min.js"></script>
    <script src="/public/pandora/js/plugin/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
    <script src="/public/pandora/js/plugin/clockpicker/clockpicker.min.js"></script>
    <script src="/public/pandora/js/plugin/bootstrap-tags/bootstrap-tagsinput.min.js"></script>
    <script src="/public/pandora/js/plugin/noUiSlider/jquery.nouislider.min.js"></script>
    <script src="/public/pandora/js/plugin/ion-slider/ion.rangeSlider.min.js"></script>
    <script src="/public/pandora/js/plugin/bootstrap-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
    <script src="/public/pandora/js/plugin/colorpicker/bootstrap-colorpicker.min.js"></script>
    <script src="/public/pandora/js/plugin/knob/jquery.knob.min.js"></script>
    <script src="/public/pandora/js/plugin/x-editable/moment.min.js"></script>
    <script src="/public/pandora/js/plugin/x-editable/jquery.mockjax.min.js"></script>
    <script src="/public/pandora/js/plugin/x-editable/x-editable.min.js"></script>
    <script src="/public/pandora/js/plugin/typeahead/typeahead.min.js"></script>
    <script src="/public/pandora/js/plugin/typeahead/typeaheadjs.min.js"></script>


    <script type="text/javascript">

        // DO NOT REMOVE : GLOBAL FUNCTIONS!

        $(document).ready(function() {

            pageSetUp();

            // PAGE RELATED SCRIPTS

            // Spinners
            $("#spinner").spinner();
            $("#spinner-decimal").spinner({
                step: 0.01,
                numberFormat: "n"
            });

            $("#spinner-currency").spinner({
                min: 5,
                max: 2500,
                step: 25,
                start: 1000,
                numberFormat: "C"
            });

            //Maxlength

            $('input[maxlength]').maxlength({
                warningClass: "label label-success",
                limitReachedClass: "label label-important",
            });


            // START AND FINISH DATE
            $('#startdate').datepicker({
                dateFormat: 'dd.mm.yy',
                prevText: '<i class="fa fa-chevron-left"></i>',
                nextText: '<i class="fa fa-chevron-right"></i>',
                onSelect: function (selectedDate) {
                    $('#finishdate').datepicker('option', 'minDate', selectedDate);
                }
            });
            $('#finishdate').datepicker({
                dateFormat: 'dd.mm.yy',
                prevText: '<i class="fa fa-chevron-left"></i>',
                nextText: '<i class="fa fa-chevron-right"></i>',
                onSelect: function (selectedDate) {
                    $('#startdate').datepicker('option', 'maxDate', selectedDate);
                }
            });

            // Date Range Picker
            $("#from").datepicker({
                defaultDate: "+1w",
                changeMonth: true,
                numberOfMonths: 3,
                prevText: '<i class="fa fa-chevron-left"></i>',
                nextText: '<i class="fa fa-chevron-right"></i>',
                onClose: function (selectedDate) {
                    $("#to").datepicker("option", "maxDate", selectedDate);
                }

            });
            $("#to").datepicker({
                defaultDate: "+1w",
                changeMonth: true,
                numberOfMonths: 3,
                prevText: '<i class="fa fa-chevron-left"></i>',
                nextText: '<i class="fa fa-chevron-right"></i>',
                onClose: function (selectedDate) {
                    $("#from").datepicker("option", "minDate", selectedDate);
                }
            });

            /*
             * TIMEPICKER
             */

            $('#timepicker').timepicker();

            /*
             * CLOCKPICKER
             */

            $('#clockpicker').clockpicker({
                placement: 'top',
                donetext: 'Done'
            });

            /*
             * JS SLIDER
             */

            $("#nouislider-1").noUiSlider({
                range: [2, 100],
                start: 55,
                handles: 1,
                connect: true,
            });

            $("#nouislider-2").noUiSlider({
                range: [0, 300],
                start: [55, 130],
                step: 60,
                handles: 2,
                connect: true
            });

            $("#nouislider-3").noUiSlider({
                range: [0, 1000],
                start: [264, 776],
                step: 1,
                connect: true,
                slide: function () {
                    var values = $(this).val();
                    $(".nouislider-value").text(values[0] + " - " + values[1]);
                }
            });

            $("#nouislider-4").noUiSlider({
                range: [0, 100],
                start: 50,
                handles: 1
            }).attr("disabled", "disabled");



            /*
             * ION SLIDER
             */

            $("#range-slider-1").ionRangeSlider({
                min: 0,
                max: 5000,
                from: 1000,
                to: 4000,
                type: 'double',
                step: 1,
                prefix: "$",
                prettify: false,
                hasGrid: true
            });

            $("#range-slider-2").ionRangeSlider();

            $("#range-slider-3").ionRangeSlider({
                min: 0,
                from: 2.3,
                max: 10,
                type: 'single',
                step: 0.1,
                postfix: " mm",
                prettify: false,
                hasGrid: true
            });

            $("#range-slider-4").ionRangeSlider({
                min: -50,
                max: 50,
                from: 5,
                to: 25,
                type: 'double',
                step: 1,
                postfix: "°",
                prettify: false,
                hasGrid: true
            });

            $("#range-slider-5").ionRangeSlider({
                min: 0,
                from: 0,
                max: 10,
                type: 'single',
                step: 0.1,
                postfix: " mm",
                prettify: false,
                hasGrid: true
            });


            /*
             * BOOTSTRAP DUALLIST BOX
             */

            var initializeDuallistbox = $('#initializeDuallistbox').bootstrapDualListbox({
                nonSelectedListLabel: 'Non-selected',
                selectedListLabel: 'Selected',
                preserveSelectionOnMove: 'moved',
                moveOnSelect: false,
                nonSelectedFilter: 'ion ([7-9]|[1][0-2])'
            });


            /*
             * COLOR PICKER
             */

            $('#colorpicker-1').colorpicker()
            $('#colorpicker-2').colorpicker()



            /*
             * KNOB
             */

            $('.knob').knob({
                change: function (value) {
                    //console.log("change : " + value);
                },
                release: function (value) {
                    //console.log(this.$.attr('value'));
                    //console.log("release : " + value);
                },
                cancel: function () {
                    //console.log("cancel : ", this);
                }
            });


            /*
             * X-Ediable
             */


            (function (e) {
                "use strict";
                var t = function (e) {
                    this.init("address", e, t.defaults)
                };
                e.fn.editableutils.inherit(t, e.fn.editabletypes.abstractinput);
                e.extend(t.prototype, {
                    render: function () {
                        this.$input = this.$tpl.find("input")
                    },
                    value2html: function (t, n) {
                        if (!t) {
                            e(n).empty();
                            return
                        }
                        var r = e("<div>").text(t.city).html() + ", " + e("<div>").text(t.street).html() +
                            " st., bld. " + e("<div>").text(t.building).html();
                        e(n).html(r)
                    },
                    html2value: function (e) {
                        return null
                    },
                    value2str: function (e) {
                        var t = "";
                        if (e)
                            for (var n in e)
                                t = t + n + ":" + e[n] + ";";
                        return t
                    },
                    str2value: function (e) {
                        return e
                    },
                    value2input: function (e) {
                        if (!e)
                            return;
                        this.$input.filter('[name="city"]').val(e.city);
                        this.$input.filter('[name="street"]').val(e.street);
                        this.$input.filter('[name="building"]').val(e.building)
                    },
                    input2value: function () {
                        return {
                            city: this.$input.filter('[name="city"]').val(),
                            street: this.$input.filter('[name="street"]').val(),
                            building: this.$input.filter('[name="building"]').val()
                        }
                    },
                    activate: function () {
                        this.$input.filter('[name="city"]').focus()
                    },
                    autosubmit: function () {
                        this.$input.keydown(function (t) {
                            t.which === 13 && e(this).closest("form").submit()
                        })
                    }
                });
                t.defaults = e.extend({}, e.fn.editabletypes.abstractinput.defaults, {
                    tpl: '<div class="editable-address"><label><span>City: </span><input type="text" name="city" class="input-small"></label></div><div class="editable-address"><label><span>Street: </span><input type="text" name="street" class="input-small"></label></div><div class="editable-address"><label><span>Building: </span><input type="text" name="building" class="input-mini"></label></div>',
                    inputclass: ""
                });
                e.fn.editabletypes.address = t
            })(window.jQuery);

            //ajax mocks
            $.mockjaxSettings.responseTime = 500;

            $.mockjax({
                url: '/post',
                response: function (settings) {
                    log(settings, this);
                }
            });

            $.mockjax({
                url: '/error',
                status: 400,
                statusText: 'Bad Request',
                response: function (settings) {
                    this.responseText = 'Please input correct value';
                    log(settings, this);
                }
            });

            $.mockjax({
                url: '/status',
                status: 500,
                response: function (settings) {
                    this.responseText = 'Internal Server Error';
                    log(settings, this);
                }
            });

            $.mockjax({
                url: '/groups',
                response: function (settings) {
                    this.responseText = [{
                        value: 0,
                        text: 'Guest'
                    }, {
                        value: 1,
                        text: 'Service'
                    }, {
                        value: 2,
                        text: 'Customer'
                    }, {
                        value: 3,
                        text: 'Operator'
                    }, {
                        value: 4,
                        text: 'Support'
                    }, {
                        value: 5,
                        text: 'Admin'
                    }];
                    log(settings, this);
                }
            });

            //TODO: add this div to page
            function log(settings, response) {
                var s = [],
                    str;
                s.push(settings.type.toUpperCase() + ' url = "' + settings.url + '"');
                for (var a in settings.data) {
                    if (settings.data[a] && typeof settings.data[a] === 'object') {
                        str = [];
                        for (var j in settings.data[a]) {
                            str.push(j + ': "' + settings.data[a][j] + '"');
                        }
                        str = '{ ' + str.join(', ') + ' }';
                    } else {
                        str = '"' + settings.data[a] + '"';
                    }
                    s.push(a + ' = ' + str);
                }
                s.push('RESPONSE: status = ' + response.status);

                if (response.responseText) {
                    if ($.isArray(response.responseText)) {
                        s.push('[');
                        $.each(response.responseText, function (i, v) {
                            s.push('{value: ' + v.value + ', text: "' + v.text + '"}');
                        });
                        s.push(']');
                    } else {
                        s.push($.trim(response.responseText));
                    }
                }
                s.push('--------------------------------------\n');
                $('#console').val(s.join('\n') + $('#console').val());
            }

            /*
             * X-EDITABLES
             */

            $('#inline').on('change', function (e) {
                if ($(this).prop('checked')) {
                    window.location.href = '?mode=inline#ajax/plugins.html';
                } else {
                    window.location.href = '?#ajax/plugins.html';
                }
            });

            if (window.location.href.indexOf("?mode=inline") > -1) {
                $('#inline').prop('checked', true);
                $.fn.editable.defaults.mode = 'inline';
            } else {
                $('#inline').prop('checked', false);
                $.fn.editable.defaults.mode = 'popup';
            }

            //defaults
            $.fn.editable.defaults.url = '/post';
            //$.fn.editable.defaults.mode = 'inline'; use this to edit inline

            //enable / disable
            $('#enable').click(function () {
                $('#user .editable').editable('toggleDisabled');
            });

            //editables
            $('#username').editable({
                url: '/post',
                type: 'text',
                pk: 1,
                name: 'username',
                title: 'Enter username'
            });

            $('#firstname').editable({
                validate: function (value) {
                    if ($.trim(value) == '')
                        return 'This field is required';
                }
            });

            $('#sex').editable({
                prepend: "not selected",
                source: [{
                    value: 1,
                    text: 'Male'
                }, {
                    value: 2,
                    text: 'Female'
                }],
                display: function (value, sourceData) {
                    var colors = {
                        "": "gray",
                        1: "green",
                        2: "blue"
                    }, elem = $.grep(sourceData, function (o) {
                        return o.value == value;
                    });

                    if (elem.length) {
                        $(this).text(elem[0].text).css("color", colors[value]);
                    } else {
                        $(this).empty();
                    }
                }
            });

            $('#status').editable();

            $('#group').editable({
                showbuttons: false
            });

            $('#vacation').editable({
                datepicker: {
                    todayBtn: 'linked'
                }
            });

            $('#dob').editable();

            $('#event').editable({
                placement: 'right',
                combodate: {
                    firstItem: 'name'
                }
            });

            $('#meeting_start').editable({
                format: 'yyyy-mm-dd hh:ii',
                viewformat: 'dd/mm/yyyy hh:ii',
                validate: function (v) {
                    if (v && v.getDate() == 10)
                        return 'Day cant be 10!';
                },
                datetimepicker: {
                    todayBtn: 'linked',
                    weekStart: 1
                }
            });

            $('#comments').editable({
                showbuttons: 'bottom'
            });

            $('#note').editable();
            $('#pencil').click(function (e) {
                e.stopPropagation();
                e.preventDefault();
                $('#note').editable('toggle');
            });

            $('#state').editable({
                source: ["Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut",
                    "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas",
                    "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota",
                    "Mississippi", "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire", "New Jersey",
                    "New Mexico", "New York", "North Dakota", "North Carolina", "Ohio", "Oklahoma", "Oregon",
                    "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas",
                    "Utah", "Vermont", "Virginia", "Washington", "West Virginia", "Wisconsin", "Wyoming"
                ]
            });

            $('#state2').editable({
                value: 'California',
                typeahead: {
                    name: 'state',
                    local: ["Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut",
                        "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa",
                        "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan",
                        "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire",
                        "New Jersey", "New Mexico", "New York", "North Dakota", "North Carolina", "Ohio",
                        "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota",
                        "Tennessee", "Texas", "Utah", "Vermont", "Virginia", "Washington", "West Virginia",
                        "Wisconsin", "Wyoming"
                    ]
                }
            });

            $('#fruits').editable({
                pk: 1,
                limit: 3,
                source: [{
                    value: 1,
                    text: 'banana'
                }, {
                    value: 2,
                    text: 'peach'
                }, {
                    value: 3,
                    text: 'apple'
                }, {
                    value: 4,
                    text: 'watermelon'
                }, {
                    value: 5,
                    text: 'orange'
                }]
            });

            $('#tags').editable({
                inputclass: 'input-large',
                select2: {
                    tags: ['html', 'javascript', 'css', 'ajax'],
                    tokenSeparators: [",", " "]
                }
            });

            var countries = [];
            $.each({
                "BD": "Bangladesh",
                "BE": "Belgium",
                "BF": "Burkina Faso",
                "BG": "Bulgaria",
                "BA": "Bosnia and Herzegovina",
                "BB": "Barbados",
                "WF": "Wallis and Futuna",
                "BL": "Saint Bartelemey",
                "BM": "Bermuda",
                "BN": "Brunei Darussalam",
                "BO": "Bolivia",
                "BH": "Bahrain",
                "BI": "Burundi",
                "BJ": "Benin",
                "BT": "Bhutan",
                "JM": "Jamaica",
                "BV": "Bouvet Island",
                "BW": "Botswana",
                "WS": "Samoa",
                "BR": "Brazil",
                "BS": "Bahamas",
                "JE": "Jersey",
                "BY": "Belarus",
                "O1": "Other Country",
                "LV": "Latvia",
                "RW": "Rwanda",
                "RS": "Serbia",
                "TL": "Timor-Leste",
                "RE": "Reunion",
                "LU": "Luxembourg",
                "TJ": "Tajikistan",
                "RO": "Romania",
                "PG": "Papua New Guinea",
                "GW": "Guinea-Bissau",
                "GU": "Guam",
                "GT": "Guatemala",
                "GS": "South Georgia and the South Sandwich Islands",
                "GR": "Greece",
                "GQ": "Equatorial Guinea",
                "GP": "Guadeloupe",
                "JP": "Japan",
                "GY": "Guyana",
                "GG": "Guernsey",
                "GF": "French Guiana",
                "GE": "Georgia",
                "GD": "Grenada",
                "GB": "United Kingdom",
                "GA": "Gabon",
                "SV": "El Salvador",
                "GN": "Guinea",
                "GM": "Gambia",
                "GL": "Greenland",
                "GI": "Gibraltar",
                "GH": "Ghana",
                "OM": "Oman",
                "TN": "Tunisia",
                "JO": "Jordan",
                "HR": "Croatia",
                "HT": "Haiti",
                "HU": "Hungary",
                "HK": "Hong Kong",
                "HN": "Honduras",
                "HM": "Heard Island and McDonald Islands",
                "VE": "Venezuela",
                "PR": "Puerto Rico",
                "PS": "Palestinian Territory",
                "PW": "Palau",
                "PT": "Portugal",
                "SJ": "Svalbard and Jan Mayen",
                "PY": "Paraguay",
                "IQ": "Iraq",
                "PA": "Panama",
                "PF": "French Polynesia",
                "BZ": "Belize",
                "PE": "Peru",
                "PK": "Pakistan",
                "PH": "Philippines",
                "PN": "Pitcairn",
                "TM": "Turkmenistan",
                "PL": "Poland",
                "PM": "Saint Pierre and Miquelon",
                "ZM": "Zambia",
                "EH": "Western Sahara",
                "RU": "Russian Federation",
                "EE": "Estonia",
                "EG": "Egypt",
                "TK": "Tokelau",
                "ZA": "South Africa",
                "EC": "Ecuador",
                "IT": "Italy",
                "VN": "Vietnam",
                "SB": "Solomon Islands",
                "EU": "Europe",
                "ET": "Ethiopia",
                "SO": "Somalia",
                "ZW": "Zimbabwe",
                "SA": "Saudi Arabia",
                "ES": "Spain",
                "ER": "Eritrea",
                "ME": "Montenegro",
                "MD": "Moldova, Republic of",
                "MG": "Madagascar",
                "MF": "Saint Martin",
                "MA": "Morocco",
                "MC": "Monaco",
                "UZ": "Uzbekistan",
                "MM": "Myanmar",
                "ML": "Mali",
                "MO": "Macao",
                "MN": "Mongolia",
                "MH": "Marshall Islands",
                "MK": "Macedonia",
                "MU": "Mauritius",
                "MT": "Malta",
                "MW": "Malawi",
                "MV": "Maldives",
                "MQ": "Martinique",
                "MP": "Northern Mariana Islands",
                "MS": "Montserrat",
                "MR": "Mauritania",
                "IM": "Isle of Man",
                "UG": "Uganda",
                "TZ": "Tanzania, United Republic of",
                "MY": "Malaysia",
                "MX": "Mexico",
                "IL": "Israel",
                "FR": "France",
                "IO": "British Indian Ocean Territory",
                "FX": "France, Metropolitan",
                "SH": "Saint Helena",
                "FI": "Finland",
                "FJ": "Fiji",
                "FK": "Falkland Islands (Malvinas)",
                "FM": "Micronesia, Federated States of",
                "FO": "Faroe Islands",
                "NI": "Nicaragua",
                "NL": "Netherlands",
                "NO": "Norway",
                "NA": "Namibia",
                "VU": "Vanuatu",
                "NC": "New Caledonia",
                "NE": "Niger",
                "NF": "Norfolk Island",
                "NG": "Nigeria",
                "NZ": "New Zealand",
                "NP": "Nepal",
                "NR": "Nauru",
                "NU": "Niue",
                "CK": "Cook Islands",
                "CI": "Cote d'Ivoire",
                "CH": "Switzerland",
                "CO": "Colombia",
                "CN": "China",
                "CM": "Cameroon",
                "CL": "Chile",
                "CC": "Cocos (Keeling) Islands",
                "CA": "Canada",
                "CG": "Congo",
                "CF": "Central African Republic",
                "CD": "Congo, The Democratic Republic of the",
                "CZ": "Czech Republic",
                "CY": "Cyprus",
                "CX": "Christmas Island",
                "CR": "Costa Rica",
                "CV": "Cape Verde",
                "CU": "Cuba",
                "SZ": "Swaziland",
                "SY": "Syrian Arab Republic",
                "KG": "Kyrgyzstan",
                "KE": "Kenya",
                "SR": "Suriname",
                "KI": "Kiribati",
                "KH": "Cambodia",
                "KN": "Saint Kitts and Nevis",
                "KM": "Comoros",
                "ST": "Sao Tome and Principe",
                "SK": "Slovakia",
                "KR": "Korea, Republic of",
                "SI": "Slovenia",
                "KP": "Korea, Democratic People's Republic of",
                "KW": "Kuwait",
                "SN": "Senegal",
                "SM": "San Marino",
                "SL": "Sierra Leone",
                "SC": "Seychelles",
                "KZ": "Kazakhstan",
                "KY": "Cayman Islands",
                "SG": "Singapore",
                "SE": "Sweden",
                "SD": "Sudan",
                "DO": "Dominican Republic",
                "DM": "Dominica",
                "DJ": "Djibouti",
                "DK": "Denmark",
                "VG": "Virgin Islands, British",
                "DE": "Germany",
                "YE": "Yemen",
                "DZ": "Algeria",
                "US": "United States",
                "UY": "Uruguay",
                "YT": "Mayotte",
                "UM": "United States Minor Outlying Islands",
                "LB": "Lebanon",
                "LC": "Saint Lucia",
                "LA": "Lao People's Democratic Republic",
                "TV": "Tuvalu",
                "TW": "Taiwan",
                "TT": "Trinidad and Tobago",
                "TR": "Turkey",
                "LK": "Sri Lanka",
                "LI": "Liechtenstein",
                "A1": "Anonymous Proxy",
                "TO": "Tonga",
                "LT": "Lithuania",
                "A2": "Satellite Provider",
                "LR": "Liberia",
                "LS": "Lesotho",
                "TH": "Thailand",
                "TF": "French Southern Territories",
                "TG": "Togo",
                "TD": "Chad",
                "TC": "Turks and Caicos Islands",
                "LY": "Libyan Arab Jamahiriya",
                "VA": "Holy See (Vatican City State)",
                "VC": "Saint Vincent and the Grenadines",
                "AE": "United Arab Emirates",
                "AD": "Andorra",
                "AG": "Antigua and Barbuda",
                "AF": "Afghanistan",
                "AI": "Anguilla",
                "VI": "Virgin Islands, U.S.",
                "IS": "Iceland",
                "IR": "Iran, Islamic Republic of",
                "AM": "Armenia",
                "AL": "Albania",
                "AO": "Angola",
                "AN": "Netherlands Antilles",
                "AQ": "Antarctica",
                "AP": "Asia/Pacific Region",
                "AS": "American Samoa",
                "AR": "Argentina",
                "AU": "Australia",
                "AT": "Austria",
                "AW": "Aruba",
                "IN": "India",
                "AX": "Aland Islands",
                "AZ": "Azerbaijan",
                "IE": "Ireland",
                "ID": "Indonesia",
                "UA": "Ukraine",
                "QA": "Qatar",
                "MZ": "Mozambique"
            }, function (k, v) {
                countries.push({
                    id: k,
                    text: v
                });
            });

            $('#country').editable({
                source: countries,
                select2: {
                    width: 200
                }
            });

            $('#address').editable({
                url: '/post',
                value: {
                    city: "Moscow",
                    street: "Lenina",
                    building: "12"
                },
                validate: function (value) {
                    if (value.city == '')
                        return 'city is required!';
                },
                display: function (value) {
                    if (!value) {
                        $(this).empty();
                        return;
                    }
                    var html = '<b>' + $('<div>').text(value.city).html() + '</b>, ' + $('<div>').text(value.street)
                            .html() + ' st., bld. ' + $('<div>').text(value.building).html();
                    $(this).html(html);
                }
            });

            $('#user .editable').on('hidden', function (e, reason) {
                if (reason === 'save' || reason === 'nochange') {
                    var $next = $(this).closest('tr').next().find('.editable');
                    if ($('#autoopen').is(':checked')) {
                        setTimeout(function () {
                            $next.editable('show');
                        }, 300);
                    } else {
                        $next.focus();
                    }
                }
            });

        })

    </script>
    <?php break; ?>

<?php case 'wizard': ?>
    <!-- PAGE RELATED PLUGIN(S) -->
    <script src="/public/pandora/js/plugin/bootstrap-wizard/jquery.bootstrap.wizard.min.js"></script>
    <script src="/public/pandora/js/plugin/fuelux/wizard/wizard.min.js"></script>


    <script type="text/javascript">

        // DO NOT REMOVE : GLOBAL FUNCTIONS!

        $(document).ready(function() {

            pageSetUp();



            //Bootstrap Wizard Validations

            var $validator = $("#wizard-1").validate({

                rules: {
                    email: {
                        required: true,
                        email: "Your email address must be in the format of name@domain.com"
                    },
                    fname: {
                        required: true
                    },
                    lname: {
                        required: true
                    },
                    country: {
                        required: true
                    },
                    city: {
                        required: true
                    },
                    postal: {
                        required: true,
                        minlength: 4
                    },
                    wphone: {
                        required: true,
                        minlength: 10
                    },
                    hphone: {
                        required: true,
                        minlength: 10
                    }
                },

                messages: {
                    fname: "Please specify your First name",
                    lname: "Please specify your Last name",
                    email: {
                        required: "We need your email address to contact you",
                        email: "Your email address must be in the format of name@domain.com"
                    }
                },

                highlight: function (element) {
                    $(element).closest('.form-group').removeClass('has-success').addClass('has-error');
                },
                unhighlight: function (element) {
                    $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                },
                errorElement: 'span',
                errorClass: 'help-block',
                errorPlacement: function (error, element) {
                    if (element.parent('.input-group').length) {
                        error.insertAfter(element.parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            $('#bootstrap-wizard-1').bootstrapWizard({
                'tabClass': 'form-wizard',
                'onNext': function (tab, navigation, index) {
                    var $valid = $("#wizard-1").valid();
                    if (!$valid) {
                        $validator.focusInvalid();
                        return false;
                    } else {
                        $('#bootstrap-wizard-1').find('.form-wizard').children('li').eq(index - 1).addClass(
                            'complete');
                        $('#bootstrap-wizard-1').find('.form-wizard').children('li').eq(index - 1).find('.step')
                            .html('<i class="fa fa-check"></i>');
                    }
                }
            });


            // fuelux wizard
            var wizard = $('.wizard').wizard();

            wizard.on('finished', function (e, data) {
                //$("#fuelux-wizard").submit();
                //console.log("submitted!");
                $.smallBox({
                    title: "Congratulations! Your form was submitted",
                    content: "<i class='fa fa-clock-o'></i> <i>1 seconds ago...</i>",
                    color: "#5F895F",
                    iconSmall: "fa fa-check bounce animated",
                    timeout: 4000
                });

            });


        })

    </script>
    <?php break; ?>

<?php case 'othereditors': ?>
		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/summernote/summernote.min.js"></script>
		<script src="/public/pandora/js/plugin/markdown/markdown.min.js"></script>
		<script src="/public/pandora/js/plugin/markdown/to-markdown.min.js"></script>
		<script src="/public/pandora/js/plugin/markdown/bootstrap-markdown.min.js"></script>


		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                /*
                 * SUMMERNOTE EDITOR
                 */

                $('.summernote').summernote({
                    height : 180,
                    focus : false,
                    tabsize : 2
                });

                /*
                 * MARKDOWN EDITOR
                 */

                $("#mymarkdown").markdown({
                    autofocus:false,
                    savable:true
                })


            })

        </script>
    <?php break; ?>

<?php case 'dropzone': ?>
		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/dropzone/dropzone.min.js"></script>



		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                Dropzone.autoDiscover = false;
                $("#mydropzone").dropzone({
                    //url: "/file/post",
                    addRemoveLinks : true,
                    maxFilesize: 0.5,
                    dictDefaultMessage: '<span class="text-center"><span class="font-lg visible-xs-block visible-sm-block visible-lg-block"><span class="font-lg"><i class="fa fa-caret-right text-danger"></i> Drop files <span class="font-xs">to upload</span></span><span>&nbsp&nbsp<h4 class="display-inline"> (Or Click)</h4></span>',
                    dictResponseError: 'Error uploading file!'
                });


            })

        </script>
    <?php break; ?>

<?php case 'imageeditor': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script src="/public/pandora/js/plugin/jcrop/jquery.Jcrop.min.js"></script>
		<script src="/public/pandora/js/plugin/jcrop/jquery.color.min.js"></script>

		<script type="text/javascript">

            $(document).ready(function() {
                pageSetUp();


                //console.log("load and ready");


                // api_handler

                var api_handler = function() {

                    // The variable jcrop_api will hold a reference to the
                    // Jcrop API once Jcrop is instantiated.
                    var jcrop_api;


                    // The function is pretty simple
                    var initJcrop = function(){
                        // Hide any interface elements that require Jcrop
                        // (This is for the local user interface portion.)
                        $('.requiresjcrop').hide();

                        // Invoke Jcrop in typical fashion
                        $('#target-5').Jcrop({
                            onRelease : releaseCheck
                        }, function() {

                            jcrop_api = this;
                            jcrop_api.animateTo([100, 100, 400, 300]);

                            // Setup and dipslay the interface for "enabled"
                            $('#can_click,#can_move,#can_size').attr('checked', 'checked');
                            $('#ar_lock,#size_lock,#bg_swap').attr('checked', false);
                            $('.requiresjcrop').show();

                        });

                    };

                    // In this example, since Jcrop may be attached or detached
                    // at the whim of the user, I've wrapped the call into a function
                    initJcrop();

                    // Use the API to find cropping dimensions
                    // Then generate a random selection
                    // This function is used by setSelect and animateTo buttons
                    // Mainly for demonstration purposes
                    function getRandom() {
                        var dim = jcrop_api.getBounds();
                        return [Math.round(Math.random() * dim[0]), Math.round(Math.random() * dim[1]), Math.round(Math.random() * dim[0]), Math.round(Math.random() * dim[1])];
                    };

                    // This function is bound to the onRelease handler...
                    // In certain circumstances (such as if you set minSize
                    // and aspectRatio together), you can inadvertently lose
                    // the selection. This callback re-enables creating selections
                    // in such a case. Although the need to do this is based on a
                    // buggy behavior, it's recommended that you in some way trap
                    // the onRelease callback if you use allowSelect: false
                    function releaseCheck() {
                        jcrop_api.setOptions({
                            allowSelect : true
                        });
                        $('#can_click').attr('checked', false);
                    };

                    // Attach interface buttons
                    // This may appear to be a lot of code but it's simple stuff
                    $('#setSelect').click(function(e) {
                        // Sets a random selection
                        jcrop_api.setSelect(getRandom());
                    });
                    $('#animateTo').click(function(e) {
                        // Animates to a random selection
                        jcrop_api.animateTo(getRandom());
                    });
                    $('#release').click(function(e) {
                        // Release method clears the selection
                        jcrop_api.release();
                    });
                    $('#disable').click(function(e) {
                        // Disable Jcrop instance
                        jcrop_api.disable();
                        // Update the interface to reflect disabled state
                        $('#enable').show();
                        $('.requiresjcrop').hide();
                    });
                    $('#enable').click(function(e) {
                        // Re-enable Jcrop instance
                        jcrop_api.enable();
                        // Update the interface to reflect enabled state
                        $('#enable').hide();
                        $('.requiresjcrop').show();
                    });
                    $('#rehook').click(function(e) {
                        // This button is visible when Jcrop has been destroyed
                        // It performs the re-attachment and updates the UI
                        $('#rehook,#enable').hide();
                        initJcrop();
                        $('#unhook,.requiresjcrop').show();
                        return false;
                    });
                    $('#unhook').click(function(e) {
                        // Destroy Jcrop widget, restore original state
                        jcrop_api.destroy();
                        // Update the interface to reflect un-attached state
                        $('#unhook,#enable,.requiresjcrop').hide();
                        $('#rehook').show();
                        return false;
                    });

                    // Hook up the three image-swapping buttons
                    $('#img1').click(function(e) {
                        $(this).addClass('active').closest('.btn-group').find('button.active').not(this).removeClass('active');

                        jcrop_api.setImage('/public/pandora/img/superbox/superbox-full-7.jpg');
                        jcrop_api.setOptions({
                            bgOpacity : .6
                        });
                        return false;
                    });
                    $('#img2').click(function(e) {
                        $(this).addClass('active').closest('.btn-group').find('button.active').not(this).removeClass('active');

                        jcrop_api.setImage('/public/pandora/img/superbox/superbox-full-24.jpg');
                        jcrop_api.setOptions({
                            bgOpacity : .6
                        });
                        return false;
                    });
                    $('#img3').click(function(e) {
                        $(this).addClass('active').closest('.btn-group').find('button.active').not(this).removeClass('active');

                        jcrop_api.setImage('/public/pandora/img/superbox/superbox-full-20.jpg', function() {
                            this.setOptions({
                                bgOpacity : 1,
                                outerImage : '/public/pandora/img/superbox/superbox-full-20-bw.jpg'
                            });
                            this.animateTo(getRandom());
                        });
                        return false;
                    });

                    // The checkboxes simply set options based on it's checked value
                    // Options are changed by passing a new options object

                    // Also, to prevent strange behavior, they are initially checked
                    // This matches the default initial state of Jcrop

                    $('#can_click').change(function(e) {
                        jcrop_api.setOptions({
                            allowSelect : !!this.checked
                        });
                        jcrop_api.focus();
                    });
                    $('#can_move').change(function(e) {
                        jcrop_api.setOptions({
                            allowMove : !!this.checked
                        });
                        jcrop_api.focus();
                    });
                    $('#can_size').change(function(e) {
                        jcrop_api.setOptions({
                            allowResize : !!this.checked
                        });
                        jcrop_api.focus();
                    });
                    $('#ar_lock').change(function(e) {
                        jcrop_api.setOptions(this.checked ? {
                            aspectRatio : 4 / 3
                        } : {
                            aspectRatio : 0
                        });
                        jcrop_api.focus();
                    });
                    $('#size_lock').change(function(e) {
                        jcrop_api.setOptions(this.checked ? {
                            minSize : [80, 80],
                            maxSize : [350, 350]
                        } : {
                            minSize : [0, 0],
                            maxSize : [0, 0]
                        });
                        jcrop_api.focus();
                    });

                }

                // end api_handler

                // default

                var default_handler = function(){
                    $('#target').Jcrop();
                }

                // basic handler

                var basic_handler = function() {

                    var jcrop_api;

                    $('#target-2').Jcrop({
                        onChange : showCoords,
                        onSelect : showCoords,
                        onRelease : clearCoords
                    }, function() {
                        jcrop_api = this;
                    });

                    $('#coords').on('change', 'input', function(e) {
                        var x1 = $('#x1').val(), x2 = $('#x2').val(), y1 = $('#y1').val(), y2 = $('#y2').val();
                        jcrop_api.setSelect([x1, y1, x2, y2]);
                    });

                    // Simple event handler, called from onChange and onSelect
                    // event handlers, as per the Jcrop invocation above
                    function showCoords(c) {
                        $('#x1').val(c.x);
                        $('#y1').val(c.y);
                        $('#x2').val(c.x2);
                        $('#y2').val(c.y2);
                        $('#w').val(c.w);
                        $('#h').val(c.h);
                    };

                    function clearCoords() {
                        $('#coords input').val('');
                    };

                };

                // end basic_handler

                // aspect ratio

                var aspect_ratio = function() {

                    // Create variables (in this scope) to hold the API and image size
                    var jcrop_api, boundx, boundy,

                    // Grab some information about the preview pane
                        $preview = $('#preview-pane'), $pcnt = $('#preview-pane .preview-container'), $pimg = $('#preview-pane .preview-container img'), xsize = $pcnt.width(), ysize = $pcnt.height();

                    console.log('init', [xsize, ysize]);
                    $('#target-3').Jcrop({
                        onChange : updatePreview,
                        onSelect : updatePreview,
                        aspectRatio : xsize / ysize
                    }, function() {
                        // Use the API to get the real image size
                        var bounds = this.getBounds();
                        boundx = bounds[0];
                        boundy = bounds[1];
                        // Store the API in the jcrop_api variable
                        jcrop_api = this;

                        // Move the preview into the jcrop container for css positioning
                        $preview.appendTo(jcrop_api.ui.holder);
                    });

                    function updatePreview(c) {
                        if (parseInt(c.w) > 0) {
                            var rx = xsize / c.w;
                            var ry = ysize / c.h;

                            $pimg.css({
                                width : Math.round(rx * boundx) + 'px',
                                height : Math.round(ry * boundy) + 'px',
                                marginLeft : '-' + Math.round(rx * c.x) + 'px',
                                marginTop : '-' + Math.round(ry * c.y) + 'px'
                            });
                        }
                    };

                }
                // end aspect_ratio

                // animation_handler

                var animation_handler = function() {

                    var jcrop_api;

                    $('#target-4').Jcrop({
                        bgFade : true,
                        bgOpacity : .2,
                        setSelect : [60, 70, 540, 330]
                    }, function() {
                        jcrop_api = this;
                    });

                    $('#fadetog').change(function() {
                        jcrop_api.setOptions({
                            bgFade : this.checked
                        });
                    }).attr('checked', 'checked');

                    $('#shadetog').change(function() {
                        if (this.checked)
                            $('#shadetxt').slideDown();
                        else
                            $('#shadetxt').slideUp();
                        jcrop_api.setOptions({
                            shade : this.checked
                        });
                    }).attr('checked', false);

                    // Define page sections
                    var sections = {
                        bgc_buttons : 'Change bgColor',
                        bgo_buttons : 'Change bgOpacity',
                        anim_buttons : 'Animate Selection'
                    };
                    // Define animation buttons
                    var ac = {
                        anim1 : [217, 122, 382, 284],
                        anim2 : [20, 20, 580, 380],
                        anim3 : [24, 24, 176, 376],
                        anim4 : [347, 165, 550, 355],
                        anim5 : [136, 55, 472, 183]
                    };
                    // Define bgOpacity buttons
                    var bgo = {
                        Low : .2,
                        Mid : .5,
                        High : .8,
                        Full : 1
                    };
                    // Define bgColor buttons
                    var bgc = {
                        R : '#900',
                        B : '#4BB6F0',
                        Y : '#F0B207',
                        G : '#46B81C',
                        W : 'white',
                        K : 'black'
                    };
                    // Create fieldset targets for buttons
                    for (i in sections)insertSection(i, sections[i]);

                    function create_btn(c) {
                        var $o = $('<button />').addClass('btn btn-default btn-small');
                        if (c)
                            $o.append(c);
                        return $o;
                    }

                    var a_count = 1;
                    // Create animation buttons
                    for (i in ac) {
                        $('#anim_buttons .btn-group').append(create_btn(a_count++).click(animHandler(ac[i])), ' ');
                    }

                    $('#anim_buttons .btn-group').append(create_btn('Bye!').click(function(e) {
                        $(e.target).addClass('active');
                        jcrop_api.animateTo([300, 200, 300, 200], function() {
                            this.release();
                            $(e.target).closest('.btn-group').find('.active').removeClass('active');
                        });
                        return false;
                    }));

                    // Create bgOpacity buttons
                    for (i in bgo) {
                        $('#bgo_buttons .btn-group').append(create_btn(i).click(setoptHandler('bgOpacity', bgo[i])), ' ');
                    }
                    // Create bgColor buttons
                    for (i in bgc) {
                        $('#bgc_buttons .btn-group').append(create_btn(i).css({
                            background : bgc[i],
                            color : ((i == 'K') || (i == 'R')) ? 'white' : 'black'
                        }).click(setoptHandler('bgColor', bgc[i])), ' ');
                    }
                    // Function to insert named sections into interface
                    function insertSection(k, v) {
                        $('#interface').prepend($('<fieldset></fieldset>').attr('id', k).append($('<legend></legend>').append(v), '<div class="btn-toolbar"><div class="btn-group"></div></div>'));
                    };
                    // Handler for option-setting buttons
                    function setoptHandler(k, v) {
                        return function(e) {
                            $(e.target).closest('.btn-group').find('.active').removeClass('active');
                            $(e.target).addClass('active');
                            var opt = { };
                            opt[k] = v;
                            jcrop_api.setOptions(opt);
                            return false;
                        };
                    };
                    // Handler for animation buttons
                    function animHandler(v) {
                        return function(e) {
                            $(e.target).addClass('active');
                            jcrop_api.animateTo(v, function() {
                                $(e.target).closest('.btn-group').find('.active').removeClass('active');
                            });
                            return false;
                        };
                    };

                    $('#bgo_buttons .btn:first,#bgc_buttons .btn:last').addClass('active');
                    $('#interface').show();

                }
                // end animation_handler

                // styling_handler

                var styling_handler = function () {

                    var api;

                    $('#target-6').Jcrop({
                        // start off with jcrop-light class
                        bgOpacity : 0.5,
                        bgColor : 'white',
                        addClass : 'jcrop-light'
                    }, function() {
                        api = this;
                        api.setSelect([130, 65, 130 + 350, 65 + 285]);
                        api.setOptions({
                            bgFade : true
                        });
                        api.ui.selection.addClass('jcrop-selection');
                    });

                    $('#buttonbar').on('click', 'button', function(e) {
                        var $t = $(this), $g = $t.closest('.btn-group');
                        $g.find('button.active').removeClass('active');
                        $t.addClass('active');
                        $g.find('[data-setclass]').each(function() {
                            var $th = $(this), c = $th.data('setclass'), a = $th.hasClass('active');
                            if (a) {
                                api.ui.holder.addClass(c);
                                switch(c) {

                                    case 'jcrop-light':
                                        api.setOptions({
                                            bgColor : 'white',
                                            bgOpacity : 0.5
                                        });
                                        break;

                                    case 'jcrop-dark':
                                        api.setOptions({
                                            bgColor : 'black',
                                            bgOpacity : 0.4
                                        });
                                        break;

                                    case 'jcrop-normal':
                                        api.setOptions({
                                            bgColor : $.Jcrop.defaults.bgColor,
                                            bgOpacity : $.Jcrop.defaults.bgOpacity
                                        });
                                        break;
                                }
                            } else
                                api.ui.holder.removeClass(c);
                        });
                    });

                }

                // end styling_handler

                //run functions

                api_handler();
                default_handler();
                basic_handler();
                aspect_ratio();
                animation_handler();
                styling_handler();
            });

        </script>
    <?php break; ?>

<?php case 'generalelements': ?>
		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/bootstrap-progressbar/bootstrap-progressbar.min.js"></script>



		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                /*
                 * Autostart Carousel
                 */
                $('.carousel.slide').carousel({
                    interval : 3000,
                    cycle : true
                });
                $('.carousel.fade').carousel({
                    interval : 3000,
                    cycle : true
                });

                // Fill all progress bars with animation

                $('.progress-bar').progressbar({
                    display_text : 'fill'
                });


                /*
                 * Smart Notifications
                 */
                $('#eg1').click(function(e) {

                    $.bigBox({
                        title : "Big Information box",
                        content : "This message will dissapear in 6 seconds!",
                        color : "#C46A69",
                        //timeout: 6000,
                        icon : "fa fa-warning shake animated",
                        number : "1",
                        timeout : 6000
                    });

                    e.preventDefault();

                })

                $('#eg2').click(function(e) {

                    $.bigBox({
                        title : "Big Information box",
                        content : "Lorem ipsum dolor sit amet, test consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam",
                        color : "#3276B1",
                        //timeout: 8000,
                        icon : "fa fa-bell swing animated",
                        number : "2"
                    });

                    e.preventDefault();
                })

                $('#eg3').click(function(e) {

                    $.bigBox({
                        title : "Shield is up and running!",
                        content : "Lorem ipsum dolor sit amet, test consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam",
                        color : "#C79121",
                        //timeout: 8000,
                        icon : "fa fa-shield fadeInLeft animated",
                        number : "3"
                    });

                    e.preventDefault();

                })

                $('#eg4').click(function(e) {

                    $.bigBox({
                        title : "Success Message Example",
                        content : "Lorem ipsum dolor sit amet, test consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam",
                        color : "#739E73",
                        //timeout: 8000,
                        icon : "fa fa-check",
                        number : "4"
                    }, function() {
                        closedthis();
                    });

                    e.preventDefault();

                })



                $('#eg5').click(function() {

                    $.smallBox({
                        title : "Ding Dong!",
                        content : "Someone's at the door...shall one get it sir? <p class='text-align-right'><a href='javascript:void(0);' class='btn btn-primary btn-sm'>Yes</a> <a href='javascript:void(0);' class='btn btn-danger btn-sm'>No</a></p>",
                        color : "#296191",
                        //timeout: 8000,
                        icon : "fa fa-bell swing animated"
                    });

                });



                $('#eg6').click(function() {

                    $.smallBox({
                        title : "Big Information box",
                        content : "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam",
                        color : "#5384AF",
                        //timeout: 8000,
                        icon : "fa fa-bell"
                    });

                })

                $('#eg7').click(function() {

                    $.smallBox({
                        title : "James Simmons liked your comment",
                        content : "<i class='fa fa-clock-o'></i> <i>2 seconds ago...</i>",
                        color : "#296191",
                        iconSmall : "fa fa-thumbs-up bounce animated",
                        timeout : 4000
                    });

                })

                function closedthis() {
                    $.smallBox({
                        title : "Great! You just closed that last alert!",
                        content : "This message will be gone in 5 seconds!",
                        color : "#739E73",
                        iconSmall : "fa fa-cloud",
                        timeout : 5000
                    });
                }

                /*
                 * SmartAlerts
                 */
                // With Callback
                $("#smart-mod-eg1").click(function(e) {
                    $.SmartMessageBox({
                        title : "Smart Alert!",
                        content : "This is a confirmation box. Can be programmed for button callback",
                        buttons : '[No][Yes]'
                    }, function(ButtonPressed) {
                        if (ButtonPressed === "Yes") {

                            $.smallBox({
                                title : "Callback function",
                                content : "<i class='fa fa-clock-o'></i> <i>You pressed Yes...</i>",
                                color : "#659265",
                                iconSmall : "fa fa-check fa-2x fadeInRight animated",
                                timeout : 4000
                            });
                        }
                        if (ButtonPressed === "No") {
                            $.smallBox({
                                title : "Callback function",
                                content : "<i class='fa fa-clock-o'></i> <i>You pressed No...</i>",
                                color : "#C46A69",
                                iconSmall : "fa fa-times fa-2x fadeInRight animated",
                                timeout : 4000
                            });
                        }

                    });
                    e.preventDefault();
                })
                // With Input
                $("#smart-mod-eg2").click(function(e) {

                    $.SmartMessageBox({
                        title : "Smart Alert: Input",
                        content : "Please enter your user name",
                        buttons : "[Accept]",
                        input : "text",
                        placeholder : "Enter your user name"
                    }, function(ButtonPress, Value) {
                        alert(ButtonPress + " " + Value);
                    });

                    e.preventDefault();
                })
                // With Buttons
                $("#smart-mod-eg3").click(function(e) {

                    $.SmartMessageBox({
                        title : "Smart Notification: Buttons",
                        content : "Lots of buttons to go...",
                        buttons : '[Need?][You][Do][Buttons][Many][How]'
                    });

                    e.preventDefault();
                })
                // With Select
                $("#smart-mod-eg4").click(function(e) {

                    $.SmartMessageBox({
                        title : "Smart Alert: Select",
                        content : "You can even create a group of options.",
                        buttons : "[Done]",
                        input : "select",
                        options : "[Costa Rica][United States][Autralia][Spain]"
                    }, function(ButtonPress, Value) {
                        alert(ButtonPress + " " + Value);
                    });

                    e.preventDefault();
                });

                // With Login
                $("#smart-mod-eg5").click(function(e) {

                    $.SmartMessageBox({
                        title : "Login form",
                        content : "Please enter your user name",
                        buttons : "[Cancel][Accept]",
                        input : "text",
                        placeholder : "Enter your user name"
                    }, function(ButtonPress, Value) {
                        if (ButtonPress == "Cancel") {
                            alert("Why did you cancel that? :(");
                            return 0;
                        }

                        Value1 = Value.toUpperCase();
                        ValueOriginal = Value;
                        $.SmartMessageBox({
                            title : "Hey! <strong>" + Value1 + ",</strong>",
                            content : "And now please provide your password:",
                            buttons : "[Login]",
                            input : "password",
                            placeholder : "Password"
                        }, function(ButtonPress, Value) {
                            alert("Username: " + ValueOriginal + " and your password is: " + Value);
                        });
                    });

                    e.preventDefault();
                });


            })

        </script>
    <?php break; ?>

<?php case 'buttons': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'fa': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                function hide_divs(search) {
                    $(".demo-icon-font").hide(); // hide all divs
                    $("#all-icons-demo h2").hide();
                    $("#all-icons-demo .alert").hide();
                    $('.demo-icon-font > i[class*="'+search+'"]').parent().show(); // show the ones that match
                }

                function show_all() {
                    $(".demo-icon-font").show()
                    $("#all-icons-demo h2").show();
                    $("#all-icons-demo .alert").show();
                }

                $("#fa-icon-search").keyup(function() {
                    var search = $.trim(this.value);
                    if (search === "") {
                        show_all();
                    }
                    else {
                        hide_divs(search);
                    }
                });

            })

        </script>
    <?php break; ?>

<?php case 'glyph': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->



		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                // PAGE RELATED SCRIPTS

                function hide_divs(search) {
                    $(".bs-glyphicons li").hide(); // hide all divs
                    $('.bs-glyphicons li > span[class*="'+search+'"]').parent().show(); // show the ones that match
                }

                function show_all() {
                    $(".bs-glyphicons li").show()
                }

                $("#glyph-search").keyup(function() {
                    var search = $.trim(this.value);
                    if (search === "") {
                        show_all();
                    }
                    else {
                        hide_divs(search);
                    }
                });


            })

        </script>
    <?php break; ?>

<?php case 'flags': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">
            $(document).ready(function() {
                pageSetUp();
            });

        </script>
    <?php break; ?>

<?php case 'grid': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'treeview': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->


		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                // PAGE RELATED SCRIPTS

                $('.tree > ul').attr('role', 'tree').find('ul').attr('role', 'group');
                $('.tree').find('li:has(ul)').addClass('parent_li').attr('role', 'treeitem').find(' > span').attr('title', 'Collapse this branch').on('click', function(e) {
                    var children = $(this).parent('li.parent_li').find(' > ul > li');
                    if (children.is(':visible')) {
                        children.hide('fast');
                        $(this).attr('title', 'Expand this branch').find(' > i').removeClass().addClass('fa fa-lg fa-plus-circle');
                    } else {
                        children.show('fast');
                        $(this).attr('title', 'Collapse this branch').find(' > i').removeClass().addClass('fa fa-lg fa-minus-circle');
                    }
                    e.stopPropagation();
                });

            })

        </script>
    <?php break; ?>

<?php case 'nestablelist': ?>
		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/jquery-nestable/jquery.nestable.min.js"></script>


		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                // PAGE RELATED SCRIPTS

                var updateOutput = function(e) {
                    var list = e.length ? e : $(e.target), output = list.data('output');
                    if (window.JSON) {
                        output.val(window.JSON.stringify(list.nestable('serialize')));
                        //, null, 2));
                    } else {
                        output.val('JSON browser support required for this demo.');
                    }
                };

                // activate Nestable for list 1
                $('#nestable').nestable({
                    group : 1
                }).on('change', updateOutput);

                // activate Nestable for list 2
                $('#nestable2').nestable({
                    group : 1
                }).on('change', updateOutput);

                // output initial serialised data
                updateOutput($('#nestable').data('output', $('#nestable-output')));
                updateOutput($('#nestable2').data('output', $('#nestable2-output')));

                $('#nestable-menu').on('click', function(e) {
                    var target = $(e.target), action = target.data('action');
                    if (action === 'expand-all') {
                        $('.dd').nestable('expandAll');
                    }
                    if (action === 'collapse-all') {
                        $('.dd').nestable('collapseAll');
                    }
                });

                $('#nestable3').nestable();

            })

        </script>
    <?php break; ?>

<?php case 'jqui': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->



		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                // menu
                $("#menu").menu();

                /*
                 * AUTO COMPLETE AJAX
                 */

                function log(message) {
                    $("<div>").text(message).prependTo("#log");
                    $("#log").scrollTop(0);
                }

                $("#city").autocomplete({
                    source : function(request, response) {
                        $.ajax({
                            url : "http://ws.geonames.org/searchJSON",
                            dataType : "jsonp",
                            data : {
                                featureClass : "P",
                                style : "full",
                                maxRows : 12,
                                name_startsWith : request.term
                            },
                            success : function(data) {
                                response($.map(data.geonames, function(item) {
                                    return {
                                        label : item.name + (item.adminName1 ? ", " + item.adminName1 : "") + ", " + item.countryName,
                                        value : item.name
                                    }
                                }));
                            }
                        });
                    },
                    minLength : 2,
                    select : function(event, ui) {
                        log(ui.item ? "Selected: " + ui.item.label : "Nothing selected, input was " + this.value);
                    }
                });

                /*
                 * Spinners
                 */
                $("#spinner").spinner();
                $("#spinner-decimal").spinner({
                    step : 0.01,
                    numberFormat : "n"
                });

                $("#spinner-currency").spinner({
                    min : 5,
                    max : 2500,
                    step : 25,
                    start : 1000,
                    numberFormat : "C"
                });

                /*
                 * CONVERT DIALOG TITLE TO HTML
                 * REF: http://stackoverflow.com/questions/14488774/using-html-in-a-dialogs-title-in-jquery-ui-1-10
                 */
                $.widget("ui.dialog", $.extend({}, $.ui.dialog.prototype, {
                    _title : function(title) {
                        if (!this.options.title) {
                            title.html("&#160;");
                        } else {
                            title.html(this.options.title);
                        }
                    }
                }));


                /*
                 * DIALOG SIMPLE
                 */

                // Dialog click
                $('#dialog_link').click(function() {
                    $('#dialog_simple').dialog('open');
                    return false;

                });

                $('#dialog_simple').dialog({
                    autoOpen : false,
                    width : 600,
                    resizable : false,
                    modal : true,
                    title : "<div class='widget-header'><h4><i class='fa fa-warning'></i> Empty the recycle bin?</h4></div>",
                    buttons : [{
                        html : "<i class='fa fa-trash-o'></i>&nbsp; Delete all items",
                        "class" : "btn btn-danger",
                        click : function() {
                            $(this).dialog("close");
                        }
                    }, {
                        html : "<i class='fa fa-times'></i>&nbsp; Cancel",
                        "class" : "btn btn-default",
                        click : function() {
                            $(this).dialog("close");
                        }
                    }]
                });

                /*
                 * DIALOG HEADER ICON
                 */

                // Modal Link
                $('#modal_link').click(function() {
                    $('#dialog-message').dialog('open');
                    return false;
                });

                $("#dialog-message").dialog({
                    autoOpen : false,
                    modal : true,
                    title : "<div class='widget-header'><h4><i class='icon-ok'></i> jQuery UI Dialog</h4></div>",
                    buttons : [{
                        html : "Cancel",
                        "class" : "btn btn-default",
                        click : function() {
                            $(this).dialog("close");
                        }
                    }, {
                        html : "<i class='fa fa-check'></i>&nbsp; OK",
                        "class" : "btn btn-primary",
                        click : function() {
                            $(this).dialog("close");
                        }
                    }]

                });

                /*
                 * Remove focus from buttons
                 */
                $('.ui-dialog :button').blur();

                /*
                 * Just Tabs
                 */

                $('#tabs').tabs();

                /*
                 *  Simple tabs adding and removing
                 */

                $('#tabs2').tabs();

                // Dynamic tabs
                var tabTitle = $("#tab_title"), tabContent = $("#tab_content"), tabTemplate = "<li style='position:relative;'> <span class='air air-top-left delete-tab' style='top:7px; left:7px;'><button class='btn btn-xs font-xs btn-default hover-transparent'><i class='fa fa-times'></i></button></span></span><a href='#{href}'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; #{label}</a></li>", tabCounter = 2;

                var tabs = $("#tabs2").tabs();

                // modal dialog init: custom buttons and a "close" callback reseting the form inside
                var dialog = $("#addtab").dialog({
                    autoOpen : false,
                    width : 600,
                    resizable : false,
                    modal : true,
                    buttons : [{
                        html : "<i class='fa fa-times'></i>&nbsp; Cancel",
                        "class" : "btn btn-default",
                        click : function() {
                            $(this).dialog("close");

                        }
                    }, {

                        html : "<i class='fa fa-plus'></i>&nbsp; Add",
                        "class" : "btn btn-danger",
                        click : function() {
                            addTab();
                            $(this).dialog("close");
                        }
                    }]
                });

                // addTab form: calls addTab function on submit and closes the dialog
                var form = dialog.find("form").submit(function(event) {
                    addTab();
                    dialog.dialog("close");
                    event.preventDefault();
                });

                // actual addTab function: adds new tab using the input from the form above
                function addTab() {
                    var label = tabTitle.val() || "Tab " + tabCounter, id = "tabs-" + tabCounter, li = $(tabTemplate.replace(/#\{href\}/g, "#" + id).replace(/#\{label\}/g, label)), tabContentHtml = tabContent.val() || "Tab " + tabCounter + " content.";

                    tabs.find(".ui-tabs-nav").append(li);
                    tabs.append("<div id='" + id + "'><p>" + tabContentHtml + "</p></div>");
                    tabs.tabs("refresh");
                    tabCounter++;

                    // clear fields
                    $("#tab_title").val("");
                    $("#tab_content").val("");
                }

                // addTab button: just opens the dialog
                $("#add_tab").button().click(function() {
                    dialog.dialog("open");
                });

                // close icon: removing the tab on click
                $("#tabs2").on("click", 'span.delete-tab', function() {

                    var panelId = $(this).closest("li").remove().attr("aria-controls");
                    $("#" + panelId).remove();
                    tabs.tabs("refresh");
                });

                /*
                 * ACCORDION
                 */
                //jquery accordion

                var accordionIcons = {
                    header: "fa fa-plus",    // custom icon class
                    activeHeader: "fa fa-minus" // custom icon class
                };

                $("#accordion").accordion({
                    autoHeight : false,
                    heightStyle : "content",
                    collapsible : true,
                    animate : 300,
                    icons: accordionIcons,
                    header : "h4",
                })

                /*
                 * PROGRESS BAR
                 */
                $("#progressbar").progressbar({
                    value: 25,
                    create: function( event, ui ) {
                        $(this).removeClass("ui-corner-all").addClass('progress').find(">:first-child").removeClass("ui-corner-left").addClass('progress-bar progress-bar-success');
                    }
                });

            })

        </script>
    <?php break; ?>

<?php case 'typography': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'calendar': ?>
    		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/moment/moment.min.js"></script>
		<script src="/public/pandora/js/plugin/fullcalendar/jquery.fullcalendar.min.js"></script>



		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();


                "use strict";

                var date = new Date();
                var d = date.getDate();
                var m = date.getMonth();
                var y = date.getFullYear();

                var hdr = {
                    left: 'title',
                    center: 'month,agendaWeek,agendaDay',
                    right: 'prev,today,next'
                };

                var initDrag = function (e) {
                    // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
                    // it doesn't need to have a start or end

                    var eventObject = {
                        title: $.trim(e.children().text()), // use the element's text as the event title
                        description: $.trim(e.children('span').attr('data-description')),
                        icon: $.trim(e.children('span').attr('data-icon')),
                        className: $.trim(e.children('span').attr('class')) // use the element's children as the event class
                    };
                    // store the Event Object in the DOM element so we can get to it later
                    e.data('eventObject', eventObject);

                    // make the event draggable using jQuery UI
                    e.draggable({
                        zIndex: 999,
                        revert: true, // will cause the event to go back to its
                        revertDuration: 0 //  original position after the drag
                    });
                };

                var addEvent = function (title, priority, description, icon) {
                    title = title.length === 0 ? "Untitled Event" : title;
                    description = description.length === 0 ? "No Description" : description;
                    icon = icon.length === 0 ? " " : icon;
                    priority = priority.length === 0 ? "label label-default" : priority;

                    var html = $('<li><span class="' + priority + '" data-description="' + description + '" data-icon="' +
                    icon + '">' + title + '</span></li>').prependTo('ul#external-events').hide().fadeIn();

                    $("#event-container").effect("highlight", 800);

                    initDrag(html);
                };

                /* initialize the external events
                 -----------------------------------------------------------------*/

                $('#external-events > li').each(function () {
                    initDrag($(this));
                });

                $('#add-event').click(function () {
                    var title = $('#title').val(),
                        priority = $('input:radio[name=priority]:checked').val(),
                        description = $('#description').val(),
                        icon = $('input:radio[name=iconselect]:checked').val();

                    addEvent(title, priority, description, icon);
                });

                /* initialize the calendar
                 -----------------------------------------------------------------*/

                $('#calendar').fullCalendar({

                    header: hdr,
                    buttonText: {
                        prev: '<i class="fa fa-chevron-left"></i>',
                        next: '<i class="fa fa-chevron-right"></i>'
                    },

                    editable: true,
                    droppable: true, // this allows things to be dropped onto the calendar !!!

                    drop: function (date, allDay) { // this function is called when something is dropped

                        // retrieve the dropped element's stored Event Object
                        var originalEventObject = $(this).data('eventObject');

                        // we need to copy it, so that multiple events don't have a reference to the same object
                        var copiedEventObject = $.extend({}, originalEventObject);

                        // assign it the date that was reported
                        copiedEventObject.start = date;
                        copiedEventObject.allDay = allDay;

                        // render the event on the calendar
                        // the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
                        $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

                        // is the "remove after drop" checkbox checked?
                        if ($('#drop-remove').is(':checked')) {
                            // if so, remove the element from the "Draggable Events" list
                            $(this).remove();
                        }

                    },

                    select: function (start, end, allDay) {
                        var title = prompt('Event Title:');
                        if (title) {
                            calendar.fullCalendar('renderEvent', {
                                    title: title,
                                    start: start,
                                    end: end,
                                    allDay: allDay
                                }, true // make the event "stick"
                            );
                        }
                        calendar.fullCalendar('unselect');
                    },

                    events: [{
                        title: 'All Day Event',
                        start: new Date(y, m, 1),
                        description: 'long description',
                        className: ["event", "bg-color-greenLight"],
                        icon: 'fa-check'
                    }, {
                        title: 'Long Event',
                        start: new Date(y, m, d - 5),
                        end: new Date(y, m, d - 2),
                        className: ["event", "bg-color-red"],
                        icon: 'fa-lock'
                    }, {
                        id: 999,
                        title: 'Repeating Event',
                        start: new Date(y, m, d - 3, 16, 0),
                        allDay: false,
                        className: ["event", "bg-color-blue"],
                        icon: 'fa-clock-o'
                    }, {
                        id: 999,
                        title: 'Repeating Event',
                        start: new Date(y, m, d + 4, 16, 0),
                        allDay: false,
                        className: ["event", "bg-color-blue"],
                        icon: 'fa-clock-o'
                    }, {
                        title: 'Meeting',
                        start: new Date(y, m, d, 10, 30),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Lunch',
                        start: new Date(y, m, d, 12, 0),
                        end: new Date(y, m, d, 14, 0),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Birthday Party',
                        start: new Date(y, m, d + 1, 19, 0),
                        end: new Date(y, m, d + 1, 22, 30),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Smartadmin Open Day',
                        start: new Date(y, m, 28),
                        end: new Date(y, m, 29),
                        className: ["event", "bg-color-darken"]
                    }],

                    eventRender: function (event, element, icon) {
                        if (!event.description == "") {
                            element.find('.fc-event-title').append("<br/><span class='ultra-light'>" + event.description +
                            "</span>");
                        }
                        if (!event.icon == "") {
                            element.find('.fc-event-title').append("<i class='air air-top-right fa " + event.icon +
                            " '></i>");
                        }
                    },

                    windowResize: function (event, ui) {
                        $('#calendar').fullCalendar('render');
                    }
                });

                /* hide default buttons */
                $('.fc-header-right, .fc-header-center').hide();


                $('#calendar-buttons #btn-prev').click(function () {
                    $('.fc-button-prev').click();
                    return false;
                });

                $('#calendar-buttons #btn-next').click(function () {
                    $('.fc-button-next').click();
                    return false;
                });

                $('#calendar-buttons #btn-today').click(function () {
                    $('.fc-button-today').click();
                    return false;
                });

                $('#mt').click(function () {
                    $('#calendar').fullCalendar('changeView', 'month');
                });

                $('#ag').click(function () {
                    $('#calendar').fullCalendar('changeView', 'agendaWeek');
                });

                $('#td').click(function () {
                    $('#calendar').fullCalendar('changeView', 'agendaDay');
                });

            })

        </script>
    <?php break; ?>

<?php case 'widgets': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->



		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                // PAGE RELATED SCRIPTS

                // switch style change
                $('input[name="checkbox-style"]').change(function() {
                    //alert($(this).val())
                    $this = $(this);

                    if ($this.attr('value') === "switch-1") {
                        $("#switch-1").show();
                        $("#switch-2").hide();
                    } else if ($this.attr('value') === "switch-2") {
                        $("#switch-1").hide();
                        $("#switch-2").show();
                    }

                });

                // tab - pills toggle
                $('#show-tabs').click(function() {
                    $this = $(this);
                    if($this.prop('checked')){
                        $("#widget-tab-1").removeClass("nav-pills").addClass("nav-tabs");
                    } else {
                        $("#widget-tab-1").removeClass("nav-tabs").addClass("nav-pills");
                    }

                });

            });

        </script>
    <?php break; ?>

<?php case 'projects': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script src="/public/pandora/js/plugin/datatables/jquery.dataTables.min.js"></script>
		<script src="/public/pandora/js/plugin/datatables/dataTables.colVis.min.js"></script>
		<script src="/public/pandora/js/plugin/datatables/dataTables.tableTools.min.js"></script>
		<script src="/public/pandora/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
		<script src="/public/pandora/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

		<script type="text/javascript">

            $(document).ready(function() {

                /* DO NOT REMOVE : GLOBAL FUNCTIONS!
                 *
                 * pageSetUp(); WILL CALL THE FOLLOWING FUNCTIONS
                 *
                 * // activate tooltips
                 * $("[rel=tooltip]").tooltip();
                 *
                 * // activate popovers
                 * $("[rel=popover]").popover();
                 *
                 * // activate popovers with hover states
                 * $("[rel=popover-hover]").popover({ trigger: "hover" });
                 *
                 * // activate inline charts
                 * runAllCharts();
                 *
                 * // setup widgets
                 * setup_widgets_desktop();
                 *
                 * // run form elements
                 * runAllForms();
                 *
                 ********************************
                 *
                 * pageSetUp() is needed whenever you load a page.
                 * It initializes and checks for all basic elements of the page
                 * and makes rendering easier.
                 *
                 */

                pageSetUp();

                /*
                 * ALL PAGE RELATED SCRIPTS CAN GO BELOW HERE
                 * eg alert("my home function");
                 *
                 * var pagefunction = function() {
                 *   ...
                 * }
                 * loadScript("js/plugin/_PLUGIN_NAME_.js", pagefunction);
                 *
                 * TO LOAD A SCRIPT:
                 * var pagefunction = function (){
                 *  loadScript(".../plugin.js", run_after_loaded);
                 * }
                 *
                 * OR
                 *
                 * loadScript(".../plugin.js", run_after_loaded);
                 */

                /* Formatting function for row details - modify as you need */
                function format ( d ) {
                    // `d` is the original data object for the row
                    return '<table cellpadding="5" cellspacing="0" border="0" class="table table-hover table-condensed">'+
                        '<tr>'+
                        '<td style="width:100px">Project Title:</td>'+
                        '<td>'+d.name+'</td>'+
                        '</tr>'+
                        '<tr>'+
                        '<td>Deadline:</td>'+
                        '<td>'+d.ends+'</td>'+
                        '</tr>'+
                        '<tr>'+
                        '<td>Extra info:</td>'+
                        '<td>And any further details here (images etc)...</td>'+
                        '</tr>'+
                        '<tr>'+
                        '<td>Comments:</td>'+
                        '<td>'+d.comments+'</td>'+
                        '</tr>'+
                        '<tr>'+
                        '<td>Action:</td>'+
                        '<td>'+d.action+'</td>'+
                        '</tr>'+
                        '</table>';
                }

                // clears the variable if left blank
                var table = $('#example').DataTable( {
                    "ajax": "/public/pandora/data/dataList.json",
                    "bDestroy": true,
                    "iDisplayLength": 15,
                    "columns": [
                        {
                            "class":          'details-control',
                            "orderable":      false,
                            "data":           null,
                            "defaultContent": ''
                        },
                        { "data": "name" },
                        { "data": "est" },
                        { "data": "contacts" },
                        { "data": "status" },
                        { "data": "target-actual" },
                        { "data": "starts" },
                        { "data": "ends" },
                        { "data": "tracker" },
                    ],
                    "order": [[1, 'asc']],
                    "fnDrawCallback": function( oSettings ) {
                        runAllCharts()
                    }
                } );



                // Add event listener for opening and closing details
                $('#example tbody').on('click', 'td.details-control', function () {
                    var tr = $(this).closest('tr');
                    var row = table.row( tr );

                    if ( row.child.isShown() ) {
                        // This row is already open - close it
                        row.child.hide();
                        tr.removeClass('shown');
                    }
                    else {
                        // Open this row
                        row.child( format(row.data()) ).show();
                        tr.addClass('shown');
                    }
                });

            })

        </script>
    <?php break; ?>

<?php case 'blog': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            $(document).ready(function() {

                /* DO NOT REMOVE : GLOBAL FUNCTIONS!
                 *
                 * pageSetUp(); WILL CALL THE FOLLOWING FUNCTIONS
                 *
                 * // activate tooltips
                 * $("[rel=tooltip]").tooltip();
                 *
                 * // activate popovers
                 * $("[rel=popover]").popover();
                 *
                 * // activate popovers with hover states
                 * $("[rel=popover-hover]").popover({ trigger: "hover" });
                 *
                 * // activate inline charts
                 * runAllCharts();
                 *
                 * // setup widgets
                 * setup_widgets_desktop();
                 *
                 * // run form elements
                 * runAllForms();
                 *
                 ********************************
                 *
                 * pageSetUp() is needed whenever you load a page.
                 * It initializes and checks for all basic elements of the page
                 * and makes rendering easier.
                 *
                 */

                pageSetUp();

                /*
                 * ALL PAGE RELATED SCRIPTS CAN GO BELOW HERE
                 * eg alert("my home function");
                 *
                 * var pagefunction = function() {
                 *   ...
                 * }
                 * loadScript("js/plugin/_PLUGIN_NAME_.js", pagefunction);
                 *
                 * TO LOAD A SCRIPT:
                 * var pagefunction = function (){
                 *  loadScript(".../plugin.js", run_after_loaded);
                 * }
                 *
                 * OR
                 *
                 * loadScript(".../plugin.js", run_after_loaded);
                 */

            })

        </script>
    <?php break; ?>

<?php case 'gallery': ?>
		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/superbox/superbox.min.js"></script>


		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                $('.superbox').SuperBox();

            })

        </script>
    <?php break; ?>

<?php case 'forum': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            $(document).ready(function() {

                /* DO NOT REMOVE : GLOBAL FUNCTIONS!
                 *
                 * pageSetUp(); WILL CALL THE FOLLOWING FUNCTIONS
                 *
                 * // activate tooltips
                 * $("[rel=tooltip]").tooltip();
                 *
                 * // activate popovers
                 * $("[rel=popover]").popover();
                 *
                 * // activate popovers with hover states
                 * $("[rel=popover-hover]").popover({ trigger: "hover" });
                 *
                 * // activate inline charts
                 * runAllCharts();
                 *
                 * // setup widgets
                 * setup_widgets_desktop();
                 *
                 * // run form elements
                 * runAllForms();
                 *
                 ********************************
                 *
                 * pageSetUp() is needed whenever you load a page.
                 * It initializes and checks for all basic elements of the page
                 * and makes rendering easier.
                 *
                 */

                pageSetUp();

                /*
                 * ALL PAGE RELATED SCRIPTS CAN GO BELOW HERE
                 * eg alert("my home function");
                 *
                 * var pagefunction = function() {
                 *   ...
                 * }
                 * loadScript("js/plugin/_PLUGIN_NAME_.js", pagefunction);
                 *
                 * TO LOAD A SCRIPT:
                 * var pagefunction = function (){
                 *  loadScript(".../plugin.js", run_after_loaded);
                 * }
                 *
                 * OR
                 *
                 * loadScript(".../plugin.js", run_after_loaded);
                 */

            })

        </script>
    <?php break; ?>

<?php case 'forumtopic': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'forumpost': ?>
		<!-- PAGE RELATED PLUGIN(S)-->
		<script src="/public/pandora/js/plugin/summernote/summernote.min.js"></script>

		<script type="text/javascript">
            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                $('#forumPost').summernote({
                    height : 180,
                    focus : false,
                    tabsize : 2
                });

            })

        </script>
    <?php break; ?>

<?php case 'profile': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'timeline': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'gmapxml': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

                var pagefunction = function() {

                    /*jslint smarttabs:true */
                    var colorful_style = [{

                        "featureType" : "landscape",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "transit",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#d3d3d3"
                        }, {
                            "visibility" : "on"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#b1bc39"
                        }]
                    }, {
                        "featureType" : "landscape.man_made",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#ebad02"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#416d9f"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#000000"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }, {
                            "color" : "#ffffff"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#000000"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#ffffff"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.icon",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#ebad02"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#8ca83c"
                        }]
                    }];

                    // Grey Scale
                    var greyscale_style = [{
                        "featureType" : "road.highway",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "transit",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "stylers" : [{
                            "visibility" : "on"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#d3d3d3"
                        }, {
                            "visibility" : "on"
                        }]
                    }, {
                        "featureType" : "poi.medical",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.medical",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "color" : "#cccccc"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#cecece"
                        }]
                    }, {
                        "featureType" : "road.local",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#808080"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#808080"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#fdfdfd"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.icon",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#d2d2d2"
                        }]
                    }];

                    // Black & White
                    var monochrome_style = [{
                        "featureType" : "road.highway",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "transit",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#d3d3d3"
                        }, {
                            "visibility" : "on"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#ffffff"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#cecece"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#000000"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#ffffff"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#000000"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#000000"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.icon",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }];

                    // Retro
                    var metro_style = [{
                        "featureType" : "transit",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#d3d3d3"
                        }, {
                            "visibility" : "on"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#eee8ce"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#b8cec9"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#000000"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }, {
                            "color" : "#ffffff"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#000000"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#ffffff"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.icon",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#d3cdab"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#ced09d"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }];

                    // Night
                    var nightvision_style = [{
                        "featureType" : "landscape",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "transit",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#d3d3d3"
                        }, {
                            "visibility" : "on"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "hue" : "#0008ff"
                        }, {
                            "lightness" : -75
                        }, {
                            "saturation" : 10
                        }]
                    }, {
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "color" : "#1f1d45"
                        }]
                    }, {
                        "featureType" : "landscape.natural",
                        "stylers" : [{
                            "color" : "#1f1d45"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#01001f"
                        }]
                    }, {
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#e7e8ec"
                        }]
                    }, {
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#151348"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#f7fdd9"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#01001f"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#316694"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.icon",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#1a153d"
                        }]

                    }];

                    // Night Light
                    var nightvision_highlight_style = [{
                        "elementType" : "geometry",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "hue" : "#232a57"
                        }]
                    }, {
                        "featureType" : "road.highway",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "hue" : "#0033ff"
                        }, {
                            "saturation" : 13
                        }, {
                            "lightness" : -77
                        }]
                    }, {
                        "featureType" : "landscape",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "color" : "#4657ab"
                        }]
                    }, {
                        "featureType" : "transit",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#0d0a1f"
                        }]
                    }, {
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#d2cfe3"
                        }]
                    }, {
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#0d0a1f"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#ffffff"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#0d0a1f"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#ff9910"
                        }]
                    }, {
                        "featureType" : "road.local",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#4657ab"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.icon",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#232a57"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#232a57"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }];

                    // Papiro
                    var old_paper_style = [{
                        "elementType" : "geometry",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#f2e48c"
                        }]
                    }, {
                        "featureType" : "road.highway",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "transit",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi.park",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "color" : "#d3d3d3"
                        }, {
                            "visibility" : "on"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#f2e48c"
                        }]
                    }, {
                        "featureType" : "landscape",
                        "elementType" : "geometry.stroke",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#592c00"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#a77637"
                        }]
                    }, {
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#592c00"
                        }]
                    }, {
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#f2e48c"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#592c00"
                        }]
                    }, {
                        "featureType" : "administrative",
                        "elementType" : "labels.text.stroke",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#f2e48c"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#a5630f"
                        }]
                    }, {
                        "featureType" : "road.highway",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "on"
                        }, {
                            "color" : "#592c00"
                        }]
                    }, {
                        "featureType" : "road",
                        "elementType" : "labels.icon",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "water",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "geometry.fill",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }, {
                        "featureType" : "poi",
                        "elementType" : "labels",
                        "stylers" : [{
                            "visibility" : "off"
                        }]
                    }];

                    // One color - Change the hue value for your desired color
                    var mono_color_style = [{
                        "stylers" : [{
                            "hue" : "#ff00aa"
                        }, {
                            "saturation" : 1
                        }, {
                            "lightness" : 1
                        }]
                    }];

                    /*
                     * Google Maps Initialize
                     */



                    $this = $("#map_canvas");
                    $zoom_level = ($this.data("gmap-zoom") || 5);
                    $data_lat = ($this.data("gmap-lat") || 29.895883);
                    $data_lng = ($this.data("gmap-lng") || -80.650635);
                    $xml_src = ($this.data("gmap-src") || "xml/gmap/pins.xml");

                    var greyStyleMap = new google.maps.StyledMapType(greyscale_style, {
                            name: "Greyscale"
                        }),
                        monoChromeStyleMap = new google.maps.StyledMapType(monochrome_style, {
                            name: "Mono Chrome"
                        }),
                        metroStyleMap = new google.maps.StyledMapType(metro_style, {
                            name: "Metro"
                        }),
                        nightvisionStyleMap = new google.maps.StyledMapType(nightvision_style, {
                            name: "Nightvision"
                        }),
                        nvisionhstyleMap = new google.maps.StyledMapType(nightvision_highlight_style, {
                            name: "Nightvision Light"
                        }),
                        oPaperStyleMap = new google.maps.StyledMapType(old_paper_style, {
                            name: "Old Paper"
                        }),
                        colorfulStyleMap = new google.maps.StyledMapType(colorful_style, {
                            name: "Colorful"
                        }),
                        monoColorStyleMap = new google.maps.StyledMapType(mono_color_style, {
                            name: "One Color"
                        });

                    function demoLoadAttribute() {

                        var centerLatLng = new google.maps.LatLng($data_lat, $data_lng),
                            mapOptions = {
                                zoom: $zoom_level,
                                center: centerLatLng,
                                //disableDefaultUI: true,
                                //mapTypeId : google.maps.MapTypeId.ROADMAP
                                mapTypeControlOptions: {
                                    mapTypeIds: [google.maps.MapTypeId.TERRAIN, 'colorful_style', 'greyscale_style',
                                        'monochrome_style', 'metro_style', 'nightvision_style', 'nightvision_highlight_style',
                                        'old_paper_style', 'mono_color_style'
                                    ]
                                }
                            },

                            bounds = new google.maps.LatLngBounds(),
                            infowindow = new google.maps.InfoWindow(),
                            map = new google.maps.Map(document.getElementById("map_canvas"), mapOptions);

                        map.mapTypes.set('colorful_style', colorfulStyleMap);
                        map.mapTypes.set('greyscale_style', greyStyleMap);
                        map.mapTypes.set('monochrome_style', monoChromeStyleMap);
                        map.mapTypes.set('metro_style', metroStyleMap);
                        map.mapTypes.set('nightvision_style', nightvisionStyleMap);
                        map.mapTypes.set('nightvision_highlight_style', nvisionhstyleMap);
                        map.mapTypes.set('old_paper_style', oPaperStyleMap);
                        map.mapTypes.set('mono_color_style', monoColorStyleMap);

                        //map.setMapTypeId(google.maps.MapTypeId.TERRAIN);
                        map.setMapTypeId('metro_style');

                    } // end demoLoadAttribute

                    // grey
                    function generate_map_1() {

                        var mapOptions = {
                            center: new google.maps.LatLng(41.38155, 2.13752),
                            zoom: 12,
                        };
                        map = new google.maps.Map(document.getElementById('map_canvas1'), mapOptions);

                        // Setup skin for the map
                        map.mapTypes.set('greyscale_style', greyStyleMap);
                        map.setMapTypeId('greyscale_style');

                    }

                    // colorful
                    function generate_map_2() {

                        var mapOptions = {
                            center: new google.maps.LatLng(41.38155, 2.13752),
                            zoom: 12,
                        };
                        map = new google.maps.Map(document.getElementById('map_canvas2'), mapOptions);

                        // Setup skin for the map
                        map.mapTypes.set('colorful_style', colorfulStyleMap);
                        map.setMapTypeId('colorful_style');

                    }

                    // colorful
                    function generate_map_3() {

                        var mapOptions = {
                            center: new google.maps.LatLng(41.38155, 2.13752),
                            zoom: 12,
                        };
                        map = new google.maps.Map(document.getElementById('map_canvas3'), mapOptions);

                        // Setup skin for the map
                        map.mapTypes.set('nightvision_style', nvisionhstyleMap);
                        map.setMapTypeId('nightvision_style');

                    }

                    // Night Light
                    function generate_map_4() {

                        var mapOptions = {
                            center: new google.maps.LatLng(41.38155, 2.13752),
                            zoom: 12,
                        };
                        map = new google.maps.Map(document.getElementById('map_canvas4'), mapOptions);

                        // Setup skin for the map
                        map.mapTypes.set('nightvision_highlight_style', nvisionhstyleMap);
                        map.setMapTypeId('nightvision_highlight_style');

                    }

                    // Paper Style
                    function generate_map_5() {

                        var mapOptions = {
                            center: new google.maps.LatLng(41.38155, 2.13752),
                            zoom: 12,
                        };
                        map = new google.maps.Map(document.getElementById('map_canvas5'), mapOptions);

                        // Setup skin for the map
                        map.mapTypes.set('old_paper_style', oPaperStyleMap);
                        map.setMapTypeId('old_paper_style');

                    }

                    // One Color Style
                    function generate_map_6() {

                        var mapOptions = {
                            center: new google.maps.LatLng(41.38155, 2.13752),
                            zoom: 12,
                        };
                        map = new google.maps.Map(document.getElementById('map_canvas6'), mapOptions);

                        // Setup skin for the map
                        map.mapTypes.set('mono_color_style', monoColorStyleMap);
                        map.setMapTypeId('mono_color_style');

                    }

                    // Monochrome Style
                    function generate_map_8() {

                        var mapOptions = {
                            center: new google.maps.LatLng(41.38155, 2.13752),
                            zoom: 12,
                        };
                        map = new google.maps.Map(document.getElementById('map_canvas8'), mapOptions);

                        // Setup skin for the map
                        map.mapTypes.set('monochrome_style', monoChromeStyleMap);
                        map.setMapTypeId('monochrome_style');

                    }

                    // Metro Style
                    function generate_map_7() {

                        var mapOptions = {
                            center: new google.maps.LatLng(41.38155, 2.13752),
                            zoom: 12,
                        };
                        map = new google.maps.Map(document.getElementById('map_canvas7'), mapOptions);

                        // Setup skin for the map
                        map.mapTypes.set('metro_style', metroStyleMap);
                        map.setMapTypeId('metro_style');

                    }

                    demoLoadAttribute();
                    generate_map_1();
                    generate_map_2();
                    generate_map_3();
                    generate_map_4();
                    generate_map_5();
                    generate_map_6();
                    generate_map_7();
                    generate_map_8();


                };

                $(window).unbind('gMapsLoaded');
                $(window).bind('gMapsLoaded', pagefunction);
                window.loadGoogleMaps();
            })

        </script>
    <?php break; ?>

<?php case 'pricingtable': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'invoice': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'error500': ?>
		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                $("#search-error").focus();

            })

        </script>
    <?php break; ?>

<?php case 'blank': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            $(document).ready(function() {

                /* DO NOT REMOVE : GLOBAL FUNCTIONS!
                 *
                 * pageSetUp(); WILL CALL THE FOLLOWING FUNCTIONS
                 *
                 * // activate tooltips
                 * $("[rel=tooltip]").tooltip();
                 *
                 * // activate popovers
                 * $("[rel=popover]").popover();
                 *
                 * // activate popovers with hover states
                 * $("[rel=popover-hover]").popover({ trigger: "hover" });
                 *
                 * // activate inline charts
                 * runAllCharts();
                 *
                 * // setup widgets
                 * setup_widgets_desktop();
                 *
                 * // run form elements
                 * runAllForms();
                 *
                 ********************************
                 *
                 * pageSetUp() is needed whenever you load a page.
                 * It initializes and checks for all basic elements of the page
                 * and makes rendering easier.
                 *
                 */

                pageSetUp();

                /*
                 * ALL PAGE RELATED SCRIPTS CAN GO BELOW HERE
                 * eg alert("my home function");
                 *
                 * var pagefunction = function() {
                 *   ...
                 * }
                 * loadScript("js/plugin/_PLUGIN_NAME_.js", pagefunction);
                 *
                 * TO LOAD A SCRIPT:
                 * var pagefunction = function (){
                 *  loadScript(".../plugin.js", run_after_loaded);
                 * }
                 *
                 * OR
                 *
                 * loadScript(".../plugin.js", run_after_loaded);
                 */

            })

        </script>
    <?php break; ?>

<?php case 'emailtemplate': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->



		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                pageSetUp();

            })

        </script>
    <?php break; ?>

<?php case 'search': ?>
    		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                $("#search-project").focus();

            })

        </script>
    <?php break; ?>

<?php case 'ckeditor': ?>
		<!-- PAGE RELATED PLUGIN(S) -->
		<script src="/public/pandora/js/plugin/ckeditor/ckeditor.js"></script>



		<script type="text/javascript">

            // DO NOT REMOVE : GLOBAL FUNCTIONS!

            $(document).ready(function() {

                CKEDITOR.replace( 'ckeditor', { height: '380px', startupFocus : true} );

            })

        </script>
    <?php break; ?>

<?php case 'difver': ?>
		<!-- PAGE RELATED PLUGIN(S)
		<script src="..."></script>-->

		<script type="text/javascript">

            $(document).ready(function() {

                /* DO NOT REMOVE : GLOBAL FUNCTIONS!
                 *
                 * pageSetUp(); WILL CALL THE FOLLOWING FUNCTIONS
                 *
                 * // activate tooltips
                 * $("[rel=tooltip]").tooltip();
                 *
                 * // activate popovers
                 * $("[rel=popover]").popover();
                 *
                 * // activate popovers with hover states
                 * $("[rel=popover-hover]").popover({ trigger: "hover" });
                 *
                 * // activate inline charts
                 * runAllCharts();
                 *
                 * // setup widgets
                 * setup_widgets_desktop();
                 *
                 * // run form elements
                 * runAllForms();
                 *
                 ********************************
                 *
                 * pageSetUp() is needed whenever you load a page.
                 * It initializes and checks for all basic elements of the page
                 * and makes rendering easier.
                 *
                 */

                pageSetUp();

                /*
                 * ALL PAGE RELATED SCRIPTS CAN GO BELOW HERE
                 * eg alert("my home function");
                 *
                 * var pagefunction = function() {
                 *   ...
                 * }
                 * loadScript("js/plugin/_PLUGIN_NAME_.js", pagefunction);
                 *
                 * TO LOAD A SCRIPT:
                 * var pagefunction = function (){
                 *  loadScript(".../plugin.js", run_after_loaded);
                 * }
                 *
                 * OR
                 *
                 * loadScript(".../plugin.js", run_after_loaded);
                 */

            })

        </script>
    <?php break; ?>

<?php case 'chat': ?>
<script type="text/javascript">

    /* DO NOT REMOVE : GLOBAL FUNCTIONS!
     *
     * pageSetUp(); WILL CALL THE FOLLOWING FUNCTIONS
     *
     * // activate tooltips
     * $("[rel=tooltip]").tooltip();
     *
     * // activate popovers
     * $("[rel=popover]").popover();
     *
     * // activate popovers with hover states
     * $("[rel=popover-hover]").popover({ trigger: "hover" });
     *
     * // activate inline charts
     * runAllCharts();
     *
     * // setup widgets
     * setup_widgets_desktop();
     *
     * // run form elements
     * runAllForms();
     *
     ********************************
     *
     * pageSetUp() is needed whenever you load a page.
     * It initializes and checks for all basic elements of the page
     * and makes rendering easier.
     *
     */

    pageSetUp();

    /*
     * ALL PAGE RELATED SCRIPTS CAN GO BELOW HERE
     * eg alert("my home function");
     *
     * var pagefunction = function() {
     *   ...
     * }
     * loadScript("js/plugin/_PLUGIN_NAME_.js", pagefunction);
     *
     * TO LOAD A SCRIPT:
     * var pagefunction = function (){
     *  loadScript(".../plugin.js", run_after_loaded);
     * }
     *
     * OR you can load chain scripts by doing
     *
     * loadScript(".../plugin.js", function(){
     * 	 loadScript("../plugin.js", function(){
     * 	   ...
     *   })
     * });
     */

    // pagefunction

    var pagefunction = null;

    // run pagefunction




</script>
    <?php break; ?>

<?php default: ?>
    <!-- script link -->
<?php endswitch; ?>