<?php

Route::group(
    [
        'prefix' => env('ADMIN_PATH', '/admin/'),
        'middleware' => [
            \TechSoft\Laravel\Admin\Middleware\AdminAuthMiddleware::class,
        ]
    ], function () {

        include __DIR__ . '/../../vendor/tech-soft/laravel/src/Admin/Routes/routes.php';
    Route::match(['get', 'post'], '', '\App\Admin\Controller\IndexController@index');

    Route::match(['get', 'post'], 'config/setting', '\App\Admin\Controller\ConfigController@setting');
    Route::match(['get', 'post'], 'config/visit', '\App\Admin\Controller\ConfigController@visit');

    Route::match(['get', 'post'], 'article_category/list', '\App\Admin\Controller\ArticleCategoryController@dataList');
    Route::match(['get', 'post'], 'article_category/add', '\App\Admin\Controller\ArticleCategoryController@dataAdd');
    Route::match(['get', 'post'], 'article_category/edit', '\App\Admin\Controller\ArticleCategoryController@dataEdit');
    Route::match(['get', 'post'], 'article_category/delete', '\App\Admin\Controller\ArticleCategoryController@dataDelete');
    Route::match(['get', 'post'], 'article_category/view', '\App\Admin\Controller\ArticleCategoryController@dataView');
    Route::match(['get', 'post'], 'article_category/sort', '\App\Admin\Controller\ArticleCategoryController@dataSort');

    Route::match(['get', 'post'], 'article/list', '\App\Admin\Controller\ArticleController@dataList');
    Route::match(['get', 'post'], 'article/add', '\App\Admin\Controller\ArticleController@dataAdd');
    Route::match(['get', 'post'], 'article/edit', '\App\Admin\Controller\ArticleController@dataEdit');
    Route::match(['get', 'post'], 'article/delete', '\App\Admin\Controller\ArticleController@dataDelete');
    Route::match(['get', 'post'], 'article/view', '\App\Admin\Controller\ArticleController@dataView');

    Route::match(['get', 'post'], 'post/list', '\App\Admin\Controller\PostController@dataList');
    Route::match(['get', 'post'], 'post/add', '\App\Admin\Controller\PostController@dataAdd');
    Route::match(['get', 'post'], 'post/edit', '\App\Admin\Controller\PostController@dataEdit');
    Route::match(['get', 'post'], 'post/delete', '\App\Admin\Controller\PostController@dataDelete');
    Route::match(['get', 'post'], 'post/view', '\App\Admin\Controller\PostController@dataView');

    Route::match(['get', 'post'], 'nav/list', '\App\Admin\Controller\NavController@dataList');
    Route::match(['get', 'post'], 'nav/add', '\App\Admin\Controller\NavController@dataAdd');
    Route::match(['get', 'post'], 'nav/edit', '\App\Admin\Controller\NavController@dataEdit');
    Route::match(['get', 'post'], 'nav/delete', '\App\Admin\Controller\NavController@dataDelete');
    Route::match(['get', 'post'], 'nav/view', '\App\Admin\Controller\NavController@dataView');
    Route::match(['get', 'post'], 'nav/sort', '\App\Admin\Controller\NavController@dataSort');

    Route::match(['get', 'post'], 'quick_nav/list', '\App\Admin\Controller\QuickNavController@dataList');
    Route::match(['get', 'post'], 'quick_nav/add', '\App\Admin\Controller\QuickNavController@dataAdd');
    Route::match(['get', 'post'], 'quick_nav/edit', '\App\Admin\Controller\QuickNavController@dataEdit');
    Route::match(['get', 'post'], 'quick_nav/delete', '\App\Admin\Controller\QuickNavController@dataDelete');
    Route::match(['get', 'post'], 'quick_nav/view', '\App\Admin\Controller\QuickNavController@dataView');
    Route::match(['get', 'post'], 'quick_nav/sort', '\App\Admin\Controller\QuickNavController@dataSort');


});
