<?php

namespace App\Util;


use EdwinFound\Laravel\Cache\CacheUtil;
use EdwinFound\Laravel\Dao\ModelUtil;
use EdwinFound\Laravel\Util\TreeUtil;

class NavUtil
{
    public static function clearCache()
    {
        CacheUtil::forget('nav');
    }

    public static function all()
    {
        return CacheUtil::remember('nav', 3600, function () {
            return TreeUtil::model2Nodes('nav', ['name', 'link']);
        });
    }
}