<?php

namespace App\Util;


use EdwinFound\Laravel\Cache\CacheUtil;
use EdwinFound\Laravel\Util\TreeUtil;

class QuickNavUtil
{
    public static function clearCache()
    {
        CacheUtil::forget('quickNav');
    }

    public static function all()
    {
        return CacheUtil::remember('quickNav', 3600, function () {
            return TreeUtil::model2Nodes('quick_nav', ['name', 'summary', 'image', 'link']);
        });
    }
}