<?php

namespace App\Web\Controller;


use App\Util\ArticleCategoryUtil;
use App\Util\ArticleUtil;
use EdwinFound\Laravel\Dao\ModelUtil;
use EdwinFound\Laravel\Http\Response;
use EdwinFound\Laravel\Util\TreeUtil;

class ArticleController extends BaseController
{
    public function view($id)
    {
        $article = ArticleUtil::get($id);
        if (empty($article)) {
            return Response::send(-1, '记录不存在');
        }
        $all = $articleCategory = ArticleCategoryUtil::all();
        $chain = TreeUtil::chain($all, $article['categoryId']);
        if (empty($chain)) {
            return Response::send(-1, '请求出现错误');
        }
        $category = ArticleCategoryUtil::get($article['categoryId']);
        if (empty($chain)) {
            return Response::send(-1, '数据错误');
        }
        $dataView = [];
        $dataView['article'] = $article;
        $dataView['category'] = $category;
        $dataView['chain'] = $chain;
        return $this->_view('articleView', $dataView);
    }

    public function lists($categoryId)
    {
        $all = $articleCategory = ArticleCategoryUtil::all();
        $chain = TreeUtil::chain($all, $categoryId);
        if (empty($chain)) {
            return Response::send(-1, '请求出现错误');
        }
        $category = ArticleCategoryUtil::get($categoryId);
        if (empty($chain)) {
            return Response::send(-1, '数据错误');
        }
        $articles = ArticleUtil::listByCategory($categoryId);
        $dataView = [];
        $dataView['categoryId'] = $categoryId;
        $dataView['category'] = $category;
        $dataView['chain'] = $chain;
        $dataView['articles'] = $articles;
        return $this->_view('articleList', $dataView);
    }
}
