<?php

namespace App\Web\Controller;


use App\Util\ArticleCategoryUtil;
use EdwinFound\Laravel\Dao\ModelUtil;
use EdwinFound\Laravel\Http\InputPackage;
use EdwinFound\Utils\PageHtmlUtil;

class SearchController extends BaseController
{
    public function index()
    {
        $input = InputPackage::buildFromInput();
        $keyword = $input->getTrimString('keyword');

        $page = $input->getInteger('page', 1);
        $pageSize = 10;

        $option = [];
        $option['where'] = [];
        $option['whereOperate'] = ['title', 'like', '%' . $keyword . '%'];
        $option['order'] = [];
        $paginateData = ModelUtil::paginate('article', $page, $pageSize, $option);
        foreach ($paginateData['records'] as $i => $record) {
            $paginateData['records'][$i]['_category'] = ArticleCategoryUtil::get($record['categoryId']);
        }
        $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '/search?keyword=' . urlencode($keyword) . '&page={page}');
        $viewData = [];
        $viewData['pageHtml'] = $pageHtml;
        $viewData['keyword'] = $keyword;
        $viewData['records'] = $paginateData['records'];
        $viewData['total'] = $paginateData['total'];
        return $this->_view('search', $viewData);
    }
}
