<?php

namespace TechSoft\Laravel\Admin\Controller;

use EdwinFound\Laravel\Http\InputPackage;
use EdwinFound\Laravel\Http\Response;
use EdwinFound\Utils\StrUtil;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;
use Mews\Captcha\Facades\Captcha;
use TechSoft\Laravel\Admin\Support\AdminAwareController;
use TechSoft\Laravel\Admin\Util\AdminUtil;
use TechSoft\Laravel\Config\ConfigUtil;

class LoginController extends AdminAwareController
{

    public function logout()
    {
        Session::flush();
        if (ConfigUtil::get('adminSSOClientEnable', false)) {
            if (Input::get('server', '') != 'true') {
                $ssoServer = ConfigUtil::get('adminSSOServer', '');
                if (empty($ssoServer)) {
                    return Response::send(-1, '请配置 同步登录服务端地址');
                }
                $clientRedirect = Input::get('redirect', '/');
                $clientLogout = \EdwinFound\Laravel\Http\Request::domainUrl() . '/logout?server=true&redirect=' . urlencode($clientRedirect);
                $ssoServerLogout = $ssoServer . '_logout?redirect=' . urlencode($clientLogout);
                return Response::send(0, null, null, $ssoServerLogout);
            }
        }
        return Response::send(0, null, null, env('ADMIN_PATH', '/'));
    }

    public function index()
    {
        $redirect = Input::get('redirect', env('ADMIN_PATH', '/admin/'));

        if ($this->adminUserId()) {
            return Response::send(0, '您已经登录', null, $redirect);
        }

        if (ConfigUtil::get('adminSSOClientEnable', false)) {
            return Response::send(0, null, null, env('ADMIN_PATH', '/admin/') . 'sso/client?redirect=' . urlencode($redirect));
        }

        if (Request::isMethod('post')) {

            $input = InputPackage::buildFromInput();

            $username = $input->getTrimString('username');
            $password = $input->getTrimString('password');

            if (empty($username)) {
                return Response::send(-1, '用户名为空');
            }
            if (empty($password)) {
                return Response::send(-2, '密码为空');
            }

            if (config('admin.login.captcha')) {
                if (!Captcha::check($input->getTrimString('captcha'))) {
                    return Response::send(-1, '图片验证码错误', null, '[js]$(\'[data-captcha]\').click();');
                }
            }

            $ret = AdminUtil::login($username, $password);
            if ($ret['code']) {
                AdminUtil::addErrorLog(0, '登录错误', [
                    'IP' => Request::ip(),
                    '用户名' => $username,
                    '密码' => StrUtil::mask($password),
                ]);
                return Response::send(-1, '用户或密码错误:' . $ret['code'], null, '[js]$(\'[data-captcha]\').click();');
            }

            $user = $ret['data'];
            Session::put('_adminUserId', $user['id']);

            AdminUtil::addInfoLog($user['id'], '登录成功', [
                'IP' => Request::ip(),
            ]);

            $redirect = Input::get('redirect', env('ADMIN_PATH', '/admin/'));
            return Response::send(0, null, null, $redirect);
        }
        if (view()->exists('admin.login')) {
            return view('admin.login');
        }
        return view('admin::login');
    }

    public function captcha()
    {
        return Captcha::create('default');
    }

}
