<?php
 namespace App\Modules\PrizePool\Mobile; use App\Constant\PayConstant; use App\Modules\Base\BaseMobileController; use App\Modules\Base\UserBaseTrait; use App\Modules\PrizePool\ActivityType; use App\Modules\PrizePool\DrawnPhysicalStatus; use App\Modules\PrizePool\PrizePoolPayDrawStatus; use App\Util\PlatformService; use App\Util\PlatformUtil; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Laravel\Type\TypeUtil; use TechOnline\Utils\StrUtil; use TechSoft\Laravel\Pay\Types\PayType; use TechSoft\Laravel\User\UserLoginCheck; class HomeController extends BaseMobileController implements UserLoginCheck { use UserBaseTrait; const MODULE = 'prizePool'; public static function owner() { $alias = Request::route('alias'); if (empty($alias)) { return 0; } $memberUser = ModelUtil::getWithCache('member_user', ['alias' => $alias]); if (empty($memberUser)) { return 0; } return $memberUser['id']; } public function payDraw($alias, $activityType, $activityAlias) { $activityName = TypeUtil::name(ActivityType::class, $activityType); if (empty($activityName)) { return Response::send(-1, '请求错误'); } $table = 'module_' . StrUtil::uncamelize($activityType) . '_activity'; $activity = ModelUtil::get($table, ['alias' => $activityAlias]); if (empty($activity)) { return Response::send(-1, '活动不存在'); } if (!$activity['payDrawEnable']) { return Response::send(-1, '不需要付费'); } if ($activity['payDrawMoney'] < 1.00) { return Response::send(-1, '付费金额不能小于1元'); } $payDraw = ModelUtil::insert('module_prize_pool_pay_draw', [ 'memberUserId' => $activity['memberUserId'], 'userId' => $this->userId(), 'activityType' => $activityType, 'activityId' => $activity['id'], 'status' => PrizePoolPayDrawStatus::WAIT_PAY, 'money' => $activity['payDrawMoney'], ]); $ret = PlatformUtil::createOrder( $activity['memberUserId'], $this->userId(), PayConstant::BIZ_POOL_PRIZE_PAY_DRAW, $payDraw['id'], PayType::WECHAT_MOBILE, $activity['payDrawMoney'], 'PrizePool-PayDraw-' . $activityType, 'PrizePool-PayDraw-' . $activityType, '/m/' . StrUtil::uncamelize($activityType) . '_' . $activityAlias . '?_t' . time() ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['json'] = $ret['data']['json']; $data['successRedirect'] = $ret['data']['successRedirect']; return Response::send(0, null, $data); } public function activity($alias, $activityType, $activityAlias) { $activityName = TypeUtil::name(ActivityType::class, $activityType); if (empty($activityName)) { return Response::send(-1, '请求错误'); } $table = 'module_' . StrUtil::uncamelize($activityType) . '_activity'; $activity = ModelUtil::get($table, ['alias' => $activityAlias]); if (empty($activity)) { return Response::send(-1, '活动不存在'); } if (Request::isPost()) { $input = InputPackage::buildFromInput(); $page = $input->getInteger('page', 1); $type = $input->getInteger('type'); $pageSize = 10; $option = []; $option['where'] = [ 'userId' => $this->userId(), 'activityType' => $activityType, 'activityId' => $activity['id'], ]; if ($type == 1) { $option['whereIn'] = ['physicalStatus', [ DrawnPhysicalStatus::DRAWN ]]; } else if ($type == 2) { $option['whereIn'] = ['physicalStatus', [ DrawnPhysicalStatus::WAIT_SHIPPING, DrawnPhysicalStatus::CHECKED, DrawnPhysicalStatus::SHIPPED ] ]; } $option['order'] = ['id', 'desc']; $paginateData = ModelUtil::paginate('module_prize_pool_drawn', $page, $pageSize, $option); if (empty($paginateData['records'])) { return Response::send(0, null, ['html' => null]); } $html = $this->_viewRender('prizeItems', [ 'records' => $paginateData['records'], ]); return Response::send(0, null, ['html' => $html]); } return $this->_view('activity'); } public function users($alias, $activityType, $activityAlias) { $activityName = TypeUtil::name(ActivityType::class, $activityType); if (empty($activityName)) { return Response::send(-1, '请求错误'); } $table = 'module_' . StrUtil::uncamelize($activityType) . '_activity'; $activity = ModelUtil::get($table, ['alias' => $activityAlias]); if (empty($activity)) { return Response::send(-1, '活动不存在'); } if (Request::isPost()) { $page = InputPackage::buildFromInput()->getInteger('page', 1); $pageSize = 10; $option = []; $option['where'] = [ 'activityType' => $activityType, 'activityId' => $activity['id'], ]; $option['order'] = ['id', 'desc']; $paginateData = ModelUtil::paginate('module_prize_pool_drawn', $page, $pageSize, $option); if (empty($paginateData['records'])) { return Response::send(0, null, ['html' => null]); } ModelUtil::join($paginateData['records'], 'userId', '_user', 'member_user', 'id'); $html = $this->_viewRender('userItems', [ 'records' => $paginateData['records'], ]); return Response::send(0, null, ['html' => $html]); } return $this->_view('users'); } public function fill($alias, $drawnId) { $drawn = ModelUtil::get('module_prize_pool_drawn', [ 'id' => $drawnId, 'userId' => $this->userId(), 'memberUserId' => $this->memberUserId, ]); if (empty($drawn)) { return Response::send(-1, '记录不存在'); } if ($drawn['physicalStatus'] != DrawnPhysicalStatus::DRAWN) { return Response::send(-1, '状态不正确'); } if (Request::isPost()) { $input = InputPackage::buildFromInput(); $update = []; $update['userName'] = $input->getTrimString('userName'); $update['userPhone'] = $input->getPhone('userPhone'); $update['userAddress'] = $input->getTrimString('userAddress'); if (empty($update['userName'])) { return Response::send(-1, '姓名为空'); } if (empty($update['userPhone'])) { return Response::send(-1, '手机为空 或 格式不正确'); } if (empty($update['userAddress'])) { return Response::send(-1, '地址为空'); } $update['physicalStatus'] = DrawnPhysicalStatus::WAIT_SHIPPING; ModelUtil::update('module_prize_pool_drawn', ['id' => $drawnId], $update); return Response::send(0, '收件信息填写成功', null, '[back]'); } return $this->_view('fill', [ 'drawn' => $drawn, ]); } }