<?php
 namespace App\Modules\User\Manage; use App\Http\Controllers\Support\BaseController; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Laravel\Type\TypeUtil; use TechSoft\Laravel\Data\DataUtil; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\Member\Type\Gender; use TechSoft\Laravel\MemberCredit\MemberCreditUtil; use TechSoft\Laravel\MemberMoney\MemberMoneyUtil; use TechSoft\Laravel\Report\ReportUtil; class HomeController extends BaseController implements MemberLoginCheck { public function index() { $newUserLatestReport = ReportUtil::countDaily( 'user', ['memberUserId' => $this->memberUserId()], date('Y-m-d', strtotime('-13 day')), date('Y-m-d') ); return $this->_view('module.user.index', [ 'newUserLatestReport' => $newUserLatestReport, ]); } public function listsSearchFilter($searchParam = []) { $search = []; if (empty($searchParam) || !is_array($searchParam)) { return $search; } foreach ($searchParam as $searchItem) { foreach ($searchItem as $field => $searchInfo) { switch ($field) { case 'username': if (isset($searchInfo['like'])) { $search[] = ['username' => ['like' => $searchInfo['like']]]; } break; } } } return $search; } public function lists() { if (empty($this->wechatAccount)) { return Response::send(-1, '请先绑定公众号', null, '/member/wechat_bind'); } if (Request::isPost()) { $page = Input::get('page'); $pageSize = 10; $option = []; $option['where']['memberUserId'] = $this->memberUserId(); $option['order'] = ['id', 'desc']; $option['search'] = $this->listsSearchFilter(Input::get('search', [])); $head = []; $head[] = ['field' => 'username', 'title' => '用户',]; $head[] = ['field' => 'money', 'title' => '资金',]; $head[] = ['field' => 'credit', 'title' => '积分',]; $head[] = ['field' => 'gender', 'title' => '性别',]; $head[] = ['field' => 'address', 'title' => '地区',]; $head[] = ['field' => 'created_at', 'title' => '加入时间',]; $list = []; $paginateData = ModelUtil::paginate('member_user', $page, $pageSize, $option); foreach ($paginateData['records'] as &$record) { $item = []; $item['_id'] = $record['id']; $item['username'] = '<a href="javascript:;" data-user-info="' . $record['id'] . '" class="list-user-info"><img src="' . DataUtil::fix($record['avatar']) . '" /><span>' . htmlspecialchars($record['username']) . '</span></a>'; $item['money'] = sprintf('￥%0.2f', $record['money']); $item['credit'] = intval($record['credit']); $item['gender'] = TypeUtil::name(Gender::class, $record['gender']); $address = []; if ($record['country']) { $address[] = $record['country']; } if ($record['province']) { $address[] = $record['province']; } if ($record['city']) { $address[] = $record['city']; } $item['address'] = join(' ', $address); $item['created_at'] = $record['created_at']; $list[] = $item; } $data = []; $data['head'] = $head; $data['list'] = $list; $data['total'] = $paginateData['total']; $data['pageSize'] = $pageSize; $data['page'] = $page; return Response::generate(0, null, $data); } return $this->_view('module.user.lists'); } public function info($id) { $memberUser = MemberUtil::get($id); return $this->_view('module.user.info', [ 'memberUser' => $memberUser, 'moneyTotal' => MemberMoneyUtil::getTotal($memberUser['id']), 'creditTotal' => MemberCreditUtil::getTotal($memberUser['id']), ]); } }