<?php
 namespace App\Modules\User\Mobile; use App\Modules\Base\BaseMobileController; use App\Util\PlatformService; use App\Util\PlatformUtil; use Illuminate\Support\Facades\View; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Notice\NoticeUtil; use TechSoft\Laravel\User\UserLoginCheck; class MoneyController extends BaseMobileController implements UserLoginCheck { public static function owner() { $alias = Request::route('alias'); if (empty($alias)) { return 0; } $memberUser = ModelUtil::getWithCache('member_user', ['alias' => $alias]); if (empty($memberUser)) { return 0; } return $memberUser['id']; } public function index($alias) { $memberUser = ModelUtil::getWithCache('member_user', ['alias' => $alias]); if (empty($alias)) { return Response::send(-1, '页面不存在'); } if (Request::isPost()) { $page = InputPackage::buildFromInput()->getInteger('page', 1); $pageSize = 10; $option = []; $option['where'] = ['userId' => $this->userId()]; $option['order'] = ['id', 'desc']; $paginateData = ModelUtil::paginate('user_money_log', $page, $pageSize, $option); if (empty($paginateData['records'])) { return Response::send(0, null, ['html' => null]); } $html = View::make('res::user.default.mobile.moneyLogItem', [ 'records' => $paginateData['records'], ])->render(); return Response::send(0, null, ['html' => $html]); } return view('res::user.default.mobile.money', [ 'memberUser' => $memberUser, ]); } public function cash($alias) { $memberUser = ModelUtil::getWithCache('member_user', ['alias' => $alias]); if (empty($alias)) { return Response::send(-1, '页面不存在'); } if (Request::isPost()) { $money = InputPackage::buildFromInput()->getDecimal('money'); if ($money < 1.00) { return Response::send(-1, '提现金额不能小于1.00元'); } $user = $this->user(); if ($user['money'] < $money) { return Response::generate(-1, '余额不足'); } ModelUtil::transactionBegin(); $ret = PlatformUtil::cashMoneyToUser( $memberUser['id'], $this->userId(), $money ); if ($ret['code']) { ModelUtil::transactionRollback(); return Response::send(-1, $ret['msg']); } ModelUtil::transactionCommit(); if (PlatformUtil::usePlatformPayment($memberUser['id'])) { NoticeUtil::sendConfigNotice('adminNotifyMoneyPlatformCash', [ '商户' => $memberUser['username'], '用户' => $user['username'], '金额' => $money ]); } return Response::send(0, '提现申请成功', null, '[reload]'); } return view('res::user.default.mobile.cash', [ 'memberUser' => $memberUser, ]); } }