@foreach($records as $record)
    <div class="item">
        <div class="head">
            @if(!$record['cover'])
                <div class="cover">
                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($record['cover'])}}" />
                </div>
            @endif
            @if($record['type']==\App\Modules\PrizePool\PrizeType::REDBAG)
                <span class="mui-badge mui-badge-danger">红包</span>
                {{$record['name']}}
                <span class="value">
                    ￥{{sprintf('%0.2f',$record['redbagValue'])}} 元
                </span>
            @endif
            @if($record['type']==\App\Modules\PrizePool\PrizeType::CREDIT)
                <span class="mui-badge mui-badge-success">积分</span>
                {{$record['name']}}
                <span class="value">
                    {{$record['creditValue']}} 分
                </span>
            @endif
            @if($record['type']==\App\Modules\PrizePool\PrizeType::CODE)
                <span class="mui-badge mui-badge-warning">兑换码</span>
                {{$record['name']}}
            @endif
            @if($record['type']==\App\Modules\PrizePool\PrizeType::PHYSICAL)
                <span class="mui-badge mui-badge-primary">实物</span>
                {{$record['name']}}
            @endif
        </div>
        <div class="body">
            <div class="line">
                <span class="label">活动：</span>
                {{\TechOnline\Laravel\Type\TypeUtil::name(\App\Modules\PrizePool\ActivityType::class,$record['activityType'])}}
            </div>
            <div class="line">
                <span class="label">时间：</span>
                <time datetime="{{$record['created_at']}}"></time>
            </div>
            @if($record['type']==\App\Modules\PrizePool\PrizeType::CODE)
                @if($record['codeNo'])
                    <div class="line">
                        <span class="label">卡号：</span>
                        {{$record['codeNo']}}
                    </div>
                @endif
                @if($record['codeSecret'])
                    <div class="line">
                        <span class="label">卡密：</span>
                        {{$record['codeSecret']}}
                    </div>
                @endif
                @if($record['codeExpire'])
                    <div class="line">
                        <span class="label">过期：</span>
                        {{$record['codeExpire']}}
                    </div>
                @endif
            @endif
            @if($record['type']==\App\Modules\PrizePool\PrizeType::PHYSICAL)
                @if($record['userName'])
                    <div class="line">
                        <span class="label">姓名：</span>
                        {{$record['userName']}}
                    </div>
                @endif
                @if($record['userPhone'])
                    <div class="line">
                        <span class="label">手机：</span>
                        {{$record['userPhone']}}
                    </div>
                @endif
                @if($record['userAddress'])
                    <div class="line">
                        <span class="label">地址：</span>
                        {{$record['userAddress']}}
                    </div>
                @endif
                @if($record['physicalStatus']==\App\Modules\PrizePool\DrawnPhysicalStatus::WAIT_SHIPPING)
                    <div class="line">
                        <span class="label">状态：</span>
                        待发货
                    </div>
                @endif
                @if($record['physicalStatus']==\App\Modules\PrizePool\DrawnPhysicalStatus::SHIPPED)
                    <div class="line">
                        <span class="label">状态：</span>
                        已快递邮寄
                    </div>
                @endif
                @if($record['physicalStatus']==\App\Modules\PrizePool\DrawnPhysicalStatus::CHECKED)
                    <div class="line">
                        <span class="label">状态：</span>
                        已现场核销
                    </div>
                @endif
            @endif
        </div>
        @if($record['type']==\App\Modules\PrizePool\PrizeType::PHYSICAL)
            @if($record['physicalStatus']==\App\Modules\PrizePool\DrawnPhysicalStatus::DRAWN)
                <div class="action">
                    <a href="{{action('\App\Modules\PrizePool\Mobile\HomeController@fill',['alias'=>$_memberUser['alias'],'drawnId'=>$record['id']])}}"><i class="iconfont">&#xe64f;</i> 填写邮寄地址</a>
                    <a href="javascript:;" data-prize-check-code="{{$record['checkCode']}}"><i class="iconfont">&#xe683;</i> 现场兑换</a>
                </div>
            @endif
        @endif
    </div>
@endforeach