@extends('res::frameMUI')

@section('pageTitle','会员中心')

@section('headAppend')
    <link rel="stylesheet" href="@assets('res/user/default/mobile/css/style.css')">
@endsection

@section('body')

    <div class="mui-content">

        <div class="pb-member-home-head">
            <div class="body">
                <a class="avatar" href="javascript:;">
                    <img src="{{$_user['avatar']}}"/>
                </a>
                <div class="name">
                    {{$_user['username']}}的中心
                </div>
            </div>
        </div>

        <div class="pb-user-card-grid">
            <ul class="mui-table-view mui-grid-view mui-grid-9">
                <li class="mui-table-view-cell mui-media mui-col-xs-4">
                    <a href="{{action('\App\Modules\User\Mobile\MoneyController@index',['alias'=>$memberUser['alias']])}}">
                        <span class="icon iconfont">&#xe683;</span>
                        <div class="mui-media-body">钱包 ￥{{sprintf('%0.2f',$_user['money'])}}</div>
                    </a>
                </li>
                <li class="mui-table-view-cell mui-media mui-col-xs-4">
                    <a href="{{action('\App\Modules\User\Mobile\CreditController@index',['alias'=>$memberUser['alias']])}}">
                        <span class="icon iconfont">&#xe6c3;</span>
                        <div class="mui-media-body">积分 {{$_user['credit'] or 0}}</div>
                    </a>
                </li>
                @if($userCardSetting && $userCardSetting['enable'])
                    <li class="mui-table-view-cell mui-media mui-col-xs-4">
                        <a href="{{action('\App\Modules\UserCard\Mobile\HomeController@index', ['alias' => $userCardSetting['alias']])}}">
                            <span class="icon iconfont">&#xe626;</span>
                            <div class="mui-media-body">{{$userCardSetting['name']}}</div>
                        </a>
                    </li>
                @endif
            </ul>
        </div>

    </div>

@endsection