@extends('theme.default.pc.member.frame')

@section('pageTitleMain',MODULE_ACTIVITY_TEXT)

@section('memberBreadcrumb')
    <ul class="uk-breadcrumb">
        <li><a href="/member">管理首页</a></li>
        <li class="uk-active"><span>{{MODULE_ACTIVITY_TEXT}}</span></li>
    </ul>
@endsection

@section('memberContent')

    <div class="pb pb-module-panel">
        <div class="head">
            <div class="more">
                @if(!empty($activities))
                    <a href="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}_activity_edit"><i class="uk-icon-plus"></i> 新建{{MODULE_ACTIVITY_TEXT}}</a>
                @endif
            </div>
            <h2>{{MODULE_ACTIVITY_TEXT}}</h2>
        </div>
        <div class="body">
            @if(empty($activities))
                <a class="empty-add" href="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}_activity_edit">
                    <i class="uk-icon-plus"></i> 新建{{MODULE_ACTIVITY_TEXT}}
                </a>
            @else
                @foreach($activities as $activity)
                    <div class="item-activity">
                        <h2>{{$activity['title']}}</h2>
                        <div class="attr">
                            ID：{{$activity['id']}}
                        </div>
                        <div class="attr">
                            @if($activity['enable'])
                                状态：<span class="uk-badge uk-badge-success">已开启</span>
                            @else
                                状态：<span class="uk-badge uk-badge-danger">已关闭</span>
                            @endif
                        </div>
                        <div class="attr">
                            时间：{{$activity['startTime']}} - {{$activity['endTime']}}
                        </div>
                        <div class="action">
                            <a class="uk-button" href="javascript:;" data-uk-tooltip title="复制链接" data-clipboard-text="{{action('\App\Modules\\'.ucfirst(MODULE_ACTIVITY_NAME).'\Mobile\HomeController@home',['alias'=>$activity['alias']])}}"><i class="uk-icon-link"> 链接</i></a>
                            <a class="uk-button" href="javascript:;" data-uk-tooltip title="查看二维码" data-qrcode-content="{{action('\App\Modules\\'.ucfirst(MODULE_ACTIVITY_NAME).'\Mobile\HomeController@home',['alias'=>$activity['alias']])}}"><i class="uk-icon-qrcode"></i> 二维码</a>
                            <a class="uk-button" href="/module/manage/{{MODULE_ACTIVITY_NAME_UNDERSCORE}}_activity/{{$activity['id']}}"><i class="uk-icon-bar-chart"></i> 进入管理</a>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>

@endsection