@extends('theme.default.pc.member.frame')

@section('pageTitleMain','会员管理')

@section('memberBreadcrumb')
    <ul class="uk-breadcrumb">
        <li><a href="/member">管理首页</a></li>
        <li class="uk-active"><span>会员管理</span></li>
    </ul>
@endsection

@section('bodyScript')
    @parent
    <script src="@assets('assets/echarts/echarts.all.js')"></script>
    <script>
        $(function () {
            var option = {
                color: ['#DF6B25'],
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {
                        type : 'shadow'
                    }
                },
                grid: {
                    left: '3%',
                    right: '3%',
                    bottom: '3%',
                    top:'3%',
                    containLabel: true
                },
                xAxis : [
                    {
                        type : 'category',
                        data : @jsonArray($newUserLatestReport['time']),
                        axisTick: {
                            alignWithLabel: true,
                        },
                        axisLabel:{
                            interval:0,
                            formatter: function (value, index) {
                                var date = new Date(value);
                                return [(date.getMonth()<9?'0':''),(date.getMonth() + 1), (date.getDate()<10?'0':''),date.getDate()].join('');
                            }
                        }
                    }
                ],
                yAxis : [
                    {
                        type : 'value'
                    }
                ],
                series : [
                    {
                        name:'新增会员',
                        type:'bar',
                        barWidth: '60%',
                        data:@jsonArray($newUserLatestReport['value'])
                    }
                ]
            };
            echarts.init(document.getElementById('newUserLatestReport')).setOption(option);
        });
    </script>
@endsection

@section('memberContent')

    <div class="uk-grid">
        <div class="uk-width-1-2">
            <div class="pb pb-module-panel">
                <div class="head">
                    <h2>概况</h2>
                </div>
                <div class="body">
                    <div class="uk-grid">
                        <div class="uk-width-1-3">
                            <a href="/module/manage/user_lists" class="item-count">
                                <i class="uk-icon-users"></i>
                                <span class="value uk-text-success">{{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('user',['memberUserId'=>$_memberUser['id']]))}}</span>
                                <span class="title">会员总数</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="pb pb-module-panel">
                <div class="head">
                    <h2>会员管理</h2>
                </div>
                <div class="body">
                    <div class="uk-grid">
                        <div class="uk-width-1-3">
                            <a href="/module/manage/user_lists" class="item">
                                <i class="uk-icon-list"></i>
                                <span>会员列表</span>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="uk-width-1-2">

            <div class="pb pb-module-panel">
                <div class="head">
                    <h2>新增会员</h2>
                </div>
                <div class="body">
                    <div id="newUserLatestReport" style="height:235px;width:100%;"></div>
                </div>
            </div>

        </div>
    </div>



    <div class="pb pb-module-panel">
        <div class="head">
            <h2>会员中心链接</h2>
        </div>
        <div class="body">
            <form class="uk-form">
                <div class="uk-grid">
                    <div class="uk-width-8-10">
                        <input type="text" class="uk-width-1-1" disabled value="{{action('\App\Modules\User\Mobile\HomeController@index',['alias'=>$_memberUser['alias']])}}">
                    </div>
                    <div class="uk-width-1-10">
                        <a class="uk-button uk-width-1-1" href="javascript:;" data-qrcode-content="{{action('\App\Modules\User\Mobile\HomeController@index',['alias'=>$_memberUser['alias']])}}" data-uk-tooltip title="二维码"><i class="uk-icon-qrcode"></i></a>
                    </div>
                    <div class="uk-width-1-10">
                        <a class="uk-button uk-width-1-1" href="javascript:;" data-clipboard-text="{{action('\App\Modules\User\Mobile\HomeController@index',['alias'=>$_memberUser['alias']])}}" data-uk-tooltip title="复制链接"><i class="uk-icon-link"></i></a>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection