﻿<?php
/*
 * 支付核心类库
 * PayApis.cn
 */

class Pay
{
    private $id;
    private $key;

    public function __construct($id = null, $key = null)
    {
        $this->id = $id;
        $this->key = $key;
    }

    /**
     * @Note   发起公众号支付
     * @param $trade_no  订单号
     * @param $name  商品名称
     * @param $money  金额
     * @param $notify_url  异步通知地址
     * @param $mchid  商户号
     * @return bool
     */
    public function mp_pay($trade_no, $name, $money, $notify_url, $mchid)
    {
        $url = 'http://payapis.cn/api/mp_pay.html';
        $data = [
            'id' => $this->id,
            'trade_no' => $trade_no,
            'name' => $name,
            'money' => $money,
            'notify_url' => $notify_url,
            'mchid' => $mchid
        ];
        $sign = $this->getSign($data);
        $data['sign'] = $sign;
        $data['sign_type'] = 'MD5';
        $url = $url . '?' . http_build_query($data);
        return $url;
    }

    /**
     * @Note   发起扫码支付
     * @param $trade_no  订单号
     * @param $name  商品名称
     * @param $money  金额
     * @param $notify_url  异步通知地址
     * @param $mchid  商户号
     * @return bool
     */
    public function scan_pay($trade_no, $name, $money, $notify_url, $mchid)
    {
        $url = 'http://payapis.cn/api/scan_pay.html';
        $data = [
            'id' => $this->id,
            'trade_no' => $trade_no,
            'name' => $name,
            'money' => $money,
            'notify_url' => $notify_url,
            'mchid' => $mchid
        ];
        $sign = $this->getSign($data);
        $data['sign'] = $sign;
        $data['sign_type'] = 'MD5';
        $url = $url . '?' . http_build_query($data);
        $res = file_get_contents($url);
        if (!$res) return '发起支付失败！';
        $res = json_decode($res, 1);
        if ($res['code'] == 1) {
            return $res['code_url'];
        } else {
            return '发起支付失败！';
        }
    }

    /**
     * @Note   验证签名
     * @param $data  待验证参数
     * @return bool
     */
    public function verify($data)
    {
        if (!isset($data['sign']) || !$data['sign']) {
            return false;
        }
        $sign = $data['sign'];
        unset($data['sign']);
        unset($data['sign_type']);
        $sign2 = $this->getSign($data);
        if ($sign != $sign2) {
            $sign2 = $this->getSign($data);
            if ($sign == $sign2) return true;
            return false;
        }
        return true;
    }

    /**
     * @Note  生成签名
     * @param $data   参与签名的参数
     * @return string
     */
    public function getSign($data)
    {
        $data = array_filter($data);
        if (get_magic_quotes_gpc()) {
            $data = stripslashes($data);
        }
        ksort($data);
        $str1 = '';
        foreach ($data as $k => $v) {
            $str1 .= '&' . $k . "=" . $v;
        }
        $str = $str1 . $this->key;
        $str = trim($str, '&');
        $sign = md5($str);
        return $sign;
    }
}