<?php

/**
 * @Author: շ
 * @Date:   2019-10-26 23:30:41
 * @Last Modified by:   շ
 * @Last Modified time: 2019-10-26 23:47:46
 * @E-mail: admin@eyabc.cn
 */
class Xiaowei
{
    /**
     * 
     * @var array
     */
    protected $config;
    /**
     * ֧
     * @var string
     */
    protected $apiurl = 'https://www.8817892.cn/';

    /**
     * ʼ췽
     * @access public
     * @param  array   $config
     */
    public function __construct($config)
    {
		// ֧
        $this->apiurl = isset($config['apiurl']) && !empty(trim($config['apiurl'])) ? $config['apiurl'] : $this->apiurl;
        // ֧
        $this->config = $this->getValue($config, ['appid', 'key', 'notifyUrl', 'returnUrl']);
    }

    /**
     * ȡֵ
     * @access protected
     * @param  array   $data    ȡ
     * @param  array    $params б
     * @return array
     */
    protected function getValue($data, $params = [])
    {
        $list = [];
        foreach ($params as $value) {
            $list[$value] = isset($data[$value]) ? $data[$value] : null;
        }
        return $list;
    }

    /**
     * ֧
     * @access public
     * @param  array   $data
     * @return string  Html Form
     */
    public function createPayRequest($data)
    {
        // 첽صַ
        $notify_url = $this->config['notifyUrl'];
        // ͬصַ
        $return_url = $this->config['returnUrl'];
        // ̻
        $out_trade_no = $data['out_trade_no'];
        // 
		$name = $out_trade_no;
        // ֧
        $money = sprintf("%.2f", $data['money']);
        // վ
		$sitename = $out_trade_no;
		
        //ҪĲ
        $parameter = array(
            "pid"          => trim($this->config['appid']),
            "type"         => 'wxpay',
            "notify_url"   => $notify_url,
            "return_url"   => $return_url,
            "out_trade_no" => $out_trade_no,
            "name"         => $name,
            "money"        => $money,
            "sitename"     => $sitename,
        );

        //
        $para  = $this->buildRequestPara($parameter);
		
        $sHtml = "<form id='epaysubmit' name='epaysubmit' action='{$this->apiurl}/pay/epay/order?_input_charset=utf-8' method='GET'>";
        while (list($key, $val) = each($para)) {
            $sHtml .= "<input type='hidden' name='" . $key . "' value='" . $val . "'/>";
        }
        //submitťؼ벻Ҫname
        $sHtml = $sHtml . "<input type='submit' value='ύ'></form>";
        $sHtml = $sHtml . "<script>document.forms['epaysubmit'].submit();</script>";
        return $sHtml;
    }

    public function notify($data)
    {
        return $this->getSignVeryfy($data, $data["sign"]);
    }

    protected function buildRequestPara($para_temp)
    {
        //ȥǩеĿֵǩ
        $para_filter = $this->paraFilter($para_temp);

        //Դǩ
        $para_sort = $this->argSort($para_filter);

        //ǩ
        $mysign = $this->buildRequestMysign($para_sort);

        //ǩǩʽύ
        $para_sort['sign']      = $mysign;
        $para_sort['sign_type'] = 'MD5';

        return $para_sort;
    }

    protected function paraFilter($para)
    {
        $para_filter = array();
        while (list($key, $val) = each($para)) {
            if ($key == "sign" || $key == "sign_type" || $val == "") {
                continue;
            } else {
                $para_filter[$key] = $para[$key];
            }

        }
        return $para_filter;
    }

    protected function argSort($para)
    {
        ksort($para);
        reset($para);
        return $para;
    }

    protected function buildRequestMysign($para_sort)
    {
        //Ԫأ"=ֵ"ģʽ"&"ַƴӳַ
        $prestr = $this->createLinkstring($para_sort);
		
        $mysign = $this->md5Sign($prestr, $this->config['key']);

        return $mysign;
    }

    protected function createLinkstring($para)
    {
        $arg = "";
        while (list($key, $val) = each($para)) {
            $arg .= $key . "=" . $val . "&";
        }
        //ȥһ&ַ
        $arg = substr($arg, 0, count($arg) - 2);

        //תַôȥת
        if (get_magic_quotes_gpc()) {$arg = stripslashes($arg);}

        return $arg;
    }

    protected function md5Sign($prestr, $key)
    {
        $prestr = $prestr . $key;
        return md5($prestr);
    }

    protected function getSignVeryfy($para_temp, $sign)
    {
        //ȥǩеĿֵǩ
        $para_filter = $this->paraFilter($para_temp);

        //Դǩ
        $para_sort = $this->argSort($para_filter);

        //Ԫأ"=ֵ"ģʽ"&"ַƴӳַ
        $prestr = $this->createLinkstring($para_sort);

        $isSgin = false;
        $isSgin = $this->md5Verify($prestr, $sign, $this->config['key']);

        return $isSgin;
    }

    protected function md5Verify($prestr, $sign, $key)
    {
        $prestr = $prestr . $key;
        $mysgin = md5($prestr);
        if ($mysgin == $sign) {
            return true;
        } else {
            return false;
        }
    }
}
