/*
 * This file is part of the ************************ package.
 * _____________                           _______________
 *  ______/     \__  _____  ____  ______  / /_  _________
 *   ____/ __   / / / / _ \/ __`\/ / __ \/ __ \/ __ \___
 *    __/ / /  / /_/ /  __/ /  \  / /_/ / / / / /_/ /__
 *      \_\ \_/\____/\___/_/   / / .___/_/ /_/ .___/
 *         \_\                /_/_/         /_/
 *
 * The PHP Framework For Code Poem As Free As Wind. <Query Yet Simple>
 * (c) 2010-2018 http://queryphp.com All rights reserved.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Leevel\Log;

use Monolog\Handler\SyslogHandler;

/**
 * log.syslog.
 *
 * @author Xiangmin Liu <635750556@qq.com>
 *
 * @since 2017.09.01
 *
 * @version 1.0
 */
class Syslog extends Connect
{
    /**
     * 配置.
     *
     * @see \Monolog\Handler\AbstractSyslogHandler
     *
     * @var array
     */
    protected option = [
        "channel" : "development",
        "facility" : LOG_USER,
        "level" : ILog::DEBUG
    ];
    
    /**
     * 构造函数.
     *
     * @param array $option
     */
    public function __construct(array option = []) -> void
    {
        parent::__construct(option);

        this->makeSyslogHandler();
    }
    
    /**
     * 初始化系统 handler.
     *
     * @return \Psr\Log\LoggerInterface
     */
    protected function makeSyslogHandler() -> <LoggerInterface>
    {
        var handler;
    
        let handler = new SyslogHandler(
            this->option["channel"],
            this->option["facility"],
            this->normalizeMonologLevel(this->option["level"])
        );

        return this->monolog->pushHandler(this->normalizeHandler(handler));
    }
}
