/*
 * This file is part of the ************************ package.
 * _____________                           _______________
 *  ______/     \__  _____  ____  ______  / /_  _________
 *   ____/ __   / / / / _ \/ __`\/ / __ \/ __ \/ __ \___
 *    __/ / /  / /_/ /  __/ /  \  / /_/ / / / / /_/ /__
 *      \_\ \_/\____/\___/_/   / / .___/_/ /_/ .___/
 *         \_\                /_/_/         /_/
 *
 * The PHP Framework For Code Poem As Free As Wind. <Query Yet Simple>
 * (c) 2010-2018 http://queryphp.com All rights reserved.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Leevel\Session;

use SessionHandlerInterface;

/**
 * session.nulls.
 *
 * @author Xiangmin Liu <635750556@qq.com>
 *
 * @since 2018.08.17
 *
 * @version 1.0
 */
class Nulls implements SessionHandlerInterface
{
    /**
     * {@inheritdoc}
     */
    public function open(var savePath, var sessionName)
    {
        return true;
    }
    
    /**
     * {@inheritdoc}
     */
    public function close()
    {
        return true;
    }
    
    /**
     * {@inheritdoc}
     */
    public function read(var sessionid)
    {
        return [];
    }
    
    /**
     * {@inheritdoc}
     */
    public function write(var sessionid, var sessiondata)
    {
        return true;
    }
    
    /**
     * {@inheritdoc}
     */
    public function destroy(var sessionid)
    {
        return true;
    }
    
    /**
     * {@inheritdoc}
     */
    public function gc(var maxlifetime)
    {
        return true;
    }
    
    /**
     * 返回缓存仓储.
     */
    public function getCache()
    {
    }
}
