<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id 2 2008-08-24 17:08 $
*/
!defined('IN_MUDDER') && exit('Access Denied');

function query_article($callid,$params) {
    global $db, $dbpre,$_config;

    $params = parseGlobal($params);
    if(empty($params)) return array();
    extract($params);

    $cachename = sprintf("%d_%s", $callid,cacheIdentifier($params));
    $cachefile = MUDDER_ROOT.$_config['datacall_dir'].'cache_'.$cachename.'.php';

    if(check_cache($cachefile, $cachetime)) {
        return read_cache($cachefile);
    }

    $result = $where = array();
    $from = "{$dbpre}articles a";
    if($showdetail) {
        $from .= " LEFT JOIN {$dbpre}articledata ad ON(a.articleid=ad.articleid)";
    }
    $where[] = "status=1";
    is_numeric($classid) && $classid > 0 && $where[] = "classid='$classid'";
    is_numeric($shopid) && $shopid > 0 && $where[] = "shopid='$shopid'";
    is_numeric($att) && $att > 0 && $where[] = "att='$att'";
    is_numeric($dateline) && $dateline > 0 && $where[] = "dateline>=UNIX_TIMESTAMP()-$dateline";
    is_numeric($pageview) && $pageview > 0 && $where[] = "pageview>='$pageview'";
    is_numeric($digg) && $digg > 0 && $where[] = "digg>='$digg'";
    $where = implode(" AND ", $where);
    $order = strip_order($order);
    $orderby = $order ? "ORDER BY $order" : '';
    $limit = ($row=intval($row)) ? "LIMIT 0,$row" : 'LIMIT 0,10';
    $query = $db->query("SELECT * FROM $from WHERE $where $orderby $limit");
    if($db->num_rows($query) <= 0) {
        $result = array();
    } else {
        if(!function_exists('read_cache_articleclass')) {
            require_once(dirname(__FILE__).'/fun_common.php');
        }
        $articleclass = read_cache_articleclass();
        while($row = $db->fetch_array($query)) {
            $row['classname'] = $articleclass[$row['classid']]['classname'];
            $result[] = $row;
        }
        $db->free_result($query);
    }

    if($cachetime > 0) {
        write_cache($cachename, arrayeval($result), '', 'return', $_config['datacall_dir']);
    }

    return $result;
}
?>