<?php
/**
* UCenter Feed 推送
* @author moufer<moufer@163.com>
* @package 
* @copyright wa666.cn
* @version $Id feed_uc.class.php 1 2008-4-21 21:14 $
*/
!defined('IN_MUDDER') && exit('Access Denied');

class Feed_UC {

    function add_review($reviewid,$shopname,$message) {
        global $user, $_config, $_modules;
        if(!$_config['uc_feed']) return;
        $modurl = $_modules['shop']['url'];
        $feed = array();
        $feed['icon'] = 'debate';
        $feed['title_template'] = '{username} 点评了一家商铺';
        $feed['title_data'] = array (
            'username' => '<a href="space.php?uid='.$user->uid.'">'.$user->username.'</a>',
            );
        $feed['body_template'] = '{shopname} ({respond})';
        $feed['body_data'] = array (
            'shopname' => '<a href="'.$modurl.'viewreview.php?reviewid='.$reviewid.'">'.$shopname.'</a>',
            'respond' => '<a href="'.$modurl.'viewreview.php?reviewid='.$reviewid.'#respond">回应</a>',
        );
        $feed['body_general'] = trimmed_title(strip_tags(preg_replace("/\[.+?\]/is", '', $message)), 150);
        uc_feed_add($feed['icon'], $user->uid, $user->username, $feed['title_template'], $feed['title_data'], $feed['body_template'], $feed['body_data'], $feed['body_general'], '', array());
    }

    function add_newshop($shopid, $shopname) {
        global $user, $_config, $_modules;
        if(!$_config['uc_feed']) return;
        $modurl = $_modules['shop']['url'];
        $feed = array();
        $feed['icon'] = 'debate';
        $feed['title_template'] = '{username} 登记了一家商铺';
        $feed['title_data'] = array (
            'username' => '<a href="space.php?uid='.$user->uid.'">'.$user->username.'</a>',
            );
        $feed['body_template'] = '{shopname} ({review})';
        $feed['body_data'] = array(
            'shopname' => '<a href="'.$modurl.'shop.php?shopid='.$shopid.'">'.$shopname.'</a>',
            'review' => '<a href="'.$modurl.'post.php?action=newreview&shopid='.$shopid.'">点评</a>',
        );
        uc_feed_add($feed['icon'], $user->uid, $user->username, $feed['title_template'], $feed['title_data'], $feed['body_template'], $feed['body_data'], '', '', array());
    }

    function add_respond($reviewid,$respond_content) {
        global $user, $_config, $db,$dbpre, $_modules;
        if(!$_config['uc_feed']) return;
        $reviewuname = $db->get_value("SELECT a.username FROM {$dbpre}reviews a LEFT JOIN {$dbpre}members b ON(a.uid=b.uid) WHERE rid='$reviewid'");
        $feed = array();
        $feed['icon'] = 'comment';
        $feed['title_template'] = '{username} 回应了一个点评';
        $feed['title_data'] = array (
            'username' => '<a href="space.php?uid='.$user->uid.'">'.$user->username.'</a>',
            'sitename' => $_config['sitename'],
            'reviewuname' => $reviewuname,
            );
        $feed['body_template'] = '回应 {reviewuname} 的点评';
        $feed['body_data'] = array(
            'reviewuname' => '<a href="'.$_modules['shop']['url'].'viewreview.php?reviewid='.$reviewid.'">'.$reviewuname.'</a>',
        );
        $feed['body_general'] = trimmed_title(strip_tags(preg_replace("/\[.+?\]/is", '', $respond_content)), 150);
        $id = uc_feed_add($feed['icon'], $user->uid, $user->username, $feed['title_template'], $feed['title_data'], $feed['body_template'], $feed['body_data'], $feed['body_general'], '', array());
    }
}
?>