<?php
// 模板引擎
!defined('IN_MUDDER') && exit('Access Denied');

function parse_template($file, $templateid, $tpldir, $cachedir, $ext) {
    global $_config;

    $nest = 5;
	$tplfile = $tpldir . '/' . $file . $ext;
	$objfile = $cachedir . '/' . $templateid . '_' . $file . '.tpl.php';

	if(!@$fp = fopen(MUDDER_ROOT . $tplfile, 'r')) {
		die("Current template file '{$tplfile}' not found or have no access!");
	}

	$template = fread($fp, filesize(MUDDER_ROOT . $tplfile));
	fclose($fp);

	$var_regexp = "((\\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)(\[[a-zA-Z0-9_\-\.\"\'\[\]\$\x7f-\xff]+\])*)";
	$const_regexp = "([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)";

    $template = preg_replace("/\<\!\-\-\{(.+?)\}\-\-\>/s", "{\\1}", $template);
    $template = preg_replace("/\{(\\\$[a-zA-Z0-9_\[\]\'\"\$\.\x7f-\xff]+)\}/s", "<?=\\1?>", $template);
    $template = preg_replace("/[\n\r\t]*\{datacall:([0-9]+)\}[\n\r\t]*/ies", "datacall('\\1')", $template);
    $template = str_replace("{LF}", "<?=\"\\r\\n\"?>", $template);
    $template = preg_replace("/$var_regexp/es", "addquote('<?=\\1?>')", $template);
    $template = preg_replace("/\<\?\=\<\?\=$var_regexp\?\>\?\>/es", "addquote('<?=\\1?>')", $template);
    $template = preg_replace("/\<\?\=(.+?)\?\>(\->[a-zA-Z0-9_\x7f-\xff]*)/is", "<?=\\1\\2?>", $template);

    $template = "<? !defined('IN_MUDDER') && exit('Access Denied'); ?>\n$template";
	$template = preg_replace("/[\n\r\t]*\{template\s+([a-z0-9_]+)\}[\n\r\t]*/is", "\n<? include template('\\1'); ?>\n", $template);
	$template = preg_replace("/[\n\r\t]*\{template\s+(.+?)\}[\n\r\t]*/ies", "stripvtags('\n<? include template(\\1); ?>\n','')", $template);
	$template = preg_replace("/[\n\r\t]*\{spacestyle\s+([a-z0-9_]+)\}[\n\r\t]*/is", "\n<? include spacestyle('\\1'); ?>\n", $template);
	$template = preg_replace("/[\n\r\t]*\{itemstyle\s+([a-z0-9_]+)\}[\n\r\t]*/is", "\n<? include itemstyle('\\1'); ?>\n", $template);
	$template = preg_replace("/[\n\r\t]*\{elseif\s+(.+?)\}[\n\r\t]*/ies", "stripvtags('\n<? } elseif(\\1) { ?>\n','')", $template);
	$template = preg_replace("/[\n\r\t]*\{else\}[\n\r\t]*/is", "\n<? } else { ?>\n", $template);
    $template = preg_replace("/[\n\r\t]*\{eval\s+(.+?)\}[\n\r\t]*/ies", "stripvtags('<? \\1 ?>','')", $template);

    $template = preg_replace("/[\n\r\t]*\{query:(.+?)\s+(.+?)\}[\n\r\t]*/ies", "stripquery('\\1','\\2')", $template);
    $template = preg_replace("/[\n\r\t]*\{\/query\}[\n\r\t]*/i", "\r\n<? } ?>\r\n", $template);
    $template = preg_replace("/[\n\r\t]*\{sublen\s+(.+?)\}[\n\r\t]*/ies", "stripvtags('<? echo trimmed_title(\\1); ?>','')", $template);
    $template = preg_replace("/[\n\r\t]*\{date\s+(.+?)\}[\n\r\t]*/ies", "stripvtags('<? echo newdate(\\1); ?>','')", $template);

	for($i = 0; $i < $nest; $i++) {
		$template = preg_replace("/[\n\r\t]*\{loop\s+(\S+)\s+(\S+)\}[\n\r]*(.+?)[\n\r]*\{\/loop\}[\n\r\t]*/ies", "stripvtags('\n<? if(is_array(\\1)) { foreach(\\1 as \\2) { ?>','\n\\3\n<? } } ?>\n')", $template);
		$template = preg_replace("/[\n\r\t]*\{loop\s+(\S+)\s+(\S+)\s+(\S+)\}[\n\r\t]*(.+?)[\n\r\t]*\{\/loop\}[\n\r\t]*/ies", "stripvtags('\n<? if(is_array(\\1)) { foreach(\\1 as \\2 => \\3) { ?>','\n\\4\n<? } } ?>\n')", $template);
		$template = preg_replace("/[\n\r\t]*\{if\s+(.+?)\}[\n\r]*(.+?)[\n\r]*\{\/if\}[\n\r\t]*/ies", "stripvtags('<? if(\\1) { ?>','\n\\2<? } ?>\n')", $template);
	}

	$template = preg_replace("/\{$const_regexp\}/s", "<?=\\1?>", $template);
	$template = preg_replace("/ \?\>[\n\r]*\<\? /s", " ", $template);

	if(!@$fp = fopen(MUDDER_ROOT.$objfile, 'w')) {
		die("Directory '{$objfile}' not found or have no access!");
	}

    $template = preg_replace("/\"(http)?[\w\.\/:]+\?[^\"]+?&[^\"]+?\"/e", "transamp('\\0')", $template);
	$template = preg_replace("/(\<script[^\>]*?src=\"(.+?)\".*?\>\s*\<\/script\>)/ise", "stripscriptamp('\\1','\\2')", $template);

	flock($fp, 2);
	fwrite($fp, $template);
	fclose($fp);
}

function transamp($str) {
	$str = str_replace('&', '&amp;', $str);
	$str = str_replace('&amp;amp;', '&amp;', $str);
	$str = str_replace('\"', '"', $str);
	return $str;
}

function addquote($var) {
	return str_replace("\\\"", "\"", preg_replace("/\[([a-zA-Z0-9_\-\.\x7f-\xff]+)\]/s", "['\\1']", $var));
}

function stripvtags($expr, $statement) {
	$expr = str_replace("\\\"", "\"", preg_replace("/\<\?\=(\\\$.+?)\?\>/s", "\\1", $expr));
	$statement = str_replace("\\\"", "\"", $statement);
	return $expr.$statement;
}

function stripscriptamp($script, $src) {
	$s = str_replace('&amp;', '&', $src);
    $search = array($src, '\"');
    $replace = array($s, '"');
    if(strpos(strtolower($src),'mapbar.com')) {
        array_push($search,'<?=','?>');
        array_push($replace,'','');
    }
	return str_replace($search, $replace, $script);
}

function stripquery($fun, $str) {
    $str = stripvtags($str, '');
    $vars = explode(' ', $str);
    if(!$vars) return $str;
    $varlist = array();
    $s = array('_DESC', '_ASC');
    $r = array(' DESC', ' ASC');
    $fun = 'query_'.$fun;
    $var = '';
    $s_var = '';
    foreach($vars as $val) {
        $tmp = array();
        $tmp = explode('=', $val);
        if($tmp[0] == 'order') {
            $tmp[1] = str_replace($s, $r, $tmp[1]);
        }
        if($tmp[0] == 'var') {
            $s_var = $tmp[1];
            $var = '_QUERY[\''.$tmp[1].'\']';
        } elseif($tmp[0] == 'cachetime') {
            $cachetime = $tmp[1];
        } elseif($tmp[0] == 'callid') {
            $callid = $tmp[1];
        } elseif($tmp[0]!='') {
            $varlist[$tmp[0]] = $tmp[1];
        }
    }
    if($varlist['params']) {
        $params = explode('/',$varlist['param']);
        for($i= 0; $i < count($params); $i += 2) {
            $varlist[$params[$i]] = $params[$i+1];
        }
        unset($varlist['param']);
    }
    $cachetime = intval($cachetime);

    $array = 'array(';
    foreach($varlist as $key => $val) {
        if(preg_match('/^\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*.+$/', $val)) {
            $array .= "'".$key."'=>".$val .",";
        } else {
            $array .= "'".$key."'=>'".str_replace("'","\'",$val)."',";
        }
    }
    $array .= ')';

    $restr = "\r\n<? \$$var = $fun($callid,$array);\r\n";
    $restr .= "if(is_array(\$$var))foreach(\$$var as \$$s_var){ ?>\r\n";

    return $restr;
}
?>
