<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id 3 2008-08-30 01:00 $
*/
!defined('IN_MUDDER') && exit('Access Denied');

// 提交点评回应
function postRespond($post) {
    global $db, $dbpre, $_inputlimit,$_webtotal;

    $post['content'] = unite_textarea($post['content']);
    if(!$post['content']) {
        redirect('未填写回应信息，请返回修改。');
    } elseif(strlen($post['content']) < $_inputlimit['respond']['min'] || 
             strlen($post['content']) > $_inputlimit['respond']['max']) {
        redirect('回应内容请控制在'.$_inputlimit['respond']['min'].' - '.$_inputlimit['respond']['max'].'个字符。');
    }
    if($post['respondid']) {
        // 更新
        $respondid = $post['respondid'];
        unset($post['respondid']);
        $old = $db->get_one("SELECT * FROM {$dbpre}responds WHERE rid='$respondid'");
        empty($old) and redirect('回应对象不存在，无法回应。');
        $db->update_new($dbpre.'responds', "rid='$respondid'", $post);
        if($post['status']!=2 && $old['status']==2) {
            checkupRespond(array($respondid));
        }
    } else {
        // 增加
        $db->insert_new($dbpre.'responds', $post);
        $respondid = $db->insert_id();
        empty($respondid) and redirect('提交失败。');
        if($post['status'] != '2') {
            RespondBeRelated($post);
            $_webtotal['totalrespond']++;
            update_webtotal();
        }
    }
    return $respondid;
}

// 审核回应信息
function checkupRespond($respondids) {
    global $db, $dbpre, $_webtotal;

    if(empty($respondids)||!is_array($respondids)) return;
    $showmsg = defined('IN_ADMIN') ? 'cpmsg' : 'redirect';
    $ids = "'".implode("','", $respondids)."'";
    $upresponds = array();
    $query = $db->query("SELECT * FROM {$dbpre}responds WHERE rid IN ($ids)");
    while($row = $db->fetch_array($query)) {
        if($row['status'] == 2) {
            RespondBeRelated($row);
            $upresponds[] = $row['rid'];
            $_webtotal['totalrespond']++;
        }
    }
    if($upresponds) {
        $ids = "'".implode("','", $upresponds)."'";
        $db->query("UPDATE {$dbpre}responds SET status=1 WHERE rid IN ($ids)");
        update_webtotal();
    }
}

// 删除回应信息
function deleteRespond($myids, $idtype='rid', $opuid='-1', $upReview=true, $credit=false) {
    global $db, $dbpre;

    if(empty($myids)||!is_array($myids)) return; 
    $showmsg = defined('IN_ADMIN') ? 'cpmsg' : 'redirect';
    $delresponds = array();
    $ids = "'".implode("','", $myids)."'";
    //pr("SELECT * FROM {$dbpre}responds WHERE $idtype IN ($ids)");
    $query = $db->query("SELECT * FROM {$dbpre}responds WHERE $idtype IN ($ids)");
    while($row = $db->fetch_array($query)) {
        $access = defined('IN_ADMIN') || $opuid==-1 || $opuid==$row['uid'];
        !$access and $showmsg('您没有足够的权限来完成本次操作，请返回。');
        $delresponds[] = $row['rid'];
        // 有效的回复
        if($row['status'] != 2) {
            // 更新会员表
            $sqlset = "responds=responds-1";
            if($credit) {
                if(!function_exists('updateCredit')) {
                    require_once(MUDDER_ROOT.'./member/include/fun_member.php');
                }
                $sqlset .= ",".updateCredit($row['uid'], 'deleterespond', 'sqlset');
            }
            $db->update("UPDATE {$dbpre}members SET $sqlset WHERE uid='{$row['uid']}'");
            // 更新点评表统计
            if($upReview) {
                $db->update("UPDATE {$dbpre}reviews SET respond=respond-1 WHERE rid='{$row['reviewid']}'");
            }
        }
    }
    $db->free_result($query);
    if($delresponds) {
        $ids = "'".implode("','", $delresponds)."'";
        $db->query("DELETE FROM {$dbpre}responds WHERE rid IN ($ids)");
    }
}

// 回应后关联表更新
function RespondBeRelated($row) {
    global $db, $dbpre, $ucenter_enable;

    $db->update("UPDATE {$dbpre}reviews SET respond=respond+1 WHERE rid='{$row['reviewid']}'");
    // 更新会员积分和统计
    if(!function_exists('updateCredit')) {
        require_once(MUDDER_ROOT.'./member/include/fun_member.php');
    }
    $sqlset = updateCredit($row['uid'], 'addrespond', 'sqlset');
    $sqlset .= ($sqlset ? ', ' : '') . "responds=responds+1";
    $db->update("UPDATE {$dbpre}members SET $sqlset WHERE uid='{$row['uid']}'");
    // Feed 推送
    if($ucenter_enable) {
        if(!class_exists('Feed_UC')) {
            require_once(MUDDER_ROOT.'./include/feed_uc.class.php');
        }
        Feed_UC::add_respond($row['reviewid'], $row['content']);
    }
}
?>