<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id 6 2008-09-17 14:57 $
*/
!defined('IN_MUDDER') && exit('Access Denied');
// 解析字符串为数组
function parseTagstr($str) {
    $split = " "; // 标签分隔符号
    $match = "/(，|、|,|\/|\\\|\||——|=)/is"; // 过滤正则
    $str = preg_replace($match, $split, $str);
    $str = trim(preg_replace("/(\s)+/is", $split, $str));
    return explode($split, $str);
}

function tagToArray($tags) {
	if(empty($tags)) return;
	$result = array();
	foreach ($tags as $val) {
		$result[] = array(
			'tagname' => $val, 
			'tagnameenc' => rawurlencode($val),
		);
	}
	return $result;
}

// 自定义标签之固定标签
function customTagstr($pcd, $tags) {
    global $_panel_config;
    $cfg = $_panel_config[$pcd];
    if(empty($cfg) || !is_array($tags)) return;
    $split = $tagstr = '';
    if($cfg['suitplace_enable']) {
        foreach ($tags as $tagname) {
            if(!in_array($tagname, $cfg['suitplaces'])) continue;
            $tagstr .= $split.$tagname;
            $split = ' '; // 标签分隔符
        }
    }
    return $tagstr;
}

// 返回字符串状态
function tagTostr($tags) {
    $split = ' ';
    return is_array($tags) ? implode($split, $tags) : $tags;
}

// 标准化标签内容
function checkTagPost($post, $pcd) {
    
    $showmsg = defined("IN_ADMIN") ? 'cpmsg' : 'redirect';
    $post['suitplacetags'] = customTagstr($pcd, $post['suitplacetags']);
    foreach(array('shop','product','suitplace') as $val) {
        $val = sprintf("%stags", $val);
        // 标签标准化，纠正不符合合规则的标签
        $post[$val] = parseTagstr($post[$val]);
        // 检测标签
        if($post[$val]) foreach($post[$val] as $tagname) {
            if(strlen($tagname) > 25) {
                $showmsg('标签“'.$tagname.'”过长，请返回精简此标签。');
            }
        }
        $post[$val] = tagTostr($post[$val]); // 还原为字符串
    }
    return $post;
}

// 组合提交标签
function uniteTagAndPost($review, $pcd, $isUpdate = false, $oldReview=array()) {
    foreach(array('shop','product','suitplace') as $val) {
        $tk = sprintf("%stags", $val);
        if(!$isUpdate && empty($review[$tk])) continue;
        if($isUpdate && $review[$tk]==$oldReview[$tk]) continue;
        postTags($review['shopid'],$review['rid'], $pcd, 
        	parseTagstr($review[$tk]),$val,($isUpdate ? 'update' : ''));
    }
}

// 提交数据库
function postTags($shopid, $reviewid, $panelcode, $tags, $sort, $extra='') {
    global $db, $dbpre;
    if(!is_numeric($shopid) || $shopid <= 0) return;
    //if(!is_numeric($reviewid) || $reviewid <= 0) return;
    if(!in_array($sort, array('shop','product','suitplace'))) return;
    // 更新Tags
    if($extra == 'update') {
        $query = $db->query("SELECT tagname FROM {$dbpre}shoptags WHERE reviewid='$reviewid' AND tagsort='$sort'");
        // 更新统计
        while($d_tag = $db->fetch_array($query)) {
            $db->update("UPDATE {$dbpre}tags SET total=total-1 WHERE tagname='{$d_tag['tagname']}' AND panelcode='$panelcode'");
        }
        // 将原来的Tags删除
        $db->query("DELETE FROM {$dbpre}shoptags WHERE reviewid='$reviewid' AND tagsort='$sort'");
        $db->query("DELETE FROM {$dbpre}tags WHERE total=0 ");
    }
    // $arr_tag = array_unique(explode(" ", $tags));
    foreach($tags as $tag) {
        $tag = trim($tag);
        if(trim($tag) == '') continue;
        if(!$extra) {
            $result = $db->get_one("SELECT * FROM {$dbpre}shoptags WHERE shopid='$shopid' AND reviewid='$reviewid' AND tagsort='$sort' AND tagname='$tag'");
            !$result && $db->query("INSERT INTO {$dbpre}shoptags (tagname, shopid, reviewid, tagsort) VALUES('$tag', '$shopid', '$reviewid', '$sort')");
            unset($result);
            $panelcode = strlen($panelcode) > 2 ? substr($panelcode, 0, 2) : $panelcode;
            $result = $db->get_one("SELECT * FROM {$dbpre}tags WHERE tagname='$tag' AND panelcode='$panelcode'");
            if($result) {
                $db->update("UPDATE {$dbpre}tags SET total=total+1 WHERE tagname='$tag' AND panelcode='$panelcode' ");
            } else {
                $db->query("INSERT INTO {$dbpre}tags (tagname,total,panelcode) VALUES('$tag','1','$panelcode') ");
            }
        } elseif($extra == 'update') {
            $db->query("INSERT INTO {$dbpre}shoptags (tagname, shopid, reviewid, tagsort) VALUES('$tag', '$shopid', '$reviewid', '$sort')");
            $db->query("INSERT INTO {$dbpre}tags (tagname,total,panelcode) VALUES('$tag','1','$panelcode') ");
        }
    }
}

// 返回商铺的标签
function getItemTags($shopid) {
    global $db, $dbpre;
    $query = $db->query("SELECT tagname,count(tagname) as total,tagsort FROM {$dbpre}shoptags WHERE shopid='$shopid' GROUP BY tagname,tagsort ORDER BY total DESC");
    while($tag = $db->fetch_array($query)) {
        $tag['tagnameenc'] = rawurlencode($tag['tagname']);
        if($tag['tagsort'] == 'shop') {
           $shoptags[] = $tag; //商铺
        } elseif($tag['tagsort'] == 'product') {
            $producttags[] = $tag; // 产品
        } elseif($tag['tagsort'] == 'suitplace') {
            $suitplaces[] = $tag; // 适合
        }
    }
    return array( $shoptags, $producttags, $suitplaces);
}
?>