<?php
/**
* 所有点评
* @author moufer<moufer@163.com>
* @package modoer
* @copyright Moufer Studio(www.modoer.com)
* @version $Id: reviews.php 3 2007-12-13 22:51 $
*/

define('SCRIPTNAV', 'reviews');
require_once './include/inc_common.php';

(!$pcd || !array_key_exists($pcd, $_panels)) && $pcd = $_config['default_panel'];

$day = @intval($day);
$panelcfg =& $_panel_config[$pcd];
$reviewsorts =& $panelcfg['review'];
// 兼容性
if($_config['compatible']) {
    $review_item =& $reviewsorts;
}

switch($day) {
case '3':
    $selectorder['name']='近三天 ';
    break;
case '7':
    $selectorder['name']='近一周 ';
    break;
case '90':
    $selectorder['name']='近三月 ';
    break;
case '365':
    $selectorder['name']='近一年 ';
    break;
default: //默认1个月
    $selectorder['name'] = '近一月 ';
    $day = '30';
}
switch($order) {
case 'respond'://最多回应
    $selectorder['name'].='最多回应';
    $orderby = 'a.respond DESC, a.posttime DESC';
    break;
case 'flower'://最多鲜花
    $selectorder['name'].='最多鲜花';
    $orderby = 'a.flower DESC, a.posttime DESC';
    break;
case 'enjoy'://最近好评
    $selectorder['name'].='最近好评';
    $orderby = 'a.enjoy DESC, a.posttime DESC';
    break;
default: //默认最新点评
    $order = 'new';
    $selectorder['name'].='最新点评';
    $orderby = 'a.posttime DESC';
}

$where = "(classcode BETWEEN '{$pcd}00' AND '{$pcd}99') AND a.status=1";
$selectorder['total'] = $db->get_value("SELECT COUNT(*) FROM {$dbpre}reviews a LEFT JOIN {$dbpre}shops b ON(a.shopid=b.sid) WHERE $where");
if($selectorder['total'] > 0) {
    $limit = get_limit($page, $_config['dpreviewnumber']);
    $query = $db->query("SELECT a.*,b.username,b.face,b.reviews as member_reviews,b.flowers as member_flowers,b.point as member_point,b.coin as member_coin,c.shopname,c.subname,c.areacode,c.address,c.tel1,c.tel2,c.mobile,c.mappoint FROM {$dbpre}reviews a LEFT JOIN {$dbpre}members b ON(a.uid=b.uid) LEFT JOIN {$dbpre}shops c ON(a.shopid=c.sid) WHERE $where ORDER BY $orderby LIMIT $limit");

    while($row = $db->fetch_array($query)) {
        $row['member'] = array(
            'uid' => $row['uid'],
            'username' => $row['username'],
            'face' => $row['face'],
            'reviews' => $row['member_reviews'],
            'flowers' => $row['member_flowers'],
            'point' => $row['member_point'],
            'coin' => $row['member_coin'],
        );
        $row['item'] = array(
            'sid' => $row['shopid'],
            'shopname' => $row['shopname'],
            'subname' => $row['subname'],
            'classcode' => $row['classcode'],
            'streetcode' => $row['streetcode'],
            'address' => $row['address'],
            'tel1' => $row['tel1'],
            'tel2' => $row['tel2'],
            'mobile' => $row['mobile'],
            'mappoint' => $row['mappoint'],
        );
        $tmp = reviewToArray($row);
        $tmp['shop'] =& $tmp['item'];
        $reviews[] = $tmp;
    }
    $db->free_result($query);
    $multipage = multi($selectorder['total'], $offset, $page, "reviews.php?pcd=$pcd&order=$order&day=$day");
}

$orders =array(
    'new'=>'最新点评',
    'enjoy'=>'最近好评',
    'flower'=>'鲜花数',
    'respond'=>'回应数',
);
$days = array(
    '3' => '近三天',
    '7' => '近一周',
    '30' => '近一月',
    '90' => '近三月',
    '365' => '近一年',
);

$subtitle = $_panels[$pcd].'_'.$selectorder['name'];
require_once MUDDER_ROOT.'header.php';
require_once template('shop_reviews');
footer();
?>