<?php
/**
* 会员个人空间
* @author moufer<moufer@163.com>
* @pageage space
* @copyright Moufer Studio(www.modoer.com)
* @version $Id: index.php 12 2008-10-20 19:54 $
*/
define('SCRIPTNAV', 'space');
require_once './include/inc_common.php';
// 模型
require_once MOD_ROOT.'model/space.php';
require_once MOD_ROOT.'model/gbook.php';
require_once MOD_ROOT.'model/traveler.php';
if($ucenter_enable) {
    require_once MUDDER_ROOT.'./member/model/friend_uc.php';
} else {
    require_once MUDDER_ROOT.'./member/model/friend.php';
}
if(!function_exists('getMemberReviews')) {
    require_once(MUDDER_ROOT.'./'.$_modules['shop']['directory'].'/include/fun_review.php');
}
// 实例化
$model = new SpaceModel();
$gbookmodel = new GbookModel();
$travelermodel = new TravelerModel();
$friendmodel = new moFriendModel();
//=================
if(is_numeric($_SERVER['QUERY_STRING'])) {
    $suid = $_SERVER['QUERY_STRING'];
} else {
    $suid = empty($uid) ? $suid : $uid;
}

if($viewstyle && empty($space_styleid)) {
    redirect('未指定预览风格ID。');
}
// 风格预览
if($action == 'viewstyle') {
    if(!$user->isLogin) {
        location($_config['siteurl'].'member/'.'login.php?forward='.rawurlencode($forward), false);
    } elseif(!array_key_exists($space_styleid, $_templates['space'])) {
        redirect('空间风格模板不存在，无法预览。');
    } else {
        $suid = $user->uid;
    }
} elseif($_config['ucenter_enable'] && $_config['uc_uch']) {
    // 跳转到UCHome的个人主页
    header("Location:".$_config['uc_uch_url']."/?".$suid);
}

if(!is_numeric($suid)&&$suid<=0) {
    redirect('未知的会员ID空间。');
}
$model->setUid($suid);

if(!check_submit('spacesubmit')) {

    $space = $model->readInfo();
    empty($space) && redirect('会员不存在或已删除。');

    if($user->isLogin && ($user->uid != $suid) && $_space['recordguest']) {
        $travelermodel->record($suid,$user);
    }

    $left_gbooks = $gbookmodel->read($suid, 0, 5);
    $left_friends = $friendmodel->read($suid, 0, 5);
    $travelers = $travelermodel->read($suid, 0, 5);

    if($n == 'reviews') {
        $subtitle = '我的最新点评';
        $offset = intval($_space['reviews']);
        list($total, $reviews) = getMemberReviews($suid, get_limit($page,$offset));
        if($total>0) {
            $multipage = multi($total, $offset, $page, "index.php?suid=$suid&n=reviews");
        }
    } elseif($n == 'gbook') {
        $subtitle = '我的留言板';
        $total = $gbookmodel->getTotal($suid);
        if($total > 0) {
            $gbooks = $gbookmodel->read($suid, dblimit($page,$offset=20));
            $multipage = multi($total, $offset, $page, $_modules['space']['url']."index.php?suid=$suid&n=gbook");
        }
    } elseif($n == 'friends') {
        $subtitle = '我的好友';
        $total = $friendmodel->getTotal($suid);
        if($total >0) {
            $friends = $friendmodel->read($suid,dblimit($page,$offset));
            $multipage = multi($total, $offset, $page, "index.php?suid=$suid&n=friends");
        }
    } else {
        $n = 'index';
        list(,$reviews) = getMemberReviews($suid, intval($_space['index_reviews']));
        $gbooks = $gbookmodel->read($suid, 0, intval($_space['index_gbooks']));
        if($suid != $user->uid) $model->updatePageview();
    }

} else {
    if($action == 'postgbook') {
        $post = array();
        if($user->isLogin) {
            $post['gbuid'] = $user->uid;
            $post['gbusername'] = $user->username;
        } else {
            if(!$username) redirect('未填写您的昵称，请返回修改。');
            $post['gbuid'] = 0;
            $post['gbusername'] = html_special_chars_ex($username);
        }
        $post['content'] = isset($content) ? unite_textarea($content) : '';
        if(!$post['content']) {
            redirect('未填写回应的内容，请返回修改。');
        } elseif(strlen($post['content']) > 300 || strlen($post['content']) < 3) {
            redirect('请将回应内容控制在3-300个字符以内，请返回修改。');
        } else {
            if(!class_exists('GbookModel')) {
                require_once('./model/gbook.php');
            }
            $gbookmodel = new GbookModel();
            $gbookmodel->save($suid, $post);
            unset($post);
            redirect('留言完毕！', $MOD['url']."index.php?suid=$suid&n=gbook");
        }
    }
}

$member = &$space; // 兼容
$pagetitle = $subtitle ? $subtitle : $space['spacedescribe'];
$subtitle = $pagetitle = $space['spacename'].'_'.$pagetitle.' - '.$_config['sitename'];

if($viewstyle && $space_styleid) {
    $space_styleid = $space_styleid;
} elseif(is_array($_templates['space']) && array_key_exists($space['space_styleid'], $_templates['space'])) {
    $space_styleid = $space['space_styleid'];
} else {
    $space_styleid = $_config['space_styleid'];
}
$spacestyle_dir = $_templates['space'][$space_styleid]['directory'];
if(!file_exists($spacestyle_dir)) {
    $_config['space_styleid'] = $space['space_styleid'] = 0;
} else {
    substr($spacestyle_dir, -1, 1) != '/' && $spacestyle_dir .= '/';
    $spacestyle_url = $_config['siteurl'].substr($spacestyle_dir,2);
}

if(($viewstyle) || $_config['space_styleid'] || $space['space_styleid']) {
    !$viewstyle && $space_styleid = $_config['space_styleid'];
    require_once spacestyle('header', $space_styleid);
    require_once spacestyle($n, $space_styleid);
    footer($space_styleid, '', 'space');
} else {
    // 不使用风格
    require_once MUDDER_ROOT.'header.php';
    require_once template('space_'.$n);
    footer();
}
?>