/**
 * D5Power Studio d5power Webgame Engine
 *
 * Extends DOTK system
 * Author: D5Power Studio
 *
 *
 * 第五动力工作室 d5power网页游戏引擎 Ver 1.0
 * 继承自:DOTK引擎
 * 作者：第五动力工作室
 */

/* -------------------------------------------------------
 * DotK WebGame Engine, Version 0.5 Beta
 * DotK Engine is part of Defenders of the Kingdom's Project
 * Developer: Marcio Henrique Toloi
 * Date: 7-october-2007
 * ------------------------------------------------------- */

//Global variables.
var myCharacter = null;
var charactersOnScreen = [];
var actualMap = null;
var mapOffset = {x:170, y:110};


/**
 * Dotk Map Class
 */
Map = Class.create();
Map.prototype = {
  initialize: function() {
    this.mapId = undefined;
    this.collisionPoints = undefined;
    this.mapLayers = new Array('terrain_layer','ground_layer','up_layer');
    this.imgObjs = undefined;
    this.loadedImages = 0;
    this.totalImages = this.mapLayers.length;
  },
    
  load: function() {
    this.imgObjs = new Array();
    $('loading').style.display = 'inline';
    for (var i=0; i<this.totalImages; i++) {
      this.imgObjs[i] = new Image();
      this.imgObjs[i].onload = this.imgLoaded;
      //imgObjs[i].onerror = imgFailed;
      this.imgObjs[i].src = 'd5power.php?action=loadMap&maplayer='+this.mapLayers[i];
      $(this.mapLayers[i]).style.backgroundImage = 'url("'+this.imgObjs[i].src+'")';
    }
    this.getCollisionPoints();
  },
  
  imgLoaded: function() {
    actualMap.loadedImages++;
      if (actualMap.loadedImages == actualMap.totalImages) {
        $('loading').style.display = 'none';  
      }
    return;
  },
 
  loadCollisionMap: function() {
    var url = 'getMapInfo.php';
    var pars = 'colisionMap=1';
    var myAjax = new Ajax.Request( url, { method: 'get', parameters: pars, onComplete: 
            function(result) {
                this.collisionPoints = this.parseCollisionPoints();
            } });
  },
    
  getCollisionPoints: function() {
    new Ajax.Request(
            'd5power.php', {
            method: 'get',
            parameters: 'action=loadCollisionPoints',
            onComplete: function(result) {
                            actualMap.collisionPoints = eval("(" + result.responseText + ")");						
            }});
    return;
  }
};


/**
 * Players List Class
 * Structure to handle character instances.
 */
characterList = Class.create();
characterList.prototype = {
  initialize: function() {
    this.list = [];
  },

  add: function(characterInstance) {
    this.list.push(characterInstance);
    return;
  },
  
  length: function() {
    return this.list.length;
  },

  remove: function(characterId) {
    for (i=0; i<this.list.length; i++) {
      if (this.list[i].characterId == characterId) {
        this.list[i].destroy();
        this.list[i] = null; 
      }
    }
    this.list = this.list.compact();	
    return;
  },

  getById: function(characterId) {
    for (i=0; i<this.list.length; i++) {
      if (this.list[i].characterId == characterId) {
        return this.list[i];
      }
    }
    return null;
  },
  
  getByIndex: function(index) {
    return this.list[index];
  }
};


/**
 * Player Class
 * No implementations was needed for while.
 */
Player = Class.create();
Player.prototype = {
  //void    
};


/**
 * Generic Character Class
 */
Character = Class.create();
Character.prototype = {
    initialize: function(characterId, name, actualPosition, pictureKind) {
        this.characterId = characterId;
        this.name = name;
        this.actualPosition = actualPosition;
        this.pictureKind = pictureKind;
        this.pictureNum = 2;
        this.walking = false;
        this.lookingTo = 'south';
        this.speed = 2;
        this.pointsToWalk = [];
		

        //Configuring character container (div)
        this.charContainer = document.createElement('DIV');
        this.charContainer.id = this.characterId;
        this.charContainer.className = 'character';
        this.charContainer.style.left = this.actualPosition.x+"px";
        this.charContainer.style.top = this.actualPosition.y+"px";
        document.getElementById('characters_layer').appendChild(this.charContainer);

        //Configuring character's name container (div)
        this.charLabelContainer = document.createElement('DIV');
        this.charLabelContainer.id = this.characterId+'Label';
        this.charLabelContainer.className = 'charLabel';
        this.charLabelContainer.style.left = (this.actualPosition.x - 35)+'px';
        this.charLabelContainer.style.top = (this.actualPosition.y - 15)+'px';
        this.charLabelContainer.innerHTML = '<div>'+ this.name + '</div>';
        document.getElementById('up_layer').appendChild(this.charLabelContainer);	
        setTimeout('charactersOnScreen.getById('+this.characterId+').logOnAnimation()',200);
        return;
    },

    destroy: function() {
        document.body.removeChild(this.charContainer);
        document.body.removeChild(this.charLabelContainer);
        return;
    },

    lookTo: function(direction) {
        switch (direction) {
            case 'EAST': this.lookingTo = 'east'; break;
            case 'WEST': this.lookingTo = 'west'; break;
            case 'NORTH': this.lookingTo = 'north'; break;
            case 'SOUTH': this.lookingTo = 'south'; break;
        }
        return;
    },

    logOnAnimation: function() {
        this.charContainer.innerHTML = "<img src = \"..\/pictures\/chipsets\/logoff.gif\">";
        this.pictureNum = 1;
        setTimeout('charactersOnScreen.getById('+this.characterId+').changePicture()',600);
        return;
    },

    logOffAnimation: function() {
        this.charContainer.innerHTML = "<img src = \"..\/pictures\/chipsets\/logoff.gif\">";
        return;
    },

    moveLayers: function(newPoint_x, newPoint_y) {
        this.charContainer.style.left = (newPoint_x - 10)+"px";
        this.charContainer.style.top = (newPoint_y - 20)+"px";
        this.charLabelContainer.style.left = (newPoint_x - 45)+"px";
        this.charLabelContainer.style.top = (newPoint_y - 35)+"px";
        return;
    },

    changePicture: function() {
        this.pictureNum++;  
        if (this.pictureNum > 4) {
            this.pictureNum = 1;
        }  
        this.charContainer.innerHTML = "<img src = \"..\/pictures\/chipsets\/"+ this.pictureKind + "_" + this.lookingTo + this.pictureNum + ".gif\">";
    },

    walk : function() {
        if(this.walking) {
            var alreadyLooking = false;
            var target = tileToPixel(this.pointsToWalk[0]);
            if(target.x == this.actualPosition.x && target.y == this.actualPosition.y) {
                this.pointsToWalk.shift();
                if(this.pointsToWalk.length == 0) {
                    this.walking = false;
                    this.pictureNum = 1;
                    this.changePicture();
                    return;
                }
            }
            target = tileToPixel(this.pointsToWalk[0]);
            
            if(target.x > this.actualPosition.x) { 
                this.actualPosition.x += this.speed; 
                this.lookingTo = 'east';
                alreadyLooking = true;
            }
            else if(target.x < this.actualPosition.x) {
                this.actualPosition.x -= this.speed;
                this.lookingTo = 'west';
                alreadyLooking = true;
            }
            
            if(target.y > this.actualPosition.y) { 
                this.actualPosition.y += this.speed;
                if(!alreadyLooking) {
                    this.lookingTo = 'south';
                }
            }
            else if(target.y < this.actualPosition.y) { 
                this.actualPosition.y -= this.speed; 
                if(!alreadyLooking) {
                    this.lookingTo = 'north';
                }
            }
        }
        this.changePicture();
        this.moveLayers(this.actualPosition.x, this.actualPosition.y);
    }
};


/**
 * Function pixelToTile
 * @description Converts a coordinate in pixels to a coordinate in tiles.
 * @param {Object} point
 * @return Point object with attributes x and y.
 */
function pixelToTile(point) {
    var realx = point.x/16;
    var realy = point.y/16;	
    if(parseInt(realx) < realx) { realx = parseInt(realx)+1; }	
    if(parseInt(realy) < realy) { realy = parseInt(realy)+1; }
    return {x:realx, y:realy};
}


/**
 * Function tileToPixel
 * @param {Array} tile
 * @return
 */
function tileToPixel(tile) {
    var outputPoint = [];
    outputPoint[0] = (tile[0]*16)-8; //calibrates to center of tile
    outputPoint[1] = (tile[1]*16)-8; //again
    return {x:outputPoint[0], y:outputPoint[1]};
}


/**
 * Function sendMessage
 * @param {Object} event
 */
function sendMessage(event) {
  //Verify if user pressed ENTER
  if(event.keyCode == 13) {
    var message = encodeURIComponent($('edt_message').value);
    if (message !== '') {
      new Ajax.Request('d5power.php', {method: 'get', parameters: 'action=send_chat&message='+message, onComplete:
        function(result) {
          if (result.responseText == 'OK') {
            $('edt_message').value = '';
            addToHistory(myCharacter.name, decodeURIComponent(message));
          }
        }
      });
    }
  }
}


/**
 * Function addToHistory
 * @param {String} charName
 * @param {String} message
 */
function addToHistory(charName, message) {
  $('chat_history').innerHTML += charName+': '+message+'<br>';
  $('chat_history').scrollTop = $('chat_history').scrollHeight;
}


/**
 * Start the character walking.
 */
walk = function(event) {
  if (!myCharacter.walking) {
    var mousePoint = captureMousePoint(event);
    if ((isNaN(mousePoint.x)) || (isNaN(mousePoint.y))) {
        alert('Sorry, D5Power Engine do not run in your browser yet. Try one of these browsers: Mozilla Firefox 1.5+, Microsoft Internet Explorer 5+ or Konqueror 3.5+');
        return;
    }
    mousePoint.x -= mapOffset.x;
    mousePoint.y -= mapOffset.y;
    var goalPoint = pixelToTile(mousePoint);
        goalPoint = [goalPoint.x, goalPoint.y];
    var startPoint = pixelToTile(myCharacter.actualPosition);
        startPoint = [startPoint.x, startPoint.y];
    var path = AStar(actualMap.collisionPoints, startPoint, goalPoint, 'DiagonalFree');
	
    if (path.length > 0) {
        myCharacter.pointsToWalk = path;
        myCharacter.walking = true;
    	new Ajax.Request('d5power.php', {method: 'get', parameters: 'action=walk&posx='+goalPoint[0]+'&posy='+goalPoint[1], onComplete:
      		function(result) {
	    	//TODO: validations from server
      		}
    	});
	}
  }
};


/**
 * Function initEngine
 * @description Used to initialize the Engine.
 */
initEngine = function() {
    actualMap = new Map();
    actualMap.load();
    charactersOnScreen = new characterList(null);
    loadCharacters('myLoggedCharacter');
    loadCharacters('otherCharacters');
    
    var mloop = window.setInterval('mainLoop()',70);
	var events = window.setInterval('getNewEvents()', 2000);
}


/**
 * 
 */
mainLoop = function() {	
    for(var i=0; i<charactersOnScreen.length(); i++) {
        var character = charactersOnScreen.getByIndex(i);
        if(character.walking) {
            character.walk();
        }
    }
}


/**
 * 
 */
getNewEvents = function() {
	new Ajax.Request(
            'd5power.php', {
            method: 'get',
            parameters: 'action=getNewEvents',
            onComplete:
			  function(result) {
                var jsonObj = eval("(" + result.responseText + ")");
			
				//Parsing chat messages
				if(jsonObj['chat'] != null) {
					for(var i=0; i<jsonObj['chat'].length; i++) {
						addToHistory(charactersOnScreen.getById(jsonObj['chat'][i]['cid']).name,
						jsonObj['chat'][i]['chatmsg']);
					}
				}
				
				if(jsonObj['movements'] != null) {
					for(var i=0; i<jsonObj['movements'].length; i++) {
						//alert(jsonObj['movements'][i]['cid']);
						var c = charactersOnScreen.getById(jsonObj['movements'][i]['cid']);
						var goalPoint = [parseInt(jsonObj['movements'][i]['posx']), parseInt(jsonObj['movements'][i]['posy'])];
						
						var startPoint = pixelToTile(c.actualPosition);
							startPoint = [startPoint.x, startPoint.y];
						var path = AStar(actualMap.collisionPoints, startPoint, goalPoint, 'DiagonalFree');
						
						if (path.length > 0) {
					    	c.pointsToWalk = path;
							c.walking = true;
						}
					}
             	}
			}
		});		
	return;
}


/**
 * Function loadCharacters
 * @return
 * @description Used to load all characters on the map.
 */
function loadCharacters(who) {
    
    switch(who) {
                
        case 'myLoggedCharacter':
            new Ajax.Request(
            'd5power.php', {
            method: 'get',
            parameters: 'action=getMyLoggedCharacter',
            onComplete: function(result) {
                            var jsonString = eval("(" + result.responseText + ")");
                            //set the global reference to my character.
                            myCharacter = arrayToCharacter(jsonString);
                            charactersOnScreen.add(myCharacter);
            }});
        break
        
        case 'otherCharacters':
            new Ajax.Request(
            'd5power.php', {
            method: 'get',
            parameters: 'action=getOtherCharacters',
            onComplete: function(result) {
                            var jsonObj = eval("(" + result.responseText  + ")");
                            for(i=0; i<jsonObj.length; i++) {
                                charactersOnScreen.add(arrayToCharacter(jsonObj[i]));
                            }
            }});
        break
    }
}


/** 
 * @description jsonToCharacter function is used to
 * convert a JSONArray format to a DotK Character instance.
 * @param {Object} JSONArray
 * @return {Character} outputCharacter
 */
function arrayToCharacter(jsonObject) {
    outputCharacter = new Character(
    jsonObject.cid,
    jsonObject.charactername,
    tileToPixel({0:jsonObject.posx, 1:jsonObject.posy}),
    'warrior');
    return outputCharacter;
}


/**
 * Function captureMousePoint
 * @description Capture actual mouse position on screen.
 * @param {Object} event
 */
function captureMousePoint(event) {
  var x,y;
  
  if (Prototype.Browser.IE) {
    $x = window.event.clientX + document.documentElement.scrollLeft
      + document.body.scrollLeft;
    $y = window.event.clientY + document.documentElement.scrollTop
      + document.body.scrollTop;
  }
  if (Prototype.Browser.Gecko) {
    $x = event.clientX + window.scrollX;
    $y = event.clientY + window.scrollY;
  }
  return {x:$x, y:$y};
}


/**
 * Function showCoordinates
 * @description For debug only.
 */
function showCoordinates(event) {
    var mouse = captureMousePoint(event);
    mouse.x -= mapOffset.x;
    mouse.y -= mapOffset.y;
    var tile = pixelToTile(mouse);
    document.getElementById('debug').innerHTML = 'Debug info: coordinates ('+mouse.x+','+mouse.y+')   tile ('+tile.x+','+tile.y+')';
}