/* SQL Manager 2005 Lite for InterBase and Firebird 4.1.0.3   */
/* ---------------------------------------------------------- */
/* Host     : 127.0.0.1                                       */
/* Database : /var/www/dotk-project/sandbox/database/dotk.gdb */

CREATE DATABASE '127.0.0.1:/var/www/dotk-project/sandbox/database/dotk.gdb'
   USER 'SYSDBA'
   PAGE_SIZE 4096
   DEFAULT CHARACTER SET NONE;

/* Definition for the `BOOLEAN` domain :  */

CREATE DOMAIN BOOLEAN AS
  SMALLINT
  CHECK (value in (0,1));

/* Definition for the `GENDER` domain :  */

CREATE DOMAIN GENDER AS
  CHAR(1) CHARACTER SET NONE
  CHECK (value in ('M','F'))
  COLLATE NONE;

/* Definition for the `GEN_CHARACTER_ID` generator :  */

CREATE GENERATOR GEN_CHARACTER_ID;

/* Definition for the `GEN_CHAT_ID` generator :  */

CREATE GENERATOR GEN_CHAT_ID;

/* Definition for the `GEN_LAST_MOVE` generator :  */

CREATE GENERATOR GEN_LAST_MOVE;

/* Definition for the `GEN_MAIL_ID` generator :  */

CREATE GENERATOR GEN_MAIL_ID;

/* Definition for the `GEN_MAP_ID` generator :  */

CREATE GENERATOR GEN_MAP_ID;

/* Definition for the `GEN_NPC_ID` generator :  */

CREATE GENERATOR GEN_NPC_ID;

/* Definition for the `GEN_PLAYER_ID` generator :  */

CREATE GENERATOR GEN_PLAYER_ID;

/* Definition for the `GEN_WAYPOINTS_ID` generator :  */

CREATE GENERATOR GEN_WAYPOINTS_ID;

/* Structure for the `MAP` table :  */

CREATE TABLE MAP (
  MAP_ID INTEGER NOT NULL,
  NAME VARCHAR(30) CHARACTER SET NONE DEFAULT '' NOT NULL COLLATE NONE,
  COLLISIONPOINTS VARCHAR(1200) CHARACTER SET NONE COLLATE NONE,
  GROUND_LAYER VARCHAR(32) CHARACTER SET NONE DEFAULT '' NOT NULL COLLATE NONE,
  UP_LAYER VARCHAR(32) CHARACTER SET NONE DEFAULT '' NOT NULL COLLATE NONE,
  TERRAIN_LAYER VARCHAR(32) CHARACTER SET NONE NOT NULL COLLATE NONE);


ALTER TABLE MAP ADD CONSTRAINT INTEG_14 PRIMARY KEY (MAP_ID);


/* Structure for the `WAYPOINTS` table :  */

CREATE TABLE WAYPOINTS (
  WAYPOINT_ID SMALLINT NOT NULL,
  MAP_ID_FROM INTEGER DEFAULT 0 NOT NULL,
  MAP_ID_TO INTEGER DEFAULT 0 NOT NULL,
  POSX_FROM SMALLINT,
  POSY_FROM SMALLINT,
  POSX_TO SMALLINT,
  POSY_TO SMALLINT);


ALTER TABLE WAYPOINTS ADD CONSTRAINT INTEG_75 PRIMARY KEY (WAYPOINT_ID);

ALTER TABLE WAYPOINTS ADD CONSTRAINT FK_WAYPOINTS FOREIGN KEY (MAP_ID_FROM) REFERENCES MAP(MAP_ID) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE WAYPOINTS ADD CONSTRAINT FK_WAYPOINTS2 FOREIGN KEY (MAP_ID_TO) REFERENCES MAP(MAP_ID) ON DELETE CASCADE ON UPDATE CASCADE;


/* Structure for the `NPC` table :  */

CREATE TABLE NPC (
  NPC_ID INTEGER NOT NULL,
  NAME VARCHAR(16) CHARACTER SET NONE COLLATE NONE,
  STRENGHT INTEGER,
  DEXTERITY INTEGER,
  VITALITY INTEGER,
  INTELIGENCE INTEGER,
  MONEY DECIMAL(15, 2),
  WISDOM INTEGER,
  HP INTEGER,
  AVATAR SMALLINT,
  MAP INTEGER,
  POSX SMALLINT,
  POSY SMALLINT,
  GENDER GENDER);


ALTER TABLE NPC ADD CONSTRAINT INTEG_12 PRIMARY KEY (NPC_ID);

ALTER TABLE NPC ADD CONSTRAINT FK_NPC FOREIGN KEY (MAP) REFERENCES MAP(MAP_ID);


/* Structure for the `COUNTRY` table :  */

CREATE TABLE COUNTRY (
  COUNTRY_ID SMALLINT NOT NULL,
  NAME VARCHAR(40) CHARACTER SET NONE NOT NULL COLLATE NONE,
  EXTENDED_NAME VARCHAR(60) CHARACTER SET NONE COLLATE NONE);


ALTER TABLE COUNTRY ADD CONSTRAINT INTEG_59 PRIMARY KEY (COUNTRY_ID);


/* Structure for the `PLAYER` table :  */

CREATE TABLE PLAYER (
  PLAYER_ID INTEGER NOT NULL,
  NAME VARCHAR(50) CHARACTER SET NONE COLLATE NONE,
  ADDRESS VARCHAR(120) CHARACTER SET NONE COLLATE NONE,
  NUMBER INTEGER,
  TELEPHONE VARCHAR(10) CHARACTER SET NONE COLLATE NONE,
  USERNAME VARCHAR(18) CHARACTER SET NONE NOT NULL COLLATE NONE,
  PASSWD VARCHAR(32) CHARACTER SET NONE NOT NULL COLLATE NONE,
  ACTIVED BOOLEAN NOT NULL,
  EMAIL VARCHAR(56) CHARACTER SET NONE DEFAULT '' NOT NULL COLLATE NONE,
  COUNTRY SMALLINT DEFAULT 0 NOT NULL,
  REGISTER_DATE DATE);


ALTER TABLE PLAYER ADD CONSTRAINT INTEG_10 PRIMARY KEY (PLAYER_ID);

ALTER TABLE PLAYER ADD CONSTRAINT FK_PLAYER FOREIGN KEY (COUNTRY) REFERENCES COUNTRY(COUNTRY_ID);

CREATE INDEX IDX_LOGIN ON PLAYER(USERNAME);

CREATE INDEX IDX_PLAYER_ID ON PLAYER(PLAYER_ID);


/* Structure for the `CHARACTERS` table :  */

CREATE TABLE CHARACTERS (
  CHARACTER_ID INTEGER NOT NULL,
  MAP_ID INTEGER NOT NULL,
  PLAYER_ID INTEGER NOT NULL,
  NAME VARCHAR(18) CHARACTER SET NONE COLLATE NONE,
  STRENGTH INTEGER,
  DEXTERITY INTEGER,
  INTELIGENCE INTEGER,
  VITALITY INTEGER,
  WISDOM INTEGER,
  POSX INTEGER NOT NULL,
  POSY INTEGER NOT NULL,
  MONEY DECIMAL(15, 2),
  OFFLINETIME INTEGER,
  BUSY BOOLEAN,
  XP INTEGER,
  LVL INTEGER NOT NULL,
  GENDER GENDER,
  HP INTEGER,
  ONLINE BOOLEAN,
  LAST_MOVE INTEGER,
  STATE SMALLINT,
  AVATAR VARCHAR(20) CHARACTER SET NONE NOT NULL COLLATE NONE,
  PROFESSION VARCHAR(20) CHARACTER SET NONE NOT NULL COLLATE NONE);


ALTER TABLE CHARACTERS ADD CONSTRAINT INTEG_67 PRIMARY KEY (CHARACTER_ID);

ALTER TABLE CHARACTERS ADD CONSTRAINT FK_CHARACTERS FOREIGN KEY (MAP_ID) REFERENCES MAP(MAP_ID);

ALTER TABLE CHARACTERS ADD CONSTRAINT FK_CHARACTERS1 FOREIGN KEY (PLAYER_ID) REFERENCES PLAYER(PLAYER_ID);


/* Structure for the `MAIL` table :  */

CREATE TABLE MAIL (
  MAIL_ID INTEGER NOT NULL,
  FROM_ID INTEGER NOT NULL,
  TEXT VARCHAR(250) CHARACTER SET NONE COLLATE NONE,
  SUBJECT VARCHAR(20) CHARACTER SET NONE COLLATE NONE,
  TO_ID INTEGER);


ALTER TABLE MAIL ADD CONSTRAINT PK_MAIL PRIMARY KEY (MAIL_ID);

ALTER TABLE MAIL ADD CONSTRAINT FK_MAIL FOREIGN KEY (FROM_ID) REFERENCES CHARACTERS(CHARACTER_ID);

ALTER TABLE MAIL ADD CONSTRAINT FK_MAIL1 FOREIGN KEY (TO_ID) REFERENCES CHARACTERS(CHARACTER_ID);


/* Structure for the `CHAT` table :  */

CREATE TABLE CHAT (
  CHAT_ID INTEGER NOT NULL,
  SENT_DATE TIMESTAMP NOT NULL,
  CHARACTER_ID INTEGER,
  MAP_ID INTEGER,
  MSG_TEXT VARCHAR(200) CHARACTER SET NONE NOT NULL COLLATE NONE);


ALTER TABLE CHAT ADD CONSTRAINT INTEG_87 PRIMARY KEY (CHAT_ID);

ALTER TABLE CHAT ADD CONSTRAINT FK_CHARACTERID_ON_CHAT FOREIGN KEY (CHARACTER_ID) REFERENCES CHARACTERS(CHARACTER_ID) ON DELETE SET NULL;

ALTER TABLE CHAT ADD CONSTRAINT FK_MAP_ON_CHAT FOREIGN KEY (MAP_ID) REFERENCES MAP(MAP_ID) ON DELETE SET NULL;


/* Structure for the `ACCOUNT_PLANS` table :  */

CREATE TABLE ACCOUNT_PLANS (
  ACC_PLAN VARCHAR(10) CHARACTER SET NONE NOT NULL COLLATE NONE,
  PRICE FLOAT);


ALTER TABLE ACCOUNT_PLANS ADD CONSTRAINT INTEG_18 PRIMARY KEY (ACC_PLAN);


/* Structure for the `EQUIPMENT` table :  */

CREATE TABLE EQUIPMENT (
  EQUIPMENT_ID INTEGER NOT NULL,
  TYPE_ID INTEGER NOT NULL,
  NAME VARCHAR(16) CHARACTER SET NONE COLLATE NONE,
  WEIGHT INTEGER,
  DEFENSE INTEGER,
  ATTACK INTEGER);


ALTER TABLE EQUIPMENT ADD CONSTRAINT INTEG_37 PRIMARY KEY (EQUIPMENT_ID);


CREATE INDEX IDX_EQUIP_ID ON EQUIPMENT(EQUIPMENT_ID);

CREATE INDEX IDX_FK_EQUIP_TYPE ON EQUIPMENT(TYPE_ID);


/* Structure for the `EQUIP_TYPE` table :  */

CREATE TABLE EQUIP_TYPE (
  TYPE_ID INTEGER NOT NULL,
  DESCRIPTION VARCHAR(40) CHARACTER SET NONE COLLATE NONE);


ALTER TABLE EQUIP_TYPE ADD CONSTRAINT INTEG_16 PRIMARY KEY (TYPE_ID);


/* Structure for the `EVENT_TYPE` table :  */

CREATE TABLE EVENT_TYPE (
  EVENT_TYPE INTEGER NOT NULL,
  DIALOG VARCHAR(20) CHARACTER SET NONE COLLATE NONE);


ALTER TABLE EVENT_TYPE ADD CONSTRAINT INTEG_6 PRIMARY KEY (EVENT_TYPE);


/* Structure for the `GUILD` table :  */

CREATE TABLE GUILD (
  GUILD_ID INTEGER NOT NULL,
  NAME VARCHAR(20) CHARACTER SET NONE COLLATE NONE);


ALTER TABLE GUILD ADD CONSTRAINT INTEG_4 PRIMARY KEY (GUILD_ID);


/* Structure for the `ITEMS` table :  */

CREATE TABLE ITEMS (
  ITEM_ID INTEGER NOT NULL,
  NAME VARCHAR(20) CHARACTER SET NONE COLLATE NONE,
  COST INTEGER,
  WEIGHT INTEGER,
  HEAL INTEGER,
  STAMINA INTEGER,
  STRENGHT INTEGER,
  INTELIGENCE INTEGER,
  DEXTERITY INTEGER);


ALTER TABLE ITEMS ADD CONSTRAINT INTEG_2 PRIMARY KEY (ITEM_ID);


/* Definition for the `BI_MAIL_MAIL_ID` trigger :  */

SET TERM ^ ;

CREATE TRIGGER BI_MAIL_MAIL_ID FOR MAIL
ACTIVE AFTER 
POSITION 0
AS
^

SET TERM ; ^

/* Definition for the `CHARACTERS_BI` trigger :  */

SET TERM ^ ;

CREATE TRIGGER CHARACTERS_BI FOR CHARACTERS
ACTIVE AFTER 
POSITION 0
AS
^

SET TERM ; ^

/* Definition for the `CHARACTERS_BU` trigger :  */

SET TERM ^ ;

CREATE TRIGGER CHARACTERS_BU FOR CHARACTERS
ACTIVE AFTER 
POSITION 0
AS
^

SET TERM ; ^

/* Definition for the `CHAT_BI` trigger :  */

SET TERM ^ ;

CREATE TRIGGER CHAT_BI FOR CHAT
ACTIVE AFTER 
POSITION 0
AS
^

SET TERM ; ^

/* Definition for the `MAP_BI` trigger :  */

SET TERM ^ ;

CREATE TRIGGER MAP_BI FOR MAP
ACTIVE AFTER 
POSITION 0
AS
^

SET TERM ; ^

/* Definition for the `NPC_BI` trigger :  */

SET TERM ^ ;

CREATE TRIGGER NPC_BI FOR NPC
ACTIVE AFTER 
POSITION 0
AS
^

SET TERM ; ^

/* Definition for the `TRG_PLAYER_BI` trigger :  */

SET TERM ^ ;

CREATE TRIGGER TRG_PLAYER_BI FOR PLAYER
ACTIVE AFTER 
POSITION 0
AS
^

SET TERM ; ^

/* Definition for the `WAYPOINTS_BI` trigger :  */

SET TERM ^ ;

CREATE TRIGGER WAYPOINTS_BI FOR WAYPOINTS
ACTIVE AFTER 
POSITION 0
AS
^

SET TERM ; ^

INSERT INTO MAP
VALUES 
  (1, 'Plains - west', '001100000000000000000001111111111111111100110000000000000000000111111111111111110000000000000000000000011111111111111111000000000000000000000000001111111111111100000000000000111000000100011111111111110000000000000011100000000000011111111111001110000000000000000000000000111111111100111000000000000000000000000000000000110000000000000000000000000000000000000001000000000000000000000111000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000100011000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000011100000011100000000000000000000000000001110000001110000000011100000000000000000000000000000000000001110000000000000000000000000000000000000000000001110000000000000000110000000000000000000111000000000000000011100000000000000000000000000000000110110000000000000000000110000000011100011011000000000000000000000000000001110011000000000000000000000000000000000000001100000011010000000000000000000000000000000000001100000010000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000000', 'map_1_ground.gif', 'map_1_up.gif', 'ocean.gif');

INSERT INTO MAP
VALUES 
  (2, 'Plains - east', '111111111111111111100110000000001111111111111111111111111110000000000000111111111111111111111111111000000000000011111111111111111111111111100000000000000111111111111111111111111110110000000000111111111111111111111111111011000000000011111111111111111111111111100000000000011111111111111111111111111100000000000111111111111111111111111111100000000000011111111111111111111111111100000000000000011111111101111111011111100000000000000000111111110000000000000000000000000000000011111111000011000000000000000000000000001111111100000000000000000000000000000000111111110000000000000000000000000000000001111111000000000000000000000000000000110000011100000000000000000000000000000000000011110001000000000000000000000000000011001111000000000001110000000000000000000000111110011000000111000001110000000000001111111001100000000000000111000000000011111111000000000000000000000000000000011111111101100000000000000000000000000001111111110110000000000000000000000000000011111111000000000000011000000000000000001111111101100000000001100000000000000011111111110110000011100000000000001000011111111111110000001110000000000000000011111111111111000000000000000000000001111111111111110000000000000000000000001111111111111111', 'map_2_ground.gif', 'map_2_up.gif', 'ocean.gif');

INSERT INTO COUNTRY
VALUES 
  (1, 'Afghanistan', 'Islamic State of Afghanistan');

INSERT INTO COUNTRY
VALUES 
  (2, 'Albania', 'Republic of Albania');

INSERT INTO COUNTRY
VALUES 
  (3, 'Algeria', 'Peoples Democratic Republic of Algeria');

INSERT INTO COUNTRY
VALUES 
  (4, 'Andorra', 'Principality of Andorra');

INSERT INTO COUNTRY
VALUES 
  (5, 'Angola', 'Republic of Angola');

INSERT INTO COUNTRY
VALUES 
  (6, 'Antigua and Barbuda', '');

INSERT INTO COUNTRY
VALUES 
  (7, 'Argentina', 'Argentine Republic');

INSERT INTO COUNTRY
VALUES 
  (8, 'Armenia', 'Republic of Armenia');

INSERT INTO COUNTRY
VALUES 
  (9, 'Australia', 'Commonwealth of Australia');

INSERT INTO COUNTRY
VALUES 
  (10, 'Austria', 'Republic of Austria');

INSERT INTO COUNTRY
VALUES 
  (11, 'Azerbaijan', 'Republic of Azerbaijan');

INSERT INTO COUNTRY
VALUES 
  (12, 'Bahamas, The', 'Commonwealth of The Bahamas');

INSERT INTO COUNTRY
VALUES 
  (13, 'Bahrain', 'Kingdom of Bahrain');

INSERT INTO COUNTRY
VALUES 
  (14, 'Bangladesh', 'Peoples Republic of Bangladesh');

INSERT INTO COUNTRY
VALUES 
  (15, 'Barbados', '');

INSERT INTO COUNTRY
VALUES 
  (16, 'Belarus', 'Republic of Belarus');

INSERT INTO COUNTRY
VALUES 
  (17, 'Belgium', 'Kingdom of Belgium');

INSERT INTO COUNTRY
VALUES 
  (18, 'Belize', '');

INSERT INTO COUNTRY
VALUES 
  (19, 'Benin', 'Republic of Benin');

INSERT INTO COUNTRY
VALUES 
  (20, 'Bhutan', 'Kingdom of Bhutan');

INSERT INTO COUNTRY
VALUES 
  (21, 'Bolivia', 'Republic of Bolivia');

INSERT INTO COUNTRY
VALUES 
  (22, 'Bosnia and Herzegovina', '');

INSERT INTO COUNTRY
VALUES 
  (23, 'Botswana', 'Republic of Botswana');

INSERT INTO COUNTRY
VALUES 
  (24, 'Brazil', 'Federative Republic of Brazil');

INSERT INTO COUNTRY
VALUES 
  (25, 'Brunei', 'Negara Brunei Darussalam');

INSERT INTO COUNTRY
VALUES 
  (26, 'Bulgaria', 'Republic of Bulgaria');

INSERT INTO COUNTRY
VALUES 
  (27, 'Burkina Faso', '');

INSERT INTO COUNTRY
VALUES 
  (28, 'Burundi', 'Republic of Burundi');

INSERT INTO COUNTRY
VALUES 
  (29, 'Cambodia', 'Kingdom of Cambodia');

INSERT INTO COUNTRY
VALUES 
  (30, 'Cameroon', 'Republic of Cameroon');

INSERT INTO COUNTRY
VALUES 
  (31, 'Canada', '');

INSERT INTO COUNTRY
VALUES 
  (32, 'Cape Verde', 'Republic of Cape Verde');

INSERT INTO COUNTRY
VALUES 
  (33, 'Central African Republic', '');

INSERT INTO COUNTRY
VALUES 
  (34, 'Chad', 'Republic of Chad');

INSERT INTO COUNTRY
VALUES 
  (35, 'Chile', 'Republic of Chile');

INSERT INTO COUNTRY
VALUES 
  (36, 'China, Peoples Republic of', 'Peoples Republic of China');

INSERT INTO COUNTRY
VALUES 
  (37, 'Colombia', 'Republic of Colombia');

INSERT INTO COUNTRY
VALUES 
  (38, 'Comoros', 'Union of Comoros');

INSERT INTO COUNTRY
VALUES 
  (39, 'Congo, (Kinshasa)', 'Democratic Republic of the Congo');

INSERT INTO COUNTRY
VALUES 
  (40, 'Congo, (Brazzaville)', 'Republic of the Congo');

INSERT INTO COUNTRY
VALUES 
  (41, 'Costa Rica', 'Republic of Costa Rica');

INSERT INTO COUNTRY
VALUES 
  (42, 'Cote dIvoire (Ivory Coast)', 'Republic of Cote dIvoire');

INSERT INTO COUNTRY
VALUES 
  (43, 'Croatia', 'Republic of Croatia');

INSERT INTO COUNTRY
VALUES 
  (44, 'Cuba', 'Republic of Cuba');

INSERT INTO COUNTRY
VALUES 
  (45, 'Cyprus', 'Republic of Cyprus');

INSERT INTO COUNTRY
VALUES 
  (46, 'Czech Republic', '');

INSERT INTO COUNTRY
VALUES 
  (47, 'Denmark', 'Kingdom of Denmark');

INSERT INTO COUNTRY
VALUES 
  (48, 'Djibouti', 'Republic of Djibouti');

INSERT INTO COUNTRY
VALUES 
  (49, 'Dominica', 'Commonwealth of Dominica');

INSERT INTO COUNTRY
VALUES 
  (50, 'Dominican Republic', '');

INSERT INTO COUNTRY
VALUES 
  (51, 'Ecuador', 'Republic of Ecuador');

INSERT INTO COUNTRY
VALUES 
  (52, 'Egypt', 'Arab Republic of Egypt');

INSERT INTO COUNTRY
VALUES 
  (53, 'El Salvador', 'Republic of El Salvador');

INSERT INTO COUNTRY
VALUES 
  (54, 'Equatorial Guinea', 'Republic of Equatorial Guinea');

INSERT INTO COUNTRY
VALUES 
  (55, 'Eritrea', 'State of Eritrea');

INSERT INTO COUNTRY
VALUES 
  (56, 'Estonia', 'Republic of Estonia');

INSERT INTO COUNTRY
VALUES 
  (57, 'Ethiopia', 'Federal Democratic Republic of Ethiopia');

INSERT INTO COUNTRY
VALUES 
  (58, 'Fiji', 'Republic of the Fiji Islands');

INSERT INTO COUNTRY
VALUES 
  (59, 'Finland', 'Republic of Finland');

INSERT INTO COUNTRY
VALUES 
  (60, 'France', 'French Republic');

INSERT INTO COUNTRY
VALUES 
  (61, 'Gabon', 'Gabonese Republic');

INSERT INTO COUNTRY
VALUES 
  (62, 'Gambia, The', 'Republic of The Gambia');

INSERT INTO COUNTRY
VALUES 
  (63, 'Georgia', 'Republic of Georgia');

INSERT INTO COUNTRY
VALUES 
  (64, 'Germany', 'Federal Republic of Germany');

INSERT INTO COUNTRY
VALUES 
  (65, 'Ghana', 'Republic of Ghana');

INSERT INTO COUNTRY
VALUES 
  (66, 'Greece', 'Hellenic Republic');

INSERT INTO COUNTRY
VALUES 
  (67, 'Grenada', '');

INSERT INTO COUNTRY
VALUES 
  (68, 'Guatemala', 'Republic of Guatemala');

INSERT INTO COUNTRY
VALUES 
  (69, 'Guinea', 'Republic of Guinea');

INSERT INTO COUNTRY
VALUES 
  (70, 'Guinea-Bissau', 'Republic of Guinea-Bissau');

INSERT INTO COUNTRY
VALUES 
  (71, 'Guyana', 'Co-operative Republic of Guyana');

INSERT INTO COUNTRY
VALUES 
  (72, 'Haiti', 'Republic of Haiti');

INSERT INTO COUNTRY
VALUES 
  (73, 'Honduras', 'Republic of Honduras');

INSERT INTO COUNTRY
VALUES 
  (74, 'Hungary', 'Republic of Hungary');

INSERT INTO COUNTRY
VALUES 
  (75, 'Iceland', 'Republic of Iceland');

INSERT INTO COUNTRY
VALUES 
  (76, 'India', 'Republic of India');

INSERT INTO COUNTRY
VALUES 
  (77, 'Indonesia', 'Republic of Indonesia');

INSERT INTO COUNTRY
VALUES 
  (78, 'Iran', 'Islamic Republic of Iran');

INSERT INTO COUNTRY
VALUES 
  (79, 'Iraq', 'Republic of Iraq');

INSERT INTO COUNTRY
VALUES 
  (80, 'Ireland', '');

INSERT INTO COUNTRY
VALUES 
  (81, 'Israel', 'State of Israel');

INSERT INTO COUNTRY
VALUES 
  (82, 'Italy', 'Italian Republic');

INSERT INTO COUNTRY
VALUES 
  (83, 'Jamaica', '');

INSERT INTO COUNTRY
VALUES 
  (84, 'Japan', '');

INSERT INTO COUNTRY
VALUES 
  (85, 'Jordan', 'Hashemite Kingdom of Jordan');

INSERT INTO COUNTRY
VALUES 
  (86, 'Kazakhstan', 'Republic of Kazakhstan');

INSERT INTO COUNTRY
VALUES 
  (87, 'Kenya', 'Republic of Kenya');

INSERT INTO COUNTRY
VALUES 
  (88, 'Kiribati', 'Republic of Kiribati');

INSERT INTO COUNTRY
VALUES 
  (89, 'Korea, North', 'Democratic Peoples Republic of Korea');

INSERT INTO COUNTRY
VALUES 
  (90, 'Korea, South', 'Republic of Korea');

INSERT INTO COUNTRY
VALUES 
  (91, 'Kuwait', 'State of Kuwait');

INSERT INTO COUNTRY
VALUES 
  (92, 'Kyrgyzstan', 'Kyrgyz Republic');

INSERT INTO COUNTRY
VALUES 
  (93, 'Laos', 'Lao Peoples Democratic Republic');

INSERT INTO COUNTRY
VALUES 
  (94, 'Latvia', 'Republic of Latvia');

INSERT INTO COUNTRY
VALUES 
  (95, 'Lebanon', 'Lebanese Republic');

INSERT INTO COUNTRY
VALUES 
  (96, 'Lesotho', 'Kingdom of Lesotho');

INSERT INTO COUNTRY
VALUES 
  (97, 'Liberia', 'Republic of Liberia');

INSERT INTO COUNTRY
VALUES 
  (98, 'Libya', 'Great Socialist Peoples Libyan Arab Jamahiriya');

INSERT INTO COUNTRY
VALUES 
  (99, 'Liechtenstein', 'Principality of Liechtenstein');

INSERT INTO COUNTRY
VALUES 
  (100, 'Lithuania', 'Republic of Lithuania');

INSERT INTO COUNTRY
VALUES 
  (101, 'Luxembourg', 'Grand Duchy of Luxembourg');

INSERT INTO COUNTRY
VALUES 
  (102, 'Macedonia', 'Republic of Macedonia');

INSERT INTO COUNTRY
VALUES 
  (103, 'Madagascar', 'Republic of Madagascar');

INSERT INTO COUNTRY
VALUES 
  (104, 'Malawi', 'Republic of Malawi');

INSERT INTO COUNTRY
VALUES 
  (105, 'Malaysia', '');

INSERT INTO COUNTRY
VALUES 
  (106, 'Maldives', 'Republic of Maldives');

INSERT INTO COUNTRY
VALUES 
  (107, 'Mali', 'Republic of Mali');

INSERT INTO COUNTRY
VALUES 
  (108, 'Malta', 'Republic of Malta');

INSERT INTO COUNTRY
VALUES 
  (109, 'Marshall Islands', 'Republic of the Marshall Islands');

INSERT INTO COUNTRY
VALUES 
  (110, 'Mauritania', 'Islamic Republic of Mauritania');

INSERT INTO COUNTRY
VALUES 
  (111, 'Mauritius', 'Republic of Mauritius');

INSERT INTO COUNTRY
VALUES 
  (112, 'Mexico', 'United Mexican States');

INSERT INTO COUNTRY
VALUES 
  (113, 'Micronesia', 'Federated States of Micronesia');

INSERT INTO COUNTRY
VALUES 
  (114, 'Moldova', 'Republic of Moldova');

INSERT INTO COUNTRY
VALUES 
  (115, 'Monaco', 'Principality of Monaco');

INSERT INTO COUNTRY
VALUES 
  (116, 'Mongolia', '');

INSERT INTO COUNTRY
VALUES 
  (117, 'Montenegro', 'Republic of Montenegro');

INSERT INTO COUNTRY
VALUES 
  (118, 'Morocco', 'Kingdom of Morocco');

INSERT INTO COUNTRY
VALUES 
  (119, 'Mozambique', 'Republic of Mozambique');

INSERT INTO COUNTRY
VALUES 
  (120, 'Myanmar (Burma)', 'Union of Myanmar');

INSERT INTO COUNTRY
VALUES 
  (121, 'Namibia', 'Republic of Namibia');

INSERT INTO COUNTRY
VALUES 
  (122, 'Nauru', 'Republic of Nauru');

INSERT INTO COUNTRY
VALUES 
  (123, 'Nepal', '');

INSERT INTO COUNTRY
VALUES 
  (124, 'Netherlands', 'Kingdom of the Netherlands');

INSERT INTO COUNTRY
VALUES 
  (125, 'New Zealand', '');

INSERT INTO COUNTRY
VALUES 
  (126, 'Nicaragua', 'Republic of Nicaragua');

INSERT INTO COUNTRY
VALUES 
  (127, 'Niger', 'Republic of Niger');

INSERT INTO COUNTRY
VALUES 
  (128, 'Nigeria', 'Federal Republic of Nigeria');

INSERT INTO COUNTRY
VALUES 
  (129, 'Norway', 'Kingdom of Norway');

INSERT INTO COUNTRY
VALUES 
  (130, 'Oman', 'Sultanate of Oman');

INSERT INTO COUNTRY
VALUES 
  (131, 'Pakistan', 'Islamic Republic of Pakistan');

INSERT INTO COUNTRY
VALUES 
  (132, 'Palau', 'Republic of Palau');

INSERT INTO COUNTRY
VALUES 
  (133, 'Panama', 'Republic of Panama');

INSERT INTO COUNTRY
VALUES 
  (134, 'Papua New Guinea', 'Independent State of Papua New Guinea');

INSERT INTO COUNTRY
VALUES 
  (135, 'Paraguay', 'Republic of Paraguay');

INSERT INTO COUNTRY
VALUES 
  (136, 'Peru', 'Republic of Peru');

INSERT INTO COUNTRY
VALUES 
  (137, 'Philippines', 'Republic of the Philippines');

INSERT INTO COUNTRY
VALUES 
  (138, 'Poland', 'Republic of Poland');

INSERT INTO COUNTRY
VALUES 
  (139, 'Portugal', 'Portuguese Republic');

INSERT INTO COUNTRY
VALUES 
  (140, 'Qatar', 'State of Qatar');

INSERT INTO COUNTRY
VALUES 
  (141, 'Romania', '');

INSERT INTO COUNTRY
VALUES 
  (142, 'Russia', 'Russian Federation');

INSERT INTO COUNTRY
VALUES 
  (143, 'Rwanda', 'Republic of Rwanda');

INSERT INTO COUNTRY
VALUES 
  (144, 'Saint Kitts and Nevis', 'Federation of Saint Kitts and Nevis');

INSERT INTO COUNTRY
VALUES 
  (145, 'Saint Lucia', '');

INSERT INTO COUNTRY
VALUES 
  (146, 'Saint Vincent and the Grenadines', '');

INSERT INTO COUNTRY
VALUES 
  (147, 'Samoa', 'Independent State of Samoa');

INSERT INTO COUNTRY
VALUES 
  (148, 'San Marino', 'Republic of San Marino');

INSERT INTO COUNTRY
VALUES 
  (149, 'Sao Tome and Principe', 'Democratic Republic of Sao Tome and Principe');

INSERT INTO COUNTRY
VALUES 
  (150, 'Saudi Arabia', 'Kingdom of Saudi Arabia');

INSERT INTO COUNTRY
VALUES 
  (151, 'Senegal', 'Republic of Senegal');

INSERT INTO COUNTRY
VALUES 
  (152, 'Serbia', 'Republic of Serbia');

INSERT INTO COUNTRY
VALUES 
  (153, 'Seychelles', 'Republic of Seychelles');

INSERT INTO COUNTRY
VALUES 
  (154, 'Sierra Leone', 'Republic of Sierra Leone');

INSERT INTO COUNTRY
VALUES 
  (155, 'Singapore', 'Republic of Singapore');

INSERT INTO COUNTRY
VALUES 
  (156, 'Slovakia', 'Slovak Republic');

INSERT INTO COUNTRY
VALUES 
  (157, 'Slovenia', 'Republic of Slovenia');

INSERT INTO COUNTRY
VALUES 
  (158, 'Solomon Islands', '');

INSERT INTO COUNTRY
VALUES 
  (159, 'Somalia', '');

INSERT INTO COUNTRY
VALUES 
  (160, 'South Africa', 'Republic of South Africa');

INSERT INTO COUNTRY
VALUES 
  (161, 'Spain', 'Kingdom of Spain');

INSERT INTO COUNTRY
VALUES 
  (162, 'Sri Lanka', 'Democratic Socialist Republic of Sri Lanka');

INSERT INTO COUNTRY
VALUES 
  (163, 'Sudan', 'Republic of the Sudan');

INSERT INTO COUNTRY
VALUES 
  (164, 'Suriname', 'Republic of Suriname');

INSERT INTO COUNTRY
VALUES 
  (165, 'Swaziland', 'Kingdom of Swaziland');

INSERT INTO COUNTRY
VALUES 
  (166, 'Sweden', 'Kingdom of Sweden');

INSERT INTO COUNTRY
VALUES 
  (167, 'Switzerland', 'Swiss Confederation');

INSERT INTO COUNTRY
VALUES 
  (168, 'Syria', 'Syrian Arab Republic');

INSERT INTO COUNTRY
VALUES 
  (169, 'Tajikistan', 'Republic of Tajikistan');

INSERT INTO COUNTRY
VALUES 
  (170, 'Tanzania', 'United Republic of Tanzania');

INSERT INTO COUNTRY
VALUES 
  (171, 'Thailand', 'Kingdom of Thailand');

INSERT INTO COUNTRY
VALUES 
  (172, 'Timor-Leste (East Timor)', 'Democratic Republic of Timor-Leste');

INSERT INTO COUNTRY
VALUES 
  (173, 'Togo', 'Togolese Republic');

INSERT INTO COUNTRY
VALUES 
  (174, 'Tonga', 'Kingdom of Tonga');

INSERT INTO COUNTRY
VALUES 
  (175, 'Trinidad and Tobago', 'Republic of Trinidad and Tobago');

INSERT INTO COUNTRY
VALUES 
  (176, 'Tunisia', 'Tunisian Republic');

INSERT INTO COUNTRY
VALUES 
  (177, 'Turkey', 'Republic of Turkey');

INSERT INTO COUNTRY
VALUES 
  (178, 'Turkmenistan', '');

INSERT INTO COUNTRY
VALUES 
  (179, 'Tuvalu', '');

INSERT INTO COUNTRY
VALUES 
  (180, 'Uganda', 'Republic of Uganda');

INSERT INTO COUNTRY
VALUES 
  (181, 'Ukraine', '');

INSERT INTO COUNTRY
VALUES 
  (182, 'United Arab Emirates', 'United Arab Emirates');

INSERT INTO COUNTRY
VALUES 
  (183, 'United Kingdom', 'United Kingdom of Great Britain and Northern Ireland');

INSERT INTO COUNTRY
VALUES 
  (184, 'United States', 'United States of America');

INSERT INTO COUNTRY
VALUES 
  (185, 'Uruguay', 'Oriental Republic of Uruguay');

INSERT INTO COUNTRY
VALUES 
  (186, 'Uzbekistan', 'Republic of Uzbekistan');

INSERT INTO COUNTRY
VALUES 
  (187, 'Vanuatu', 'Republic of Vanuatu');

INSERT INTO COUNTRY
VALUES 
  (188, 'Vatican City', 'State of the Vatican City');

INSERT INTO COUNTRY
VALUES 
  (189, 'Venezuela', 'Bolivarian Republic of Venezuela');

INSERT INTO COUNTRY
VALUES 
  (190, 'Vietnam', 'Socialist Republic of Vietnam');

INSERT INTO COUNTRY
VALUES 
  (191, 'Yemen', 'Republic of Yemen');

INSERT INTO COUNTRY
VALUES 
  (192, 'Zambia', 'Republic of Zambia');

INSERT INTO COUNTRY
VALUES 
  (193, 'Zimbabwe', 'Republic of Zimbabwe');

