<?php
/**
 * D5Power Studio d5power Webgame Engine
 *
 * Extends DOTK system
 * Author: D5Power Studio
 *
 *
 * 第五动力工作室 d5power网页游戏引擎 Ver 1.0
 * 继承自:DOTK引擎
 * 作者：第五动力工作室
 */
  session_start();
  
  if (!isset($_SESSION['playerId'])) {
  	echo "You must be logged!";
  	exit;
  }

  $allowed_page = true;

  function __autoload($className) {
    if (!isset($allowed_page)) { $allowed_page = true; }
	require_once("lib/config.php");
	require_once(CLASS_PATH."{$className}.class.php");
  }

  // Get or create game Engine
  if (!isset($_SESSION['engine'])) {
  	$engine = new Engine();
  }
  else {
  	$engine = $_SESSION['engine'];
  }
  
  //Get action of the Client application.
  if (isset($_POST['action'])) {
    $action = $_POST['action'];
  }
  else {
    $action = $_GET['action'];
  }
  
 /** 
  * ## Actions Handler ##
  * That switch catch all requests of the client
  * before sending to Engine 
  */
  switch ($action) {

	/*****************************************
	*
	*/
	case "getNewEvents":
		$engine->getNewEvents();
	break;

    /*****************************************
	*
	*/
	case "send_chat":
	  $message = trim($_GET['message']);
      $engine->sendChat($message);
    break;

    /*****************************************
	*
	*/
	case "walk":
	  $posx = $_GET['posx'];
	  $posy = $_GET['posy'];
      $engine->characterWalk($posx, $posy);
    break;

   /******************************************
    * Action login
    */
    case "login":
      if (isset($_GET['username']) && isset($_GET['password'])) {
        $username = stripslashes($_GET['username']);
        $password = stripslashes($_GET['password']);
        $engine->login($username, $password);	
      }
    break;
    
	/*****************************************
	*
	*/
	case "enterGame":
		$characterId = (int) $_POST['character'];
		$engine->setCharacter($characterId);
		header("Location: game.php");
		break;
    	

	/******************************************
	* Action getOtherCharacters
	* Used to load all characters in the map
	*/
	case "getOtherCharacters":
		$engine->loadOtherCharacters();
		break;	
	
	/******************************************
	* Action getMyCharacters
	* Used to load info about your character
	*/
	case "getMyCharacters":
		$engine->loadMyCharacters();
		break;
	
   /******************************************
    * Action getMyLoggedCharacter
    * Used to load info about your character
    */
    case "getMyLoggedCharacter":
      $engine->getMyLoggedCharacter();
    break;	    	
	
	/*****************************************
	*
	*/
    case "loadMap":
      $layer = $_GET['maplayer'];
	  $engine->loadMap($layer);
    break;
	
	/*****************************************
	*
	*/
	case "loadCollisionPoints":
	  $engine->getCollisionPoints();
	break;
    
    case "debug":
      $engine->debug();
    break;
	
    default:
    exit;
  }
  $_SESSION['engine'] = $engine;
?>
