<?php
/**
 * D5Power Studio d5power Webgame Engine
 *
 * Extends DOTK system
 * Author: D5Power Studio
 *
 *
 * 第五动力工作室 d5power网页游戏引擎 Ver 1.0
 * 继承自:DOTK引擎
 * 作者：第五动力工作室
 */
/** PAGE NOT ALLOWED
 * Verify if user called this page through a allowed page.
 * @message: That file cannot be displayed alone.
 */
if (!isset($allowed_page)) { echo "That file cannot be displayed alone."; exit; }

require_once("d5power.DAO.php");

//Dotk character class.
class Character extends DAO {

  public $character_id;
  public $name;
  public $profession;
  public $posx;
  public $posy;
  public $str;
  public $dex;
  public $int;
  public $vit;
  public $agi;
  public $money;
  public $offlinetime;
  public $busy;
  public $state;
  public $xp;
  public $level;
  public $map_id;
  public $avatar;
  
  /**
  * Constructor function
  * @param
  */
  public function Character() {
	//nothing for while
  }

  /**
  * Function "load"
  * @description Used to retrieve for DB all character's attributes
  * identified for the given 'characterId'.
  */
  public function load($characterId) {
    $sql = "SELECT * FROM characters WHERE cid = ?";
    $queryResult = $this->retrieve($sql, array($characterId));
    $result = $queryResult->getRow();

	$this->character_id = $result['cid'];
    $this->charactername = $result['charactername'];
    $this->profession = $result['profession'];
    $this->posx = $result['posx'];
    $this->posy = $result['posy'];
    $this->str = $result['_str'];
    $this->dex = $result['_dex'];
    $this->int = $result['_int'];
    $this->vit = $result['_vit'];
    $this->agi = $result['agi'];
    $this->money = $result['money'];
	$this->online = $result['online'];
    $this->offlinetime = $result['offlinetime'];
    $this->busy = $result['busy'];
    $this->state = $result['state'];
    $this->xp = $result['xp'];
    $this->level = $result['lv'];
    $this->map_id = $result['mid'];
	$this->avatar = $result['avatar'];
  }
  
  /**
  * Function "create"
  * @description Creates a new character on DB.
  */
  function create($name, $gender, $avatar) {
  
    $sql = "insert into characters (uid, charactername, gender, avatar, posx, posy, mid) values(?, ?, ?, ?, 20, 20, 1)";
    try {
	if($name==""){
  		throw new Exception("Please fill in the Character Name field. <a href=\"create_character.php\">click here </a> to try again");	
		exit;
    	}	
      $this->retrieve($sql, array($_SESSION['playerId'], $name, $gender, $avatar));
      return true;
    }
    catch(Exception $e) {
      return $e->getMessage();
    }
  }
    
  public function save() {
    $sql = "UPDATE characters SET posx = ?, posy =?, online=? WHERE cid = ? ";
    $playerResult = $this->retrieve($sql, array($this->posx,$this->posy,$this->online,$this->character_id));
  }
  
  public function gainMoney($money) {
    $this->money += $money;
    $sql = "UPDATE character SET money = ? where c = ? ";
    $playerResult = $this->retrieve($sql, arary($money, $this->character_id));
  }
  
  public function loseMoney($money) {
    if(($this->money-$money) < 0 ){
      $this->money -= $money;
      $sql = "UPDATE personagem SET dinheiro = ? where idpersonagem = ? ";
      $playerResult = $this->retrieve($sql, $money);
    }
  }
  
  public function gainXp($amount) {
   $this->xp+= $amount;
   $sql = "UPDATE personagem SET xp = ? where idpersonagem = ? ";
   $playerResult = $this->retrieve($sql, $money);
  }
  
  public function isLevelUp() {
    if($this->xp>=100 * $this->level + $this->level^4) {
      $this->level += $this->level + 1;
      // Como adicionar os pontos....?
         
      $this->state = "leveled_up";
		 
    }
  }
  
  public function acceptTrade(){
       $this->busy= 1;
       $this->status= "AcceptedTrade";
  }
  
  
  // Getters and Setters
  public function getcharacterId() {
    return $this->character_id;
  }

  public function setcharacterId($characterId) {
	$this->character_id = $characterId;
  }

  public function getname() {
	return $this->name;
  }

  public function setname($name) {
	$this->name = $name;
  }

  public function getProfession() {
	return $this->profession;
  }

  public function setProfession($profession) {
	$this->profession = $profession;
  }

  public function getPosx() {
	return $this->posx;
  }

  public function setPosx($positionX) {
	$this->posx = $positionX;
  }

  public function getPosy() {
	return $this->posy;
  }

  public function setPosy($positionY) {
	$this->posy = $positionY;
  }

  public function getstr() {
	return $this->str;
  }

  public function setstr($str) {
	$this->str = $str;
  }

  public function getdex() {
	return $this->dex;
  }

  public function setdex($dex) {
	$this->dex = $dex;
  }

  public function getint() {
	return $this->int;
  }

  public function setint($int) {
	$this->int = $int;
  }

  public function getvit() {
	return $this->vit;
  }

  public function setvit($vit) {
	$this->vit = $vit;
  }

  public function getagi() {
	return $this->agi;
  }

  public function setagi($agi) {
	$this->agi = $agi;
  }

  public function getmoney() {
	return $this->money;
  }

  public function setmoney($money) {
	$this->money = $money;
  }

  public function getofflineHours() {
	return $this->offlineHours;
  }

  public function setofflineHours($offlineHours) {
	$this->offlineHours = $offlineHours;
  }

  public function getbusy() {
	return $this->busy;
  }

  public function setbusy($busy) {
	$this->busy = $busy;
  }

  public function getstate() {
	return $this->state;
  }

  public function setstate($state) {
	$this->state = $state;
  }

  public function getxp() {
	return $this->xp;
  }

  public function setxp($xp) {
	$this->xp = $xp;
  }

  public function getlevel() {
	return $this->level;
  }

  public function setlevel($level) {
	$this->level = $level;
  }
  
  public function getActualMap() {
  	return $this->map_id;
  }
  
  public function setActualMap($mapId) {
  	$this->map_id = $mapId;
  }
  
  public function setOnline($isonline)
  {
  	$this->online = $isonline ? 1 : 0;
	$this->save();
  }

}

//Test Unit
/*
  $c = new Character();
  $c->load(1);
  print_r($c);
*/

?>
