<?php
/**
 * D5Power Studio d5power Webgame Engine
 *
 * Extends DOTK system
 * Author: D5Power Studio
 *
 *
 * 第五动力工作室 d5power网页游戏引擎 Ver 1.0
 * 继承自:DOTK引擎
 * 作者：第五动力工作室
 */
 
/** PAGE NOT ALLOWED
 * Verify if user called this page through a allowed page.
 * @message: That file cannot be displayed alone.
 */
if (!isset($allowed_page)) { echo "That file cannot be displayed alone."; exit; }

require_once(CLASS_PATH."Player.class.php");
require_once(CLASS_PATH."Character.class.php");
require_once(CLASS_PATH."d5power.DAO.php");

/**
* Class Engine
* Handler of game rules
*/
class Engine extends DAO {
    
  public $player;
  public $map;
  public $character;
  private $lastChatId = null;
  private $lastEventsCheck = null ;
  private $index_move = null;
    
  /**
  * Engine Constructor function
  * @description initilizes the game core objects.
  */
  public function Engine() {
    $this->player = new Player();
    $this->map = new Map();
    $this->character = new Character();
  }

  /**
  *
  */
  public function initialize() {
    //nothing
  }
  
  /**
  *
  */
  public function sendChat($message) {
    $query = "insert into chat(cid, mid, chatmsg) values(?,?,?);";
    $this->retrieve($query, array($this->character->getcharacterId(), $this->map->getMapId(), stripcslashes($message)));
    print("OK");
  }

	/**
	*
	*/
	public function characterWalk($x, $y)
	{
		$this->character->setPosx($x);
		$this->character->setPosy($y);	
		$sql = "update characters set posx = ?, posy = ?, lastmove=? where cid = ?";
		@$this->retrieve($sql, array($x, $y, time(), $this->character->getcharacterId()));
		print("OK");
	}


  /**
  * Function loadCharacters
  * @description Load all online characters in your actual map.
  */
  public function loadOtherCharacters()
  {
    try {
      $sql = "SELECT
                cid, charactername, posx, posy
              FROM
                characters
              WHERE
                online = 1 and
                mid = ? and 
				cid <> ?";
	  $charactersResult = $this->retrieve($sql, array($this->character->getActualMap(), $this->character->getcharacterId()));
      echo json_encode($charactersResult->getArray());
    }
    catch(Exception $e) {
     //TODO: correct Exception
    }
  }


  /**
  * Function loadMyCharacters
  * @description Used to retrieve all characters of one Player.
  * @return {ResultSet}
  */
  public function loadMyCharacters() {
    $sql = "SELECT cid, uid, charactername, mid, posx, posy FROM characters WHERE uid = ?";
    try {
      $characterResult = $this->retrieve($sql, array($_SESSION['playerId']));
      return $characterResult->getArray();
    }
    catch(Exception $e) {
      //TODO
    }
  }


  /**
  *
  */
  public function getMyLoggedCharacter() {
    echo json_encode($this->character);
  }


  /**
  *
  */
  public function getCollisionPoints() {
    $points = $this->map->getCollisionPoints();
    $matrix = Array();
    $charpos = 0;
    for($i=0; $i<30; $i++) {
        $matrix[$i] = Array();
        for($j=0; $j<40; $j++) {
            array_push($matrix[$i], (int) substr($points,$charpos,1));
            $charpos++;
        }
    }
    echo json_encode($matrix);
  }
  

  /**
  * Function loadMap
  * @description 
  */
  public function loadMap($layer) {
    header('Content-type: image/gif');
	header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    $this->map->loadMap($this->character->getActualMap());

    //TODO: Validations about the logged character.
    $fileName = "";
    $mapsPath = "../pictures/maps";
    switch ($layer) {

        case "terrain_layer":
            $fileName = $mapsPath."/".$this->map->getTerrainLayer();
        break;

        case "ground_layer":
            $fileName = $mapsPath."/".$this->map->getGroundLayer();
        break;

        case "up_layer":
            $fileName = $mapsPath."/".$this->map->getUpLayer();
        break;
    }
    $fileName = realpath($fileName);
    $file = fopen($fileName,'r');
    $contents = fread($file, filesize($fileName));
    fclose($file);
    echo $contents;
  }


  /**
  * Function loadCharset
  * @description Used to load all charset images of the current character
  */
  public function loadCharset($orientation, $number) {
    header('Contend-type: image/gif');
    $imagesPath = "../pictures/charsets";
	
	if($orientation != "north" &&
	   $orientation != "south" &&
	   $orientation != "west" &&
	   $orientation != "east") {
	   	throw new Exception("Wrong orientation.");
	}	
	
    $fileName = $imagesPath."/".$this->getAvatar()."_".$this->getProfession()."_".$orientation."_".$number.".gif";
    $fileName = realpath($fileName);
    $file = fopen($fileName,'r');
    $contents = fread($file, filesize($fileName));
    fclose($file);
    echo $contents;
  }
  

	/**
	* Function login
	* @description Authentication of players
	*/
	public function login($user, $pwd)
	{
		try
		{
			if($user == "")
			{
				throw new Exception("Please fill in the Username field. Try again");	
				exit;
			}
			if($pwd == "")
			{
				throw new Exception("Please fill in the password field. Try again");
				exit;
			}  	
			if(stripos($user,"\'") != false || stripos($pwd,"\'") != false)
			{
				throw new Exception("Invalid Characters detected. Please check your username.");
				exit;
			}
			$query = "select uid, userid, passwd from user_login ";
			$query.= "where userid = ? and passwd   = ?";
			
			$results = $this->retrieve($query, array($user, $pwd));
			if(!$results->isEmpty())
			{
				$results = $results->getRow();
				//If the username and password are correct, we initialize the Player
				$this->player->load($results['uid']);
				$_SESSION['playerId'] = $this->player->getId();
				return true;
			}else{
				throw new Exception("Unable to login please check your Username and Password.");
			}    
		}catch(Exception $e){
			return $e->getMessage();
		}
	}

  /**
  * Function setCharacter
  * @description Used when a player login in the game
  */
  public function setCharacter($characterId) {
    $this->character = new Character();
    $this->character->load($characterId);
	$this->character->setOnline(true);
  }
  
  /**
  * Function getNewEvents
  * @description
  * @return {Json} package
  */
  public function getNewEvents() {
    
    $responseArray = array("chat"=>null, "movements"=>null, "logon"=>null);
    
    //////////Check new chat messages
    if ($this->lastChatId == null) {
      $sql = "select id, cid, chatmsg, mid from chat where mid = ? and cid <> ? order by id asc";
      $messages_result = $this->retrieve($sql, array($this->map->getMapId(), $this->character->getcharacterId()));
    }
    else {
      $sql = "select id, cid, chatmsg, mid from chat where id > ? and mid = ? and cid <> ? order by id asc";
      $messages_result = $this->retrieve($sql, array($this->lastChatId, $this->map->getMapId(), $this->character->getcharacterId()));
    }
    if(!$messages_result->isEmpty()) {
        $chatId = $messages_result->getLast();
        $this->lastChatId = $chatId["id"];
        $responseArray["chat"] = $messages_result->getArray();
    }
    /////////////////////////////////
	

	//Check for character movements
	if($this->index_move == null) {
		$this->index_move = 0;		
	}
	$sql = "select
	          lastmove,
	          cid,
			  posx,
			  posy,
			  mid,
			  online 
			from
			  characters
			where
			  mid = ? and
			  online = 1 and
			  lastmove > ? and
			  cid <> ?";
	$movements_result = $this->retrieve($sql, array($this->character->getActualMap(), $this->index_move, $this->character->getcharacterId()));
	if(!$movements_result->isEmpty()) {
		$index = $movements_result->getFirst();
		$this->index_move = $index["last_move"];
		$responseArray["movements"] = $movements_result->getArray();
	}
	/////////////////////////////////

    //Create Json output
    echo json_encode($responseArray);
  }


  
  public function debug() {
    print(date("d\.m\.Y H\:i\:s"));
  }

}
?>