<?php

/** PAGE NOT ALLOWED
 * Verify if user called this page through a allowed page.
 * @message: That file cannot be displayed alone.
 */
if (!isset($allowed_page)) { echo "That file cannot be displayed alone."; exit; }

if (file_exists("lib/config.php")) { require_once("lib/config.php"); }
require_once(CLASS_PATH."abstract.DataAccess.php");
require_once(CLASS_PATH."FirebirdResultSet.class.php");

class dotkDataAccess extends abstractDataAccess {
	
 /**
  * @private connectionLink
  * Stores a active connection to DB.
  */
  private $connectionLink = null;

 /**
  * @private static instance
  * Stores a Singleton self class instance.
  */
  private static $instance;

 /**
  * @private resourceResult
  * Stores the actual resultset from last query.
  */
  private $resourceResult = null;

 /**
  * @private connected
  * Indica o estado atual da conexão.
  */
  private static $connected = false;

 /** Private Constructor for Singleton
  * @no params
  */
  private function dotkDataAccess() {
	//Nothing for while
  }

  public function getInstance() {
    if (!isset(self::$instance)) {
	$class = __CLASS__;
	self::$instance = new $class;
    }
    return self::$instance;
  }

 /** Connection function
  * Establishes a connection to Firebird Database.
  * @Static params (defined in config.php)
  */
  function connect() {

    if (DB_PERSISTENT_CONNECTION) {
      $this->connectionLink = ibase_pconnect(DB_HOSTNAME.":".DB_DATABASE_PATH.DB_DATABASE_NAME, DB_USERNAME, DB_PASSWORD)
                               or die("Database connection failure.");
    }
    else {
      $this->connectionLink = ibase_connect(DB_HOSTNAME.":".DB_DATABASE_PATH.DB_DATABASE_NAME, DB_USERNAME, DB_PASSWORD)
                               or die("Database connection failure.");
    }
    ibase_trans(IBASE_COMMITTED, $this->connectionLink);
  }

 /** Disconnect function
  * Disconnect a active link to DB.
  * NOTE: if you are using a persistent connection,
  *       that function will not close the connection.
  * @no params
  */
  function disconnect() {
    ibase_close($this->connectionLink);
  }


 /** Execute function
  * Executes a prepared query with ibase_prepare
  * @statement - previous prepared query
  * @params - collection of params to be replaced in a prepared query.
  */
  function execute($statement, $params = null) {
    try {
    	
      if(count($params) == 0) {
        //$ret = ibase_execute($statement);
        $ret = call_user_func('ibase_execute', $statement);
      }
      else {
		array_unshift($params, $statement);
		
        $ret = call_user_func_array('ibase_execute', $params);
		
        //$ret = ibase_execute($statement, $params);
      }
    }
    catch(Exception $e) {
      return 'Error on Firebird execute function: '.$e->getMessage()."\n";
    }
    return $ret;
  }


 /** SendQuery function
  * Evaluates a query text before execute.
  * @query - String containing query text.
  * @params - collection of params to be replaced in query.
  */
  function & sendQuery($query, $params = null) {
    if (!self::$connected) {
      $this->connect();
    }
    $query = ibase_prepare($this->connectionLink, $query);
	
    if (ibase_num_params($query) != count($params)) {
      throw new Exception("Input params and query params does not match.");
	  
      return false;
    }
    else {
        $resultSet = $this->execute($query, $params);
        if (!$this->isError()) {
            $myResultSet = new ResultSet();

            $i = 0;
   	        $array = array();

       	    while(@$line = ibase_fetch_assoc($resultSet)) {
			  foreach($line as $key => $value) {
					$array[$i][strtolower($key)] = $value;
			  }
          	  //$array[$i] = $line;
           	  $i++;
           	}
           	$myResultSet->fetch($array);
        }
		else {
			$myResultSet = new ResultSet();
			$myResultSet->setError(ibase_errmsg());
		}
    }
    return $myResultSet;
  }

 /** isError function
  * Check if the most recent InterBase function call resulted an Error.
  * @params - void.
  */
  function isError() {
    if (ibase_errcode())
      return ibase_errcode().": ".ibase_errmsg();
    else
      return false;
  }

}
?>
