<?php
/**
 * D5Power Studio d5power Webgame Engine
 *
 * Extends DOTK system
 * Author: D5Power Studio
 *
 *
 * 第五动力工作室 d5power网页游戏引擎 Ver 1.0
 * 继承自:DOTK引擎
 * 作者：第五动力工作室
 */
/** PAGE NOT ALLOWED
 * Verify if user called this page through a allowed page.
 * @message: That file cannot be displayed alone.
 */
if (!isset($allowed_page)) { echo "That file cannot be displayed alone."; exit; }

require_once(CLASS_PATH."d5power.DAO.php");

class Map extends DAO {

	private $map_id;
	private $name;
	private $collisionpoints;
	private $ground_layer;
	private $terrain_layer;
	private $up_layer;

	/**
	* Class constructor
	*/
	function Map() {
		//nothing for while
	}
	
	/**
	* Function loadMap()
	* @description Load all attributes of respective $mapId.
	*/
	public function loadMap($mapId)
	{
		$mapId=intval($mapId)==0 ? 1 : intval($mapId);
		$sql = "select 
				  mid,
				  mname,
				  collisionpoints,
				  ground_layer,
				  up_layer,
				  terrain_layer
				from
				  map
				where
				  mid = ?";
				  
		$result = $this->retrieve($sql, array($mapId))->getRow();

		$this->map_id = $result['mid'];
		$this->name = $result['mname'];
		$this->collisionpoints = $result['collisionpoints'];
		$this->ground_layer = $result['ground_layer'];
		$this->terrain_layer = $result['terrain_layer'];
		$this->up_layer = $result['up_layer'];
		
		return $this;
	}
	
	
	/**
	* Function create()
	*/	
	public function create($name, $terrainLayer, $groundLayer, $upLayer) {
		$sql = "insert into MAP
					(name, ground_layer, up_layer, terrain_layer) 
				values
					(?,?,?,?)";
		try {
			$this->retrieve($sql, array($name, $groundLayer, $upLayer, $terrainLayer));
		}
		catch(Exception $e) {
			return false;
		}
	}
	
	/**
	* Function save()
	*/
	public function save() {
		if (empty($this->map_id)) {
			throw new Exception("Trying to save a empty Map.");			
		}
		$sql = "update MAP set
				  name = ?,
				  collisionpoints = ?,
  				  ground_layer = ?,
				  terrain_layer = ?,
				  up_layer = ?
				where
				  map_id = ?";

		$this->retrieve($sql, array($this->name, $this->collisionpoints, $this->ground_layer, $this->terrain_layer, $this->up_layer, $this->map_id));
		return true;
	}
	
	
	//Getters and Setters
	public function getMapId() {
		return $this->map_id;
	}

	public function setMapId($mapId) {
		$this->map_id = $mapId;
	}
	
	public function getName() {
		return $this->name;
	}
	
	public function setName($name) {
		$this->name = $name;
	}

	public function getGroundLayer() {
		return $this->ground_layer;
	}

	public function setGroundLayer($groundLayer) {
		$this->ground_layer = $groundLayer;
	}

	public function getTerrainLayer() {
		return $this->terrain_layer;
	}

	public function setTerrainLayer($terrainLayer) {
		$this->terrain_layer = $terrainLayer;
	}

	public function getUpLayer() {
		return $this->up_layer;
	}

	public function setUpLayer($upLayer) {
		$this->up_layer = $upLayer;
	}

	public function getCollisionPoints() {
		return $this->collisionpoints;
	}

	public function setCollisionPoints($collisionPoints) {
		$this->collisionpoints = $collisionPoints;
	}
}
?>