<?php
/**
 * D5Power Studio d5power Webgame Engine
 *
 * Extends DOTK system
 * Author: D5Power Studio
 *
 *
 * 第五动力工作室 d5power网页游戏引擎 Ver 1.0
 * 继承自:DOTK引擎
 * 作者：第五动力工作室
 */


/** PAGE NOT ALLOWED
 * Verify if user called this page through a allowed page.
 * @message: That file cannot be displayed alone.
 */
if (!isset($allowed_page)) { echo "That file cannot be displayed alone."; exit; }

require_once("d5power.DAO.php");

//Player Class
class Player extends DAO {

  private $player_id;
  private $name;
  private $address;
  private $number;
  private $telephone;
  private $username;
  private $password;
  private $actived;
  private $characters = null;
  

  /**
  *
  */
  function Player() {
    //nothing for while
  }


  /**
  *
  */
  public function register($username, $passwd, $email, $country) {
		
	try {
		
	if($username==""){
		throw new Exception("Please fill in the Username field.Try again");	
		exit;
		}
	if($passwd==""){
		throw new Exception("Please fill in the password field.Try again");
		exit;
	}
	if(!eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $email)) {
		throw new Exception("Please fill in the email field correctly (user@domain.com).Try again");
		exit;
	}


	  $sql = "select userid from user_login where userid = ?";
	  $result = $this->retrieve($sql, array($username));

      if (!$result->isEmpty()) {
        throw new Exception("该用户名已被注册，请更换用户名");
        exit;
      }
	  
      $sql = "insert into
              user_login(userid, passwd, email, regdate)
              values(?, ?, ?, ?)";
      $this->retrieve($sql, array($username, $passwd, $email, time()));
	  return true;
	}
	catch(Exception $e) {
		return $e->getMessage();
	}
  }


  /**
  *
  */
  public function login($user, $pwd) {
  
  try{  
  	if(!isset($user)){
		throw new Exception("Please fill in the Username field.Try again");	
		exit;
		}
	if($pwd==""){
		throw new Exception("Please fill in the password field.Try again");
		exit;
	}  	
    if (stripos($user,"\'") !== false || stripos($pwd,"\'") !== false) {
      	throw new Exception("Invalid Characters detected.Please check your username.");
		exit;
	}
    $query = "select
                uid,
                userid,
                passwd
              from
                user_login
              where
                userid = ? and
                passwd   = ?";

    $results = $this->retrieve($query, array($user, $pwd));

    if (!$results->isEmpty()) {
      $results = $results->getRow(); 		
      $this->player_id = $results['uid'];
      $this->username = $results['userid'];
      $this->actived = true; //Action	
      return true;
    }
    throw new Exception("Unable to login please check your Username and Password.");
	
	}
	
	catch(Exception $e) {
		return $e->getMessage();
	}
  }


  /**
  *
  */
  function load($playerId) {
    $sql = "SELECT uid, userid, regdate, actived FROM user_login WHERE uid = ?";
    $playerResult = $this->retrieve($sql, array($playerId));

	if (!$playerResult->isEmpty()) {
      $results = $playerResult->getRow();
	  $this->player_id = $results['uid'];
      $this->username = $results['userid'];
      $this->actived = $results['actived'];
	}
  }


  /**
  *
  */
  function getUserName() {
    return $this->username;
  }


  /**
  *
  */
  function getId() {
    return $this->player_id;
  }


  /**
  *
  */
  function getState() {
    return $this->actived;
  }

}

//Test Unit
/*
  $p = new Player(1,"Foo");
  print($p->getUserName());
  print($p->getId());
  print($p->playerId);
*/

?>
