<?php
/**
 * D5Power Studio d5power Webgame Engine
 *
 * Extends DOTK system
 * Author: D5Power Studio
 *
 *
 * 第五动力工作室 d5power网页游戏引擎 Ver 1.0
 * 继承自:DOTK引擎
 * 作者：第五动力工作室
 */
 
/** PAGE NOT ALLOWED
 * Verify if user called this page through a allowed page.
 * @message: That file cannot be displayed alone.
 */
if (!isset($allowed_page)) { echo "That file cannot be displayed alone."; exit; }

if (DB_ENGINE == "FIREBIRD") {
  require_once(CLASS_PATH."Firebird.DataAccess.php");
}
if (DB_ENGINE == "MYSQL") {
  require_once(CLASS_PATH."MySQL.DataAccess.php");
}


class DAO {

  private static $dataAccess;

  function initialize() {
	if(!isset(self::$dataAccess)) {
      self::$dataAccess = d5powerDataAccess::getInstance();
    }
  }

  function & retrieve($sql, $params = null) {
	self::initialize();
	$result = & self::$dataAccess->sendQuery($sql, $params);
    if ($error = $result->isError()) {
		//TODO: Log? 
      throw new Exception($error);
	  
      return false;
    }
    else {
      return $result;
    }
  }  
  
  function update() {
    initialize();
  }

}
?>
