﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.DAL;
using LZBS.Model;
using LZBS.Common;
using System.Data;

namespace LZBS.BLL
{
    public class B_Member
    {
        D_Member dal = new D_Member();
        /// <summary>
        /// 判断用户是否存在，存在返回true，否则返回false
        /// </summary>
        /// <param name="model"></param>
        /// <returns>存在返回true，否则返回false</returns>
        public bool IsExistMember(M_Member model)
        {
            if (dal.GetInfoFromMemberID(model).Rows.Count > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// 注册账号
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddMember(M_Member model)
        {
            model.Password = Md5Encrypt.GetMd5Hash(model.Password);
            return dal.AddMember(model);
        }
        /// <summary>
        /// 判断密码和账号是否正确，正确返回True，错误返回false
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool CheckMember(M_Member model)
        {
            model.Password = Md5Encrypt.GetMd5Hash(model.Password);
            if (dal.CheckMember(model).Rows.Count > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// 修改密码
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int ChangePassword(M_Member model)
        {
            model.Password = Md5Encrypt.GetMd5Hash(model.Password);
            return dal.ChangePassword(model);
        }
        /// <summary>
        /// 根据账号获取会员信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable QueryMemberInfo(M_Member model)
        {
            return dal.GetInfoFromMemberID(model);
        }
        /// <summary>
        /// 根据账号修改个人资料
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int ChangeInfo(M_Member model)
        {
            return dal.ChangeInfo(model);
        }
        /// <summary>
        /// 获取所有会员信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetAllMembers()
        {
            return dal.GetAllMembers();
        }
        /// <summary>
        /// 根据账号删除会员
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteMember(M_Member model)
        {
            return dal.DeleteMember(model);
        }
    }
}
