﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.Model;
using LZBS.DAL;
using System.Data;

namespace LZBS.BLL
{
    public class B_SysLog
    {
        D_SysLog dal = new D_SysLog();
        /// <summary>
        /// 添加日志记录
        /// </summary>
        /// <param name="mLog"></param>
        public int AddLog(M_SysLog mLog)
        {
            return dal.AddLog(mLog);
        }
        /// <summary>
        /// 获取所有日志列表
        /// </summary>
        /// <returns></returns>
        public DataTable GetAllSysLog()
        {
            return dal.GetAllSysLog();
        }
        /// <summary>
        /// 删除日志
        /// </summary>
        /// <param name="model"></param>
        public int DeleteLog(M_SysLog model)
        {
            return dal.DeleteLog(model);
        }
        /// <summary>
        /// 根据日志时间批量删除日志
        /// </summary>
        /// <param name="model"></param>
        public int DeleteLogByTime(M_SysLog model)
        {
            return dal.DeleteLogByTime(model);
        }
        /// <summary>
        /// 通过条件查询日志
        /// </summary>
        /// <param name="model"></param>
        public DataTable GetSysLogByCondition(M_SysLog model)
        {
            return dal.GetSysLogByCondition(model);
        }
        /// <summary>
        /// 通过LogID获取日志信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetSysLogByLogID(M_SysLog model)
        {
            return dal.GetSysLogByLogID(model);
        }
    }
}
